/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.repository;

import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.jetbrains.python.packaging.repository.PyPackageRepository;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0001\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0001\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0001\u00a8\u0006\n"}, d2={"encodeCredentialsForUrl", "", "login", "password", "checkValid", "", "Lcom/jetbrains/python/packaging/repository/PyPackageRepository;", "withBasicAuthorization", "Lcom/intellij/util/io/RequestBuilder;", "repository", "intellij.python.community.impl"})
@JvmName(name="PyPackageRepositoryUtil")
public final class PyPackageRepositoryUtil {
    @ApiStatus.Experimental
    @NotNull
    public static final RequestBuilder withBasicAuthorization(@NotNull RequestBuilder $this$withBasicAuthorization, @NotNull PyPackageRepository repository) {
        Intrinsics.checkNotNullParameter((Object)$this$withBasicAuthorization, (String)"$this$withBasicAuthorization");
        Intrinsics.checkNotNullParameter((Object)((Object)repository), (String)"repository");
        String password = repository.getPassword();
        if (repository.getLogin() != null && password != null) {
            Base64.Encoder encoder = Base64.getEncoder();
            Object object = repository.getLogin() + ":" + password;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = encoder.encode(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"Base64.getEncoder().enco\u2026password}\".toByteArray())");
            object = byArray2;
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"StandardCharsets.UTF_8");
            charset = charset2;
            String credentials = new String((byte[])object, charset);
            $this$withBasicAuthorization.tuner(new HttpRequests.ConnectionTuner(credentials){
                final /* synthetic */ String $credentials;

                public final void tune(@NotNull URLConnection connection) {
                    Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                    connection.setRequestProperty("Authorization", "Basic " + this.$credentials);
                }
                {
                    this.$credentials = string;
                }
            });
        }
        return $this$withBasicAuthorization;
    }

    @ApiStatus.Experimental
    public static final boolean checkValid(@NotNull PyPackageRepository $this$checkValid) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$checkValid), (String)"$this$checkValid");
        String string = $this$checkValid.getRepositoryUrl();
        Intrinsics.checkNotNull((Object)string);
        RequestBuilder requestBuilder = HttpRequests.request((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"HttpRequests\n    .request(repositoryUrl!!)");
        return PyPackageRepositoryUtil.withBasicAuthorization(requestBuilder, $this$checkValid).connectTimeout(3000).throwStatusCodeException(false).tryConnect() == 200;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final String encodeCredentialsForUrl(@NotNull String login, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)login, (String)"login");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return URLEncoder.encode(login, StandardCharsets.UTF_8) + ":" + URLEncoder.encode(password, StandardCharsets.UTF_8);
    }
}

