/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.module;

import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ContentFolderRef;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ExternalContentFolderRef;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.module.PyRootTypeProvider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class PyContentEntriesEditor
extends CommonContentEntriesEditor {
    private final List<PyRootTypeProvider> myRootTypeProviders = PyRootTypeProvider.EP_NAME.getExtensionList();
    private final Module myModule;
    private Disposable myFilePointersDisposable;
    private MyContentEntryEditor myContentEntryEditor;
    private final FacetErrorPanel myWarningPanel;

    public PyContentEntriesEditor(Module module, ModuleConfigurationState moduleConfigurationState, boolean withBorders, JpsModuleSourceRootType<?> ... rootTypes) {
        super(module.getName(), moduleConfigurationState, withBorders, rootTypes);
        this.myModule = module;
        this.myWarningPanel = new FacetErrorPanel();
        this.reset();
    }

    public MyContentEntryEditor getContentEntryEditor() {
        return this.myContentEntryEditor;
    }

    protected ContentEntryTreeEditor createContentEntryTreeEditor(Project project) {
        return new MyContentEntryTreeEditor(project, this.getEditHandlers());
    }

    protected List<ContentEntry> addContentEntries(VirtualFile[] files) {
        List entries = super.addContentEntries(files);
        this.addContentEntryPanels(entries.toArray(new ContentEntry[0]));
        return entries;
    }

    public ContentEntry[] getContentEntries() {
        return this.getModel().getContentEntries();
    }

    public void reset() {
        if (this.myFilePointersDisposable != null) {
            Disposer.dispose((Disposable)this.myFilePointersDisposable);
        }
        this.myFilePointersDisposable = Disposer.newDisposable();
        for (PyRootTypeProvider provider : this.myRootTypeProviders) {
            provider.reset(this.myFilePointersDisposable, this, this.myModule);
        }
        if (this.myRootTreeEditor != null) {
            ContentEntryEditor editor2 = this.myRootTreeEditor.getContentEntryEditor();
            if (editor2 != null) {
                editor2.update();
            }
            this.myRootTreeEditor.update();
        }
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        if (this.myFilePointersDisposable != null) {
            Disposer.dispose((Disposable)this.myFilePointersDisposable);
        }
        for (PyRootTypeProvider provider : this.myRootTypeProviders) {
            provider.disposeUIResources(this.myModule);
        }
    }

    public void apply() throws ConfigurationException {
        super.apply();
        for (PyRootTypeProvider provider : this.myRootTypeProviders) {
            provider.apply(this.myModule);
        }
    }

    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        for (PyRootTypeProvider provider : this.myRootTypeProviders) {
            if (!provider.isModified(this.myModule)) continue;
            return true;
        }
        return false;
    }

    protected ContentEntryEditor createContentEntryEditor(String contentEntryUrl) {
        this.myContentEntryEditor = new MyContentEntryEditor(contentEntryUrl, this.getEditHandlers());
        return this.myContentEntryEditor;
    }

    protected void addAdditionalSettingsToPanel(JPanel mainPanel) {
        mainPanel.add((Component)this.myWarningPanel.getComponent(), "South");
    }

    public FacetErrorPanel getWarningPanel() {
        return this.myWarningPanel;
    }

    private class MyContentEntryTreeEditor
    extends ContentEntryTreeEditor {
        private final ChangeListener myListener;

        MyContentEntryTreeEditor(Project project, List<ModuleSourceRootEditHandler<?>> handlers) {
            super(project, handlers);
            this.myListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    MyContentEntryTreeEditor.this.update();
                }
            };
        }

        public void setContentEntryEditor(ContentEntryEditor newEditor) {
            MyContentEntryEditor existingEditor = this.getContentEntryEditor();
            if (Comparing.equal((Object)((Object)existingEditor), (Object)newEditor)) {
                return;
            }
            if (existingEditor != null) {
                existingEditor.removeListener(this.myListener);
            }
            if (newEditor != null) {
                ((MyContentEntryEditor)newEditor).addListener(this.myListener);
            }
            super.setContentEntryEditor(newEditor);
        }

        public MyContentEntryEditor getContentEntryEditor() {
            return (MyContentEntryEditor)super.getContentEntryEditor();
        }

        protected void createEditingActions() {
            super.createEditingActions();
            for (PyRootTypeProvider provider : PyContentEntriesEditor.this.myRootTypeProviders) {
                ContentEntryEditingAction action = provider.createRootEntryEditingAction((JTree)this.myTree, PyContentEntriesEditor.this.myFilePointersDisposable, PyContentEntriesEditor.this, PyContentEntriesEditor.this.getModel());
                this.myEditingActionsGroup.add((AnAction)action);
                CustomShortcutSet shortcut = provider.getShortcut();
                if (shortcut == null) continue;
                action.registerCustomShortcutSet((ShortcutSet)shortcut, (JComponent)this.myTree);
            }
        }

        protected TreeCellRenderer getContentEntryCellRenderer(@NotNull ContentEntry contentEntry) {
            if (contentEntry == null) {
                MyContentEntryTreeEditor.$$$reportNull$$$0(0);
            }
            return new ContentEntryTreeCellRenderer(this, contentEntry, this.getEditHandlers()){

                protected Icon updateIcon(ContentEntry entry, VirtualFile file, Icon originalIcon) {
                    for (PyRootTypeProvider provider : PyContentEntriesEditor.this.myRootTypeProviders) {
                        if (!provider.hasRoot(file, PyContentEntriesEditor.this)) continue;
                        return provider.getIcon();
                    }
                    Icon defaultIcon = super.updateIcon(entry, file, originalIcon);
                    if (defaultIcon == PlatformIcons.PACKAGE_ICON) {
                        return PlatformIcons.FOLDER_ICON;
                    }
                    return defaultIcon;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "com/jetbrains/python/module/PyContentEntriesEditor$MyContentEntryTreeEditor", "getContentEntryCellRenderer"));
        }
    }

    protected class MyContentEntryEditor
    extends ContentEntryEditor {
        private final EventDispatcher<ChangeListener> myEventDispatcher;

        public MyContentEntryEditor(String contentEntryUrl, List<ModuleSourceRootEditHandler<?>> handlers) {
            super(contentEntryUrl, handlers);
            this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        }

        protected ModifiableRootModel getModel() {
            return PyContentEntriesEditor.this.getModel();
        }

        public void addListener(ChangeListener changeListener) {
            this.myEventDispatcher.addListener((EventListener)changeListener);
        }

        public void removeListener(ChangeListener changeListener) {
            this.myEventDispatcher.removeListener((EventListener)changeListener);
        }

        protected ContentRootPanel createContentRootPane() {
            return new MyContentRootPanel();
        }

        public void deleteContentFolder(ContentEntry contentEntry, ContentFolderRef folderRef) {
            if (folderRef instanceof ExternalContentFolderRef) {
                String url = folderRef.getUrl();
                for (PyRootTypeProvider provider : PyContentEntriesEditor.this.myRootTypeProviders) {
                    Collection roots = provider.getRoots().get((Object)contentEntry);
                    if (!roots.stream().anyMatch(pointer -> pointer.getUrl().equals(url))) continue;
                    this.removeRoot(contentEntry, url, provider);
                    return;
                }
            }
            super.deleteContentFolder(contentEntry, folderRef);
        }

        public void removeRoot(@Nullable ContentEntry contentEntry, String folder, PyRootTypeProvider provider) {
            VirtualFilePointer root;
            if (contentEntry == null) {
                contentEntry = this.getContentEntry();
            }
            if ((root = this.getRoot(provider, folder)) != null) {
                provider.removeRoot(contentEntry, root, this.getModel());
                this.fireUpdate();
            }
        }

        public void fireUpdate() {
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
            this.update();
        }

        public VirtualFilePointer getRoot(PyRootTypeProvider provider, @NotNull String url) {
            if (url == null) {
                MyContentEntryEditor.$$$reportNull$$$0(0);
            }
            for (VirtualFilePointer filePointer : provider.getRoots().get((Object)this.getContentEntry())) {
                if (!Objects.equals(filePointer.getUrl(), url)) continue;
                return filePointer;
            }
            return null;
        }

        public void addRoot(PyRootTypeProvider provider, @NotNull VirtualFilePointer root) {
            if (root == null) {
                MyContentEntryEditor.$$$reportNull$$$0(1);
            }
            provider.getRoots().putValue((Object)this.getContentEntry(), (Object)root);
            this.fireUpdate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/module/PyContentEntriesEditor$MyContentEntryEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        protected class MyContentRootPanel
        extends ContentRootPanel {
            public MyContentRootPanel() {
                super((ContentRootPanel.ActionCallback)MyContentEntryEditor.this, MyContentEntryEditor.this.getEditHandlers());
            }

            @NotNull
            protected ContentEntry getContentEntry() {
                ContentEntry contentEntry = MyContentEntryEditor.this.getContentEntry();
                if (contentEntry == null) {
                    MyContentRootPanel.$$$reportNull$$$0(0);
                }
                return contentEntry;
            }

            protected void addFolderGroupComponents() {
                super.addFolderGroupComponents();
                for (PyRootTypeProvider provider : PyContentEntriesEditor.this.myRootTypeProviders) {
                    MultiMap<ContentEntry, VirtualFilePointer> roots = provider.getRoots();
                    Collection pointers = roots.get((Object)this.getContentEntry());
                    if (pointers.isEmpty()) continue;
                    List folderRefs = ContainerUtil.map((Collection)pointers, ExternalContentFolderRef::new);
                    JComponent sourcesComponent = this.createFolderGroupComponent(provider.getRootsGroupTitle(), folderRefs, provider.getRootsGroupColor(), null);
                    this.add(sourcesComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/module/PyContentEntriesEditor$MyContentEntryEditor$MyContentRootPanel", "getContentEntry"));
            }
        }
    }
}

