/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonIdeLanguageCustomization;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PyInterpreterInspectionQuickFixData;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkPopupFactory;
import com.jetbrains.python.sdk.PySdkProvider;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfiguration;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfigurationExtension;
import com.jetbrains.python.ui.PyUiUtil;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyInterpreterInspection
extends PyInspection {
    @NotNull
    private static final Logger LOGGER = Logger.getInstance(PyInterpreterInspection.class);
    @NotNull
    private static final Pattern NAME = Pattern.compile("Python (?<version>\\d\\.\\d+)\\s*(\\((?<name>.+?)\\))?");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyInterpreterInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyInterpreterInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    @Nullable
    private static Module guessModule(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            PyInterpreterInspection.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            Module[] modules = ModuleManager.getInstance((Project)element.getProject()).getModules();
            if (modules.length != 1) {
                return null;
            }
            module = modules[0];
        }
        return module;
    }

    private static boolean isFileIgnored(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            PyInterpreterInspection.$$$reportNull$$$0(3);
        }
        return PyInspectionExtension.EP_NAME.getExtensionList().stream().anyMatch(ep -> ep.ignoreInterpreterWarnings(pyFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "guessModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileIgnored";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class UseDetectedInterpreterFix
    extends UseInterpreterFix<PyDetectedSdk> {
        @NotNull
        private final List<Sdk> myExistingSdks;
        private final boolean myAssociate;
        @NotNull
        private final Module myModule;

        private UseDetectedInterpreterFix(@NotNull PyDetectedSdk detectedSdk, @NotNull List<Sdk> existingSdks2, boolean associate, @NotNull Module module) {
            if (detectedSdk == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(0);
            }
            if (existingSdks2 == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(1);
            }
            if (module == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(2);
            }
            super(detectedSdk);
            this.myExistingSdks = existingSdks2;
            this.myAssociate = associate;
            this.myModule = module;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Sdk newSdk;
            if (project == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(4);
            }
            PyUiUtil.clearFileLevelInspectionResults(project);
            Sdk sdk = newSdk = this.myAssociate ? PySdkExtKt.setupAssociated((PyDetectedSdk)this.mySdk, this.myExistingSdks, BasePySdkExtKt.getBasePath(this.myModule)) : PySdkExtKt.setup((PyDetectedSdk)this.mySdk, this.myExistingSdks);
            if (newSdk == null) {
                return;
            }
            SdkConfigurationUtil.addSdk((Sdk)newSdk);
            if (this.myAssociate) {
                PySdkExtKt.associateWithModule(newSdk, this.myModule, null);
            }
            PyProjectSdkConfiguration.INSTANCE.setReadyToUseSdk(project, this.myModule, newSdk);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detectedSdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingSdks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseDetectedInterpreterFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class UseExistingInterpreterFix
    extends UseInterpreterFix<Sdk> {
        @NotNull
        private final Module myModule;

        private UseExistingInterpreterFix(@NotNull Sdk existingSdk, @NotNull Module module) {
            if (existingSdk == null) {
                UseExistingInterpreterFix.$$$reportNull$$$0(0);
            }
            if (module == null) {
                UseExistingInterpreterFix.$$$reportNull$$$0(1);
            }
            super(existingSdk);
            this.myModule = module;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                UseExistingInterpreterFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                UseExistingInterpreterFix.$$$reportNull$$$0(3);
            }
            PyUiUtil.clearFileLevelInspectionResults(project);
            PyProjectSdkConfiguration.INSTANCE.setReadyToUseSdk(project, this.myModule, this.mySdk);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingSdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseExistingInterpreterFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class UseInterpreterFix<T extends Sdk>
    implements LocalQuickFix {
        @NotNull
        protected final T mySdk;

        protected UseInterpreterFix(@NotNull T sdk) {
            if (sdk == null) {
                UseInterpreterFix.$$$reportNull$$$0(0);
            }
            this.mySdk = sdk;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.interpreter.use.suggested.interpreter", new Object[0]);
            if (string == null) {
                UseInterpreterFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = PyPsiBundle.message("INSP.interpreter.use.interpreter", PySdkPopupFactory.Companion.shortenNameInPopup((Sdk)this.mySdk, 75));
            if (string == null) {
                UseInterpreterFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseInterpreterFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseInterpreterFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class UseProvidedInterpreterFix
    implements LocalQuickFix {
        @NotNull
        private final Module myModule;
        @NotNull
        private final PyProjectSdkConfigurationExtension myExtension;
        @NotNull
        @IntentionName
        private final String myName;

        private UseProvidedInterpreterFix(@NotNull Module module, @NotNull PyProjectSdkConfigurationExtension extension, @NotNull @IntentionName String name2) {
            if (module == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(0);
            }
            if (extension == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(1);
            }
            if (name2 == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(2);
            }
            this.myModule = module;
            this.myExtension = extension;
            this.myName = name2;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.interpreter.use.suggested.interpreter", new Object[0]);
            if (string == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(5);
            }
            if (descriptor2 == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(6);
            }
            PyProjectSdkConfiguration.INSTANCE.configureSdkUsingExtension(this.myModule, this.myExtension, (Function0<? extends Sdk>)((Function0)() -> this.myExtension.createAndAddSdkForInspection(this.myModule)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseProvidedInterpreterFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseProvidedInterpreterFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ConfigureInterpreterFix
    implements LocalQuickFix {
        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.interpreter.configure.python.interpreter", new Object[0]);
            if (string == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor2.getPsiElement()) == null) {
                return;
            }
            Module module = PyInterpreterInspection.guessModule(element);
            if (module == null) {
                return;
            }
            PySdkPopupFactory.Companion.createAndShow(project, module);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class InterpreterSettingsQuickFix
    implements LocalQuickFix {
        @NotNull
        private final Module myModule;

        public InterpreterSettingsQuickFix(@NotNull Module module) {
            if (module == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(0);
            }
            this.myModule = module;
        }

        @NotNull
        public String getFamilyName() {
            String string = PlatformUtils.isPyCharm() ? PyPsiBundle.message("INSP.interpreter.interpreter.settings", new Object[0]) : PyPsiBundle.message("INSP.interpreter.configure.python.interpreter", new Object[0]);
            if (string == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(3);
            }
            InterpreterSettingsQuickFix.showPythonInterpreterSettings(project, this.myModule);
        }

        public static void showPythonInterpreterSettings(@NotNull Project project, @Nullable Module module) {
            if (project == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(4);
            }
            String id = "com.jetbrains.python.configuration.PyActiveSdkModuleConfigurable";
            ConfigurableGroup group2 = ConfigurableExtensionPointUtil.getConfigurableGroup((Project)project, (boolean)true);
            if (ConfigurableVisitor.findById((String)"com.jetbrains.python.configuration.PyActiveSdkModuleConfigurable", Collections.singletonList(group2)) != null) {
                ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"com.jetbrains.python.configuration.PyActiveSdkModuleConfigurable", null);
                return;
            }
            ProjectSettingsService settingsService = ProjectSettingsService.getInstance((Project)project);
            if (module == null || InterpreterSettingsQuickFix.justOneModuleInheritingSdk(project, module)) {
                settingsService.openProjectSettings();
            } else {
                settingsService.openModuleSettings(module);
            }
        }

        private static boolean justOneModuleInheritingSdk(@NotNull Project project, @NotNull Module module) {
            if (project == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(5);
            }
            if (module == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(6);
            }
            return ProjectRootManager.getInstance((Project)project).getProjectSdk() == null && ModuleRootManager.getInstance((Module)module).isSdkInherited() && ModuleManager.getInstance((Project)project).getModules().length < 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$InterpreterSettingsQuickFix";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$InterpreterSettingsQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "showPythonInterpreterSettings";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "justOneModuleInheritingSdk";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Visitor
    extends PyInspectionVisitor {
        private static final AsyncLoadingCache<Module, List<PyDetectedSdk>> DETECTED_ASSOCIATED_ENVS_CACHE = Caffeine.newBuilder().executor((Executor)AppExecutorUtil.getAppExecutorService()).expireAfterWrite(Duration.ofSeconds(20L)).weakKeys().buildAsync(module -> {
            List<Sdk> existingSdks2 = Visitor.getExistingSdks();
            UserDataHolderBase context2 = new UserDataHolderBase();
            return PySdkExtKt.detectAssociatedEnvironments(module, existingSdks2, (UserDataHolder)context2);
        });

        public Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context2) {
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context2);
        }

        @Override
        public void visitPyFile(@NotNull PyFile node) {
            Module module;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((module = PyInterpreterInspection.guessModule((PsiElement)node)) == null || PyInterpreterInspection.isFileIgnored(node)) {
                return;
            }
            Sdk sdk = PythonSdkUtil.findPythonSdk(module);
            boolean pyCharm = PythonIdeLanguageCustomization.isMainlyPythonIde();
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            if (sdk == null) {
                String message = pyCharm ? PyPsiBundle.message("INSP.interpreter.no.python.interpreter.configured.for.project", new Object[0]) : PyPsiBundle.message("INSP.interpreter.no.python.interpreter.configured.for.module", new Object[0]);
                this.registerProblemWithCommonFixes(node, message, module, null, fixes, pyCharm);
            } else {
                PyInterpreterInspectionQuickFixData fixData;
                @NlsSafe String associatedModulePath = PySdkExtKt.getAssociatedModulePath(sdk);
                if ((associatedModulePath == null || PySdkExtKt.isAssociatedWithAnotherModule(sdk, module)) && (fixData = (PyInterpreterInspectionQuickFixData)PySdkProvider.EP_NAME.extensions().map(ext -> ext.createEnvironmentAssociationFix(module, sdk, pyCharm, associatedModulePath)).filter(it -> it != null).findFirst().orElse(null)) != null) {
                    fixes.add(fixData.getQuickFix());
                    this.registerProblemWithCommonFixes(node, fixData.getMessage(), module, sdk, fixes, pyCharm);
                    return;
                }
                if (PythonSdkUtil.isInvalid(sdk)) {
                    String message = pyCharm ? PyPsiBundle.message("INSP.interpreter.invalid.python.interpreter.selected.for.project", new Object[0]) : PyPsiBundle.message("INSP.interpreter.invalid.python.interpreter.selected.for.module", new Object[0]);
                    this.registerProblemWithCommonFixes(node, message, module, sdk, fixes, pyCharm);
                } else {
                    LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
                    if (!LanguageLevel.SUPPORTED_LEVELS.contains((Object)languageLevel)) {
                        String message = pyCharm ? PyPsiBundle.message("INSP.interpreter.python.has.reached.its.end.of.life.and.is.no.longer.supported.in.pycharm", new Object[]{languageLevel}) : PyPsiBundle.message("INSP.interpreter.python.has.reached.its.end.life.and.is.no.longer.supported.in.python.plugin", new Object[]{languageLevel});
                        this.registerProblemWithCommonFixes(node, message, module, sdk, fixes, pyCharm);
                    }
                }
            }
        }

        private void registerProblemWithCommonFixes(PyFile node, @InspectionMessage String message, Module module, Sdk sdk, List<LocalQuickFix> fixes, boolean pyCharm) {
            if (pyCharm && sdk == null) {
                String sdkName = ProjectRootManager.getInstance((Project)node.getProject()).getProjectSdkName();
                ContainerUtil.addIfNotNull(fixes, (Object)Visitor.getSuitableSdkFix(sdkName, module));
            }
            if (pyCharm) {
                fixes.add(new ConfigureInterpreterFix());
            } else {
                fixes.add(new InterpreterSettingsQuickFix(module));
            }
            this.registerProblem((PsiElement)node, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }

        @Nullable
        private static LocalQuickFix getSuitableSdkFix(@Nullable String name2, @NotNull Module module) {
            Sdk systemWideSdk;
            Matcher matcher;
            List<Sdk> existingSdks2;
            Sdk associatedSdk;
            if (module == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((associatedSdk = PySdkExtKt.mostPreferred(PySdkExtKt.filterAssociatedSdks(module, existingSdks2 = Visitor.getExistingSdks()))) != null) {
                return new UseExistingInterpreterFix(associatedSdk, module);
            }
            UserDataHolderBase context2 = new UserDataHolderBase();
            List detectedAssociatedEnvs = Collections.emptyList();
            while (true) {
                try {
                    detectedAssociatedEnvs = (List)DETECTED_ASSOCIATED_ENVS_CACHE.get((Object)module).get(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException ignored) {
                    ProgressManager.checkCanceled();
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to get suitable sdk fix for name " + name2 + " and module " + module, (Throwable)e);
                }
                break;
            }
            PyDetectedSdk detectedAssociatedSdk = (PyDetectedSdk)((Object)ContainerUtil.getFirstItem((List)detectedAssociatedEnvs));
            if (detectedAssociatedSdk != null) {
                return new UseDetectedInterpreterFix(detectedAssociatedSdk, existingSdks2, true, module);
            }
            Pair<@IntentionName String, PyProjectSdkConfigurationExtension> textAndExtension = PyProjectSdkConfigurationExtension.findForModule(module);
            if (textAndExtension != null) {
                return new UseProvidedInterpreterFix(module, (PyProjectSdkConfigurationExtension)textAndExtension.getSecond(), (String)textAndExtension.getFirst());
            }
            if (name2 != null && (matcher = NAME.matcher(name2)).matches()) {
                String venvName = matcher.group("name");
                if (venvName != null) {
                    PyDetectedSdk detectedAssociatedViaRootNameEnv = Visitor.detectAssociatedViaRootNameEnv(venvName, module, existingSdks2, context2);
                    if (detectedAssociatedViaRootNameEnv != null) {
                        return new UseDetectedInterpreterFix(detectedAssociatedViaRootNameEnv, existingSdks2, true, module);
                    }
                } else {
                    PyDetectedSdk detectedSystemWideSdk = Visitor.detectSystemWideSdk(matcher.group("version"), module, existingSdks2, context2);
                    if (detectedSystemWideSdk != null) {
                        return new UseDetectedInterpreterFix(detectedSystemWideSdk, existingSdks2, false, module);
                    }
                }
            }
            if (PyCondaSdkCustomizer.Companion.getInstance().getSuggestSharedCondaEnvironments()) {
                Sdk sharedCondaEnv = PySdkExtKt.mostPreferred(PySdkExtKt.filterSharedCondaEnvs(module, existingSdks2));
                if (sharedCondaEnv != null) {
                    return new UseExistingInterpreterFix(sharedCondaEnv, module);
                }
                PyDetectedSdk detectedCondaEnv = (PyDetectedSdk)((Object)ContainerUtil.getFirstItem(PySdkExtKt.detectCondaEnvs(module, existingSdks2, (UserDataHolder)context2)));
                if (detectedCondaEnv != null) {
                    return new UseDetectedInterpreterFix(detectedCondaEnv, existingSdks2, false, module);
                }
            }
            if ((systemWideSdk = PySdkExtKt.mostPreferred(PySdkExtKt.filterSystemWideSdks(existingSdks2))) != null) {
                return new UseExistingInterpreterFix(systemWideSdk, module);
            }
            PyDetectedSdk detectedSystemWideSdk = (PyDetectedSdk)((Object)ContainerUtil.getFirstItem(PySdkExtKt.detectSystemWideSdks(module, existingSdks2)));
            if (detectedSystemWideSdk != null) {
                return new UseDetectedInterpreterFix(detectedSystemWideSdk, existingSdks2, false, module);
            }
            return null;
        }

        @NotNull
        private static List<Sdk> getExistingSdks() {
            ProjectSdksModel model = new ProjectSdksModel();
            model.reset(null);
            List list = ContainerUtil.filter((Object[])model.getSdks(), it -> it.getSdkType() instanceof PythonSdkType);
            if (list == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Nullable
        private static PyDetectedSdk detectAssociatedViaRootNameEnv(@NotNull String associatedName, @NotNull Module module, @NotNull List<Sdk> existingSdks2, @NotNull UserDataHolderBase context2) {
            if (associatedName == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (module == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (existingSdks2 == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            return Visitor.findAssociatedViaRootNameEnv(associatedName, PySdkExtKt.detectVirtualEnvs(module, existingSdks2, (UserDataHolder)context2), Visitor::getVirtualEnvRootName);
        }

        @Nullable
        private static PyDetectedSdk detectSystemWideSdk(@NotNull String version, @NotNull Module module, @NotNull List<Sdk> existingSdks2, @NotNull UserDataHolderBase context2) {
            LanguageLevel parsedVersion;
            if (version == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            if (module == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            if (existingSdks2 == null) {
                Visitor.$$$reportNull$$$0(10);
            }
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(11);
            }
            if ((parsedVersion = LanguageLevel.fromPythonVersion(version)).toString().equals(version)) {
                return (PyDetectedSdk)((Object)ContainerUtil.find(PySdkExtKt.detectSystemWideSdks(module, existingSdks2, (UserDataHolder)context2), sdk -> PySdkExtKt.getGuessedLanguageLevel(sdk) == parsedVersion));
            }
            return null;
        }

        @Nullable
        private static PyDetectedSdk findAssociatedViaRootNameEnv(@NotNull String associatedName, @NotNull List<PyDetectedSdk> envs, @NotNull Function<PyDetectedSdk, String> envRootName) {
            if (associatedName == null) {
                Visitor.$$$reportNull$$$0(12);
            }
            if (envs == null) {
                Visitor.$$$reportNull$$$0(13);
            }
            if (envRootName == null) {
                Visitor.$$$reportNull$$$0(14);
            }
            return ((StreamEx)StreamEx.of(envs).filter(sdk -> associatedName.equals(envRootName.apply((PyDetectedSdk)((Object)sdk))))).max(Comparator.comparing(PySdkExtKt::getGuessedLanguageLevel).thenComparing(ProjectJdkImpl::getHomePath)).orElse(null);
        }

        @Nullable
        private static String getVirtualEnvRootName(@NotNull PyDetectedSdk sdk) {
            String path2;
            if (sdk == null) {
                Visitor.$$$reportNull$$$0(15);
            }
            return (path2 = sdk.getHomePath()) == null ? null : Visitor.getEnvRootName(PythonSdkUtil.getVirtualEnvRoot(path2));
        }

        @Nullable
        private static String getEnvRootName(@Nullable File envRoot) {
            return envRoot == null ? null : PathUtil.getFileName((String)envRoot.getPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$Visitor";
                    break;
                }
                case 4: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "associatedName";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingSdks";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envs";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envRootName";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$Visitor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExistingSdks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitableSdkFix";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "detectAssociatedViaRootNameEnv";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "detectSystemWideSdk";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "findAssociatedViaRootNameEnv";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getVirtualEnvRootName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class CacheCleaner
        implements ModuleRootListener,
        ProjectJdkTable.Listener {
            private CacheCleaner() {
            }

            public void beforeRootsChange(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    CacheCleaner.$$$reportNull$$$0(0);
                }
                this.invalidate();
            }

            public void jdkAdded(@NotNull Sdk jdk) {
                if (jdk == null) {
                    CacheCleaner.$$$reportNull$$$0(1);
                }
                this.invalidate();
            }

            public void jdkRemoved(@NotNull Sdk jdk) {
                if (jdk == null) {
                    CacheCleaner.$$$reportNull$$$0(2);
                }
                this.invalidate();
            }

            public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
                if (jdk == null) {
                    CacheCleaner.$$$reportNull$$$0(3);
                }
                if (previousName == null) {
                    CacheCleaner.$$$reportNull$$$0(4);
                }
                this.invalidate();
            }

            private void invalidate() {
                DETECTED_ASSOCIATED_ENVS_CACHE.synchronous().invalidateAll();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jdk";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "previousName";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$Visitor$CacheCleaner";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRootsChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkAdded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkRemoved";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkNameChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

