/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.array.ArrayTableCellRenderer;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.ColumnFilter;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayViewStrategy
extends DataViewStrategy {
    private static final String NDARRAY = "ndarray";

    @Override
    public AsyncArrayTableModel createTableModel(int rowCount, int columnCount, @NotNull PyDataViewerPanel panel2, @NotNull PyDebugValue debugValue) {
        if (panel2 == null) {
            ArrayViewStrategy.$$$reportNull$$$0(0);
        }
        if (debugValue == null) {
            ArrayViewStrategy.$$$reportNull$$$0(1);
        }
        return new AsyncArrayTableModel(rowCount, columnCount, panel2, debugValue, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ColoredCellRenderer createCellRenderer(double minValue, double maxValue, @NotNull ArrayChunk arrayChunk) {
        void arrayChunk2;
        if (arrayChunk == null) {
            ArrayViewStrategy.$$$reportNull$$$0(2);
        }
        ArrayTableCellRenderer renderer = new ArrayTableCellRenderer(minValue, maxValue, arrayChunk2.getType());
        renderer.fillColorRange(arrayChunk2.getMin(), arrayChunk2.getMax());
        return renderer;
    }

    @Override
    public boolean isNumeric(String dtypeKind) {
        if (dtypeKind != null) {
            return "biufc".contains(dtypeKind.substring(0, 1));
        }
        return false;
    }

    @Override
    @NotNull
    public String sortModifier(@NotNull String varName, @NotNull RowSorter.SortKey key) {
        if (varName == null) {
            ArrayViewStrategy.$$$reportNull$$$0(3);
        }
        if (key == null) {
            ArrayViewStrategy.$$$reportNull$$$0(4);
        }
        String string = String.format("%s[%s[:,%d].argsort()%s]", varName, varName, key.getColumn(), key.getSortOrder() == SortOrder.ASCENDING ? "" : "[::-1]");
        if (string == null) {
            ArrayViewStrategy.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String filterModifier(@NotNull String varName, @NotNull ColumnFilter filter) {
        if (varName == null) {
            ArrayViewStrategy.$$$reportNull$$$0(6);
        }
        if (filter == null) {
            ArrayViewStrategy.$$$reportNull$$$0(7);
        }
        if (filter.isSubstring()) {
            throw new UnsupportedOperationException("Substring search is not supported on numpy arrays");
        }
        String string = String.format("%1$s[_np_vectorize(lambda %4$s: bool(%2$s))(%1$s[:, %3$d])]", varName, filter.getFilter(), filter.getColumn(), "x");
        if (string == null) {
            ArrayViewStrategy.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public String getInitExecuteString() {
        return "import numpy as _np; _np_vectorize = _np.vectorize";
    }

    @Override
    @NotNull
    public String getTypeName() {
        return NDARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayChunk";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/array/ArrayViewStrategy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/array/ArrayViewStrategy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sortModifier";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "filterModifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTableModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCellRenderer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sortModifier";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterModifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

