/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.actions;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.Function;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleExecuteActionHandler;
import com.jetbrains.python.console.actions.CommandQueueListener;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class CommandQueueForPythonConsoleService {
    private final Map<ConsoleCommunication, CommandQueueListener> myListeners = new ConcurrentHashMap<ConsoleCommunication, CommandQueueListener>();
    private final Map<ConsoleCommunication, Queue<ConsoleCommunication.ConsoleCodeFragment>> queues = new ConcurrentHashMap<ConsoleCommunication, Queue<ConsoleCommunication.ConsoleCodeFragment>>();
    private final Map<ConsoleCommunication, PydevConsoleExecuteActionHandler> handlers = new ConcurrentHashMap<ConsoleCommunication, PydevConsoleExecuteActionHandler>();
    @NlsSafe
    private static final String STUB = "pass";

    @Nullable
    private Queue<ConsoleCommunication.ConsoleCodeFragment> getQueue(@NotNull ConsoleCommunication consoleComm) {
        if (consoleComm == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(0);
        }
        return this.queues.get(consoleComm);
    }

    public synchronized void addListener(@NotNull ConsoleCommunication consoleComm, @NotNull CommandQueueListener listener2) {
        if (consoleComm == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(1);
        }
        if (listener2 == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(2);
        }
        this.myListeners.put(consoleComm, listener2);
    }

    public synchronized void removeListener(@NotNull ConsoleCommunication consoleComm) {
        if (consoleComm == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(3);
        }
        this.myListeners.remove(consoleComm);
    }

    public synchronized void removeFirstCommand(@NotNull ConsoleCommunication consoleComm) {
        Queue<ConsoleCommunication.ConsoleCodeFragment> queue;
        if (consoleComm == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(4);
        }
        if ((queue = this.getQueue(consoleComm)) != null) {
            queue.remove();
        }
    }

    @Nullable
    public synchronized ConsoleCommunication.ConsoleCodeFragment getFirstCommand(@NotNull ConsoleCommunication consoleComm) {
        Queue<ConsoleCommunication.ConsoleCodeFragment> queue;
        if (consoleComm == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(5);
        }
        if ((queue = this.getQueue(consoleComm)) == null) {
            return null;
        }
        for (ConsoleCommunication.ConsoleCodeFragment elem : queue) {
            if (elem.getText().equals(STUB)) continue;
            return elem;
        }
        return null;
    }

    public boolean isEmpty(@NotNull ConsoleCommunication consoleComm) {
        if (consoleComm == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(6);
        }
        if (consoleComm instanceof PydevConsoleCommunication && ((PydevConsoleCommunication)consoleComm).isCommunicationClosed()) {
            return true;
        }
        Queue<ConsoleCommunication.ConsoleCodeFragment> queue = this.getQueue(consoleComm);
        if (queue == null) {
            return true;
        }
        return queue.isEmpty();
    }

    public synchronized boolean isOneElement(@NotNull ConsoleCommunication consoleComm) {
        Queue<ConsoleCommunication.ConsoleCodeFragment> queue;
        if (consoleComm == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(7);
        }
        if ((queue = this.getQueue(consoleComm)) == null) {
            return false;
        }
        return queue.size() == 1;
    }

    public synchronized boolean isTwoElement(@NotNull ConsoleCommunication consoleComm) {
        Queue<ConsoleCommunication.ConsoleCodeFragment> queue;
        if (consoleComm == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(8);
        }
        if ((queue = this.getQueue(consoleComm)) == null) {
            return false;
        }
        return queue.size() == 2;
    }

    public synchronized void removeCommand(@NotNull ConsoleCommunication consoleComm, boolean exceptionOccurred) {
        Queue<ConsoleCommunication.ConsoleCodeFragment> queue;
        if (consoleComm == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(9);
        }
        if ((queue = this.getQueue(consoleComm)) == null) {
            return;
        }
        if (!queue.isEmpty()) {
            if (exceptionOccurred) {
                int value = queue.size();
                if (value > 1) {
                    this.handlers.get(consoleComm).decreaseInputPromptCount(value - 1);
                }
                queue.clear();
                this.myListeners.get(consoleComm).removeAll();
            } else {
                ConsoleCommunication.ConsoleCodeFragment command = queue.remove();
                if (!command.getText().isBlank() && !command.getText().equals(STUB)) {
                    this.myListeners.get(consoleComm).removeCommand(command);
                }
                if (!queue.isEmpty()) {
                    CommandQueueForPythonConsoleService.execCommand(consoleComm, queue.peek());
                }
            }
        }
    }

    public synchronized void removeCommand(@NotNull ConsoleCommunication consoleComm, @NotNull ConsoleCommunication.ConsoleCodeFragment codeFragment) {
        Queue<ConsoleCommunication.ConsoleCodeFragment> queue;
        if (consoleComm == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(10);
        }
        if (codeFragment == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(11);
        }
        if ((queue = this.getQueue(consoleComm)) == null) {
            return;
        }
        if (!queue.isEmpty()) {
            for (ConsoleCommunication.ConsoleCodeFragment code : queue) {
                if (!code.equals(codeFragment)) continue;
                code.setText(STUB);
                break;
            }
        }
    }

    public synchronized void addNewCommand(@NotNull PydevConsoleExecuteActionHandler pydevConsoleExecuteActionHandler, @NotNull ConsoleCommunication.ConsoleCodeFragment code) {
        Queue<ConsoleCommunication.ConsoleCodeFragment> queue;
        ConsoleCommunication console;
        if (pydevConsoleExecuteActionHandler == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(12);
        }
        if (code == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(13);
        }
        if ((console = pydevConsoleExecuteActionHandler.getConsoleCommunication()).isWaitingForInput()) {
            CommandQueueForPythonConsoleService.execCommand(console, code);
            return;
        }
        if (!this.queues.containsKey(console)) {
            this.queues.put(console, new ConcurrentLinkedDeque());
            this.handlers.put(console, pydevConsoleExecuteActionHandler);
        }
        if ((queue = this.getQueue(console)) == null) {
            return;
        }
        if (!code.getText().isBlank()) {
            queue.add(code);
            this.myListeners.get(console).addCommand(code);
        }
        if (queue.size() == 1) {
            CommandQueueForPythonConsoleService.execCommand(console, code);
        }
        pydevConsoleExecuteActionHandler.updateConsoleState();
    }

    private static void execCommand(@NotNull ConsoleCommunication comm, @NotNull ConsoleCommunication.ConsoleCodeFragment code) {
        if (comm == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(14);
        }
        if (code == null) {
            CommandQueueForPythonConsoleService.$$$reportNull$$$0(15);
        }
        comm.execInterpreter(code, (Function<InterpreterResponse, Object>)((Function)x -> null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleComm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pydevConsoleExecuteActionHandler";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comm";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/console/actions/CommandQueueForPythonConsoleService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getQueue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeFirstCommand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFirstCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isEmpty";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isOneElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isTwoElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCommand";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addNewCommand";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "execCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

