/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMapper;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PydevConsoleRunnerUtil;
import com.jetbrains.python.console.PydevConsoleWithFileRunnerImpl;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.EnvironmentController;
import com.jetbrains.python.run.PlainEnvironmentController;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.TargetedPythonPaths;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0004\u000e\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory;", "Lcom/jetbrains/python/console/PythonConsoleRunnerFactory;", "()V", "createConsoleParameters", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters;", "project", "Lcom/intellij/openapi/project/Project;", "contextModule", "Lcom/intellij/openapi/module/Module;", "createConsoleRunner", "Lcom/jetbrains/python/console/PydevConsoleRunner;", "createConsoleRunnerWithFile", "config", "Lcom/jetbrains/python/run/PythonRunConfiguration;", "Companion", "ConsoleParameters", "ConstantConsoleParameters", "TargetedConsoleParameters", "intellij.python.community.impl"})
public class PydevConsoleRunnerFactory
extends PythonConsoleRunnerFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected ConsoleParameters createConsoleParameters(@NotNull Project project, @Nullable Module contextModule) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Pair<Sdk, Module> sdkAndModule = PydevConsoleRunnerUtil.findPythonSdkAndModule(project, contextModule);
        Module module = (Module)sdkAndModule.second;
        Sdk sdk = (Sdk)sdkAndModule.first;
        PyConsoleOptions pyConsoleOptions = PyConsoleOptions.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleOptions, (String)"PyConsoleOptions.getInstance(project)");
        PyConsoleOptions.PyConsoleSettings pyConsoleSettings = pyConsoleOptions.getPythonConsoleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleSettings, (String)"PyConsoleOptions.getInst\u2026ct).pythonConsoleSettings");
        PyConsoleOptions.PyConsoleSettings settingsProvider = pyConsoleSettings;
        PyRemotePathMapper pathMapper = PydevConsoleRunnerUtil.getPathMapper(project, sdk, settingsProvider);
        Map<String, String> map2 = settingsProvider.getEnvs();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"settingsProvider.envs");
        Map envs = MapsKt.toMutableMap(map2);
        Companion.putIPythonEnvFlag(project, envs);
        if (Registry.is((String)"python.use.targets.api")) {
            Function workingDirFunction = PydevConsoleRunnerFactory.Companion.getWorkingDirFunction(project, module, (PathMapper)pathMapper, settingsProvider);
            Function setupScriptFunction = PydevConsoleRunnerFactory.Companion.createSetupScriptFunction(project, module, workingDirFunction, pathMapper, settingsProvider);
            PyConsoleType pyConsoleType = PyConsoleType.PYTHON;
            Intrinsics.checkNotNullExpressionValue((Object)pyConsoleType, (String)"PyConsoleType.PYTHON");
            return new TargetedConsoleParameters(project, sdk, workingDirFunction, (Map<String, String>)envs, pyConsoleType, settingsProvider, (Function<TargetEnvironment, String>)setupScriptFunction);
        }
        String workingDir = Companion.getWorkingDir(project, module, (PathMapper)pathMapper, settingsProvider);
        String[] setupFragment = Companion.createSetupFragment(module, workingDir, (PathMapper)pathMapper, settingsProvider);
        PyConsoleType pyConsoleType = PyConsoleType.PYTHON;
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleType, (String)"PyConsoleType.PYTHON");
        return new ConstantConsoleParameters(project, sdk, workingDir, (Map<String, String>)envs, pyConsoleType, settingsProvider, setupFragment);
    }

    @Override
    @NotNull
    public PydevConsoleRunner createConsoleRunner(@NotNull Project project, @Nullable Module contextModule) {
        PydevConsoleRunner pydevConsoleRunner;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ConsoleParameters consoleParameters = this.createConsoleParameters(project, contextModule);
        if (consoleParameters instanceof ConstantConsoleParameters) {
            String[] stringArray = ((ConstantConsoleParameters)consoleParameters).getSetupFragment();
            pydevConsoleRunner = new PydevConsoleRunnerImpl(project, consoleParameters.getSdk(), consoleParameters.getConsoleType(), consoleParameters.getWorkingDir(), consoleParameters.getEnvs(), consoleParameters.getSettingsProvider(), Arrays.copyOf(stringArray, stringArray.length));
        } else if (consoleParameters instanceof TargetedConsoleParameters) {
            pydevConsoleRunner = new PydevConsoleRunnerImpl(project, consoleParameters.getSdk(), consoleParameters.getConsoleType(), consoleParameters.getConsoleType().getTitle(), ((TargetedConsoleParameters)consoleParameters).getWorkingDirFunction(), consoleParameters.getEnvs(), consoleParameters.getSettingsProvider(), ((TargetedConsoleParameters)consoleParameters).getSetupScript());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pydevConsoleRunner;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PydevConsoleRunner createConsoleRunnerWithFile(@NotNull Project project, @NotNull PythonRunConfiguration config) {
        PydevConsoleRunner pydevConsoleRunner;
        block5: {
            block6: {
                Object object;
                String string;
                PyConsoleType pyConsoleType;
                Sdk sdk;
                Project project2;
                Map consoleEnvs;
                ConsoleParameters consoleParameters;
                block8: {
                    block7: {
                        void it;
                        String string2;
                        ConsoleParameters consoleParameters2;
                        Sdk sdk2;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                            consoleParameters = this.createConsoleParameters(project, config.getModule());
                            sdk2 = config.getSdk() != null ? config.getSdk() : consoleParameters.getSdk();
                            consoleEnvs = new LinkedHashMap();
                            consoleEnvs.putAll(consoleParameters.getEnvs());
                            Map map2 = config.getEnvs();
                            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"config.envs");
                            consoleEnvs.putAll(map2);
                            consoleParameters2 = consoleParameters;
                            if (!(consoleParameters2 instanceof ConstantConsoleParameters)) break block4;
                            PyConsoleType pyConsoleType2 = consoleParameters.getConsoleType();
                            String string3 = config.getName();
                            String string4 = config.getWorkingDirectory();
                            if (string4 == null) {
                                string4 = consoleParameters.getWorkingDir();
                            }
                            String[] stringArray = ((ConstantConsoleParameters)consoleParameters).getSetupFragment();
                            pydevConsoleRunner = new PydevConsoleWithFileRunnerImpl(project, sdk2, pyConsoleType2, string3, string4, (Map<String, String>)consoleEnvs, consoleParameters.getSettingsProvider(), config, Arrays.copyOf(stringArray, stringArray.length));
                            break block5;
                        }
                        if (!(consoleParameters2 instanceof TargetedConsoleParameters)) break block6;
                        project2 = project;
                        sdk = sdk2;
                        pyConsoleType = consoleParameters.getConsoleType();
                        string = config.getName();
                        object = config.getWorkingDirectory();
                        if (object == null) break block7;
                        String string5 = string2 = object;
                        String string6 = string;
                        PyConsoleType pyConsoleType3 = pyConsoleType;
                        Sdk sdk3 = sdk;
                        Project project3 = project2;
                        boolean bl = false;
                        Function function = TargetEnvironmentFunctions.constant((Object)it);
                        project2 = project3;
                        sdk = sdk3;
                        pyConsoleType = pyConsoleType3;
                        string = string6;
                        object = function;
                        if (object != null) break block8;
                    }
                    object = ((TargetedConsoleParameters)consoleParameters).getWorkingDirFunction();
                }
                Function<TargetEnvironment, String> function = ((TargetedConsoleParameters)consoleParameters).getSetupScript();
                PythonRunConfiguration pythonRunConfiguration = config;
                PyConsoleOptions.PyConsoleSettings pyConsoleSettings = consoleParameters.getSettingsProvider();
                Map map3 = consoleEnvs;
                Object object2 = object;
                String string7 = string;
                PyConsoleType pyConsoleType4 = pyConsoleType;
                Sdk sdk4 = sdk;
                Project project4 = project2;
                pydevConsoleRunner = new PydevConsoleWithFileRunnerImpl(project4, sdk4, pyConsoleType4, string7, (Function<TargetEnvironment, String>)object2, (Map<String, String>)map3, pyConsoleSettings, pythonRunConfiguration, function);
                break block5;
            }
            throw new NoWhenBranchMatchedException();
        }
        return pydevConsoleRunner;
    }

    @JvmStatic
    public static final void putIPythonEnvFlag(@NotNull Project project, @NotNull EnvironmentController environmentController) {
        Companion.putIPythonEnvFlag(project, environmentController);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b5\u0018\u00002\u00020\u0001BG\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u0082\u0001\u0002\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters;", "", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "workingDir", "", "envs", "", "consoleType", "Lcom/jetbrains/python/console/PyConsoleType;", "settingsProvider", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/util/Map;Lcom/jetbrains/python/console/PyConsoleType;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;)V", "getConsoleType", "()Lcom/jetbrains/python/console/PyConsoleType;", "getEnvs", "()Ljava/util/Map;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getSettingsProvider", "()Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "getWorkingDir$annotations", "()V", "getWorkingDir", "()Ljava/lang/String;", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConstantConsoleParameters;", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$TargetedConsoleParameters;", "intellij.python.community.impl"})
    @ApiStatus.Experimental
    protected static abstract class ConsoleParameters {
        @NotNull
        private final Project project;
        @Nullable
        private final Sdk sdk;
        @ApiStatus.ScheduledForRemoval
        @Nullable
        private final String workingDir;
        @NotNull
        private final Map<String, String> envs;
        @NotNull
        private final PyConsoleType consoleType;
        @NotNull
        private final PyConsoleOptions.PyConsoleSettings settingsProvider;

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public final Sdk getSdk() {
            return this.sdk;
        }

        @Deprecated(message="Use `ConstantConsoleParameters.workingDir`")
        public static /* synthetic */ void getWorkingDir$annotations() {
        }

        @Nullable
        public String getWorkingDir() {
            return this.workingDir;
        }

        @NotNull
        public final Map<String, String> getEnvs() {
            return this.envs;
        }

        @NotNull
        public final PyConsoleType getConsoleType() {
            return this.consoleType;
        }

        @NotNull
        public final PyConsoleOptions.PyConsoleSettings getSettingsProvider() {
            return this.settingsProvider;
        }

        private ConsoleParameters(Project project, Sdk sdk, String workingDir, Map<String, String> envs, PyConsoleType consoleType, PyConsoleOptions.PyConsoleSettings settingsProvider) {
            this.project = project;
            this.sdk = sdk;
            this.workingDir = workingDir;
            this.envs = envs;
            this.consoleType = consoleType;
            this.settingsProvider = settingsProvider;
        }

        public /* synthetic */ ConsoleParameters(Project project, Sdk sdk, String workingDir, Map envs, PyConsoleType consoleType, PyConsoleOptions.PyConsoleSettings settingsProvider, DefaultConstructorMarker $constructor_marker) {
            this(project, sdk, workingDir, envs, consoleType, settingsProvider);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0005\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\u0002\u0010\u0010R\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConstantConsoleParameters;", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "workingDir", "", "envs", "", "consoleType", "Lcom/jetbrains/python/console/PyConsoleType;", "settingsProvider", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "setupFragment", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/util/Map;Lcom/jetbrains/python/console/PyConsoleType;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;[Ljava/lang/String;)V", "getSetupFragment", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getWorkingDir", "()Ljava/lang/String;", "intellij.python.community.impl"})
    @ApiStatus.Experimental
    protected static final class ConstantConsoleParameters
    extends ConsoleParameters {
        @Nullable
        private final String workingDir;
        @NotNull
        private final String[] setupFragment;

        @Override
        @Nullable
        public String getWorkingDir() {
            return this.workingDir;
        }

        @NotNull
        public final String[] getSetupFragment() {
            return this.setupFragment;
        }

        public ConstantConsoleParameters(@NotNull Project project, @Nullable Sdk sdk, @Nullable String workingDir, @NotNull Map<String, String> envs, @NotNull PyConsoleType consoleType, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull String[] setupFragment) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            Intrinsics.checkNotNullParameter((Object)consoleType, (String)"consoleType");
            Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
            Intrinsics.checkNotNullParameter((Object)setupFragment, (String)"setupFragment");
            super(project, sdk, workingDir, envs, consoleType, settingsProvider, null);
            this.workingDir = workingDir;
            this.setupFragment = setupFragment;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0005\u0018\u00002\u00020\u0001B}\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012 \u0010\u0006\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007j\n\u0012\u0004\u0012\u00020\t\u0018\u0001`\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u001c\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\u0002\u0010\u0012Be\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u001c\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\u0002\u0010\u0014B\u0087\u0001\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\t\u0012 \u0010\u0006\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007j\n\u0012\u0004\u0012\u00020\t\u0018\u0001`\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u001c\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\u0002\u0010\u0015R'\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R+\u0010\u0006\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007j\n\u0012\u0004\u0012\u00020\t\u0018\u0001`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$TargetedConsoleParameters;", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "workingDirFunction", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "envs", "", "consoleType", "Lcom/jetbrains/python/console/PyConsoleType;", "settingsProvider", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "setupScript", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/util/function/Function;Ljava/util/Map;Lcom/jetbrains/python/console/PyConsoleType;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;Ljava/util/function/Function;)V", "workingDir", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/util/Map;Lcom/jetbrains/python/console/PyConsoleType;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;Ljava/util/function/Function;)V", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/util/function/Function;Ljava/util/Map;Lcom/jetbrains/python/console/PyConsoleType;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;Ljava/util/function/Function;)V", "getSetupScript", "()Ljava/util/function/Function;", "getWorkingDirFunction", "intellij.python.community.impl"})
    @ApiStatus.Experimental
    protected static final class TargetedConsoleParameters
    extends ConsoleParameters {
        @Nullable
        private final Function<TargetEnvironment, String> workingDirFunction;
        @NotNull
        private final Function<TargetEnvironment, String> setupScript;

        @Nullable
        public final Function<TargetEnvironment, String> getWorkingDirFunction() {
            return this.workingDirFunction;
        }

        @NotNull
        public final Function<TargetEnvironment, String> getSetupScript() {
            return this.setupScript;
        }

        private TargetedConsoleParameters(Project project, Sdk sdk, String workingDir, Function<TargetEnvironment, String> workingDirFunction, Map<String, String> envs, PyConsoleType consoleType, PyConsoleOptions.PyConsoleSettings settingsProvider, Function<TargetEnvironment, String> setupScript) {
            super(project, sdk, workingDir, envs, consoleType, settingsProvider, null);
            this.workingDirFunction = workingDirFunction;
            this.setupScript = setupScript;
        }

        public TargetedConsoleParameters(@NotNull Project project, @Nullable Sdk sdk, @Nullable Function<TargetEnvironment, String> workingDirFunction, @NotNull Map<String, String> envs, @NotNull PyConsoleType consoleType, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Function<TargetEnvironment, String> setupScript) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            Intrinsics.checkNotNullParameter((Object)consoleType, (String)"consoleType");
            Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
            Intrinsics.checkNotNullParameter(setupScript, (String)"setupScript");
            this(project, sdk, null, workingDirFunction, envs, consoleType, settingsProvider, setupScript);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated(message="Use another constructor")
        @ApiStatus.ScheduledForRemoval
        public TargetedConsoleParameters(@NotNull Project project, @Nullable Sdk sdk, @Nullable String workingDir, @NotNull Map<String, String> envs, @NotNull PyConsoleType consoleType, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Function<TargetEnvironment, String> setupScript) {
            Function function;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            Intrinsics.checkNotNullParameter((Object)consoleType, (String)"consoleType");
            Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
            Intrinsics.checkNotNullParameter(setupScript, (String)"setupScript");
            TargetedConsoleParameters targetedConsoleParameters = this;
            Project project2 = project;
            Sdk sdk2 = sdk;
            String string = workingDir;
            String string2 = workingDir;
            if (string2 != null) {
                void it;
                String string3;
                String string4 = string3 = string2;
                String string5 = string;
                Sdk sdk3 = sdk2;
                Project project3 = project2;
                TargetedConsoleParameters targetedConsoleParameters2 = targetedConsoleParameters;
                boolean bl = false;
                Function function2 = TargetEnvironmentFunctions.constant((Object)it);
                targetedConsoleParameters = targetedConsoleParameters2;
                project2 = project3;
                sdk2 = sdk3;
                string = string5;
                function = function2;
            } else {
                function = null;
            }
            targetedConsoleParameters(project2, sdk2, string, function, envs, consoleType, settingsProvider, setupScript);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJd\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00050\u000fj\b\u0012\u0004\u0012\u00020\u0005`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072 \u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000fj\n\u0012\u0004\u0012\u00020\u0005\u0018\u0001`\u00112\b\u0010\t\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002JF\u0010\u0017\u001a\u001c\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000fj\n\u0012\u0004\u0012\u00020\u0005\u0018\u0001`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001d\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$Companion;", "", "()V", "createSetupFragment", "", "", "module", "Lcom/intellij/openapi/module/Module;", "workingDir", "pathMapper", "Lcom/intellij/util/PathMapper;", "settingsProvider", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;Lcom/intellij/util/PathMapper;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;)[Ljava/lang/String;", "createSetupScriptFunction", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "getWorkingDir", "getWorkingDirFromSettings", "getWorkingDirFunction", "putIPythonEnvFlag", "", "environmentController", "Lcom/jetbrains/python/run/EnvironmentController;", "envs", "", "intellij.python.community.impl"})
    public static final class Companion {
        public final void putIPythonEnvFlag(@NotNull Project project, @NotNull Map<String, String> envs) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            this.putIPythonEnvFlag(project, new PlainEnvironmentController(envs));
        }

        @JvmStatic
        public final void putIPythonEnvFlag(@NotNull Project project, @NotNull EnvironmentController environmentController) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)environmentController, (String)"environmentController");
            PyConsoleOptions pyConsoleOptions = PyConsoleOptions.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)pyConsoleOptions, (String)"PyConsoleOptions.getInstance(project)");
            String ipythonEnabled = pyConsoleOptions.isIpythonEnabled() ? "True" : "False";
            environmentController.putFixedValue("IPYTHONENABLE", ipythonEnabled);
        }

        @Nullable
        public final String getWorkingDir(@NotNull Project project, @Nullable Module module, @Nullable PathMapper pathMapper, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
            String workingDir = this.getWorkingDirFromSettings(project, module, settingsProvider);
            if (pathMapper != null && workingDir != null) {
                workingDir = pathMapper.convertToRemote(workingDir);
            }
            return workingDir;
        }

        private final Function<TargetEnvironment, String> getWorkingDirFunction(Project project, Module module, PathMapper pathMapper, PyConsoleOptions.PyConsoleSettings settingsProvider) {
            Function function;
            String workingDir = this.getWorkingDirFromSettings(project, module, settingsProvider);
            if (pathMapper != null && workingDir != null && pathMapper.canReplaceLocal(workingDir)) {
                String string = pathMapper.convertToRemote(workingDir);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathMapper.convertToRemote(workingDir)");
                return TargetEnvironmentFunctions.constant((Object)string);
            }
            CharSequence charSequence = workingDir;
            if (charSequence == null || charSequence.length() == 0) {
                function = null;
            } else {
                Path path2 = Path.of(workingDir, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Path.of(workingDir)");
                function = TargetEnvironmentFunctions.targetPath((Path)path2);
            }
            return function;
        }

        private final String getWorkingDirFromSettings(Project project, Module module, PyConsoleOptions.PyConsoleSettings settingsProvider) {
            VirtualFile[] projectRoots;
            String workingDirectoryInSettings = settingsProvider.getWorkingDirectory();
            VirtualFile[] virtualFileArray = (VirtualFile[])workingDirectoryInSettings;
            if (!(virtualFileArray == null || virtualFileArray.length() == 0)) {
                return workingDirectoryInSettings;
            }
            if (module != null) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                VirtualFile[] virtualFileArray2 = moduleRootManager.getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"ModuleRootManager.getInstance(module).contentRoots");
                virtualFileArray = virtualFileArray2;
                if (!(virtualFileArray.length == 0)) {
                    ModuleRootManager moduleRootManager2 = ModuleRootManager.getInstance((Module)module);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager2, (String)"ModuleRootManager.getInstance(module)");
                    VirtualFile virtualFile = moduleRootManager2.getContentRoots()[0];
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"ModuleRootManager.getIns\u2026e(module).contentRoots[0]");
                    return virtualFile.getPath();
                }
            }
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
            VirtualFile[] virtualFileArray3 = projectRoots = projectRootManager.getContentRoots();
            int n = virtualFileArray3.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile root;
                VirtualFile virtualFile = root = virtualFileArray3[i];
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"root");
                if (!(virtualFile.getFileSystem() instanceof LocalFileSystem)) continue;
                return root.getPath();
            }
            return System.getProperty("user.home");
        }

        @NotNull
        public final String[] createSetupFragment(@Nullable Module module, @Nullable String workingDir, @Nullable PathMapper pathMapper, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider) {
            Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
            Object customStartScript = settingsProvider.getCustomStartScript();
            String string = customStartScript;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"customStartScript");
            CharSequence charSequence = string;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                customStartScript = "\n" + (String)customStartScript;
            }
            Collection collection = PythonCommandLineState.collectPythonPath(module, settingsProvider.shouldAddContentRoots(), settingsProvider.shouldAddSourceRoots());
            Intrinsics.checkNotNullExpressionValue(collection, (String)"PythonCommandLineState.c\u2026r.shouldAddSourceRoots())");
            Collection pythonPath = collection;
            if (pathMapper != null) {
                List list = pathMapper.convertToRemote(pythonPath);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pathMapper.convertToRemote(pythonPath)");
                pythonPath = list;
            }
            Object object = customStartScript;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"customStartScript");
            String selfPathAppend = PydevConsoleRunnerUtil.constructPyPathAndWorkingDirCommand(pythonPath, workingDir, (String)object);
            return new String[]{selfPathAppend};
        }

        private final Function<TargetEnvironment, String> createSetupScriptFunction(Project project, Module module, Function<TargetEnvironment, String> workingDir, PyRemotePathMapper pathMapper, PyConsoleOptions.PyConsoleSettings settingsProvider) {
            Object customStartScript = settingsProvider.getCustomStartScript();
            String string = customStartScript;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"customStartScript");
            CharSequence charSequence = string;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                customStartScript = "\n" + (String)customStartScript;
            }
            Set pythonPathFuns = CollectionsKt.toMutableSet((Iterable)TargetedPythonPaths.collectPythonPath(project, module, settingsProvider.mySdkHome, pathMapper, settingsProvider.shouldAddContentRoots(), settingsProvider.shouldAddSourceRoots(), false));
            Collection collection = pythonPathFuns;
            Object object = customStartScript;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"customStartScript");
            return PydevConsoleRunnerUtil.constructPyPathAndWorkingDirCommand(collection, workingDir, (String)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

