/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.highlighting.PyHighlighter;

final class PyConsoleSourceHighlighter {
    private final Lexer myLexer;
    private final PyHighlighter myPyHighlighter;
    private int myLexerState;
    private final PythonConsoleView myPythonConsoleView;

    PyConsoleSourceHighlighter(PythonConsoleView pythonConsoleView, PyHighlighter pyHighlighter) {
        this.myPythonConsoleView = pythonConsoleView;
        this.myPyHighlighter = pyHighlighter;
        this.myLexer = this.myPyHighlighter.getHighlightingLexer();
    }

    public void printHighlightedSource(String text2) {
        this.myLexer.start((CharSequence)text2, 0, text2.length(), this.getLexerState());
        while (this.hasNext()) {
            Pair<String, ConsoleViewContentType> pair = this.next();
            this.myPythonConsoleView.printText((String)pair.first, (ConsoleViewContentType)pair.second);
        }
    }

    private boolean hasNext() {
        return this.myLexer.getTokenType() != null;
    }

    private Pair<String, ConsoleViewContentType> next() {
        this.myLexerState = this.myLexer.getState();
        IElementType tokenType = this.myLexer.getTokenType();
        Pair res = new Pair((Object)this.myLexer.getTokenText(), (Object)(tokenType == null ? ConsoleViewContentType.NORMAL_OUTPUT : ConsoleViewUtil.getContentTypeForToken((IElementType)tokenType, (SyntaxHighlighter)this.myPyHighlighter)));
        this.myLexer.advance();
        return res;
    }

    private int getLexerState() {
        return this.myLexerState != 1024 ? this.myLexerState : 0;
    }
}

