/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\nH\u0014\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/codeInsight/completion/DictLiteralCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "addCompletionForTypedDictKeys", "", "expectedType", "Lcom/jetbrains/python/psi/types/PyType;", "actualType", "dictCompletion", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "addQuotes", "", "addCompletionToAssignment", "originalElement", "Lcom/intellij/psi/PsiElement;", "possibleSequenceExpr", "Lcom/jetbrains/python/psi/PyTypedElement;", "result", "addCompletionToCallExpression", "addCompletionToReturnStatement", "addCompletions", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "intellij.python.psi.impl"})
final class DictLiteralCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result) {
        PsiElement possibleSequenceExpr;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        PsiElement psiElement = parameters.getOriginalPosition();
        if (psiElement == null || (psiElement = psiElement.getParent()) == null) {
            return;
        }
        PsiElement originalElement = psiElement;
        PsiElement psiElement2 = possibleSequenceExpr = originalElement instanceof PyStringLiteralExpression ? ((PyStringLiteralExpression)originalElement).getParent() : originalElement;
        if (possibleSequenceExpr instanceof PyDictLiteralExpression || possibleSequenceExpr instanceof PySetLiteralExpression) {
            this.addCompletionToCallExpression(originalElement, (PyTypedElement)possibleSequenceExpr, result);
            this.addCompletionToAssignment(originalElement, (PyTypedElement)possibleSequenceExpr, result);
            this.addCompletionToReturnStatement(originalElement, (PyTypedElement)possibleSequenceExpr, result);
        }
    }

    private final void addCompletionToCallExpression(PsiElement originalElement, PyTypedElement possibleSequenceExpr, CompletionResultSet result) {
        PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)originalElement, PyCallExpression.class);
        if (callExpression != null) {
            TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(originalElement.getProject(), originalElement.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"TypeEvalContext.codeComp\u2026alElement.containingFile)");
            TypeEvalContext typeEvalContext2 = typeEvalContext;
            PyExpression pyExpression = callExpression.getCallee();
            if (pyExpression == null) {
                return;
            }
            PyType callType = typeEvalContext2.getType(pyExpression);
            if (!(callType instanceof PyCallableType)) {
                return;
            }
            int argumentIndex = PyPsiUtils.findArgumentIndex(callExpression, (PsiElement)possibleSequenceExpr);
            if (argumentIndex < 0) {
                return;
            }
            List<PyCallableParameter> list = ((PyCallableType)callType).getParameters(typeEvalContext2);
            if (list == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue(list, (String)"callType.getParameters(typeEvalContext) ?: return");
            List<PyCallableParameter> params = list;
            if (params.size() < argumentIndex) {
                return;
            }
            PyType expectedType = params.get(argumentIndex).getType(typeEvalContext2);
            PyType actualType = typeEvalContext2.getType(possibleSequenceExpr);
            this.addCompletionForTypedDictKeys(expectedType, actualType, result, !(originalElement instanceof PyStringLiteralExpression));
        }
    }

    private final void addCompletionToAssignment(PsiElement originalElement, PyTypedElement possibleSequenceExpr, CompletionResultSet result) {
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)originalElement, PyAssignmentStatement.class);
        if (assignment != null) {
            kotlin.Pair targetToValue;
            kotlin.Pair pair;
            TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(originalElement.getProject(), originalElement.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"TypeEvalContext.codeComp\u2026alElement.containingFile)");
            TypeEvalContext typeEvalContext2 = typeEvalContext;
            if (assignment.getTargets().length == 1) {
                pair = TuplesKt.to((Object)assignment.getTargets()[0], (Object)assignment.getAssignedValue());
            } else {
                Object v3;
                Iterable $this$firstOrNull$iv;
                block15: {
                    List<Pair<PyExpression, PyExpression>> list = assignment.getTargetsToValuesMapping();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"assignment.targetsToValuesMapping");
                    $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)((PyExpression)it.second), (Object)possibleSequenceExpr)) continue;
                        v3 = element$iv;
                        break block15;
                    }
                    v3 = null;
                }
                Pair pair2 = v3;
                if (pair2 != null) {
                    Iterable it = $this$firstOrNull$iv = pair2;
                    boolean bl = false;
                    pair = TuplesKt.to((Object)((Pair)it).first, (Object)((Pair)it).second);
                } else {
                    pair = null;
                }
            }
            kotlin.Pair pair3 = targetToValue = pair;
            if ((pair3 != null ? (PyExpression)pair3.getFirst() : null) != null && targetToValue.getSecond() != null) {
                Object object = targetToValue.getFirst();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.python.psi.PyTypedElement");
                }
                PyType expectedType = typeEvalContext2.getType((PyTypedElement)object);
                Object object2 = targetToValue.getSecond();
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.python.psi.PyTypedElement");
                }
                PyType actualType = typeEvalContext2.getType((PyTypedElement)object2);
                this.addCompletionForTypedDictKeys(expectedType, actualType, result, !(originalElement instanceof PyStringLiteralExpression));
            } else {
                PyExpression pyExpression;
                PyExpression targetExpr;
                block16: {
                    targetExpr = assignment.getAssignedValue();
                    if (targetExpr instanceof PyTupleExpression) {
                        PyExpression[] pyExpressionArray = ((PyTupleExpression)targetExpr).getElements();
                        Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"targetExpr.elements");
                        PyExpression[] $this$firstOrNull$iv = pyExpressionArray;
                        boolean $i$f$firstOrNull = false;
                        int n = $this$firstOrNull$iv.length;
                        for (int it = 0; it < n; ++it) {
                            PyExpression element$iv;
                            PyExpression it2 = element$iv = $this$firstOrNull$iv[it];
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it2, (Object)possibleSequenceExpr)) continue;
                            pyExpression = element$iv;
                            break block16;
                        }
                        pyExpression = null;
                    } else {
                        return;
                    }
                }
                PyExpression element = pyExpression;
                if (element != null) {
                    Object[] objectArray = ((PyTupleExpression)targetExpr).getElements();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"targetExpr.elements");
                    int index = ArraysKt.indexOf((Object[])objectArray, (Object)element);
                    if (index < assignment.getTargets().length) {
                        PyType expectedType = typeEvalContext2.getType(assignment.getTargets()[index]);
                        PyType actualType = typeEvalContext2.getType(element);
                        this.addCompletionForTypedDictKeys(expectedType, actualType, result, !(originalElement instanceof PyStringLiteralExpression));
                    }
                }
            }
        }
    }

    private final void addCompletionToReturnStatement(PsiElement originalElement, PyTypedElement possibleSequenceExpr, CompletionResultSet result) {
        PyReturnStatement returnStatement = (PyReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)originalElement, PyReturnStatement.class);
        if (returnStatement != null) {
            TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(originalElement.getProject(), originalElement.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"TypeEvalContext.codeComp\u2026alElement.containingFile)");
            TypeEvalContext typeEvalContext2 = typeEvalContext;
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)returnStatement);
            if (owner instanceof PyFunction) {
                PyAnnotation annotation = ((PyFunction)owner).getAnnotation();
                String typeCommentAnnotation = ((PyFunction)owner).getTypeCommentAnnotation();
                if (annotation != null || typeCommentAnnotation != null) {
                    PyType expectedType = typeEvalContext2.getReturnType((PyCallable)((Object)owner));
                    PyType actualType = typeEvalContext2.getType(possibleSequenceExpr);
                    this.addCompletionForTypedDictKeys(expectedType, actualType, result, !(originalElement instanceof PyStringLiteralExpression));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCompletionForTypedDictKeys(PyType expectedType, PyType actualType, CompletionResultSet dictCompletion, boolean addQuotes) {
        if (expectedType instanceof PyTypedDictType) {
            Collection collection;
            if (actualType instanceof PyTypedDictType) {
                void $this$filterNotTo$iv$iv;
                Set<String> set = ((PyTypedDictType)expectedType).getFields().keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"expectedType.fields.keys");
                Iterable $this$filterNot$iv = set;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    String string;
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    Map map2 = ((PyTypedDictType)actualType).getFields();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (map2.containsKey(string)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = (List)destination$iv$iv;
            } else if (actualType instanceof PyClassType && Intrinsics.areEqual((Object)"set", (Object)((PyClassType)actualType).getName())) {
                Set<String> set = ((PyTypedDictType)expectedType).getFields().keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"expectedType.fields.keys");
                collection = set;
            } else {
                return;
            }
            Collection keys = collection;
            for (String key : keys) {
                Object object;
                if (addQuotes) {
                    object = "'" + key + "'";
                } else {
                    String string = key;
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                }
                dictCompletion.addElement((LookupElement)LookupElementBuilder.create((String)object).withTypeText("dict key").withIcon(PlatformIcons.PARAMETER_ICON));
            }
        }
    }
}

