/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharDoubleHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharDoubleScatterMap
extends CharDoubleHashMap {
    public CharDoubleScatterMap() {
        this(4);
    }

    public CharDoubleScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharDoubleScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharDoubleScatterMap from(char[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharDoubleScatterMap map2 = new CharDoubleScatterMap(keys.length);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            map2.put(keys[i2], values[i2]);
        }
        return map2;
    }
}

