/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell.metaphone;

public class Metaphone3 {
    int m_length;
    int m_metaphLength;
    boolean m_encodeVowels = false;
    boolean m_encodeExact = false;
    String m_inWord;
    StringBuffer m_primary = new StringBuffer();
    StringBuffer m_secondary = new StringBuffer();
    int m_current;
    int m_last;
    boolean flag_AL_inversion;
    int MAX_KEY_ALLOCATION = 32;
    int DEFAULT_MAX_KEY_LENGTH = 8;

    public Metaphone3() {
        this.m_metaphLength = this.DEFAULT_MAX_KEY_LENGTH;
    }

    Metaphone3(String in) {
        this();
        this.SetWord(in);
    }

    public void SetWord(String in) {
        this.m_inWord = in.toUpperCase();
        this.m_length = this.m_inWord.length();
    }

    boolean SetKeyLength(int inKeyLength) {
        if (inKeyLength < 1) {
            inKeyLength = 1;
        }
        if (inKeyLength > this.MAX_KEY_ALLOCATION) {
            this.m_metaphLength = this.MAX_KEY_ALLOCATION;
            return false;
        }
        this.m_metaphLength = inKeyLength;
        return true;
    }

    void MetaphAdd(String in) {
        if (!in.equals("A") || this.m_primary.length() <= 0 || this.m_primary.charAt(this.m_primary.length() - 1) != 'A') {
            this.m_primary.append(in);
        }
        if (!in.equals("A") || this.m_secondary.length() <= 0 || this.m_secondary.charAt(this.m_secondary.length() - 1) != 'A') {
            this.m_secondary.append(in);
        }
    }

    void MetaphAdd(String main2, String alt) {
        if (!main2.equals("A") || this.m_primary.length() <= 0 || this.m_primary.charAt(this.m_primary.length() - 1) != 'A') {
            this.m_primary.append(main2);
        }
        if (!(alt.equals("A") && this.m_secondary.length() > 0 && this.m_secondary.charAt(this.m_secondary.length() - 1) == 'A' || alt.isEmpty())) {
            this.m_secondary.append(alt);
        }
    }

    void MetaphAddExactApprox(String mainExact, String altExact, String main2, String alt) {
        if (this.m_encodeExact) {
            this.MetaphAdd(mainExact, altExact);
        } else {
            this.MetaphAdd(main2, alt);
        }
    }

    void MetaphAddExactApprox(String mainExact, String main2) {
        if (this.m_encodeExact) {
            this.MetaphAdd(mainExact);
        } else {
            this.MetaphAdd(main2);
        }
    }

    int GetKeyLength() {
        return this.m_metaphLength;
    }

    int GetMaximumKeyLength() {
        return this.MAX_KEY_ALLOCATION;
    }

    void SetEncodeVowels(boolean inEncodeVowels) {
        this.m_encodeVowels = inEncodeVowels;
    }

    boolean GetEncodeVowels() {
        return this.m_encodeVowels;
    }

    void SetEncodeExact(boolean inEncodeExact) {
        this.m_encodeExact = inEncodeExact;
    }

    boolean GetEncodeExact() {
        return this.m_encodeExact;
    }

    public String GetMetaph() {
        String primary = new String(this.m_primary);
        return primary;
    }

    String GetAlternateMetaph() {
        String secondary = new String(this.m_secondary);
        return secondary;
    }

    boolean Front_Vowel(int at) {
        return this.CharAt(at) == 'E' || this.CharAt(at) == 'I' || this.CharAt(at) == 'Y';
    }

    boolean SlavoGermanic() {
        return this.StringAt(0, 3, "SCH", "") || this.StringAt(0, 2, "SW", "") || this.CharAt(0) == 'J' || this.CharAt(0) == 'W';
    }

    boolean IsVowel(char inChar) {
        return inChar == 'A' || inChar == 'E' || inChar == 'I' || inChar == 'O' || inChar == 'U' || inChar == 'Y' || inChar == '\u00c0' || inChar == '\u00c1' || inChar == '\u00c2' || inChar == '\u00c3' || inChar == '\u00c4' || inChar == '\u00c5' || inChar == '\u00c6' || inChar == '\u00c8' || inChar == '\u00c9' || inChar == '\u00ca' || inChar == '\u00cb' || inChar == '\u00cc' || inChar == '\u00cd' || inChar == '\u00ce' || inChar == '\u00cf' || inChar == '\u00d2' || inChar == '\u00d3' || inChar == '\u00d4' || inChar == '\u00d5' || inChar == '\u00d6' || inChar == '\u008c' || inChar == '\u00d8' || inChar == '\u00d9' || inChar == '\u00da' || inChar == '\u00db' || inChar == '\u00dc' || inChar == '\u00dd' || inChar == '\u009f';
    }

    boolean IsVowel(int at) {
        if (at < 0 || at >= this.m_length) {
            return false;
        }
        char it = this.CharAt(at);
        return this.IsVowel(it);
    }

    int SkipVowels(int at) {
        if (at < 0) {
            return 0;
        }
        if (at >= this.m_length) {
            return this.m_length;
        }
        char it = this.CharAt(at);
        while (!(!this.IsVowel(it) && it != 'W' || this.StringAt(at, 4, "WICZ", "WITZ", "WIAK", "") || this.StringAt(at - 1, 5, "EWSKI", "EWSKY", "OWSKI", "OWSKY", "") || this.StringAt(at, 5, "WICKI", "WACKI", "") && at + 4 == this.m_last)) {
            if (!(this.CharAt(++at - 1) != 'W' || this.CharAt(at) != 'H' || this.StringAt(at, 3, "HOP", "") || this.StringAt(at, 4, "HIDE", "HARD", "HEAD", "HAWK", "HERD", "HOOK", "HAND", "HOLE", "") || this.StringAt(at, 5, "HEART", "HOUSE", "HOUND", "") || this.StringAt(at, 6, "HAMMER", ""))) {
                ++at;
            }
            if (at > this.m_length - 1) break;
            it = this.CharAt(at);
        }
        return at;
    }

    void AdvanceCounter(int ifNotEncodeVowels, int ifEncodeVowels) {
        this.m_current = !this.m_encodeVowels ? (this.m_current += ifNotEncodeVowels) : (this.m_current += ifEncodeVowels);
    }

    char CharAt(int at) {
        if (at < 0 || at > this.m_length - 1) {
            return '\u0000';
        }
        return this.m_inWord.charAt(at);
    }

    boolean RootOrInflections(String inWord, String root) {
        int len = root.length();
        String test = root + "S";
        if (inWord.equals(root) || inWord.equals(test)) {
            return true;
        }
        if (root.charAt(len - 1) != 'E') {
            test = root + "ES";
        }
        if (inWord.equals(test)) {
            return true;
        }
        test = root.charAt(len - 1) != 'E' ? root + "ED" : root + "D";
        if (inWord.equals(test)) {
            return true;
        }
        if (root.charAt(len - 1) == 'E') {
            root = root.substring(0, len - 1);
        }
        if (inWord.equals(test = root + "ING")) {
            return true;
        }
        test = root + "INGLY";
        if (inWord.equals(test)) {
            return true;
        }
        test = root + "Y";
        return inWord.equals(test);
    }

    boolean StringAt(int start, int length, String ... compareStrings) {
        if (start < 0 || start > this.m_length - 1 || start + length - 1 > this.m_length - 1) {
            return false;
        }
        String target = this.m_inWord.substring(start, start + length);
        for (String strFragment : compareStrings) {
            if (!target.equals(strFragment)) continue;
            return true;
        }
        return false;
    }

    public void Encode() {
        this.flag_AL_inversion = false;
        this.m_current = 0;
        this.m_primary.setLength(0);
        this.m_secondary.setLength(0);
        if (this.m_length < 1) {
            return;
        }
        this.m_last = this.m_length - 1;
        block27: while (this.m_primary.length() <= this.m_metaphLength && this.m_secondary.length() <= this.m_metaphLength && this.m_current < this.m_length) {
            switch (this.CharAt(this.m_current)) {
                case 'B': {
                    this.Encode_B();
                    continue block27;
                }
                case '\u00c7': 
                case '\u00df': {
                    this.MetaphAdd("S");
                    ++this.m_current;
                    continue block27;
                }
                case 'C': {
                    this.Encode_C();
                    continue block27;
                }
                case 'D': {
                    this.Encode_D();
                    continue block27;
                }
                case 'F': {
                    this.Encode_F();
                    continue block27;
                }
                case 'G': {
                    this.Encode_G();
                    continue block27;
                }
                case 'H': {
                    this.Encode_H();
                    continue block27;
                }
                case 'J': {
                    this.Encode_J();
                    continue block27;
                }
                case 'K': {
                    this.Encode_K();
                    continue block27;
                }
                case 'L': {
                    this.Encode_L();
                    continue block27;
                }
                case 'M': {
                    this.Encode_M();
                    continue block27;
                }
                case 'N': {
                    this.Encode_N();
                    continue block27;
                }
                case '\u00d1': {
                    this.MetaphAdd("N");
                    ++this.m_current;
                    continue block27;
                }
                case 'P': {
                    this.Encode_P();
                    continue block27;
                }
                case 'Q': {
                    this.Encode_Q();
                    continue block27;
                }
                case 'R': {
                    this.Encode_R();
                    continue block27;
                }
                case 'S': {
                    this.Encode_S();
                    continue block27;
                }
                case 'T': {
                    this.Encode_T();
                    continue block27;
                }
                case '\u00d0': 
                case '\u00de': {
                    this.MetaphAdd("0");
                    ++this.m_current;
                    continue block27;
                }
                case 'V': {
                    this.Encode_V();
                    continue block27;
                }
                case 'W': {
                    this.Encode_W();
                    continue block27;
                }
                case 'X': {
                    this.Encode_X();
                    continue block27;
                }
                case '\u008a': {
                    this.MetaphAdd("X");
                    ++this.m_current;
                    continue block27;
                }
                case '\u008e': {
                    this.MetaphAdd("S");
                    ++this.m_current;
                    continue block27;
                }
                case 'Z': {
                    this.Encode_Z();
                    continue block27;
                }
            }
            if (this.IsVowel(this.CharAt(this.m_current))) {
                this.Encode_Vowels();
                continue;
            }
            ++this.m_current;
        }
        if (this.m_primary.length() > this.m_metaphLength) {
            this.m_primary.setLength(this.m_metaphLength);
        }
        if (this.m_secondary.length() > this.m_metaphLength) {
            this.m_secondary.setLength(this.m_metaphLength);
        }
        if (this.m_primary.toString().equals(this.m_secondary.toString())) {
            this.m_secondary.setLength(0);
        }
    }

    void Encode_Vowels() {
        if (this.m_current == 0) {
            this.MetaphAdd("A");
        } else if (this.m_encodeVowels) {
            if (this.CharAt(this.m_current) != 'E') {
                if (this.Skip_Silent_UE()) {
                    return;
                }
                if (this.O_Silent()) {
                    ++this.m_current;
                    return;
                }
                this.MetaphAdd("A");
            } else {
                this.Encode_E_Pronounced();
            }
        }
        this.m_current = this.IsVowel(this.m_current - 2) || !this.StringAt(this.m_current - 1, 4, "LEWA", "LEWO", "LEWI", "") ? this.SkipVowels(this.m_current) : ++this.m_current;
    }

    void Encode_E_Pronounced() {
        if (this.StringAt(0, 4, "LAME", "SAKE", "PATE", "") && this.m_length == 4 || this.StringAt(0, 5, "AGAPE", "") && this.m_length == 5 || this.m_current == 5 && this.StringAt(0, 6, "RESUME", "")) {
            this.MetaphAdd("", "A");
            return;
        }
        if (this.StringAt(0, 4, "INGE", "") && this.m_length == 4) {
            this.MetaphAdd("A", "");
            return;
        }
        if (this.m_current == 5 && this.StringAt(0, 7, "BLESSED", "LEARNED", "")) {
            this.MetaphAddExactApprox("D", "AD", "T", "AT");
            this.m_current += 2;
            return;
        }
        if (!this.E_Silent() && !this.flag_AL_inversion && !this.Silent_Internal_E() || this.E_Pronounced_Exceptions()) {
            this.MetaphAdd("A");
        }
        this.flag_AL_inversion = false;
    }

    boolean O_Silent() {
        return this.CharAt(this.m_current) == 'O' && this.StringAt(this.m_current - 2, 4, "IRON", "") && (this.StringAt(0, 4, "IRON", "") || this.StringAt(this.m_current - 2, 4, "IRON", "") && this.m_last == this.m_current + 1) && !this.StringAt(this.m_current - 2, 6, "IRONIC", "");
    }

    boolean E_Silent() {
        if (this.E_Pronounced_At_End()) {
            return false;
        }
        return this.m_current == this.m_last || this.StringAt(this.m_last, 1, "S", "D", "") && this.m_current > 1 && this.m_current + 1 == this.m_last && !this.StringAt(this.m_current - 1, 3, "TED", "SES", "CES", "") && !this.StringAt(0, 9, "ANTIPODES", "ANOPHELES", "") && !this.StringAt(0, 8, "MOHAMMED", "MUHAMMED", "MOUHAMED", "") && !this.StringAt(0, 7, "MOHAMED", "") && !this.StringAt(0, 6, "NORRED", "MEDVED", "MERCED", "ALLRED", "KHALED", "RASHED", "MASJED", "") && !this.StringAt(0, 5, "JARED", "AHMED", "HAMED", "JAVED", "") && !this.StringAt(0, 4, "ABED", "IMED", "") || this.StringAt(this.m_current + 1, 4, "NESS", "LESS", "") && this.m_current + 4 == this.m_last || this.StringAt(this.m_current + 1, 2, "LY", "") && this.m_current + 2 == this.m_last && !this.StringAt(0, 6, "CICELY", "");
    }

    boolean E_Pronounced_At_End() {
        return this.m_current == this.m_last && (this.StringAt(this.m_current - 6, 7, "STROPHE", "") || this.m_length == 2 || this.m_length == 3 && !this.IsVowel(0) || this.StringAt(this.m_last - 2, 3, "BKE", "DKE", "FKE", "KKE", "LKE", "NKE", "MKE", "PKE", "TKE", "VKE", "ZKE", "") && !this.StringAt(0, 5, "FINKE", "FUNKE", "") && !this.StringAt(0, 6, "FRANKE", "") || this.StringAt(this.m_last - 4, 5, "SCHKE", "") || this.StringAt(0, 4, "ACME", "NIKE", "CAFE", "RENE", "LUPE", "JOSE", "ESME", "") && this.m_length == 4 || this.StringAt(0, 5, "LETHE", "CADRE", "TILDE", "SIGNE", "POSSE", "LATTE", "ANIME", "DOLCE", "CROCE", "ADOBE", "OUTRE", "JESSE", "JAIME", "JAFFE", "BENGE", "RUNGE", "CHILE", "DESME", "CONDE", "URIBE", "LIBRE", "ANDRE", "") && this.m_length == 5 || this.StringAt(0, 6, "HECATE", "PSYCHE", "DAPHNE", "PENSKE", "CLICHE", "RECIPE", "TAMALE", "SESAME", "SIMILE", "FINALE", "KARATE", "RENATE", "SHANTE", "OBERLE", "COYOTE", "KRESGE", "STONGE", "STANGE", "SWAYZE", "FUENTE", "SALOME", "URRIBE", "") && this.m_length == 6 || this.StringAt(0, 7, "ECHIDNE", "ARIADNE", "MEINEKE", "PORSCHE", "ANEMONE", "EPITOME", "SYNCOPE", "SOUFFLE", "ATTACHE", "MACHETE", "KARAOKE", "BUKKAKE", "VICENTE", "ELLERBE", "VERSACE", "") && this.m_length == 7 || this.StringAt(0, 8, "PENELOPE", "CALLIOPE", "CHIPOTLE", "ANTIGONE", "KAMIKAZE", "EURIDICE", "YOSEMITE", "FERRANTE", "") && this.m_length == 8 || this.StringAt(0, 9, "HYPERBOLE", "GUACAMOLE", "XANTHIPPE", "") && this.m_length == 9 || this.StringAt(0, 10, "SYNECDOCHE", "") && this.m_length == 10);
    }

    boolean Silent_Internal_E() {
        return this.StringAt(0, 3, "OLE", "") && this.E_Silent_Suffix(3) && !this.E_Pronouncing_Suffix(3) || this.StringAt(0, 4, "BARE", "FIRE", "FORE", "GATE", "HAGE", "HAVE", "HAZE", "HOLE", "CAPE", "HUSE", "LACE", "LINE", "LIVE", "LOVE", "MORE", "MOSE", "MORE", "NICE", "RAKE", "ROBE", "ROSE", "SISE", "SIZE", "WARE", "WAKE", "WISE", "WINE", "") && this.E_Silent_Suffix(4) && !this.E_Pronouncing_Suffix(4) || this.StringAt(0, 5, "BLAKE", "BRAKE", "BRINE", "CARLE", "CLEVE", "DUNNE", "HEDGE", "HOUSE", "JEFFE", "LUNCE", "STOKE", "STONE", "THORE", "WEDGE", "WHITE", "") && this.E_Silent_Suffix(5) && !this.E_Pronouncing_Suffix(5) || this.StringAt(0, 6, "BRIDGE", "CHEESE", "") && this.E_Silent_Suffix(6) && !this.E_Pronouncing_Suffix(6) || this.StringAt(this.m_current - 5, 7, "CHARLES", "");
    }

    boolean E_Silent_Suffix(int at) {
        return this.m_current == at - 1 && this.m_length > at + 1 && (this.IsVowel(at + 1) || this.StringAt(at, 2, "ST", "SL", "") && this.m_length > at + 2);
    }

    boolean E_Pronouncing_Suffix(int at) {
        if (this.m_length == at + 4 && this.StringAt(at, 4, "WOOD", "")) {
            return true;
        }
        if (this.m_length == at + 5 && this.StringAt(at, 5, "WATER", "WORTH", "")) {
            return true;
        }
        if (this.m_length == at + 3 && this.StringAt(at, 3, "TTE", "LIA", "NOW", "ROS", "RAS", "")) {
            return true;
        }
        if (this.m_length == at + 2 && this.StringAt(at, 2, "TA", "TT", "NA", "NO", "NE", "RS", "RE", "LA", "AU", "RO", "RA", "")) {
            return true;
        }
        return this.m_length == at + 1 && this.StringAt(at, 1, "T", "R", "");
    }

    boolean E_Pronounced_Exceptions() {
        return this.m_current + 1 == this.m_last && (this.StringAt(this.m_current - 3, 5, "OCLES", "ACLES", "AKLES", "") || this.StringAt(0, 4, "INES", "") || this.StringAt(0, 5, "LOPES", "ESTES", "GOMES", "NUNES", "ALVES", "ICKES", "INNES", "PERES", "WAGES", "NEVES", "BENES", "DONES", "") || this.StringAt(0, 6, "CORTES", "CHAVES", "VALDES", "ROBLES", "TORRES", "FLORES", "BORGES", "NIEVES", "MONTES", "SOARES", "VALLES", "GEDDES", "ANDRES", "VIAJES", "CALLES", "FONTES", "HERMES", "ACEVES", "BATRES", "MATHES", "") || this.StringAt(0, 7, "DELORES", "MORALES", "DOLORES", "ANGELES", "ROSALES", "MIRELES", "LINARES", "PERALES", "PAREDES", "BRIONES", "SANCHES", "CAZARES", "REVELES", "ESTEVES", "ALVARES", "MATTHES", "SOLARES", "CASARES", "CACERES", "STURGES", "RAMIRES", "FUNCHES", "BENITES", "FUENTES", "PUENTES", "TABARES", "HENTGES", "VALORES", "") || this.StringAt(0, 8, "GONZALES", "MERCEDES", "FAGUNDES", "JOHANNES", "GONSALES", "BERMUDES", "CESPEDES", "BETANCES", "TERRONES", "DIOGENES", "CORRALES", "CABRALES", "MARTINES", "GRAJALES", "") || this.StringAt(0, 9, "CERVANTES", "FERNANDES", "GONCALVES", "BENEVIDES", "CIFUENTES", "SIFUENTES", "SERVANTES", "HERNANDES", "BENAVIDES", "") || this.StringAt(0, 10, "ARCHIMEDES", "CARRIZALES", "MAGALLANES", "")) || this.StringAt(this.m_current - 2, 4, "FRED", "DGES", "DRED", "GNES", "") || this.StringAt(this.m_current - 5, 7, "PROBLEM", "RESPLEN", "") || this.StringAt(this.m_current - 4, 6, "REPLEN", "") || this.StringAt(this.m_current - 3, 4, "SPLE", "");
    }

    boolean Skip_Silent_UE() {
        if (!(!this.StringAt(this.m_current - 1, 3, "QUE", "GUE", "") || this.StringAt(0, 8, "BARBEQUE", "PALENQUE", "APPLIQUE", "") || this.StringAt(0, 6, "RISQUE", "") || this.StringAt(this.m_current - 3, 5, "ARGUE", "SEGUE", "") || this.StringAt(0, 7, "PIROGUE", "ENRIQUE", "") || this.StringAt(0, 10, "COMMUNIQUE", "") || this.m_current <= 1 || this.m_current + 1 != this.m_last && !this.StringAt(0, 7, "JACQUES", ""))) {
            this.m_current = this.SkipVowels(this.m_current);
            return true;
        }
        return false;
    }

    void Encode_B() {
        if (this.Encode_Silent_B()) {
            return;
        }
        this.MetaphAddExactApprox("B", "P");
        this.m_current = this.CharAt(this.m_current + 1) == 'B' || this.CharAt(this.m_current + 1) == 'P' && this.m_current + 1 < this.m_last && this.CharAt(this.m_current + 2) != 'H' ? (this.m_current += 2) : ++this.m_current;
    }

    boolean Encode_Silent_B() {
        if (this.StringAt(this.m_current - 2, 4, "DEBT", "") || this.StringAt(this.m_current - 2, 5, "SUBTL", "") || this.StringAt(this.m_current - 2, 6, "SUBTIL", "") || this.StringAt(this.m_current - 3, 5, "DOUBT", "")) {
            this.MetaphAdd("T");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    void Encode_C() {
        if (this.Encode_Silent_C_At_Beginning() || this.Encode_CA_To_S() || this.Encode_CO_To_S() || this.Encode_CH() || this.Encode_CCIA() || this.Encode_CC() || this.Encode_CK_CG_CQ() || this.Encode_C_Front_Vowel() || this.Encode_Silent_C() || this.Encode_CZ() || this.Encode_CS()) {
            return;
        }
        if (!this.StringAt(this.m_current - 1, 1, "C", "K", "G", "Q", "")) {
            this.MetaphAdd("K");
        }
        if (this.StringAt(this.m_current + 1, 2, " C", " Q", " G", "")) {
            this.m_current += 2;
        } else if (this.StringAt(this.m_current + 1, 1, "C", "K", "Q", "") && !this.StringAt(this.m_current + 1, 2, "CE", "CI", "")) {
            this.m_current += 2;
            if (this.StringAt(this.m_current, 1, "C", "K", "Q", "") && !this.StringAt(this.m_current + 1, 2, "CE", "CI", "")) {
                ++this.m_current;
            }
        } else {
            ++this.m_current;
        }
    }

    boolean Encode_Silent_C_At_Beginning() {
        if (this.m_current == 0 && this.StringAt(this.m_current, 2, "CT", "CN", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_CA_To_S() {
        if (this.m_current == 0 && this.StringAt(this.m_current, 4, "CAES", "CAEC", "CAEM", "") || this.StringAt(0, 8, "FRANCAIS", "FRANCAIX", "LINGUICA", "") || this.StringAt(0, 6, "FACADE", "") || this.StringAt(0, 9, "GONCALVES", "PROVENCAL", "")) {
            this.MetaphAdd("S");
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_CO_To_S() {
        if (this.StringAt(this.m_current, 4, "COEL", "") && (this.IsVowel(this.m_current + 4) || this.m_current + 3 == this.m_last) || this.StringAt(this.m_current, 5, "COENA", "COENO", "") || this.StringAt(0, 8, "FRANCOIS", "MELANCON", "") || this.StringAt(0, 6, "GARCON", "")) {
            this.MetaphAdd("S");
            this.AdvanceCounter(3, 1);
            return true;
        }
        return false;
    }

    boolean Encode_CH() {
        if (this.StringAt(this.m_current, 2, "CH", "")) {
            if (this.Encode_CHAE() || this.Encode_CH_To_H() || this.Encode_Silent_CH() || this.Encode_ARCH() || this.Encode_CH_To_X() || this.Encode_English_CH_To_K() || this.Encode_Germanic_CH_To_K() || this.Encode_Greek_CH_Initial() || this.Encode_Greek_CH_Non_Initial()) {
                return true;
            }
            if (this.m_current > 0) {
                if (this.StringAt(0, 2, "MC", "") && this.m_current == 1) {
                    this.MetaphAdd("K");
                } else {
                    this.MetaphAdd("X", "K");
                }
            } else {
                this.MetaphAdd("X");
            }
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_CHAE() {
        if (this.m_current > 0 && this.StringAt(this.m_current + 2, 2, "AE", "")) {
            if (this.StringAt(0, 7, "RACHAEL", "")) {
                this.MetaphAdd("X");
            } else if (!this.StringAt(this.m_current - 1, 1, "C", "K", "G", "Q", "")) {
                this.MetaphAdd("K");
            }
            this.AdvanceCounter(4, 2);
            return true;
        }
        return false;
    }

    boolean Encode_CH_To_H() {
        if (this.m_current == 0 && (this.StringAt(this.m_current + 2, 3, "AIM", "ETH", "ELM", "") || this.StringAt(this.m_current + 2, 4, "ASID", "AZAN", "") || this.StringAt(this.m_current + 2, 5, "UPPAH", "UTZPA", "ALLAH", "ALUTZ", "AMETZ", "") || this.StringAt(this.m_current + 2, 6, "ESHVAN", "ADARIM", "ANUKAH", "") || this.StringAt(this.m_current + 2, 7, "ALLLOTH", "ANNUKAH", "AROSETH", "")) || this.StringAt(this.m_current - 3, 7, "CLACHAN", "")) {
            this.MetaphAdd("H");
            this.AdvanceCounter(3, 2);
            return true;
        }
        return false;
    }

    boolean Encode_Silent_CH() {
        if (this.StringAt(this.m_current - 2, 7, "FUCHSIA", "") || this.StringAt(this.m_current - 2, 5, "YACHT", "") || this.StringAt(0, 8, "STRACHAN", "") || this.StringAt(0, 8, "CRICHTON", "") || this.StringAt(this.m_current - 3, 6, "DRACHM", "") && !this.StringAt(this.m_current - 3, 7, "DRACHMA", "")) {
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_CH_To_X() {
        if (this.StringAt(this.m_current - 2, 4, "OACH", "EACH", "EECH", "OUCH", "OOCH", "MUCH", "SUCH", "") && !this.StringAt(this.m_current - 3, 5, "JOACH", "") || this.m_current + 2 == this.m_last && this.StringAt(this.m_current - 1, 4, "ACHA", "ACHO", "") || this.StringAt(this.m_current, 4, "CHOT", "CHOD", "CHAT", "") && this.m_current + 3 == this.m_last || this.StringAt(this.m_current - 1, 4, "OCHE", "") && this.m_current + 2 == this.m_last && !this.StringAt(this.m_current - 2, 5, "DOCHE", "") || this.StringAt(this.m_current - 4, 6, "ATTACH", "DETACH", "KOVACH", "") || this.StringAt(this.m_current - 5, 7, "SPINACH", "") || this.StringAt(0, 6, "MACHAU", "") || this.StringAt(this.m_current - 4, 8, "PARACHUT", "") || this.StringAt(this.m_current - 5, 8, "MASSACHU", "") || this.StringAt(this.m_current - 3, 5, "THACH", "") && !this.StringAt(this.m_current - 1, 4, "ACHE", "") || this.StringAt(this.m_current - 2, 6, "VACHON", "")) {
            this.MetaphAdd("X");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_English_CH_To_K() {
        if (this.m_current == 1 && this.RootOrInflections(this.m_inWord, "ACHE") || this.m_current > 3 && this.RootOrInflections(this.m_inWord.substring(this.m_current - 1), "ACHE") && (this.StringAt(0, 3, "EAR", "") || this.StringAt(0, 4, "HEAD", "BACK", "") || this.StringAt(0, 5, "HEART", "BELLY", "TOOTH", "")) || this.StringAt(this.m_current - 1, 4, "ECHO", "") || this.StringAt(this.m_current - 2, 7, "MICHEAL", "") || this.StringAt(this.m_current - 4, 7, "JERICHO", "") || this.StringAt(this.m_current - 5, 7, "LEPRECH", "")) {
            this.MetaphAdd("K", "X");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_Germanic_CH_To_K() {
        if (this.m_current > 1 && !this.IsVowel(this.m_current - 2) && this.StringAt(this.m_current - 1, 3, "ACH", "") && !this.StringAt(this.m_current - 2, 7, "MACHADO", "MACHUCA", "LACHANC", "LACHAPE", "KACHATU", "") && !this.StringAt(this.m_current - 3, 7, "KHACHAT", "") && this.CharAt(this.m_current + 2) != 'I' && (this.CharAt(this.m_current + 2) != 'E' || this.StringAt(this.m_current - 2, 6, "BACHER", "MACHER", "MACHEN", "LACHER", "")) || this.StringAt(this.m_current + 2, 1, "T", "S", "") && !this.StringAt(0, 11, "WHICHSOEVER", "") && !this.StringAt(0, 9, "LUNCHTIME", "") || this.StringAt(0, 4, "SCHR", "") || this.m_current > 2 && this.StringAt(this.m_current - 2, 5, "MACHE", "") || this.m_current == 2 && this.StringAt(this.m_current - 2, 4, "ZACH", "") || this.StringAt(this.m_current - 4, 6, "SCHACH", "") || this.StringAt(this.m_current - 1, 5, "ACHEN", "") || this.StringAt(this.m_current - 3, 5, "SPICH", "ZURCH", "BUECH", "") || this.StringAt(this.m_current - 3, 5, "KIRCH", "JOACH", "BLECH", "MALCH", "") && !this.StringAt(this.m_current - 3, 8, "KIRCHNER", "") && this.m_current + 1 != this.m_last || this.m_current + 1 == this.m_last && this.StringAt(this.m_current - 2, 4, "NICH", "LICH", "BACH", "") || this.m_current + 1 == this.m_last && this.StringAt(this.m_current - 3, 5, "URICH", "BRICH", "ERICH", "DRICH", "NRICH", "") && !this.StringAt(this.m_current - 5, 7, "ALDRICH", "") && !this.StringAt(this.m_current - 6, 8, "GOODRICH", "") && !this.StringAt(this.m_current - 7, 9, "GINGERICH", "") || this.m_current + 1 == this.m_last && this.StringAt(this.m_current - 4, 6, "ULRICH", "LFRICH", "LLRICH", "EMRICH", "ZURICH", "EYRICH", "") || (this.StringAt(this.m_current - 1, 1, "A", "O", "U", "E", "") || this.m_current == 0) && this.StringAt(this.m_current + 2, 1, "L", "R", "N", "M", "B", "H", "F", "V", "W", " ", "")) {
            if (this.StringAt(this.m_current + 2, 1, "R", "L", "") || this.SlavoGermanic()) {
                this.MetaphAdd("K");
            } else {
                this.MetaphAdd("K", "X");
            }
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_ARCH() {
        if (this.StringAt(this.m_current - 2, 4, "ARCH", "")) {
            if ((this.IsVowel(this.m_current + 2) && this.StringAt(this.m_current - 2, 5, "ARCHA", "ARCHI", "ARCHO", "ARCHU", "ARCHY", "") || this.StringAt(this.m_current - 2, 6, "ARCHEA", "ARCHEG", "ARCHEO", "ARCHET", "ARCHEL", "ARCHES", "ARCHEP", "ARCHEM", "ARCHEN", "") || this.StringAt(this.m_current - 2, 4, "ARCH", "") && this.m_current + 1 == this.m_last || this.StringAt(0, 7, "MENARCH", "")) && !this.RootOrInflections(this.m_inWord, "ARCH") && !this.StringAt(this.m_current - 4, 6, "SEARCH", "POARCH", "") && !this.StringAt(0, 9, "ARCHENEMY", "ARCHIBALD", "ARCHULETA", "ARCHAMBAU", "") && !this.StringAt(0, 6, "ARCHER", "ARCHIE", "") && ((!this.StringAt(this.m_current - 3, 5, "LARCH", "MARCH", "PARCH", "") && !this.StringAt(this.m_current - 4, 6, "STARCH", "") || this.StringAt(0, 6, "EPARCH", "") || this.StringAt(0, 7, "NOMARCH", "") || this.StringAt(0, 8, "EXILARCH", "HIPPARCH", "MARCHESE", "") || this.StringAt(0, 9, "ARISTARCH", "") || this.StringAt(0, 9, "MARCHETTI", "")) && !this.RootOrInflections(this.m_inWord, "STARCH") || this.StringAt(this.m_current - 2, 5, "ARCHU", "ARCHY", "") && !this.StringAt(0, 7, "STARCHY", ""))) {
                this.MetaphAdd("K", "X");
            } else {
                this.MetaphAdd("X");
            }
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_Greek_CH_Initial() {
        if (!(!(this.StringAt(this.m_current, 6, "CHAMOM", "CHARAC", "CHARIS", "CHARTO", "CHARTU", "CHARYB", "CHRIST", "CHEMIC", "CHILIA", "") || this.StringAt(this.m_current, 5, "CHEMI", "CHEMO", "CHEMU", "CHEMY", "CHOND", "CHONA", "CHONI", "CHOIR", "CHASM", "CHARO", "CHROM", "CHROI", "CHAMA", "CHALC", "CHALD", "CHAET", "CHIRO", "CHILO", "CHELA", "CHOUS", "CHEIL", "CHEIR", "CHEIM", "CHITI", "CHEOP", "") && !this.StringAt(this.m_current, 6, "CHEMIN", "") && !this.StringAt(this.m_current - 2, 8, "ANCHONDO", "") || this.StringAt(this.m_current, 5, "CHISM", "CHELI", "") && !this.StringAt(0, 8, "MACHISMO", "") && !this.StringAt(0, 10, "REVANCHISM", "") && !this.StringAt(0, 9, "RICHELIEU", "") && (!this.StringAt(0, 5, "CHISM", "") || this.m_length != 5) && !this.StringAt(0, 6, "MICHEL", "") || this.StringAt(this.m_current, 4, "CHOR", "CHOL", "CHYM", "CHYL", "CHLO", "CHOS", "CHUS", "CHOE", "") && !this.StringAt(0, 6, "CHOLLO", "CHOLLA", "CHORIZ", "") || this.StringAt(this.m_current, 4, "CHAO", "") && this.m_current + 3 != this.m_last || this.StringAt(this.m_current, 4, "CHIA", "") && !this.StringAt(0, 10, "APPALACHIA", "") && !this.StringAt(0, 7, "CHIAPAS", "") || this.StringAt(this.m_current, 7, "CHIMERA", "CHIMAER", "CHIMERI", "") || this.m_current == 0 && this.StringAt(this.m_current, 5, "CHAME", "CHELO", "CHITO", "")) && (this.m_current + 4 != this.m_last && this.m_current + 5 != this.m_last || !this.StringAt(this.m_current - 1, 6, "OCHETE", "")) || this.StringAt(0, 5, "CHORE", "CHOLO", "CHOLA", "") && this.m_length == 5 || this.StringAt(this.m_current, 5, "CHORT", "CHOSE", "") || this.StringAt(this.m_current - 3, 7, "CROCHET", "") || this.StringAt(0, 7, "CHEMISE", "CHARISE", "CHARISS", "CHAROLE", ""))) {
            if (this.StringAt(this.m_current + 2, 1, "R", "L", "")) {
                this.MetaphAdd("K");
            } else {
                this.MetaphAdd("K", "X");
            }
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_Greek_CH_Non_Initial() {
        if (this.StringAt(this.m_current - 2, 6, "ORCHID", "NICHOL", "MECHAN", "LICHEN", "MACHIC", "PACHEL", "RACHIF", "RACHID", "RACHIS", "RACHIC", "MICHAL", "") || this.StringAt(this.m_current - 3, 5, "MELCH", "GLOCH", "TRACH", "TROCH", "BRACH", "SYNCH", "PSYCH", "STICH", "PULCH", "EPOCH", "") || this.StringAt(this.m_current - 3, 5, "TRICH", "") && !this.StringAt(this.m_current - 5, 7, "OSTRICH", "") || this.StringAt(this.m_current - 2, 4, "TYCH", "TOCH", "BUCH", "MOCH", "CICH", "DICH", "NUCH", "EICH", "LOCH", "DOCH", "ZECH", "WYCH", "") && !this.StringAt(this.m_current - 4, 9, "INDOCHINA", "") && !this.StringAt(this.m_current - 2, 6, "BUCHON", "") || this.StringAt(this.m_current - 2, 5, "LYCHN", "TACHO", "ORCHO", "ORCHI", "LICHO", "") || this.StringAt(this.m_current - 1, 5, "OCHER", "ECHIN", "ECHID", "") && (this.m_current == 1 || this.m_current == 2) || this.StringAt(this.m_current - 4, 6, "BRONCH", "STOICH", "STRYCH", "TELECH", "PLANCH", "CATECH", "MANICH", "MALACH", "BIANCH", "DIDACH", "") || this.StringAt(this.m_current - 1, 4, "ICHA", "ICHN", "") && this.m_current == 1 || this.StringAt(this.m_current - 2, 8, "ORCHESTR", "") || this.StringAt(this.m_current - 4, 8, "BRANCHIO", "BRANCHIF", "") || this.StringAt(this.m_current - 1, 5, "ACHAB", "ACHAD", "ACHAN", "ACHAZ", "") && !this.StringAt(this.m_current - 2, 7, "MACHADO", "LACHANC", "") || this.StringAt(this.m_current - 1, 6, "ACHISH", "ACHILL", "ACHAIA", "ACHENE", "") || this.StringAt(this.m_current - 1, 7, "ACHAIAN", "ACHATES", "ACHIRAL", "ACHERON", "") || this.StringAt(this.m_current - 1, 8, "ACHILLEA", "ACHIMAAS", "ACHILARY", "ACHELOUS", "ACHENIAL", "ACHERNAR", "") || this.StringAt(this.m_current - 1, 9, "ACHALASIA", "ACHILLEAN", "ACHIMENES", "") || this.StringAt(this.m_current - 1, 10, "ACHIMELECH", "ACHITOPHEL", "") || this.m_current - 2 == 0 && (this.StringAt(this.m_current - 2, 6, "INCHOA", "") || this.StringAt(0, 4, "ISCH", "")) || this.m_current + 1 == this.m_last && this.StringAt(this.m_current - 1, 1, "A", "O", "U", "E", "") && !this.StringAt(0, 7, "DEBAUCH", "") && !this.StringAt(this.m_current - 2, 4, "MUCH", "SUCH", "KOCH", "") && !this.StringAt(this.m_current - 5, 7, "OODRICH", "ALDRICH", "")) {
            this.MetaphAdd("K", "X");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_CCIA() {
        if (this.StringAt(this.m_current + 1, 3, "CIA", "")) {
            this.MetaphAdd("X", "S");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_CC() {
        if (this.StringAt(this.m_current, 2, "CC", "") && (this.m_current != 1 || this.CharAt(0) != 'M')) {
            if (this.StringAt(this.m_current - 3, 7, "FLACCID", "")) {
                this.MetaphAdd("S");
                this.AdvanceCounter(3, 2);
                return true;
            }
            if (this.m_current + 2 == this.m_last && this.StringAt(this.m_current + 2, 1, "I", "") || this.StringAt(this.m_current + 2, 2, "IO", "") || this.m_current + 4 == this.m_last && this.StringAt(this.m_current + 2, 3, "INO", "INI", "")) {
                this.MetaphAdd("X");
                this.AdvanceCounter(3, 2);
                return true;
            }
            if (this.StringAt(this.m_current + 2, 1, "I", "E", "Y", "") && this.CharAt(this.m_current + 2) != 'H' && !this.StringAt(this.m_current - 2, 6, "SOCCER", "")) {
                this.MetaphAdd("KS");
                this.AdvanceCounter(3, 2);
                return true;
            }
            this.MetaphAdd("K");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_CK_CG_CQ() {
        if (this.StringAt(this.m_current, 2, "CK", "CG", "CQ", "")) {
            if (this.StringAt(this.m_current, 3, "CKI", "CKY", "") && this.m_current + 2 == this.m_last && this.m_length > 6) {
                this.MetaphAdd("K", "SK");
            } else {
                this.MetaphAdd("K");
            }
            this.m_current += 2;
            if (this.StringAt(this.m_current, 1, "K", "G", "Q", "")) {
                ++this.m_current;
            }
            return true;
        }
        return false;
    }

    boolean Encode_C_Front_Vowel() {
        if (this.StringAt(this.m_current, 2, "CI", "CE", "CY", "")) {
            if (this.Encode_British_Silent_CE() || this.Encode_CE() || this.Encode_CI() || this.Encode_Latinate_Suffixes()) {
                this.AdvanceCounter(2, 1);
                return true;
            }
            this.MetaphAdd("S");
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_British_Silent_CE() {
        return this.StringAt(this.m_current + 1, 5, "ESTER", "") && this.m_current + 5 == this.m_last || this.StringAt(this.m_current + 1, 10, "ESTERSHIRE", "");
    }

    boolean Encode_CE() {
        if (this.StringAt(this.m_current + 1, 3, "EAN", "") && this.IsVowel(this.m_current - 1) || this.StringAt(this.m_current - 1, 4, "ACEA", "") && this.m_current + 2 == this.m_last && !this.StringAt(0, 7, "PANACEA", "") || this.StringAt(this.m_current + 1, 4, "ELLI", "ERTO", "EORL", "") || this.StringAt(this.m_current - 3, 5, "CROCE", "") && this.m_current + 1 == this.m_last || this.StringAt(this.m_current - 3, 5, "DOLCE", "") || this.StringAt(this.m_current + 1, 4, "ELLO", "") && this.m_current + 4 == this.m_last) {
            this.MetaphAdd("X", "S");
            return true;
        }
        return false;
    }

    boolean Encode_CI() {
        if (this.StringAt(this.m_current + 1, 3, "INI", "") && !this.StringAt(0, 7, "MANCINI", "") && this.m_current + 3 == this.m_last || this.StringAt(this.m_current - 1, 3, "ICI", "") && this.m_current + 1 == this.m_last || this.StringAt(this.m_current - 1, 5, "RCIAL", "NCIAL", "RCIAN", "UCIUS", "") || this.StringAt(this.m_current - 3, 6, "MARCIA", "") || this.StringAt(this.m_current - 2, 7, "ANCIENT", "")) {
            this.MetaphAdd("X", "S");
            return true;
        }
        if ((this.StringAt(this.m_current, 3, "CIO", "CIE", "CIA", "") && this.IsVowel(this.m_current - 1) || this.StringAt(this.m_current + 1, 3, "IAO", "")) && !this.StringAt(this.m_current - 4, 8, "COERCION", "")) {
            if (!(!this.StringAt(this.m_current, 4, "CIAN", "CIAL", "CIAO", "CIES", "CIOL", "CION", "") && !this.StringAt(this.m_current - 3, 7, "GLACIER", "") && !this.StringAt(this.m_current, 5, "CIENT", "CIENC", "CIOUS", "CIATE", "CIATI", "CIATO", "CIABL", "CIARY", "") && (this.m_current + 2 != this.m_last || !this.StringAt(this.m_current, 3, "CIA", "CIO", "")) && (this.m_current + 3 != this.m_last || !this.StringAt(this.m_current, 3, "CIAS", "CIOS", "")) || this.StringAt(this.m_current - 4, 11, "ASSOCIATION", "") || this.StringAt(0, 4, "OCIE", "") || this.StringAt(this.m_current - 2, 5, "LUCIO", "") || this.StringAt(this.m_current - 2, 6, "MACIAS", "") || this.StringAt(this.m_current - 3, 6, "GRACIE", "GRACIA", "") || this.StringAt(this.m_current - 2, 7, "LUCIANO", "") || this.StringAt(this.m_current - 3, 8, "MARCIANO", "") || this.StringAt(this.m_current - 4, 7, "PALACIO", "") || this.StringAt(this.m_current - 4, 9, "FELICIANO", "") || this.StringAt(this.m_current - 5, 8, "MAURICIO", "") || this.StringAt(this.m_current - 7, 11, "ENCARNACION", "") || this.StringAt(this.m_current - 4, 8, "POLICIES", "") || this.StringAt(this.m_current - 2, 8, "HACIENDA", "") || this.StringAt(this.m_current - 6, 9, "ANDALUCIA", "") || this.StringAt(this.m_current - 2, 5, "SOCIO", "SOCIE", ""))) {
                this.MetaphAdd("X", "S");
            } else {
                this.MetaphAdd("S", "X");
            }
            return true;
        }
        if (this.StringAt(this.m_current - 4, 8, "COERCION", "")) {
            this.MetaphAdd("J");
            return true;
        }
        return false;
    }

    boolean Encode_Latinate_Suffixes() {
        if (this.StringAt(this.m_current + 1, 4, "EOUS", "IOUS", "")) {
            this.MetaphAdd("X", "S");
            return true;
        }
        return false;
    }

    boolean Encode_Silent_C() {
        if (this.StringAt(this.m_current + 1, 1, "T", "S", "") && (this.StringAt(0, 11, "CONNECTICUT", "") || this.StringAt(0, 6, "INDICT", "TUCSON", ""))) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_CZ() {
        if (this.StringAt(this.m_current + 1, 1, "Z", "") && !this.StringAt(this.m_current - 1, 6, "ECZEMA", "")) {
            if (this.StringAt(this.m_current, 4, "CZAR", "")) {
                this.MetaphAdd("S");
            } else {
                this.MetaphAdd("X");
            }
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_CS() {
        if (this.StringAt(0, 6, "KOVACS", "")) {
            this.MetaphAdd("KS", "X");
            this.m_current += 2;
            return true;
        }
        if (this.StringAt(this.m_current - 1, 3, "ACS", "") && this.m_current + 1 == this.m_last && !this.StringAt(this.m_current - 4, 6, "ISAACS", "")) {
            this.MetaphAdd("X");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    void Encode_D() {
        if (this.Encode_DG() || this.Encode_DJ() || this.Encode_DT_DD() || this.Encode_D_To_J() || this.Encode_DOUS() || this.Encode_Silent_D()) {
            return;
        }
        if (this.m_encodeExact) {
            if (this.m_current == this.m_last && this.StringAt(this.m_current - 3, 4, "SSED", "")) {
                this.MetaphAdd("T");
            } else {
                this.MetaphAdd("D");
            }
        } else {
            this.MetaphAdd("T");
        }
        ++this.m_current;
    }

    boolean Encode_DG() {
        if (this.StringAt(this.m_current, 2, "DG", "")) {
            if (this.StringAt(this.m_current + 2, 1, "A", "O", "") || this.StringAt(this.m_current + 1, 3, "GUN", "GUT", "") || this.StringAt(this.m_current + 1, 4, "GEAR", "GLAS", "GRIP", "GREN", "GILL", "GRAF", "") || this.StringAt(this.m_current + 1, 5, "GUARD", "GUILT", "GRAVE", "GRASS", "") || this.StringAt(this.m_current + 1, 6, "GROUSE", "")) {
                this.MetaphAddExactApprox("DG", "TK");
            } else {
                this.MetaphAdd("J");
            }
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_DJ() {
        if (this.StringAt(this.m_current, 2, "DJ", "")) {
            this.MetaphAdd("J");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_DT_DD() {
        if (this.StringAt(this.m_current, 2, "DT", "DD", "")) {
            if (this.StringAt(this.m_current, 3, "DTH", "")) {
                this.MetaphAddExactApprox("D0", "T0");
                this.m_current += 3;
            } else {
                if (this.m_encodeExact) {
                    if (this.StringAt(this.m_current, 2, "DT", "")) {
                        this.MetaphAdd("T");
                    } else {
                        this.MetaphAdd("D");
                    }
                } else {
                    this.MetaphAdd("T");
                }
                this.m_current += 2;
            }
            return true;
        }
        return false;
    }

    boolean Encode_D_To_J() {
        if (this.StringAt(this.m_current, 3, "DUL", "") && this.IsVowel(this.m_current - 1) && this.IsVowel(this.m_current + 3) || this.m_current + 3 == this.m_last && this.StringAt(this.m_current - 1, 5, "LDIER", "NDEUR", "EDURE", "RDURE", "") || this.StringAt(this.m_current - 3, 7, "CORDIAL", "") || this.StringAt(this.m_current - 1, 5, "NDULA", "NDULU", "EDUCA", "") || this.StringAt(this.m_current - 1, 4, "ADUA", "IDUA", "IDUU", "")) {
            this.MetaphAddExactApprox("J", "D", "J", "T");
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_DOUS() {
        if (this.StringAt(this.m_current + 1, 4, "UOUS", "")) {
            this.MetaphAddExactApprox("J", "D", "J", "T");
            this.AdvanceCounter(4, 1);
            return true;
        }
        return false;
    }

    boolean Encode_Silent_D() {
        if (this.StringAt(this.m_current - 2, 9, "WEDNESDAY", "") || this.StringAt(this.m_current - 3, 7, "HANDKER", "HANDSOM", "WINDSOR", "") || this.StringAt(this.m_current - 5, 6, "PERNOD", "ARTAUD", "RENAUD", "") || this.StringAt(this.m_current - 6, 7, "RIMBAUD", "MICHAUD", "BICHAUD", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    void Encode_F() {
        if (this.StringAt(this.m_current - 1, 5, "OFTEN", "")) {
            this.MetaphAdd("F", "FT");
            this.m_current += 2;
            return;
        }
        this.m_current = this.CharAt(this.m_current + 1) == 'F' ? (this.m_current += 2) : ++this.m_current;
        this.MetaphAdd("F");
    }

    void Encode_G() {
        if (this.Encode_Silent_G_At_Beginning() || this.Encode_GG() || this.Encode_GK() || this.Encode_GH() || this.Encode_Silent_G() || this.Encode_GN() || this.Encode_GL() || this.Encode_Initial_G_Front_Vowel() || this.Encode_NGER() || this.Encode_GER() || this.Encode_GEL() || this.Encode_Non_Initial_G_Front_Vowel() || this.Encode_GA_To_J()) {
            return;
        }
        if (!this.StringAt(this.m_current - 1, 1, "C", "K", "G", "Q", "")) {
            this.MetaphAddExactApprox("G", "K");
        }
        ++this.m_current;
    }

    boolean Encode_Silent_G_At_Beginning() {
        if (this.m_current == 0 && this.StringAt(this.m_current, 2, "GN", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_GG() {
        if (this.CharAt(this.m_current + 1) == 'G') {
            if (this.StringAt(this.m_current - 1, 5, "AGGIA", "OGGIA", "AGGIO", "EGGIO", "EGGIA", "IGGIO", "") || this.StringAt(this.m_current - 1, 5, "UGGIE", "") && this.m_current + 3 != this.m_last && this.m_current + 4 != this.m_last || this.m_current + 2 == this.m_last && this.StringAt(this.m_current - 1, 4, "AGGI", "OGGI", "") || this.StringAt(this.m_current - 2, 6, "SUGGES", "XAGGER", "REGGIE", "")) {
                if (this.StringAt(this.m_current - 2, 7, "SUGGEST", "")) {
                    this.MetaphAddExactApprox("G", "K");
                }
                this.MetaphAdd("J");
                this.AdvanceCounter(3, 2);
            } else {
                this.MetaphAddExactApprox("G", "K");
                this.m_current += 2;
            }
            return true;
        }
        return false;
    }

    boolean Encode_GK() {
        if (this.CharAt(this.m_current + 1) == 'K') {
            this.MetaphAdd("K");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_GH() {
        if (this.CharAt(this.m_current + 1) == 'H') {
            if (this.Encode_GH_After_Consonant() || this.Encode_Initial_GH() || this.Encode_GH_To_J() || this.Encode_GH_To_H() || this.Encode_UGHT() || this.Encode_GH_H_Part_Of_Other_Word() || this.Encode_Silent_GH() || this.Encode_GH_To_F()) {
                return true;
            }
            this.MetaphAddExactApprox("G", "K");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_GH_After_Consonant() {
        if (!(this.m_current <= 0 || this.IsVowel(this.m_current - 1) || this.StringAt(this.m_current - 3, 5, "HALGH", "") && this.m_current + 1 == this.m_last)) {
            this.MetaphAddExactApprox("G", "K");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_Initial_GH() {
        if (this.m_current < 3 && this.m_current == 0) {
            if (this.CharAt(this.m_current + 2) == 'I') {
                this.MetaphAdd("J");
            } else {
                this.MetaphAddExactApprox("G", "K");
            }
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_GH_To_J() {
        if (this.StringAt(this.m_current - 2, 4, "ALGH", "") && this.m_current + 1 == this.m_last) {
            this.MetaphAdd("J", "");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_GH_To_H() {
        if (this.StringAt(this.m_current - 4, 4, "DONO", "DONA", "") && this.IsVowel(this.m_current + 2) || this.StringAt(this.m_current - 5, 9, "CALLAGHAN", "")) {
            this.MetaphAdd("H");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_UGHT() {
        if (this.StringAt(this.m_current - 1, 4, "UGHT", "")) {
            if (this.StringAt(this.m_current - 3, 5, "LAUGH", "") && !this.StringAt(this.m_current - 4, 7, "SLAUGHT", "") && !this.StringAt(this.m_current - 3, 7, "LAUGHTO", "") || this.StringAt(this.m_current - 4, 6, "DRAUGH", "")) {
                this.MetaphAdd("FT");
            } else {
                this.MetaphAdd("T");
            }
            this.m_current += 3;
            return true;
        }
        return false;
    }

    boolean Encode_GH_H_Part_Of_Other_Word() {
        if (this.StringAt(this.m_current + 1, 4, "HOUS", "HEAD", "HOLE", "HORN", "HARN", "")) {
            this.MetaphAddExactApprox("G", "K");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_Silent_GH() {
        if ((this.m_current > 1 && this.StringAt(this.m_current - 2, 1, "B", "H", "D", "G", "L", "") || this.m_current > 2 && this.StringAt(this.m_current - 3, 1, "B", "H", "D", "K", "W", "N", "P", "V", "") && !this.StringAt(0, 6, "ENOUGH", "") || this.m_current > 3 && this.StringAt(this.m_current - 4, 1, "B", "H", "") || this.m_current > 3 && this.StringAt(this.m_current - 4, 2, "PL", "SL", "") || this.m_current > 0 && (this.CharAt(this.m_current - 1) == 'I' || this.StringAt(0, 4, "PUGH", "") || this.StringAt(this.m_current - 1, 3, "AGH", "") && this.m_current + 1 == this.m_last || this.StringAt(this.m_current - 4, 6, "GERAGH", "DRAUGH", "") || this.StringAt(this.m_current - 3, 5, "GAUGH", "GEOGH", "MAUGH", "") && !this.StringAt(0, 9, "MCGAUGHEY", "") || this.StringAt(this.m_current - 2, 4, "OUGH", "") && this.m_current > 3 && !this.StringAt(this.m_current - 4, 6, "CCOUGH", "ENOUGH", "TROUGH", "CLOUGH", ""))) && (this.StringAt(this.m_current - 3, 5, "VAUGH", "FEIGH", "LEIGH", "") || this.StringAt(this.m_current - 2, 4, "HIGH", "TIGH", "") || this.m_current + 1 == this.m_last || this.StringAt(this.m_current + 2, 2, "IE", "EY", "ES", "ER", "ED", "TY", "") && this.m_current + 3 == this.m_last && !this.StringAt(this.m_current - 5, 9, "GALLAGHER", "") || this.StringAt(this.m_current + 2, 1, "Y", "") && this.m_current + 2 == this.m_last || this.StringAt(this.m_current + 2, 3, "ING", "OUT", "") && this.m_current + 4 == this.m_last || this.StringAt(this.m_current + 2, 4, "ERTY", "") && this.m_current + 5 == this.m_last || !this.IsVowel(this.m_current + 2) || this.StringAt(this.m_current - 3, 5, "GAUGH", "GEOGH", "MAUGH", "") || this.StringAt(this.m_current - 4, 8, "BROUGHAM", "")) && !this.StringAt(0, 6, "BALOGH", "SABAGH", "") && !this.StringAt(this.m_current - 2, 7, "BAGHDAD", "") && !this.StringAt(this.m_current - 3, 5, "WHIGH", "") && !this.StringAt(this.m_current - 5, 7, "SABBAGH", "AKHLAGH", "")) {
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_GH_Special_Cases() {
        boolean handled = false;
        if (this.StringAt(this.m_current - 6, 8, "HICCOUGH", "")) {
            this.MetaphAdd("P");
            handled = true;
        } else if (this.StringAt(0, 5, "LOUGH", "")) {
            this.MetaphAdd("K");
            handled = true;
        } else if (this.StringAt(0, 6, "BALOGH", "")) {
            this.MetaphAddExactApprox("G", "", "K", "");
            handled = true;
        } else if (this.StringAt(this.m_current - 3, 8, "LAUGHLIN", "COUGHLAN", "LOUGHLIN", "")) {
            this.MetaphAdd("K", "F");
            handled = true;
        } else if (this.StringAt(this.m_current - 3, 5, "GOUGH", "") || this.StringAt(this.m_current - 7, 9, "COLCLOUGH", "")) {
            this.MetaphAdd("", "F");
            handled = true;
        }
        if (handled) {
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_GH_To_F() {
        if (this.Encode_GH_Special_Cases()) {
            return true;
        }
        if (this.m_current > 2 && this.CharAt(this.m_current - 1) == 'U' && this.IsVowel(this.m_current - 2) && this.StringAt(this.m_current - 3, 1, "C", "G", "L", "R", "T", "N", "S", "") && !this.StringAt(this.m_current - 4, 8, "BREUGHEL", "FLAUGHER", "")) {
            this.MetaphAdd("F");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_Silent_G() {
        if (this.m_current + 1 == this.m_last && (this.StringAt(this.m_current - 1, 3, "EGM", "IGM", "AGM", "") || this.StringAt(this.m_current, 2, "GT", "")) || this.StringAt(0, 5, "HUGES", "") && this.m_length == 5) {
            ++this.m_current;
            return true;
        }
        if (this.StringAt(0, 2, "NG", "") && this.m_current != this.m_last) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_GN() {
        if (this.CharAt(this.m_current + 1) == 'N') {
            if (!((this.m_current <= 1 || !this.StringAt(this.m_current - 1, 1, "I", "U", "E", "") && !this.StringAt(this.m_current - 3, 9, "LORGNETTE", "") && !this.StringAt(this.m_current - 2, 9, "LAGNIAPPE", "") && !this.StringAt(this.m_current - 2, 6, "COGNAC", "") && !this.StringAt(this.m_current - 3, 7, "CHAGNON", "") && !this.StringAt(this.m_current - 5, 9, "COMPAGNIE", "") && !this.StringAt(this.m_current - 4, 6, "BOLOGN", "") || this.StringAt(this.m_current + 2, 5, "ATION", "") || this.StringAt(this.m_current + 2, 4, "ATOR", "") || this.StringAt(this.m_current + 2, 3, "ATE", "ITY", "") || this.StringAt(this.m_current + 2, 2, "AN", "AC", "IA", "UM", "") && !this.StringAt(this.m_current - 3, 8, "POIGNANT", "") && !this.StringAt(this.m_current - 2, 6, "COGNAC", "") || this.StringAt(0, 7, "SPIGNER", "STEGNER", "") || this.StringAt(0, 5, "SIGNE", "") && this.m_length == 5 || this.StringAt(this.m_current - 2, 5, "LIGNI", "LIGNO", "REGNA", "DIGNI", "WEGNE", "TIGNE", "RIGNE", "REGNE", "TIGNO", "") || this.StringAt(this.m_current - 2, 6, "SIGNAL", "SIGNIF", "SIGNAT", "") || this.StringAt(this.m_current - 1, 5, "IGNIT", "") || this.StringAt(this.m_current - 2, 6, "SIGNET", "LIGNEO", "")) && (this.m_current + 2 != this.m_last || !this.StringAt(this.m_current, 3, "GNE", "GNA", "") || this.StringAt(this.m_current - 2, 5, "SIGNA", "MAGNA", "SIGNE", "")))) {
                this.MetaphAddExactApprox("N", "GN", "N", "KN");
            } else {
                this.MetaphAddExactApprox("GN", "KN");
            }
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_GL() {
        if (this.StringAt(this.m_current + 1, 3, "LIA", "LIO", "LIE", "") && this.IsVowel(this.m_current - 1)) {
            this.MetaphAddExactApprox("L", "GL", "L", "KL");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Initial_G_Soft() {
        return (this.StringAt(this.m_current + 1, 2, "EL", "EM", "EN", "EO", "ER", "ES", "IA", "IN", "IO", "IP", "IU", "YM", "YN", "YP", "YR", "EE", "") || this.StringAt(this.m_current + 1, 3, "IRA", "IRO", "")) && !this.StringAt(this.m_current + 1, 3, "ELD", "ELT", "ERT", "INZ", "ERH", "ITE", "ERD", "ERL", "ERN", "INT", "EES", "EEK", "ELB", "EER", "") && !this.StringAt(this.m_current + 1, 4, "ERSH", "ERST", "INSB", "INGR", "EROW", "ERKE", "EREN", "") && !this.StringAt(this.m_current + 1, 5, "ELLER", "ERDIE", "ERBER", "ESUND", "ESNER", "INGKO", "INKGO", "IPPER", "ESELL", "IPSON", "EEZER", "ERSON", "ELMAN", "") && !this.StringAt(this.m_current + 1, 6, "ESTALT", "ESTAPO", "INGHAM", "ERRITY", "ERRISH", "ESSNER", "ENGLER", "") && !this.StringAt(this.m_current + 1, 7, "YNAECOL", "YNECOLO", "ENTHNER", "ERAGHTY", "") && !this.StringAt(this.m_current + 1, 8, "INGERICH", "EOGHEGAN", "") || this.IsVowel(this.m_current + 1) && (this.StringAt(this.m_current + 1, 3, "EE ", "EEW", "") || this.StringAt(this.m_current + 1, 3, "IGI", "IRA", "IBE", "AOL", "IDE", "IGL", "") && !this.StringAt(this.m_current + 1, 5, "IDEON", "") || this.StringAt(this.m_current + 1, 4, "ILES", "INGI", "ISEL", "") || this.StringAt(this.m_current + 1, 5, "INGER", "") && !this.StringAt(this.m_current + 1, 8, "INGERICH", "") || this.StringAt(this.m_current + 1, 5, "IBBER", "IBBET", "IBLET", "IBRAN", "IGOLO", "IRARD", "IGANT", "") || this.StringAt(this.m_current + 1, 6, "IRAFFE", "EEWHIZ", "") || this.StringAt(this.m_current + 1, 7, "ILLETTE", "IBRALTA", ""));
    }

    boolean Encode_Initial_G_Front_Vowel() {
        if (this.m_current == 0 && this.Front_Vowel(this.m_current + 1)) {
            if (this.StringAt(this.m_current + 1, 3, "ILA", "") && this.m_length == 4) {
                this.MetaphAdd("H");
            } else if (this.Initial_G_Soft()) {
                this.MetaphAddExactApprox("J", "G", "J", "K");
            } else if (this.m_inWord.charAt(this.m_current + 1) == 'E' || this.m_inWord.charAt(this.m_current + 1) == 'I') {
                this.MetaphAddExactApprox("G", "J", "K", "J");
            } else {
                this.MetaphAddExactApprox("G", "K");
            }
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_NGER() {
        if (this.m_current > 1 && this.StringAt(this.m_current - 1, 4, "NGER", "")) {
            if (!(this.RootOrInflections(this.m_inWord, "ANGER") || this.RootOrInflections(this.m_inWord, "LINGER") || this.RootOrInflections(this.m_inWord, "MALINGER") || this.RootOrInflections(this.m_inWord, "FINGER") || this.StringAt(this.m_current - 3, 4, "HUNG", "FING", "BUNG", "WING", "RING", "DING", "ZENG", "ZING", "JUNG", "LONG", "PING", "CONG", "MONG", "BANG", "GANG", "HANG", "LANG", "SANG", "SING", "WANG", "ZANG", "") && !this.StringAt(this.m_current - 6, 7, "BOULANG", "SLESING", "KISSING", "DERRING", "") && !this.StringAt(this.m_current - 8, 9, "SCHLESING", "") && !this.StringAt(this.m_current - 5, 6, "SALING", "BELANG", "") && !this.StringAt(this.m_current - 6, 7, "BARRING", "") && !this.StringAt(this.m_current - 6, 9, "PHALANGER", "") && !this.StringAt(this.m_current - 4, 5, "CHANG", "") || this.StringAt(this.m_current - 4, 5, "STING", "YOUNG", "") || this.StringAt(this.m_current - 5, 6, "STRONG", "") || this.StringAt(0, 3, "UNG", "ENG", "ING", "") || this.StringAt(this.m_current, 6, "GERICH", "") || this.StringAt(0, 6, "SENGER", "") || this.StringAt(this.m_current - 3, 6, "WENGER", "MUNGER", "SONGER", "KINGER", "") || this.StringAt(this.m_current - 4, 7, "FLINGER", "SLINGER", "STANGER", "STENGER", "KLINGER", "CLINGER", "") || this.StringAt(this.m_current - 5, 8, "SPRINGER", "SPRENGER", "") || this.StringAt(this.m_current - 3, 7, "LINGERF", "") || this.StringAt(this.m_current - 2, 7, "ANGERLY", "ANGERBO", "INGERSO", ""))) {
                this.MetaphAddExactApprox("J", "G", "J", "K");
            } else {
                this.MetaphAddExactApprox("G", "J", "K", "J");
            }
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_GER() {
        if (this.m_current > 0 && this.StringAt(this.m_current + 1, 2, "ER", "")) {
            if ((this.m_current == 2 && this.IsVowel(this.m_current - 1) && !this.IsVowel(this.m_current - 2) && !this.StringAt(this.m_current - 2, 5, "PAGER", "WAGER", "NIGER", "ROGER", "LEGER", "CAGER", "") || this.StringAt(this.m_current - 2, 5, "AUGER", "EAGER", "INGER", "YAGER", "") || this.StringAt(this.m_current - 3, 6, "SEEGER", "JAEGER", "GEIGER", "KRUGER", "SAUGER", "BURGER", "MEAGER", "MARGER", "RIEGER", "YAEGER", "STEGER", "PRAGER", "SWIGER", "YERGER", "TORGER", "FERGER", "HILGER", "ZEIGER", "YARGER", "COWGER", "CREGER", "KROGER", "KREGER", "GRAGER", "STIGER", "BERGER", "") || this.StringAt(this.m_current - 3, 6, "BERGER", "") && this.m_current + 2 == this.m_last || this.StringAt(this.m_current - 4, 7, "KREIGER", "KRUEGER", "METZGER", "KRIEGER", "KROEGER", "STEIGER", "DRAEGER", "BUERGER", "BOERGER", "FIBIGER", "") || this.StringAt(this.m_current - 3, 6, "BARGER", "") && this.m_current > 4 || this.StringAt(this.m_current, 6, "GERBER", "") && this.m_current > 0 || this.StringAt(this.m_current - 5, 8, "SCHWAGER", "LYBARGER", "SPRENGER", "GALLAGER", "WILLIGER", "") || this.StringAt(0, 4, "HARGER", "") || this.StringAt(0, 4, "AGER", "EGER", "") && this.m_length == 4 || this.StringAt(this.m_current - 1, 6, "YGERNE", "") || this.StringAt(this.m_current - 6, 9, "SCHWEIGER", "")) && !this.StringAt(this.m_current - 5, 10, "BELLIGEREN", "") && !this.StringAt(0, 7, "MARGERY", "") && !this.StringAt(this.m_current - 3, 8, "BERGERAC", "")) {
                if (this.SlavoGermanic()) {
                    this.MetaphAddExactApprox("G", "K");
                } else {
                    this.MetaphAddExactApprox("G", "J", "K", "J");
                }
            } else {
                this.MetaphAddExactApprox("J", "G", "J", "K");
            }
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_GEL() {
        if (this.StringAt(this.m_current + 1, 2, "EL", "") && this.m_current > 0) {
            if (this.m_length == 5 && this.IsVowel(this.m_current - 1) && !this.IsVowel(this.m_current - 2) && !this.StringAt(this.m_current - 2, 5, "NIGEL", "RIGEL", "") || this.StringAt(this.m_current - 2, 5, "ENGEL", "HEGEL", "NAGEL", "VOGEL", "") || this.StringAt(this.m_current - 3, 6, "MANGEL", "WEIGEL", "FLUGEL", "RANGEL", "HAUGEN", "RIEGEL", "VOEGEL", "") || this.StringAt(this.m_current - 4, 7, "SPEIGEL", "STEIGEL", "WRANGEL", "SPIEGEL", "") || this.StringAt(this.m_current - 4, 8, "DANEGELD", "")) {
                if (this.SlavoGermanic()) {
                    this.MetaphAddExactApprox("G", "K");
                } else {
                    this.MetaphAddExactApprox("G", "J", "K", "J");
                }
            } else {
                this.MetaphAddExactApprox("J", "G", "J", "K");
            }
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_Non_Initial_G_Front_Vowel() {
        if (this.StringAt(this.m_current + 1, 1, "E", "I", "Y", "")) {
            if (this.StringAt(this.m_current, 2, "GE", "") && this.m_current == this.m_last - 1) {
                if (this.Hard_GE_At_End()) {
                    if (this.SlavoGermanic()) {
                        this.MetaphAddExactApprox("G", "K");
                    } else {
                        this.MetaphAddExactApprox("G", "J", "K", "J");
                    }
                } else {
                    this.MetaphAdd("J");
                }
            } else if (this.Internal_Hard_G()) {
                if (this.m_current != 2 || !this.StringAt(0, 2, "MC", "") || this.m_current == 3 && this.StringAt(0, 3, "MAC", "")) {
                    if (this.SlavoGermanic()) {
                        this.MetaphAddExactApprox("G", "K");
                    } else {
                        this.MetaphAddExactApprox("G", "J", "K", "J");
                    }
                }
            } else {
                this.MetaphAddExactApprox("J", "G", "J", "K");
            }
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Hard_GE_At_End() {
        return this.StringAt(0, 6, "RENEGE", "STONGE", "STANGE", "PRANGE", "KRESGE", "") || this.StringAt(0, 5, "BYRGE", "BIRGE", "BERGE", "HAUGE", "") || this.StringAt(0, 4, "HAGE", "") || this.StringAt(0, 5, "LANGE", "SYNGE", "BENGE", "RUNGE", "HELGE", "") || this.StringAt(0, 4, "INGE", "LAGE", "");
    }

    boolean Internal_Hard_G() {
        return !(this.m_current + 1 == this.m_last && this.CharAt(this.m_current + 1) == 'E' || !this.Internal_Hard_NG() && !this.Internal_Hard_GEN_GIN_GET_GIT() && !this.Internal_Hard_G_Open_Syllable() && !this.Internal_Hard_G_Other());
    }

    boolean Internal_Hard_G_Other() {
        return this.StringAt(this.m_current, 4, "GETH", "GEAR", "GEIS", "GIRL", "GIVI", "GIVE", "GIFT", "GIRD", "GIRT", "GILV", "GILD", "GELD", "") && !this.StringAt(this.m_current - 3, 6, "GINGIV", "") || this.StringAt(this.m_current + 1, 3, "ISH", "") && this.m_current > 0 && !this.StringAt(0, 4, "LARG", "") || this.StringAt(this.m_current - 2, 5, "MAGED", "MEGID", "") && this.m_current + 2 != this.m_last || this.StringAt(this.m_current, 3, "GEZ", "") || this.StringAt(0, 4, "WEGE", "HAGE", "") || this.StringAt(this.m_current - 2, 6, "ONGEST", "UNGEST", "") && this.m_current + 3 == this.m_last && !this.StringAt(this.m_current - 3, 7, "CONGEST", "") || this.StringAt(0, 5, "VOEGE", "BERGE", "HELGE", "") || this.StringAt(0, 4, "ENGE", "BOGY", "") && this.m_length == 4 || this.StringAt(this.m_current, 6, "GIBBON", "") || this.StringAt(0, 10, "CORREGIDOR", "") || this.StringAt(0, 8, "INGEBORG", "") || this.StringAt(this.m_current, 4, "GILL", "") && (this.m_current + 3 == this.m_last || this.m_current + 4 == this.m_last) && !this.StringAt(0, 8, "STURGILL", "");
    }

    boolean Internal_Hard_G_Open_Syllable() {
        return this.StringAt(this.m_current + 1, 3, "EYE", "") || this.StringAt(this.m_current - 2, 4, "FOGY", "POGY", "YOGI", "") || this.StringAt(this.m_current - 2, 5, "MAGEE", "MCGEE", "HAGIO", "") || this.StringAt(this.m_current - 1, 4, "RGEY", "OGEY", "") || this.StringAt(this.m_current - 3, 5, "HOAGY", "STOGY", "PORGY", "") || this.StringAt(this.m_current - 5, 8, "CARNEGIE", "") || this.StringAt(this.m_current - 1, 4, "OGEY", "OGIE", "") && this.m_current + 2 == this.m_last;
    }

    boolean Internal_Hard_GEN_GIN_GET_GIT() {
        return this.StringAt(this.m_current - 3, 6, "FORGET", "TARGET", "MARGIT", "MARGET", "TURGEN", "BERGEN", "MORGEN", "JORGEN", "HAUGEN", "JERGEN", "JURGEN", "LINGEN", "BORGEN", "LANGEN", "KLAGEN", "STIGER", "BERGER", "") && !this.StringAt(this.m_current, 7, "GENETIC", "GENESIS", "") && !this.StringAt(this.m_current - 4, 8, "PLANGENT", "") || this.StringAt(this.m_current - 3, 6, "BERGIN", "FEAGIN", "DURGIN", "") && this.m_current + 2 == this.m_last || this.StringAt(this.m_current - 2, 5, "ENGEN", "") && !this.StringAt(this.m_current + 3, 3, "DER", "ETI", "ESI", "") || this.StringAt(this.m_current - 4, 7, "JUERGEN", "") || this.StringAt(0, 5, "NAGIN", "MAGIN", "HAGIN", "") || this.StringAt(0, 5, "ENGIN", "DEGEN", "LAGEN", "MAGEN", "NAGIN", "") && this.m_length == 5 || this.StringAt(this.m_current - 2, 5, "BEGET", "BEGIN", "HAGEN", "FAGIN", "BOGEN", "WIGIN", "NTGEN", "EIGEN", "WEGEN", "WAGEN", "") && !this.StringAt(this.m_current - 5, 8, "OSPHAGEN", "");
    }

    boolean Internal_Hard_NG() {
        return this.StringAt(this.m_current - 3, 4, "DANG", "FANG", "SING", "") && !this.StringAt(this.m_current - 5, 8, "DISINGEN", "") || this.StringAt(0, 5, "INGEB", "ENGEB", "") || this.StringAt(this.m_current - 3, 4, "RING", "WING", "HANG", "LONG", "") && !this.StringAt(this.m_current - 4, 5, "CRING", "FRING", "ORANG", "TWING", "CHANG", "PHANG", "") && !this.StringAt(this.m_current - 5, 6, "SYRING", "") && !this.StringAt(this.m_current - 3, 7, "RINGENC", "RINGENT", "LONGITU", "LONGEVI", "") && (!this.StringAt(this.m_current, 4, "GELO", "GINO", "") || this.m_current + 3 != this.m_last) || this.StringAt(this.m_current - 1, 3, "NGY", "") && !this.StringAt(this.m_current - 3, 5, "RANGY", "MANGY", "MINGY", "") && !this.StringAt(this.m_current - 4, 6, "SPONGY", "STINGY", "");
    }

    boolean Encode_GA_To_J() {
        if (this.StringAt(this.m_current - 3, 7, "MARGARY", "MARGARI", "") && !this.StringAt(this.m_current - 3, 8, "MARGARIT", "") || this.StringAt(0, 4, "GAOL", "") || this.StringAt(this.m_current - 2, 5, "ALGAE", "")) {
            this.MetaphAddExactApprox("J", "G", "J", "K");
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    void Encode_H() {
        if (this.Encode_Initial_Silent_H() || this.Encode_Initial_HS() || this.Encode_Initial_HU_HW() || this.Encode_Non_Initial_Silent_H()) {
            return;
        }
        if (!this.Encode_H_Pronounced()) {
            ++this.m_current;
        }
    }

    boolean Encode_Initial_Silent_H() {
        if (this.StringAt(this.m_current + 1, 3, "OUR", "ERB", "EIR", "") || this.StringAt(this.m_current + 1, 4, "ONOR", "") || this.StringAt(this.m_current + 1, 5, "ONOUR", "ONEST", "")) {
            if (this.m_current == 0 && this.StringAt(this.m_current, 4, "HERB", "")) {
                if (this.m_encodeVowels) {
                    this.MetaphAdd("HA", "A");
                } else {
                    this.MetaphAdd("H", "A");
                }
            } else if (this.m_current == 0 || this.m_encodeVowels) {
                this.MetaphAdd("A");
            }
            ++this.m_current;
            this.m_current = this.SkipVowels(this.m_current);
            return true;
        }
        return false;
    }

    boolean Encode_Initial_HS() {
        if (this.m_current == 0 && this.StringAt(0, 2, "HS", "")) {
            this.MetaphAdd("X");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_Initial_HU_HW() {
        if (this.StringAt(0, 3, "HUA", "HUE", "HWA", "") && !this.StringAt(this.m_current, 4, "HUEY", "")) {
            this.MetaphAdd("A");
            if (!this.m_encodeVowels) {
                this.m_current += 3;
            } else {
                ++this.m_current;
                while (this.IsVowel(this.m_current) || this.CharAt(this.m_current) == 'W') {
                    ++this.m_current;
                }
            }
            return true;
        }
        return false;
    }

    boolean Encode_Non_Initial_Silent_H() {
        if (this.StringAt(this.m_current - 2, 5, "NIHIL", "VEHEM", "LOHEN", "NEHEM", "MAHON", "MAHAN", "COHEN", "GAHAN", "") || this.StringAt(this.m_current - 3, 6, "GRAHAM", "PROHIB", "FRAHER", "TOOHEY", "TOUHEY", "") || this.StringAt(this.m_current - 3, 5, "TOUHY", "") || this.StringAt(0, 9, "CHIHUAHUA", "")) {
            if (!this.m_encodeVowels) {
                this.m_current += 2;
            } else {
                ++this.m_current;
                this.m_current = this.SkipVowels(this.m_current);
            }
            return true;
        }
        return false;
    }

    boolean Encode_H_Pronounced() {
        if ((this.m_current == 0 || this.IsVowel(this.m_current - 1) || this.m_current > 0 && this.CharAt(this.m_current - 1) == 'W') && this.IsVowel(this.m_current + 1) || this.CharAt(this.m_current + 1) == 'H' && this.IsVowel(this.m_current + 2)) {
            this.MetaphAdd("H");
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    void Encode_J() {
        if (this.Encode_Spanish_J() || this.Encode_Spanish_OJ_UJ()) {
            return;
        }
        this.Encode_Other_J();
    }

    boolean Encode_Spanish_J() {
        if (this.StringAt(this.m_current + 1, 3, "UAN", "ACI", "ALI", "EFE", "ICA", "IME", "OAQ", "UAR", "") && !this.StringAt(this.m_current, 8, "JIMERSON", "JIMERSEN", "") || this.StringAt(this.m_current + 1, 3, "OSE", "") && this.m_current + 3 == this.m_last || this.StringAt(this.m_current + 1, 4, "EREZ", "UNTA", "AIME", "AVIE", "AVIA", "") || this.StringAt(this.m_current + 1, 6, "IMINEZ", "ARAMIL", "") || this.m_current + 2 == this.m_last && this.StringAt(this.m_current - 2, 5, "MEJIA", "") || this.StringAt(this.m_current - 2, 5, "TEJED", "TEJAD", "LUJAN", "FAJAR", "BEJAR", "BOJOR", "CAJIG", "DEJAS", "DUJAR", "DUJAN", "MIJAR", "MEJOR", "NAJAR", "NOJOS", "RAJED", "RIJAL", "REJON", "TEJAN", "UIJAN", "") || this.StringAt(this.m_current - 3, 8, "ALEJANDR", "GUAJARDO", "TRUJILLO", "") || this.StringAt(this.m_current - 2, 5, "RAJAS", "") && this.m_current > 2 || this.StringAt(this.m_current - 2, 5, "MEJIA", "") && !this.StringAt(this.m_current - 2, 6, "MEJIAN", "") || this.StringAt(this.m_current - 1, 5, "OJEDA", "") || this.StringAt(this.m_current - 3, 5, "LEIJA", "MINJA", "") || this.StringAt(this.m_current - 3, 6, "VIAJES", "GRAJAL", "") || this.StringAt(this.m_current, 8, "JAUREGUI", "") || this.StringAt(this.m_current - 4, 8, "HINOJOSA", "") || this.StringAt(0, 4, "SAN ", "") || this.m_current + 1 == this.m_last && this.CharAt(this.m_current + 1) == 'O' && !this.StringAt(0, 4, "TOJO", "") && !this.StringAt(0, 5, "BANJO", "") && !this.StringAt(0, 6, "MARYJO", "")) {
            if (!this.StringAt(this.m_current, 4, "JUAN", "") && !this.StringAt(this.m_current, 4, "JOAQ", "")) {
                this.MetaphAdd("H");
            } else if (this.m_current == 0) {
                this.MetaphAdd("A");
            }
            this.AdvanceCounter(2, 1);
            return true;
        }
        if (this.StringAt(this.m_current + 1, 4, "ORGE", "ULIO", "ESUS", "") && !this.StringAt(0, 6, "JORGEN", "")) {
            if (this.m_current + 4 == this.m_last && this.StringAt(this.m_current + 1, 4, "ORGE", "")) {
                if (this.m_encodeVowels) {
                    this.MetaphAdd("JARJ", "HARHA");
                } else {
                    this.MetaphAdd("JRJ", "HRH");
                }
                this.AdvanceCounter(5, 5);
                return true;
            }
            this.MetaphAdd("J", "H");
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_German_J() {
        if (this.StringAt(this.m_current + 1, 2, "AH", "") || this.StringAt(this.m_current + 1, 5, "OHANN", "") && this.m_current + 5 == this.m_last || this.StringAt(this.m_current + 1, 3, "UNG", "") && !this.StringAt(this.m_current + 1, 4, "UNGL", "") || this.StringAt(this.m_current + 1, 3, "UGO", "")) {
            this.MetaphAdd("A");
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_Spanish_OJ_UJ() {
        if (this.StringAt(this.m_current + 1, 5, "OJOBA", "UJUY ", "")) {
            if (this.m_encodeVowels) {
                this.MetaphAdd("HAH");
            } else {
                this.MetaphAdd("HH");
            }
            this.AdvanceCounter(4, 3);
            return true;
        }
        return false;
    }

    boolean Encode_J_To_J() {
        if (this.IsVowel(this.m_current + 1)) {
            if (this.m_current == 0 && this.Names_Beginning_With_J_That_Get_Alt_Y()) {
                if (this.m_encodeVowels) {
                    this.MetaphAdd("JA", "A");
                } else {
                    this.MetaphAdd("J", "A");
                }
            } else if (this.m_encodeVowels) {
                this.MetaphAdd("JA");
            } else {
                this.MetaphAdd("J");
            }
            ++this.m_current;
            this.m_current = this.SkipVowels(this.m_current);
            return false;
        }
        this.MetaphAdd("J");
        ++this.m_current;
        return true;
    }

    boolean Encode_Spanish_J_2() {
        if (this.m_current - 2 == 0 && this.StringAt(this.m_current - 2, 4, "BOJA", "BAJA", "BEJA", "BOJO", "MOJA", "MOJI", "MEJI", "") || this.m_current - 3 == 0 && this.StringAt(this.m_current - 3, 5, "FRIJO", "BRUJO", "BRUJA", "GRAJE", "GRIJA", "LEIJA", "QUIJA", "") || this.m_current + 3 == this.m_last && this.StringAt(this.m_current - 1, 5, "AJARA", "") || this.m_current + 2 == this.m_last && this.StringAt(this.m_current - 1, 4, "AJOS", "EJOS", "OJAS", "OJOS", "UJON", "AJOZ", "AJAL", "UJAR", "EJON", "EJAN", "") || this.m_current + 1 == this.m_last && this.StringAt(this.m_current - 1, 3, "OJA", "EJA", "") && !this.StringAt(0, 4, "DEJA", "")) {
            this.MetaphAdd("H");
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_J_As_Vowel() {
        if (this.StringAt(this.m_current, 5, "JEWSK", "")) {
            this.MetaphAdd("J", "");
            return true;
        }
        return this.StringAt(this.m_current + 1, 1, "L", "T", "K", "S", "N", "M", "") && !this.StringAt(this.m_current + 2, 1, "A", "") || this.StringAt(0, 9, "HALLELUJA", "LJUBLJANA", "") || this.StringAt(0, 4, "LJUB", "BJOR", "") || this.StringAt(0, 5, "HAJEK", "") || this.StringAt(0, 3, "WOJ", "") || this.StringAt(0, 2, "FJ", "") || this.StringAt(this.m_current, 5, "JAVIK", "JEVIC", "") || this.m_current + 1 == this.m_last && this.StringAt(0, 5, "SONJA", "TANJA", "TONJA", "");
    }

    void Encode_Other_J() {
        if (this.m_current == 0) {
            if (this.Encode_German_J()) {
                return;
            }
            if (this.Encode_J_To_J()) {
                return;
            }
        } else {
            if (this.Encode_Spanish_J_2()) {
                return;
            }
            if (!this.Encode_J_As_Vowel()) {
                this.MetaphAdd("J");
            }
            this.m_current = this.CharAt(this.m_current + 1) == 'J' ? (this.m_current += 2) : ++this.m_current;
        }
    }

    void Encode_K() {
        if (!this.Encode_Silent_K()) {
            this.MetaphAdd("K");
            this.m_current = this.CharAt(this.m_current + 1) == 'K' || this.CharAt(this.m_current + 1) == 'Q' ? (this.m_current += 2) : ++this.m_current;
        }
    }

    boolean Encode_Silent_K() {
        if (this.m_current == 0 && this.StringAt(this.m_current, 2, "KN", "") && !this.StringAt(this.m_current + 2, 5, "ESSET", "IEVEL", "") && !this.StringAt(this.m_current + 2, 3, "ISH", "")) {
            ++this.m_current;
            return true;
        }
        if (this.StringAt(this.m_current + 1, 3, "NOW", "NIT", "NOT", "NOB", "") && !this.StringAt(0, 8, "BANKNOTE", "") || this.StringAt(this.m_current + 1, 4, "NOCK", "NUCK", "NIFE", "NACK", "") || this.StringAt(this.m_current + 1, 5, "NIGHT", "")) {
            this.m_current = this.m_current > 0 && this.CharAt(this.m_current - 1) == 'N' ? (this.m_current += 2) : ++this.m_current;
            return true;
        }
        return false;
    }

    void Encode_L() {
        int save_current = this.m_current;
        this.Interpolate_Vowel_When_Cons_L_At_End();
        if (this.Encode_LELY_To_L() || this.Encode_COLONEL() || this.Encode_French_AULT() || this.Encode_French_EUIL() || this.Encode_French_OULX() || this.Encode_Silent_L_In_LM() || this.Encode_Silent_L_In_LK_LV() || this.Encode_Silent_L_In_OULD()) {
            return;
        }
        if (this.Encode_LL_As_Vowel_Cases()) {
            return;
        }
        this.Encode_LE_Cases(save_current);
    }

    void Interpolate_Vowel_When_Cons_L_At_End() {
        if (this.m_encodeVowels && this.m_current == this.m_last && this.StringAt(this.m_current - 1, 1, "D", "G", "T", "")) {
            this.MetaphAdd("A");
        }
    }

    boolean Encode_LELY_To_L() {
        if (this.StringAt(this.m_current - 1, 5, "ILELY", "") && this.m_current + 3 == this.m_last) {
            this.MetaphAdd("L");
            this.m_current += 3;
            return true;
        }
        return false;
    }

    boolean Encode_COLONEL() {
        if (this.StringAt(this.m_current - 2, 7, "COLONEL", "")) {
            this.MetaphAdd("R");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_French_AULT() {
        if (!(this.m_current <= 3 || !this.StringAt(this.m_current - 3, 5, "RAULT", "NAULT", "BAULT", "SAULT", "GAULT", "CAULT", "") && !this.StringAt(this.m_current - 4, 6, "REAULT", "RIAULT", "NEAULT", "BEAULT", "") || this.RootOrInflections(this.m_inWord, "ASSAULT") || this.StringAt(this.m_current - 8, 10, "SOMERSAULT", "") || this.StringAt(this.m_current - 9, 11, "SUMMERSAULT", ""))) {
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_French_EUIL() {
        if (this.StringAt(this.m_current - 3, 4, "EUIL", "") && this.m_current == this.m_last) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_French_OULX() {
        if (this.StringAt(this.m_current - 2, 4, "OULX", "") && this.m_current + 1 == this.m_last) {
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_Silent_L_In_LM() {
        if (this.StringAt(this.m_current, 2, "LM", "LN", "")) {
            if ((this.StringAt(this.m_current - 2, 4, "COLN", "CALM", "BALM", "MALM", "PALM", "") || this.StringAt(this.m_current - 1, 3, "OLM", "") && this.m_current + 1 == this.m_last || this.StringAt(this.m_current - 3, 5, "PSALM", "QUALM", "") || this.StringAt(this.m_current - 2, 6, "SALMON", "HOLMES", "") || this.StringAt(this.m_current - 1, 6, "ALMOND", "") || this.m_current == 1 && this.StringAt(this.m_current - 1, 4, "ALMS", "")) && !this.StringAt(this.m_current + 2, 1, "A", "") && !this.StringAt(this.m_current - 2, 5, "BALMO", "") && !this.StringAt(this.m_current - 2, 6, "PALMER", "PALMOR", "BALMER", "") && !this.StringAt(this.m_current - 3, 5, "THALM", "")) {
                ++this.m_current;
                return true;
            }
            this.MetaphAdd("L");
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_Silent_L_In_LK_LV() {
        if ((this.StringAt(this.m_current - 2, 4, "WALK", "YOLK", "FOLK", "HALF", "TALK", "CALF", "BALK", "CALK", "") || this.StringAt(this.m_current - 2, 4, "POLK", "") && !this.StringAt(this.m_current - 2, 5, "POLKA", "WALKO", "") || this.StringAt(this.m_current - 2, 4, "HALV", "") && !this.StringAt(this.m_current - 2, 5, "HALVA", "HALVO", "") || this.StringAt(this.m_current - 3, 5, "CAULK", "CHALK", "BAULK", "FAULK", "") && !this.StringAt(this.m_current - 4, 6, "SCHALK", "") || (this.StringAt(this.m_current - 2, 5, "SALVE", "CALVE", "") || this.StringAt(this.m_current - 2, 6, "SOLDER", "")) && !this.StringAt(this.m_current - 2, 6, "SALVER", "CALVER", "")) && !this.StringAt(this.m_current - 5, 9, "GONSALVES", "GONCALVES", "") && !this.StringAt(this.m_current - 2, 6, "BALKAN", "TALKAL", "") && !this.StringAt(this.m_current - 3, 5, "PAULK", "CHALF", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_Silent_L_In_OULD() {
        if (this.StringAt(this.m_current - 3, 5, "WOULD", "COULD", "") || this.StringAt(this.m_current - 4, 6, "SHOULD", "") && !this.StringAt(this.m_current - 4, 8, "SHOULDER", "")) {
            this.MetaphAddExactApprox("D", "T");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_LL_As_Vowel_Special_Cases() {
        if (this.StringAt(this.m_current - 5, 8, "TORTILLA", "") || this.StringAt(this.m_current - 8, 11, "RATATOUILLE", "") || this.StringAt(0, 5, "GUILL", "VEILL", "GAILL", "") && !this.StringAt(this.m_current - 3, 7, "GUILLOT", "GUILLOR", "GUILLEN", "") && (!this.StringAt(0, 5, "GUILL", "") || this.m_length != 5) || this.StringAt(0, 7, "BROUILL", "GREMILL", "ROBILL", "") || this.StringAt(this.m_current - 2, 5, "EILLE", "") && this.m_current + 2 == this.m_last && !this.StringAt(this.m_current - 5, 8, "REVEILLE", "")) {
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_LL_As_Vowel() {
        if (this.m_current + 3 == this.m_length && this.StringAt(this.m_current - 1, 4, "ILLO", "ILLA", "ALLE", "") || (this.StringAt(this.m_last - 1, 2, "AS", "OS", "") || this.StringAt(this.m_last, 2, "AS", "OS", "") || this.StringAt(this.m_last, 1, "A", "O", "")) && this.StringAt(this.m_current - 1, 2, "AL", "IL", "") && !this.StringAt(this.m_current - 1, 4, "ALLA", "") || this.StringAt(0, 5, "VILLE", "VILLA", "") || this.StringAt(0, 8, "GALLARDO", "VALLADAR", "MAGALLAN", "CAVALLAR", "BALLASTE", "") || this.StringAt(0, 3, "LLA", "")) {
            this.MetaphAdd("L", "");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_LL_As_Vowel_Cases() {
        if (this.CharAt(this.m_current + 1) == 'L') {
            if (this.Encode_LL_As_Vowel_Special_Cases()) {
                return true;
            }
            if (this.Encode_LL_As_Vowel()) {
                return true;
            }
            this.m_current += 2;
        } else {
            ++this.m_current;
        }
        return false;
    }

    boolean Encode_Vowel_LE_Transposition(int save_current) {
        if (!(!this.m_encodeVowels || save_current <= 1 || this.IsVowel(save_current - 1) || this.CharAt(save_current + 1) != 'E' || this.CharAt(save_current - 1) == 'L' || this.CharAt(save_current - 1) == 'R' || this.IsVowel(save_current + 2) || this.StringAt(0, 7, "ECCLESI", "COMPLEC", "COMPLEJ", "ROBLEDO", "") || this.StringAt(0, 5, "MCCLE", "MCLEL", "") || this.StringAt(0, 6, "EMBLEM", "KADLEC", "") || save_current + 2 == this.m_last && this.StringAt(save_current, 3, "LET", "") || this.StringAt(save_current, 7, "LETTING", "") || this.StringAt(save_current, 6, "LETELY", "LETTER", "LETION", "LETIAN", "LETING", "LETORY", "") || this.StringAt(save_current, 5, "LETUS", "LETIV", "") || this.StringAt(save_current, 4, "LESS", "LESQ", "LECT", "LEDG", "LETE", "LETH", "LETS", "LETT", "") || this.StringAt(save_current, 3, "LEG", "LER", "LEX", "") || this.StringAt(save_current, 6, "LEMENT", "") && !this.StringAt(this.m_current - 5, 6, "BATTLE", "TANGLE", "PUZZLE", "RABBLE", "BABBLE", "") && !this.StringAt(this.m_current - 4, 5, "TABLE", "") || save_current + 2 == this.m_last && this.StringAt(save_current - 2, 5, "OCLES", "ACLES", "AKLES", "") || this.StringAt(save_current - 3, 5, "LISLE", "AISLE", "") || this.StringAt(0, 4, "ISLE", "") || this.StringAt(0, 6, "ROBLES", "") || this.StringAt(save_current - 4, 7, "PROBLEM", "RESPLEN", "") || this.StringAt(save_current - 3, 6, "REPLEN", "") || this.StringAt(save_current - 2, 4, "SPLE", "") || this.CharAt(save_current - 1) == 'H' || this.CharAt(save_current - 1) == 'W')) {
            this.MetaphAdd("AL");
            this.flag_AL_inversion = true;
            if (this.CharAt(save_current + 2) == 'L') {
                this.m_current = save_current + 3;
            }
            return true;
        }
        return false;
    }

    boolean Encode_Vowel_Preserve_Vowel_After_L(int save_current) {
        if (!(!this.m_encodeVowels || this.IsVowel(save_current - 1) || this.CharAt(save_current + 1) != 'E' || save_current <= 1 || save_current + 1 == this.m_last || this.StringAt(save_current + 1, 2, "ES", "ED", "") && save_current + 2 == this.m_last || this.StringAt(save_current - 1, 5, "RLEST", ""))) {
            this.MetaphAdd("LA");
            this.m_current = this.SkipVowels(this.m_current);
            return true;
        }
        return false;
    }

    void Encode_LE_Cases(int save_current) {
        if (this.Encode_Vowel_LE_Transposition(save_current)) {
            return;
        }
        if (this.Encode_Vowel_Preserve_Vowel_After_L(save_current)) {
            return;
        }
        this.MetaphAdd("L");
    }

    void Encode_M() {
        if (this.Encode_Silent_M_At_Beginning() || this.Encode_MR_And_MRS() || this.Encode_MAC() || this.Encode_MPT()) {
            return;
        }
        this.Encode_MB();
        this.MetaphAdd("M");
    }

    boolean Encode_Silent_M_At_Beginning() {
        if (this.m_current == 0 && this.StringAt(this.m_current, 2, "MN", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_MR_And_MRS() {
        if (this.m_current == 0 && this.StringAt(this.m_current, 2, "MR", "")) {
            if (this.m_length == 2 && this.StringAt(this.m_current, 2, "MR", "")) {
                if (this.m_encodeVowels) {
                    this.MetaphAdd("MASTAR");
                } else {
                    this.MetaphAdd("MSTR");
                }
                this.m_current += 2;
                return true;
            }
            if (this.m_length == 3 && this.StringAt(this.m_current, 3, "MRS", "")) {
                if (this.m_encodeVowels) {
                    this.MetaphAdd("MASAS");
                } else {
                    this.MetaphAdd("MSS");
                }
                this.m_current += 3;
                return true;
            }
        }
        return false;
    }

    boolean Encode_MAC() {
        if (this.m_current == 0 && (this.StringAt(0, 7, "MACIVER", "MACEWEN", "") || this.StringAt(0, 8, "MACELROY", "MACILROY", "") || this.StringAt(0, 9, "MACINTOSH", "") || this.StringAt(0, 2, "MC", ""))) {
            if (this.m_encodeVowels) {
                this.MetaphAdd("MAK");
            } else {
                this.MetaphAdd("MK");
            }
            this.m_current = this.StringAt(0, 2, "MC", "") ? (this.StringAt(this.m_current + 2, 1, "K", "G", "Q", "") && !this.StringAt(this.m_current + 2, 4, "GEOR", "") ? (this.m_current += 3) : (this.m_current += 2)) : (this.m_current += 3);
            return true;
        }
        return false;
    }

    boolean Encode_MPT() {
        if (this.StringAt(this.m_current - 2, 8, "COMPTROL", "") || this.StringAt(this.m_current - 4, 7, "ACCOMPT", "")) {
            this.MetaphAdd("N");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Test_Silent_MB_1() {
        return this.m_current == 3 && this.StringAt(this.m_current - 3, 5, "THUMB", "") || this.m_current == 2 && this.StringAt(this.m_current - 2, 4, "DUMB", "BOMB", "DAMN", "LAMB", "NUMB", "TOMB", "");
    }

    boolean Test_Pronounced_MB() {
        return this.StringAt(this.m_current - 2, 6, "NUMBER", "") || this.StringAt(this.m_current + 2, 1, "A", "") && !this.StringAt(this.m_current - 2, 7, "DUMBASS", "") || this.StringAt(this.m_current + 2, 1, "O", "") || this.StringAt(this.m_current - 2, 6, "LAMBEN", "LAMBER", "LAMBET", "TOMBIG", "LAMBRE", "");
    }

    boolean Test_Silent_MB_2() {
        return this.CharAt(this.m_current + 1) == 'B' && this.m_current > 1 && (this.m_current + 1 == this.m_last || this.StringAt(this.m_current + 2, 3, "ING", "ABL", "") || this.StringAt(this.m_current + 2, 4, "LIKE", "") || this.CharAt(this.m_current + 2) == 'S' && this.m_current + 2 == this.m_last || this.StringAt(this.m_current - 5, 7, "BUNCOMB", "") || this.StringAt(this.m_current + 2, 2, "ED", "ER", "") && this.m_current + 3 == this.m_last && (this.StringAt(0, 5, "CLIMB", "PLUMB", "") || !this.StringAt(this.m_current - 1, 5, "IMBER", "AMBER", "EMBER", "UMBER", "")) && !this.StringAt(this.m_current - 2, 6, "CUMBER", "SOMBER", ""));
    }

    boolean Test_Pronounced_MB_2() {
        return this.StringAt(this.m_current - 1, 5, "OMBAS", "OMBAD", "UMBRA", "") || this.StringAt(this.m_current - 3, 4, "FLAM", "");
    }

    boolean Test_MN() {
        return this.CharAt(this.m_current + 1) == 'N' && (this.m_current + 1 == this.m_last || this.StringAt(this.m_current + 2, 3, "ING", "EST", "") && this.m_current + 4 == this.m_last || this.CharAt(this.m_current + 2) == 'S' && this.m_current + 2 == this.m_last || this.StringAt(this.m_current + 2, 2, "LY", "ER", "ED", "") && this.m_current + 3 == this.m_last || this.StringAt(this.m_current - 2, 9, "DAMNEDEST", "") || this.StringAt(this.m_current - 5, 9, "GODDAMNIT", ""));
    }

    void Encode_MB() {
        this.m_current = this.Test_Silent_MB_1() ? (this.Test_Pronounced_MB() ? ++this.m_current : (this.m_current += 2)) : (this.Test_Silent_MB_2() ? (this.Test_Pronounced_MB_2() ? ++this.m_current : (this.m_current += 2)) : (this.Test_MN() ? (this.m_current += 2) : (this.CharAt(this.m_current + 1) == 'M' ? (this.m_current += 2) : ++this.m_current)));
    }

    void Encode_N() {
        if (this.Encode_NCE()) {
            return;
        }
        this.m_current = this.CharAt(this.m_current + 1) == 'N' ? (this.m_current += 2) : ++this.m_current;
        if (!this.StringAt(this.m_current - 3, 8, "MONSIEUR", "") && !this.StringAt(this.m_current - 3, 6, "NENESS", "")) {
            this.MetaphAdd("N");
        }
    }

    boolean Encode_NCE() {
        if (this.StringAt(this.m_current + 1, 1, "C", "S", "") && this.StringAt(this.m_current + 2, 1, "E", "Y", "I", "") && (this.m_current + 2 == this.m_last || this.m_current + 3 == this.m_last && this.CharAt(this.m_current + 3) == 'S')) {
            this.MetaphAdd("NTS");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    void Encode_P() {
        if (this.Encode_Silent_P_At_Beginning() || this.Encode_PT() || this.Encode_PH() || this.Encode_PPH() || this.Encode_RPS() || this.Encode_COUP() || this.Encode_PNEUM() || this.Encode_PSYCH() || this.Encode_PSALM()) {
            return;
        }
        this.Encode_PB();
        this.MetaphAdd("P");
    }

    boolean Encode_Silent_P_At_Beginning() {
        if (this.m_current == 0 && this.StringAt(this.m_current, 2, "PN", "PF", "PS", "PT", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_PT() {
        if (this.CharAt(this.m_current + 1) == 'T' && (this.m_current == 0 && this.StringAt(this.m_current, 5, "PTERO", "") || this.StringAt(this.m_current - 5, 7, "RECEIPT", "") || this.StringAt(this.m_current - 4, 8, "ASYMPTOT", ""))) {
            this.MetaphAdd("T");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_PH() {
        if (this.CharAt(this.m_current + 1) == 'H') {
            if (this.StringAt(this.m_current, 9, "PHTHALEIN", "") || this.m_current == 0 && this.StringAt(this.m_current, 4, "PHTH", "") || this.StringAt(this.m_current - 3, 10, "APOPHTHEGM", "")) {
                this.MetaphAdd("0");
                this.m_current += 4;
            } else if (this.m_current > 0 && (this.StringAt(this.m_current + 2, 3, "EAD", "OLE", "ELD", "ILL", "OLD", "EAP", "ERD", "ARD", "ANG", "ORN", "EAV", "ART", "") || this.StringAt(this.m_current + 2, 4, "OUSE", "") || this.StringAt(this.m_current + 2, 2, "AM", "") && !this.StringAt(this.m_current - 1, 5, "LPHAM", "") || this.StringAt(this.m_current + 2, 5, "AMMER", "AZARD", "UGGER", "") || this.StringAt(this.m_current + 2, 6, "OLSTER", "")) && !this.StringAt(this.m_current - 3, 5, "LYMPH", "NYMPH", "")) {
                this.MetaphAdd("P");
                this.AdvanceCounter(3, 2);
            } else {
                this.MetaphAdd("F");
                this.m_current += 2;
            }
            return true;
        }
        return false;
    }

    boolean Encode_PPH() {
        if (this.CharAt(this.m_current + 1) == 'P' && this.m_current + 2 < this.m_length && this.CharAt(this.m_current + 2) == 'H') {
            this.MetaphAdd("F");
            this.m_current += 3;
            return true;
        }
        return false;
    }

    boolean Encode_RPS() {
        if (this.StringAt(this.m_current - 3, 5, "CORPS", "") && !this.StringAt(this.m_current - 3, 6, "CORPSE", "")) {
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_COUP() {
        if (this.m_current == this.m_last && this.StringAt(this.m_current - 3, 4, "COUP", "") && !this.StringAt(this.m_current - 5, 6, "RECOUP", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_PNEUM() {
        if (this.StringAt(this.m_current + 1, 4, "NEUM", "")) {
            this.MetaphAdd("N");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_PSYCH() {
        if (this.StringAt(this.m_current + 1, 4, "SYCH", "")) {
            if (this.m_encodeVowels) {
                this.MetaphAdd("SAK");
            } else {
                this.MetaphAdd("SK");
            }
            this.m_current += 5;
            return true;
        }
        return false;
    }

    boolean Encode_PSALM() {
        if (this.StringAt(this.m_current + 1, 4, "SALM", "")) {
            if (this.m_encodeVowels) {
                this.MetaphAdd("SAM");
            } else {
                this.MetaphAdd("SM");
            }
            this.m_current += 5;
            return true;
        }
        return false;
    }

    void Encode_PB() {
        this.m_current = this.StringAt(this.m_current + 1, 1, "P", "B", "") ? (this.m_current += 2) : ++this.m_current;
    }

    void Encode_Q() {
        if (this.StringAt(this.m_current, 3, "QIN", "")) {
            this.MetaphAdd("X");
            ++this.m_current;
            return;
        }
        this.m_current = this.CharAt(this.m_current + 1) == 'Q' ? (this.m_current += 2) : ++this.m_current;
        this.MetaphAdd("K");
    }

    void Encode_R() {
        if (this.Encode_RZ()) {
            return;
        }
        if (!this.Test_Silent_R() && !this.Encode_Vowel_RE_Transposition()) {
            this.MetaphAdd("R");
        }
        this.m_current = this.CharAt(this.m_current + 1) == 'R' || this.StringAt(this.m_current - 6, 8, "POITIERS", "") ? (this.m_current += 2) : ++this.m_current;
    }

    boolean Encode_RZ() {
        if (this.StringAt(this.m_current - 2, 4, "GARZ", "KURZ", "MARZ", "MERZ", "HERZ", "PERZ", "WARZ", "") || this.StringAt(this.m_current, 5, "RZANO", "RZOLA", "") || this.StringAt(this.m_current - 1, 4, "ARZA", "ARZN", "")) {
            return false;
        }
        if (this.StringAt(this.m_current - 4, 11, "YASTRZEMSKI", "")) {
            this.MetaphAdd("R", "X");
            this.m_current += 2;
            return true;
        }
        if (this.StringAt(this.m_current - 1, 10, "BRZEZINSKI", "")) {
            this.MetaphAdd("RS", "RJ");
            this.m_current += 4;
            return true;
        }
        if (this.StringAt(this.m_current - 1, 3, "TRZ", "PRZ", "KRZ", "") || this.StringAt(this.m_current, 2, "RZ", "") && (this.IsVowel(this.m_current - 1) || this.m_current == 0)) {
            this.MetaphAdd("RS", "X");
            this.m_current += 2;
            return true;
        }
        if (this.StringAt(this.m_current - 1, 3, "BRZ", "DRZ", "GRZ", "")) {
            this.MetaphAdd("RS", "J");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Test_Silent_R() {
        return this.m_current == this.m_last && this.StringAt(this.m_current - 2, 3, "IER", "") && (this.StringAt(this.m_current - 5, 3, "MET", "VIV", "LUC", "") || this.StringAt(this.m_current - 6, 4, "CART", "DOSS", "FOUR", "OLIV", "BUST", "DAUM", "ATEL", "SONN", "CORM", "MERC", "PELT", "POIR", "BERN", "FORT", "GREN", "SAUC", "GAGN", "GAUT", "GRAN", "FORC", "MESS", "LUSS", "MEUN", "POTH", "HOLL", "CHEN", "") || this.StringAt(this.m_current - 7, 5, "CROUP", "TORCH", "CLOUT", "FOURN", "GAUTH", "TROTT", "DEROS", "CHART", "") || this.StringAt(this.m_current - 8, 6, "CHEVAL", "LAVOIS", "PELLET", "SOMMEL", "TREPAN", "LETELL", "COLOMB", "") || this.StringAt(this.m_current - 9, 7, "CHARCUT", "") || this.StringAt(this.m_current - 10, 8, "CHARPENT", "")) || this.StringAt(this.m_current - 2, 7, "SURBURB", "WORSTED", "") || this.StringAt(this.m_current - 2, 9, "WORCESTER", "") || this.StringAt(this.m_current - 7, 8, "MONSIEUR", "") || this.StringAt(this.m_current - 6, 8, "POITIERS", "");
    }

    boolean Encode_Vowel_RE_Transposition() {
        if (!(!this.m_encodeVowels || this.CharAt(this.m_current + 1) != 'E' || this.m_length <= 3 || this.StringAt(0, 5, "OUTRE", "LIBRE", "ANDRE", "") || this.StringAt(0, 4, "FRED", "TRES", "") && this.m_length == 4 || this.StringAt(this.m_current - 2, 5, "LDRED", "LFRED", "NDRED", "NFRED", "NDRES", "TRES", "IFRED", "") || this.IsVowel(this.m_current - 1) || this.m_current + 1 != this.m_last && (this.m_current + 2 != this.m_last || !this.StringAt(this.m_current + 2, 1, "D", "S", "")))) {
            this.MetaphAdd("AR");
            return true;
        }
        return false;
    }

    void Encode_S() {
        if (this.Encode_SKJ() || this.Encode_Special_SW() || this.Encode_SJ() || this.Encode_Silent_French_S_Final() || this.Encode_Silent_French_S_Internal() || this.Encode_ISL() || this.Encode_STL() || this.Encode_Christmas() || this.Encode_STHM() || this.Encode_ISTEN() || this.Encode_Sugar() || this.Encode_SH() || this.Encode_SCH() || this.Encode_SUR() || this.Encode_SU() || this.Encode_SSIO() || this.Encode_SS() || this.Encode_SIA() || this.Encode_SIO() || this.Encode_Anglicisations() || this.Encode_SC() || this.Encode_SEA_SUI_SIER() || this.Encode_SEA()) {
            return;
        }
        this.MetaphAdd("S");
        this.m_current = this.StringAt(this.m_current + 1, 1, "S", "Z", "") && !this.StringAt(this.m_current + 1, 2, "SH", "") ? (this.m_current += 2) : ++this.m_current;
    }

    boolean Encode_Special_SW() {
        if (this.m_current == 0) {
            if (this.Names_Beginning_With_SW_That_Get_Alt_SV()) {
                this.MetaphAdd("S", "SV");
                this.m_current += 2;
                return true;
            }
            if (this.Names_Beginning_With_SW_That_Get_Alt_XV()) {
                this.MetaphAdd("S", "XV");
                this.m_current += 2;
                return true;
            }
        }
        return false;
    }

    boolean Encode_SKJ() {
        if (this.StringAt(this.m_current, 4, "SKJO", "SKJU", "") && this.IsVowel(this.m_current + 3)) {
            this.MetaphAdd("X");
            this.m_current += 3;
            return true;
        }
        return false;
    }

    boolean Encode_SJ() {
        if (this.StringAt(0, 2, "SJ", "")) {
            this.MetaphAdd("X");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_Silent_French_S_Final() {
        if (this.StringAt(0, 5, "LOUIS", "") && this.m_current == this.m_last) {
            this.MetaphAdd("S", "");
            ++this.m_current;
            return true;
        }
        if (this.m_current == this.m_last && (this.StringAt(0, 4, "YVES", "") || this.StringAt(0, 4, "HORS", "") && this.m_current == 3 || this.StringAt(this.m_current - 4, 5, "CAMUS", "YPRES", "") || this.StringAt(this.m_current - 5, 6, "MESNES", "DEBRIS", "BLANCS", "INGRES", "CANNES", "") || this.StringAt(this.m_current - 6, 7, "CHABLIS", "APROPOS", "JACQUES", "ELYSEES", "OEUVRES", "GEORGES", "DESPRES", "") || this.StringAt(0, 8, "ARKANSAS", "FRANCAIS", "CRUDITES", "BRUYERES", "") || this.StringAt(0, 9, "DESCARTES", "DESCHUTES", "DESCHAMPS", "DESROCHES", "DESCHENES", "") || this.StringAt(0, 10, "RENDEZVOUS", "") || this.StringAt(0, 11, "CONTRETEMPS", "DESLAURIERS", "")) || this.m_current == this.m_last && this.StringAt(this.m_current - 2, 2, "AI", "OI", "UI", "") && !this.StringAt(0, 4, "LOIS", "LUIS", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_Silent_French_S_Internal() {
        if (this.StringAt(this.m_current - 2, 9, "DESCARTES", "") || this.StringAt(this.m_current - 2, 7, "DESCHAM", "DESPRES", "DESROCH", "DESROSI", "DESJARD", "DESMARA", "DESCHEN", "DESHOTE", "DESLAUR", "") || this.StringAt(this.m_current - 2, 6, "MESNES", "") || this.StringAt(this.m_current - 5, 8, "DUQUESNE", "DUCHESNE", "") || this.StringAt(this.m_current - 7, 10, "BEAUCHESNE", "") || this.StringAt(this.m_current - 3, 7, "FRESNEL", "") || this.StringAt(this.m_current - 3, 9, "GROSVENOR", "") || this.StringAt(this.m_current - 4, 10, "LOUISVILLE", "") || this.StringAt(this.m_current - 7, 10, "ILLINOISAN", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_ISL() {
        if (this.StringAt(this.m_current - 2, 4, "LISL", "LYSL", "AISL", "") && !this.StringAt(this.m_current - 3, 7, "PAISLEY", "BAISLEY", "ALISLAM", "ALISLAH", "ALISLAA", "") || this.m_current == 1 && (this.StringAt(this.m_current - 1, 4, "ISLE", "") || this.StringAt(this.m_current - 1, 5, "ISLAN", "")) && !this.StringAt(this.m_current - 1, 5, "ISLEY", "ISLER", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_STL() {
        if (this.StringAt(this.m_current, 4, "STLE", "STLI", "") && !this.StringAt(this.m_current + 2, 4, "LESS", "LIKE", "LINE", "") || this.StringAt(this.m_current - 3, 7, "THISTLY", "BRISTLY", "GRISTLY", "") || this.StringAt(this.m_current - 1, 5, "USCLE", "")) {
            if (this.StringAt(0, 7, "KRISTEN", "KRYSTLE", "CRYSTLE", "KRISTLE", "") || this.StringAt(0, 11, "CHRISTENSEN", "CHRISTENSON", "") || this.StringAt(this.m_current - 3, 9, "FIRSTLING", "") || this.StringAt(this.m_current - 2, 8, "NESTLING", "WESTLING", "")) {
                this.MetaphAdd("ST");
                this.m_current += 2;
            } else {
                if (this.m_encodeVowels && this.CharAt(this.m_current + 3) == 'E' && this.CharAt(this.m_current + 4) != 'R' && !this.StringAt(this.m_current + 3, 4, "ETTE", "ETTA", "") && !this.StringAt(this.m_current + 3, 2, "EY", "")) {
                    this.MetaphAdd("SAL");
                    this.flag_AL_inversion = true;
                } else {
                    this.MetaphAdd("SL");
                }
                this.m_current += 3;
            }
            return true;
        }
        return false;
    }

    boolean Encode_Christmas() {
        if (this.StringAt(this.m_current - 4, 8, "CHRISTMA", "")) {
            this.MetaphAdd("SM");
            this.m_current += 3;
            return true;
        }
        return false;
    }

    boolean Encode_STHM() {
        if (this.StringAt(this.m_current, 4, "STHM", "")) {
            this.MetaphAdd("SM");
            this.m_current += 4;
            return true;
        }
        return false;
    }

    boolean Encode_ISTEN() {
        if (this.StringAt(0, 8, "CHRISTEN", "")) {
            if (this.RootOrInflections(this.m_inWord, "CHRISTEN") || this.StringAt(0, 11, "CHRISTENDOM", "")) {
                this.MetaphAdd("S", "ST");
            } else {
                this.MetaphAdd("ST");
            }
            this.m_current += 2;
            return true;
        }
        if (this.StringAt(this.m_current - 2, 6, "LISTEN", "RISTEN", "HASTEN", "FASTEN", "MUSTNT", "") || this.StringAt(this.m_current - 3, 7, "MOISTEN", "")) {
            this.MetaphAdd("S");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_Sugar() {
        if (this.StringAt(this.m_current, 5, "SUGAR", "")) {
            this.MetaphAdd("X");
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_SH() {
        if (this.StringAt(this.m_current, 2, "SH", "")) {
            if (this.StringAt(this.m_current - 2, 8, "CASHMERE", "")) {
                this.MetaphAdd("J");
                this.m_current += 2;
                return true;
            }
            if (this.m_current > 0 && (this.StringAt(this.m_current + 1, 3, "HAP", "") && this.m_current + 3 == this.m_last || this.StringAt(this.m_current + 1, 4, "HEIM", "HOEK", "HOLM", "HOLZ", "HOOD", "HEAD", "HEID", "HAAR", "HORS", "HOLE", "HUND", "HELM", "HAWK", "HILL", "") || this.StringAt(this.m_current + 1, 5, "HEART", "HATCH", "HOUSE", "HOUND", "HONOR", "") || this.StringAt(this.m_current + 2, 3, "EAR", "") && this.m_current + 4 == this.m_last || this.StringAt(this.m_current + 2, 3, "ORN", "") && !this.StringAt(this.m_current - 2, 7, "UNSHORN", "") || this.StringAt(this.m_current + 1, 4, "HOUR", "") && !this.StringAt(0, 7, "BASHOUR", "") && !this.StringAt(0, 8, "MANSHOUR", "") && !this.StringAt(0, 6, "ASHOUR", "") || this.StringAt(this.m_current + 2, 5, "ARMON", "ONEST", "ALLOW", "OLDER", "OPPER", "EIMER", "ANDLE", "ONOUR", "") || this.StringAt(this.m_current + 2, 6, "ABILLE", "UMANCE", "ABITUA", ""))) {
                if (!this.StringAt(this.m_current - 1, 1, "S", "")) {
                    this.MetaphAdd("S");
                }
            } else {
                this.MetaphAdd("X");
            }
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_SCH() {
        if (this.StringAt(this.m_current + 1, 2, "CH", "")) {
            if (this.m_current > 0 && (this.StringAt(this.m_current + 3, 3, "IEF", "EAT", "") || this.StringAt(this.m_current + 3, 4, "ANCE", "ARGE", "") || this.StringAt(0, 6, "ESCHEW", ""))) {
                this.MetaphAdd("S");
                ++this.m_current;
                return true;
            }
            if (this.StringAt(this.m_current + 3, 2, "OO", "ER", "EN", "UY", "ED", "EM", "IA", "IZ", "IS", "OL", "") && !this.StringAt(this.m_current, 6, "SCHOLT", "SCHISL", "SCHERR", "") || this.StringAt(this.m_current + 3, 3, "ISZ", "") || this.StringAt(this.m_current - 1, 6, "ESCHAT", "ASCHIN", "ASCHAL", "ISCHAE", "ISCHIA", "") && !this.StringAt(this.m_current - 2, 8, "FASCHING", "") || this.StringAt(this.m_current - 1, 5, "ESCHI", "") && this.m_current + 3 == this.m_last || this.CharAt(this.m_current + 3) == 'Y') {
                if (this.StringAt(this.m_current + 3, 2, "ER", "EN", "IS", "") && (this.m_current + 4 == this.m_last || this.StringAt(this.m_current + 3, 3, "ENK", "ENB", "IST", ""))) {
                    this.MetaphAdd("X", "SK");
                } else {
                    this.MetaphAdd("SK");
                }
                this.m_current += 3;
                return true;
            }
            this.MetaphAdd("X");
            this.m_current += 3;
            return true;
        }
        return false;
    }

    boolean Encode_SUR() {
        if (this.StringAt(this.m_current + 1, 3, "URE", "URA", "URY", "")) {
            if (this.m_current == 0 || this.StringAt(this.m_current - 1, 1, "N", "K", "") || this.StringAt(this.m_current - 2, 2, "NO", "")) {
                this.MetaphAdd("X");
            } else {
                this.MetaphAdd("J");
            }
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_SU() {
        if (this.StringAt(this.m_current + 1, 2, "UO", "UA", "") && this.m_current != 0) {
            if (this.StringAt(this.m_current - 1, 4, "RSUA", "")) {
                this.MetaphAdd("S");
            } else if (this.IsVowel(this.m_current - 1)) {
                this.MetaphAdd("J", "S");
            } else {
                this.MetaphAdd("X", "S");
            }
            this.AdvanceCounter(3, 1);
            return true;
        }
        return false;
    }

    boolean Encode_SSIO() {
        if (this.StringAt(this.m_current + 1, 4, "SION", "")) {
            if (this.StringAt(this.m_current - 2, 2, "CI", "")) {
                this.MetaphAdd("J");
            } else if (this.IsVowel(this.m_current - 1)) {
                this.MetaphAdd("X");
            }
            this.AdvanceCounter(4, 2);
            return true;
        }
        return false;
    }

    boolean Encode_SS() {
        if (this.StringAt(this.m_current - 1, 5, "USSIA", "ESSUR", "ISSUR", "ISSUE", "") || this.StringAt(this.m_current - 1, 6, "ESSIAN", "ASSURE", "ASSURA", "ISSUAB", "ISSUAN", "ASSIUS", "")) {
            this.MetaphAdd("X");
            this.AdvanceCounter(3, 2);
            return true;
        }
        return false;
    }

    boolean Encode_SIA() {
        if (this.StringAt(this.m_current - 2, 5, "CHSIA", "") || this.StringAt(this.m_current - 1, 5, "RSIAL", "")) {
            this.MetaphAdd("X");
            this.AdvanceCounter(3, 1);
            return true;
        }
        if (this.StringAt(0, 6, "ALESIA", "ALYSIA", "ALISIA", "STASIA", "") && this.m_current == 3 && !this.StringAt(0, 9, "ANASTASIA", "") || this.StringAt(this.m_current - 5, 9, "DIONYSIAN", "") || this.StringAt(this.m_current - 5, 8, "THERESIA", "")) {
            this.MetaphAdd("X", "S");
            this.AdvanceCounter(3, 1);
            return true;
        }
        if (this.StringAt(this.m_current, 3, "SIA", "") && this.m_current + 2 == this.m_last || this.StringAt(this.m_current, 4, "SIAN", "") && this.m_current + 3 == this.m_last || this.StringAt(this.m_current - 5, 9, "AMBROSIAL", "")) {
            if (!(!this.IsVowel(this.m_current - 1) && !this.StringAt(this.m_current - 1, 1, "R", "") || this.StringAt(0, 5, "JAMES", "NICOS", "PEGAS", "PEPYS", "") || this.StringAt(0, 6, "HOBBES", "HOLMES", "JAQUES", "KEYNES", "") || this.StringAt(0, 7, "MALTHUS", "HOMOOUS", "") || this.StringAt(0, 8, "MAGLEMOS", "HOMOIOUS", "") || this.StringAt(0, 9, "LEVALLOIS", "TARDENOIS", "") || this.StringAt(this.m_current - 4, 5, "ALGES", ""))) {
                this.MetaphAdd("J");
            } else {
                this.MetaphAdd("S");
            }
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_SIO() {
        if (this.StringAt(0, 7, "SIOBHAN", "")) {
            this.MetaphAdd("X");
            this.AdvanceCounter(3, 1);
            return true;
        }
        if (this.StringAt(this.m_current + 1, 3, "ION", "")) {
            if (this.IsVowel(this.m_current - 1) || this.StringAt(this.m_current - 2, 2, "ER", "UR", "")) {
                this.MetaphAdd("J");
            } else {
                this.MetaphAdd("X");
            }
            this.AdvanceCounter(3, 1);
            return true;
        }
        return false;
    }

    boolean Encode_Anglicisations() {
        if (this.m_current == 0 && this.StringAt(this.m_current + 1, 1, "M", "N", "L", "") || this.StringAt(this.m_current + 1, 1, "Z", "")) {
            this.MetaphAdd("S", "X");
            this.m_current = this.StringAt(this.m_current + 1, 1, "Z", "") ? (this.m_current += 2) : ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_SC() {
        if (this.StringAt(this.m_current, 2, "SC", "")) {
            if (this.StringAt(this.m_current - 2, 8, "VISCOUNT", "")) {
                ++this.m_current;
                return true;
            }
            if (this.StringAt(this.m_current + 2, 1, "I", "E", "Y", "")) {
                if (this.StringAt(this.m_current + 2, 4, "IOUS", "") || this.StringAt(this.m_current + 2, 3, "IUT", "") || this.StringAt(this.m_current - 4, 9, "OMNISCIEN", "") || this.StringAt(this.m_current - 3, 8, "CONSCIEN", "CRESCEND", "CONSCION", "") || this.StringAt(this.m_current - 2, 6, "FASCIS", "")) {
                    this.MetaphAdd("X");
                } else if (this.StringAt(this.m_current, 7, "SCEPTIC", "SCEPSIS", "") || this.StringAt(this.m_current, 5, "SCIVV", "SCIRO", "") || this.StringAt(this.m_current, 6, "SCIPIO", "") || this.StringAt(this.m_current - 2, 10, "PISCITELLI", "")) {
                    this.MetaphAdd("SK");
                } else {
                    this.MetaphAdd("S");
                }
                this.m_current += 2;
                return true;
            }
            this.MetaphAdd("SK");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_SEA_SUI_SIER() {
        if (this.StringAt(this.m_current - 3, 6, "NAUSEA", "") && this.m_current + 2 == this.m_last || this.StringAt(this.m_current - 2, 5, "CASUI", "") || this.StringAt(this.m_current - 1, 5, "OSIER", "ASIER", "") && !this.StringAt(0, 6, "EASIER", "") && !this.StringAt(0, 5, "OSIER", "") && !this.StringAt(this.m_current - 2, 6, "ROSIER", "MOSIER", "")) {
            this.MetaphAdd("J", "X");
            this.AdvanceCounter(3, 1);
            return true;
        }
        return false;
    }

    boolean Encode_SEA() {
        if (this.StringAt(0, 4, "SEAN", "") && this.m_current + 3 == this.m_last || this.StringAt(this.m_current - 3, 6, "NAUSEO", "") && !this.StringAt(this.m_current - 3, 7, "NAUSEAT", "")) {
            this.MetaphAdd("X");
            this.AdvanceCounter(3, 1);
            return true;
        }
        return false;
    }

    void Encode_T() {
        if (this.Encode_T_Initial() || this.Encode_TCH() || this.Encode_Silent_French_T() || this.Encode_TUN_TUL_TUA_TUO() || this.Encode_TUE_TEU_TEOU_TUL_TIE() || this.Encode_TUR_TIU_Suffixes() || this.Encode_TI() || this.Encode_TIENT() || this.Encode_TSCH() || this.Encode_TZSCH() || this.Encode_TH_Pronounced_Separately() || this.Encode_TTH() || this.Encode_TH()) {
            return;
        }
        this.m_current = this.StringAt(this.m_current + 1, 1, "T", "D", "") ? (this.m_current += 2) : ++this.m_current;
        this.MetaphAdd("T");
    }

    boolean Encode_T_Initial() {
        if (this.m_current == 0) {
            if (this.StringAt(this.m_current + 1, 3, "SAR", "ZAR", "")) {
                ++this.m_current;
                return true;
            }
            if (this.m_length == 3 && this.StringAt(this.m_current + 1, 2, "SO", "SA", "SU", "") || this.m_length == 4 && this.StringAt(this.m_current + 1, 3, "SAO", "SAI", "") || this.m_length == 5 && this.StringAt(this.m_current + 1, 4, "SING", "SANG", "")) {
                this.MetaphAdd("X");
                this.AdvanceCounter(3, 2);
                return true;
            }
            if (this.StringAt(this.m_current + 1, 1, "S", "") && this.IsVowel(this.m_current + 2)) {
                this.MetaphAdd("TS", "S");
                this.AdvanceCounter(3, 2);
                return true;
            }
            if (this.StringAt(this.m_current + 1, 1, "J", "")) {
                this.MetaphAdd("X");
                this.AdvanceCounter(3, 2);
                return true;
            }
            if (this.StringAt(this.m_current + 1, 2, "HU", "") && this.m_length == 3 || this.StringAt(this.m_current + 1, 3, "HAI", "HUY", "HAO", "") || this.StringAt(this.m_current + 1, 4, "HYME", "HYMY", "HANH", "") || this.StringAt(this.m_current + 1, 5, "HERES", "")) {
                this.MetaphAdd("T");
                this.AdvanceCounter(3, 2);
                return true;
            }
        }
        return false;
    }

    boolean Encode_TCH() {
        if (this.StringAt(this.m_current + 1, 2, "CH", "")) {
            this.MetaphAdd("X");
            this.m_current += 3;
            return true;
        }
        return false;
    }

    boolean Encode_Silent_French_T() {
        if (this.m_current == this.m_last && this.StringAt(this.m_current - 4, 5, "MONET", "GENET", "CHAUT", "") || this.StringAt(this.m_current - 2, 9, "POTPOURRI", "") || this.StringAt(this.m_current - 3, 9, "BOATSWAIN", "") || this.StringAt(this.m_current - 3, 8, "MORTGAGE", "") || (this.StringAt(this.m_current - 4, 5, "BERET", "BIDET", "FILET", "DEBUT", "DEPOT", "PINOT", "TAROT", "") || this.StringAt(this.m_current - 5, 6, "BALLET", "BUFFET", "CACHET", "CHALET", "ESPRIT", "RAGOUT", "GOULET", "CHABOT", "BENOIT", "") || this.StringAt(this.m_current - 6, 7, "GOURMET", "BOUQUET", "CROCHET", "CROQUET", "PARFAIT", "PINCHOT", "CABARET", "PARQUET", "RAPPORT", "TOUCHET", "COURBET", "DIDEROT", "") || this.StringAt(this.m_current - 7, 8, "ENTREPOT", "CABERNET", "DUBONNET", "MASSENET", "MUSCADET", "RICOCHET", "ESCARGOT", "") || this.StringAt(this.m_current - 8, 9, "SOBRIQUET", "CABRIOLET", "CASSOULET", "OUBRIQUET", "CAMEMBERT", "")) && !this.StringAt(this.m_current + 1, 2, "AN", "RY", "IC", "OM", "IN", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_TUN_TUL_TUA_TUO() {
        if (this.StringAt(this.m_current - 3, 6, "FORTUN", "") || this.StringAt(this.m_current, 3, "TUL", "") && this.IsVowel(this.m_current - 1) && this.IsVowel(this.m_current + 3) || this.StringAt(this.m_current - 2, 5, "BITUA", "BITUE", "") || this.m_current > 1 && this.StringAt(this.m_current, 3, "TUA", "TUO", "")) {
            this.MetaphAdd("X", "T");
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_TUE_TEU_TEOU_TUL_TIE() {
        if (this.StringAt(this.m_current + 1, 4, "UENT", "") || this.StringAt(this.m_current - 4, 9, "RIGHTEOUS", "") || this.StringAt(this.m_current - 3, 7, "STATUTE", "") || this.StringAt(this.m_current - 3, 7, "AMATEUR", "") || this.StringAt(this.m_current - 1, 5, "NTULE", "NTULA", "STULE", "STULA", "STEUR", "") || this.m_current + 2 == this.m_last && this.StringAt(this.m_current, 3, "TUE", "") || this.StringAt(this.m_current, 5, "TUENC", "") || this.StringAt(this.m_current - 3, 8, "STATUTOR", "") || this.m_current + 5 == this.m_last && this.StringAt(this.m_current, 6, "TIENCE", "")) {
            this.MetaphAdd("X", "T");
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_TUR_TIU_Suffixes() {
        if (this.m_current > 0 && this.StringAt(this.m_current + 1, 3, "URE", "URA", "URI", "URY", "URO", "IUS", "")) {
            if (this.StringAt(this.m_current + 1, 3, "URA", "URO", "") && this.m_current + 3 == this.m_last && !this.StringAt(this.m_current - 3, 7, "VENTURA", "") || this.StringAt(this.m_current + 1, 4, "URIA", "")) {
                this.MetaphAdd("T");
            } else {
                this.MetaphAdd("X", "T");
            }
            this.AdvanceCounter(2, 1);
            return true;
        }
        return false;
    }

    boolean Encode_TI() {
        if (this.StringAt(this.m_current + 1, 2, "IO", "") && !this.StringAt(this.m_current - 1, 5, "ETIOL", "") || this.StringAt(this.m_current + 1, 3, "IAL", "") || this.StringAt(this.m_current - 1, 5, "RTIUM", "ATIUM", "") || this.StringAt(this.m_current + 1, 3, "IAN", "") && this.m_current > 0 && !this.StringAt(this.m_current - 4, 8, "FAUSTIAN", "") && !this.StringAt(this.m_current - 5, 9, "PROUSTIAN", "") && !this.StringAt(this.m_current - 2, 7, "TATIANA", "") && !this.StringAt(this.m_current - 3, 7, "KANTIAN", "GENTIAN", "") && !this.StringAt(this.m_current - 8, 12, "ROOSEVELTIAN", "") || this.m_current + 2 == this.m_last && this.StringAt(this.m_current, 3, "TIA", "") && !this.StringAt(this.m_current - 3, 6, "HESTIA", "MASTIA", "") && !this.StringAt(this.m_current - 2, 5, "OSTIA", "") && !this.StringAt(0, 3, "TIA", "") && !this.StringAt(this.m_current - 5, 8, "IZVESTIA", "") || this.StringAt(this.m_current + 1, 4, "IATE", "IATI", "IABL", "IATO", "IARY", "") || this.StringAt(this.m_current - 5, 9, "CHRISTIAN", "")) {
            if (this.m_current == 2 && this.StringAt(0, 4, "ANTI", "") || this.StringAt(0, 5, "PATIO", "PITIA", "DUTIA", "")) {
                this.MetaphAdd("T");
            } else if (this.StringAt(this.m_current - 4, 8, "EQUATION", "")) {
                this.MetaphAdd("J");
            } else if (this.StringAt(this.m_current, 4, "TION", "")) {
                this.MetaphAdd("X");
            } else if (this.StringAt(0, 5, "KATIA", "LATIA", "")) {
                this.MetaphAdd("T", "X");
            } else {
                this.MetaphAdd("X", "T");
            }
            this.AdvanceCounter(3, 1);
            return true;
        }
        return false;
    }

    boolean Encode_TIENT() {
        if (this.StringAt(this.m_current + 1, 4, "IENT", "")) {
            this.MetaphAdd("X", "T");
            this.AdvanceCounter(3, 1);
            return true;
        }
        return false;
    }

    boolean Encode_TSCH() {
        if (this.StringAt(this.m_current, 4, "TSCH", "") && !this.StringAt(this.m_current - 3, 4, "WELT", "KLAT", "FEST", "")) {
            this.MetaphAdd("X");
            this.m_current += 4;
            return true;
        }
        return false;
    }

    boolean Encode_TZSCH() {
        if (this.StringAt(this.m_current, 5, "TZSCH", "")) {
            this.MetaphAdd("X");
            this.m_current += 5;
            return true;
        }
        return false;
    }

    boolean Encode_TH_Pronounced_Separately() {
        if (this.m_current > 0 && this.StringAt(this.m_current + 1, 4, "HOOD", "HEAD", "HEID", "HAND", "HILL", "HOLD", "HAWK", "HEAP", "HERD", "HOLE", "HOOK", "HUNT", "HUMO", "HAUS", "HOFF", "HARD", "") && !this.StringAt(this.m_current - 3, 5, "SOUTH", "NORTH", "") || this.StringAt(this.m_current + 1, 5, "HOUSE", "HEART", "HASTE", "HYPNO", "HEQUE", "") || this.StringAt(this.m_current + 1, 4, "HALL", "") && this.m_current + 4 == this.m_last && !this.StringAt(this.m_current - 3, 5, "SOUTH", "NORTH", "") || this.StringAt(this.m_current + 1, 3, "HAM", "") && this.m_current + 3 == this.m_last && !this.StringAt(0, 6, "GOTHAM", "WITHAM", "LATHAM", "") && !this.StringAt(0, 7, "BENTHAM", "WALTHAM", "WORTHAM", "") && !this.StringAt(0, 8, "GRANTHAM", "") || this.StringAt(this.m_current + 1, 5, "HATCH", "") && this.m_current != 0 && !this.StringAt(this.m_current - 2, 8, "UNTHATCH", "") || this.StringAt(this.m_current - 3, 7, "WARTHOG", "") || this.StringAt(this.m_current - 2, 6, "ESTHER", "") || this.StringAt(this.m_current - 3, 6, "GOETHE", "") || this.StringAt(this.m_current - 2, 8, "NATHALIE", "")) {
            if (this.StringAt(this.m_current - 3, 7, "POSTHUM", "")) {
                this.MetaphAdd("X");
            } else {
                this.MetaphAdd("T");
            }
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_TTH() {
        if (this.StringAt(this.m_current, 3, "TTH", "")) {
            if (this.StringAt(this.m_current - 2, 5, "MATTH", "")) {
                this.MetaphAdd("0");
            } else {
                this.MetaphAdd("T0");
            }
            this.m_current += 3;
            return true;
        }
        return false;
    }

    boolean Encode_TH() {
        if (this.StringAt(this.m_current, 2, "TH", "")) {
            if (this.StringAt(this.m_current - 3, 7, "CLOTHES", "")) {
                this.m_current += 3;
                return true;
            }
            if (this.StringAt(this.m_current + 2, 4, "OMAS", "OMPS", "OMPK", "OMSO", "OMSE", "AMES", "OVEN", "OFEN", "ILDA", "ILDE", "") || this.StringAt(0, 4, "THOM", "") && this.m_length == 4 || this.StringAt(0, 5, "THOMS", "") && this.m_length == 5 || this.StringAt(0, 4, "VAN ", "VON ", "") || this.StringAt(0, 3, "SCH", "")) {
                this.MetaphAdd("T");
            } else if (this.StringAt(0, 2, "SM", "")) {
                this.MetaphAdd("0", "T");
            } else {
                this.MetaphAdd("0");
            }
            this.m_current += 2;
            return true;
        }
        return false;
    }

    void Encode_V() {
        this.m_current = this.CharAt(this.m_current + 1) == 'V' ? (this.m_current += 2) : ++this.m_current;
        this.MetaphAddExactApprox("V", "F");
    }

    void Encode_W() {
        if (this.Encode_Silent_W_At_Beginning() || this.Encode_WITZ_WICZ() || this.Encode_WR() || this.Encode_Initial_W_Vowel() || this.Encode_WH() || this.Encode_Eastern_European_W()) {
            return;
        }
        if (this.m_encodeVowels && this.StringAt(this.m_current, 2, "WE", "") && this.m_current + 1 == this.m_last) {
            this.MetaphAdd("A");
        }
        ++this.m_current;
    }

    boolean Encode_Silent_W_At_Beginning() {
        if (this.m_current == 0 && this.StringAt(this.m_current, 2, "WR", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_WITZ_WICZ() {
        if (this.m_current + 3 == this.m_last && this.StringAt(this.m_current, 4, "WICZ", "WITZ", "")) {
            if (this.m_encodeVowels) {
                if (this.m_primary.length() > 0 && this.m_primary.charAt(this.m_primary.length() - 1) == 'A') {
                    this.MetaphAdd("TS", "FAX");
                } else {
                    this.MetaphAdd("ATS", "FAX");
                }
            } else {
                this.MetaphAdd("TS", "FX");
            }
            this.m_current += 4;
            return true;
        }
        return false;
    }

    boolean Encode_WR() {
        if (this.StringAt(this.m_current, 2, "WR", "")) {
            this.MetaphAdd("R");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_Initial_W_Vowel() {
        if (this.m_current == 0 && this.IsVowel(this.m_current + 1)) {
            if (this.Germanic_Or_Slavic_Name_Beginning_With_W()) {
                if (this.m_encodeVowels) {
                    this.MetaphAddExactApprox("A", "VA", "A", "FA");
                } else {
                    this.MetaphAddExactApprox("A", "V", "A", "F");
                }
            } else {
                this.MetaphAdd("A");
            }
            ++this.m_current;
            this.m_current = this.SkipVowels(this.m_current);
            return true;
        }
        return false;
    }

    boolean Encode_WH() {
        if (this.StringAt(this.m_current, 2, "WH", "")) {
            if (!(this.CharAt(this.m_current + 2) != 'O' || this.StringAt(this.m_current + 2, 4, "OOSH", "") || this.StringAt(this.m_current + 2, 3, "OOP", "OMP", "ORL", "ORT", "") || this.StringAt(this.m_current + 2, 2, "OA", "OP", ""))) {
                this.MetaphAdd("H");
                this.AdvanceCounter(3, 2);
                return true;
            }
            if (this.StringAt(this.m_current + 2, 3, "IDE", "ARD", "EAD", "AWK", "ERD", "OOK", "AND", "OLE", "OOD", "") || this.StringAt(this.m_current + 2, 4, "EART", "OUSE", "OUND", "") || this.StringAt(this.m_current + 2, 5, "AMMER", "")) {
                this.MetaphAdd("H");
                this.m_current += 2;
                return true;
            }
            if (this.m_current == 0) {
                this.MetaphAdd("A");
                this.m_current += 2;
                this.m_current = this.SkipVowels(this.m_current);
                return true;
            }
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_Eastern_European_W() {
        if (this.m_current == this.m_last && this.IsVowel(this.m_current - 1) || this.StringAt(this.m_current - 1, 5, "EWSKI", "EWSKY", "OWSKI", "OWSKY", "") || this.StringAt(this.m_current, 5, "WICKI", "WACKI", "") && this.m_current + 4 == this.m_last || this.StringAt(this.m_current, 4, "WIAK", "") && this.m_current + 3 == this.m_last || this.StringAt(0, 3, "SCH", "")) {
            this.MetaphAddExactApprox("", "V", "", "F");
            ++this.m_current;
            return true;
        }
        return false;
    }

    void Encode_X() {
        if (this.Encode_Initial_X() || this.Encode_Greek_X() || this.Encode_X_Special_Cases() || this.Encode_X_To_H() || this.Encode_X_Vowel() || this.Encode_French_X_Final()) {
            return;
        }
        this.m_current = this.StringAt(this.m_current + 1, 1, "X", "Z", "S", "") || this.StringAt(this.m_current + 1, 2, "CI", "CE", "") ? (this.m_current += 2) : ++this.m_current;
    }

    boolean Encode_Initial_X() {
        if (this.StringAt(0, 3, "XIA", "XIO", "XIE", "") || this.StringAt(0, 2, "XU", "")) {
            this.MetaphAdd("X");
            ++this.m_current;
            return true;
        }
        if (this.m_current == 0) {
            this.MetaphAdd("S");
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_Greek_X() {
        if (this.StringAt(this.m_current + 1, 3, "YLO", "YLE", "ENO", "") || this.StringAt(this.m_current + 1, 4, "ANTH", "")) {
            this.MetaphAdd("S");
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_X_Special_Cases() {
        if (this.StringAt(this.m_current - 2, 5, "LUXUR", "")) {
            this.MetaphAddExactApprox("GJ", "KJ");
            ++this.m_current;
            return true;
        }
        if (this.StringAt(0, 7, "TEXEIRA", "") || this.StringAt(0, 8, "TEIXEIRA", "")) {
            this.MetaphAdd("X");
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_X_To_H() {
        if (this.StringAt(this.m_current - 2, 6, "OAXACA", "") || this.StringAt(this.m_current - 3, 7, "QUIXOTE", "")) {
            this.MetaphAdd("H");
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_X_Vowel() {
        if (this.StringAt(this.m_current + 1, 3, "UAL", "ION", "IOU", "")) {
            this.MetaphAdd("KX", "KS");
            this.AdvanceCounter(3, 1);
            return true;
        }
        return false;
    }

    boolean Encode_French_X_Final() {
        if (this.m_current != this.m_last || !this.StringAt(this.m_current - 3, 3, "IAU", "EAU", "IEU", "") && !this.StringAt(this.m_current - 2, 2, "AI", "AU", "OU", "OI", "EU", "")) {
            this.MetaphAdd("KS");
        }
        return false;
    }

    void Encode_Z() {
        if (this.Encode_ZZ() || this.Encode_ZU_ZIER_ZS() || this.Encode_French_EZ() || this.Encode_German_Z()) {
            return;
        }
        if (this.Encode_ZH()) {
            return;
        }
        this.MetaphAdd("S");
        this.m_current = this.CharAt(this.m_current + 1) == 'Z' ? (this.m_current += 2) : ++this.m_current;
    }

    boolean Encode_ZZ() {
        if (this.CharAt(this.m_current + 1) == 'Z' && (this.StringAt(this.m_current + 2, 1, "I", "O", "A", "") && this.m_current + 2 == this.m_last || this.StringAt(this.m_current - 2, 9, "MOZZARELL", "PIZZICATO", "PUZZONLAN", ""))) {
            this.MetaphAdd("TS", "S");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Encode_ZU_ZIER_ZS() {
        if (this.m_current == 1 && this.StringAt(this.m_current - 1, 4, "AZUR", "") || this.StringAt(this.m_current, 4, "ZIER", "") && !this.StringAt(this.m_current - 2, 6, "VIZIER", "") || this.StringAt(this.m_current, 3, "ZSA", "")) {
            this.MetaphAdd("J", "S");
            this.m_current = this.StringAt(this.m_current, 3, "ZSA", "") ? (this.m_current += 2) : ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_French_EZ() {
        if (this.m_current == 3 && this.StringAt(this.m_current - 3, 4, "CHEZ", "") || this.StringAt(this.m_current - 5, 6, "RENDEZ", "")) {
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_German_Z() {
        if (this.m_current == 2 && this.m_current + 1 == this.m_last && this.StringAt(this.m_current - 2, 4, "NAZI", "") || this.StringAt(this.m_current - 2, 6, "NAZIFY", "MOZART", "") || this.StringAt(this.m_current - 3, 4, "HOLZ", "HERZ", "MERZ", "FITZ", "") || this.StringAt(this.m_current - 3, 4, "GANZ", "") && !this.IsVowel(this.m_current + 1) || this.StringAt(this.m_current - 4, 5, "STOLZ", "PRINZ", "") || this.StringAt(this.m_current - 4, 7, "VENEZIA", "") || this.StringAt(this.m_current - 3, 6, "HERZOG", "") || this.m_inWord.contains("SCH") && !this.StringAt(this.m_last - 2, 3, "IZE", "OZE", "ZEL", "") || this.m_current > 0 && this.StringAt(this.m_current, 4, "ZEIT", "") || this.StringAt(this.m_current - 3, 4, "WEIZ", "")) {
            if (this.m_current > 0 && this.m_inWord.charAt(this.m_current - 1) == 'T') {
                this.MetaphAdd("S");
            } else {
                this.MetaphAdd("TS");
            }
            ++this.m_current;
            return true;
        }
        return false;
    }

    boolean Encode_ZH() {
        if (this.CharAt(this.m_current + 1) == 'H') {
            this.MetaphAdd("J");
            this.m_current += 2;
            return true;
        }
        return false;
    }

    boolean Names_Beginning_With_SW_That_Get_Alt_SV() {
        return this.StringAt(0, 7, "SWANSON", "SWENSON", "SWINSON", "SWENSEN", "SWOBODA", "") || this.StringAt(0, 9, "SWIDERSKI", "SWARTHOUT", "") || this.StringAt(0, 10, "SWEARENGIN", "");
    }

    boolean Names_Beginning_With_SW_That_Get_Alt_XV() {
        return this.StringAt(0, 5, "SWART", "") || this.StringAt(0, 6, "SWARTZ", "SWARTS", "SWIGER", "") || this.StringAt(0, 7, "SWITZER", "SWANGER", "SWIGERT", "SWIGART", "SWIHART", "") || this.StringAt(0, 8, "SWEITZER", "SWATZELL", "SWINDLER", "") || this.StringAt(0, 9, "SWINEHART", "") || this.StringAt(0, 10, "SWEARINGEN", "");
    }

    boolean Germanic_Or_Slavic_Name_Beginning_With_W() {
        return this.StringAt(0, 3, "WEE", "WIX", "WAX", "") || this.StringAt(0, 4, "WOLF", "WEIS", "WAHL", "WALZ", "WEIL", "WERT", "WINE", "WILK", "WALT", "WOLL", "WADA", "WULF", "WEHR", "WURM", "WYSE", "WENZ", "WIRT", "WOLK", "WEIN", "WYSS", "WASS", "WANN", "WINT", "WINK", "WILE", "WIKE", "WIER", "WELK", "WISE", "") || this.StringAt(0, 5, "WIRTH", "WIESE", "WITTE", "WENTZ", "WOLFF", "WENDT", "WERTZ", "WILKE", "WALTZ", "WEISE", "WOOLF", "WERTH", "WEESE", "WURTH", "WINES", "WARGO", "WIMER", "WISER", "WAGER", "WILLE", "WILDS", "WAGAR", "WERTS", "WITTY", "WIENS", "WIEBE", "WIRTZ", "WYMER", "WULFF", "WIBLE", "WINER", "WIEST", "WALKO", "WALLA", "WEBRE", "WEYER", "WYBLE", "WOMAC", "WILTZ", "WURST", "WOLAK", "WELKE", "WEDEL", "WEIST", "WYGAN", "WUEST", "WEISZ", "WALCK", "WEITZ", "WYDRA", "WANDA", "WILMA", "WEBER", "") || this.StringAt(0, 6, "WETZEL", "WEINER", "WENZEL", "WESTER", "WALLEN", "WENGER", "WALLIN", "WEILER", "WIMMER", "WEIMER", "WYRICK", "WEGNER", "WINNER", "WESSEL", "WILKIE", "WEIGEL", "WOJCIK", "WENDEL", "WITTER", "WIENER", "WEISER", "WEXLER", "WACKER", "WISNER", "WITMER", "WINKLE", "WELTER", "WIDMER", "WITTEN", "WINDLE", "WASHER", "WOLTER", "WILKEY", "WIDNER", "WARMAN", "WEYANT", "WEIBEL", "WANNER", "WILKEN", "WILTSE", "WARNKE", "WALSER", "WEIKEL", "WESNER", "WITZEL", "WROBEL", "WAGNON", "WINANS", "WENNER", "WOLKEN", "WILNER", "WYSONG", "WYCOFF", "WUNDER", "WINKEL", "WIDMAN", "WELSCH", "WEHNER", "WEIGLE", "WETTER", "WUNSCH", "WHITTY", "WAXMAN", "WILKER", "WILHAM", "WITTIG", "WITMAN", "WESTRA", "WEHRLE", "WASSER", "WILLER", "WEGMAN", "WARFEL", "WYNTER", "WERNER", "WAGNER", "WISSER", "") || this.StringAt(0, 7, "WISEMAN", "WINKLER", "WILHELM", "WELLMAN", "WAMPLER", "WACHTER", "WALTHER", "WYCKOFF", "WEIDNER", "WOZNIAK", "WEILAND", "WILFONG", "WIEGAND", "WILCHER", "WIELAND", "WILDMAN", "WALDMAN", "WORTMAN", "WYSOCKI", "WEIDMAN", "WITTMAN", "WIDENER", "WOLFSON", "WENDELL", "WEITZEL", "WILLMAN", "WALDRUP", "WALTMAN", "WALCZAK", "WEIGAND", "WESSELS", "WIDEMAN", "WOLTERS", "WIREMAN", "WILHOIT", "WEGENER", "WOTRING", "WINGERT", "WIESNER", "WAYMIRE", "WHETZEL", "WENTZEL", "WINEGAR", "WESTMAN", "WYNKOOP", "WALLICK", "WURSTER", "WINBUSH", "WILBERT", "WALLACH", "WYNKOOP", "WALLICK", "WURSTER", "WINBUSH", "WILBERT", "WALLACH", "WEISSER", "WEISNER", "WINDERS", "WILLMON", "WILLEMS", "WIERSMA", "WACHTEL", "WARNICK", "WEIDLER", "WALTRIP", "WHETSEL", "WHELESS", "WELCHER", "WALBORN", "WILLSEY", "WEINMAN", "WAGAMAN", "WOMMACK", "WINGLER", "WINKLES", "WIEDMAN", "WHITNER", "WOLFRAM", "WARLICK", "WEEDMAN", "WHISMAN", "WINLAND", "WEESNER", "WARTHEN", "WETZLER", "WENDLER", "WALLNER", "WOLBERT", "WITTMER", "WISHART", "WILLIAM", "") || this.StringAt(0, 8, "WESTPHAL", "WICKLUND", "WEISSMAN", "WESTLUND", "WOLFGANG", "WILLHITE", "WEISBERG", "WALRAVEN", "WOLFGRAM", "WILHOITE", "WECHSLER", "WENDLING", "WESTBERG", "WENDLAND", "WININGER", "WHISNANT", "WESTRICK", "WESTLING", "WESTBURY", "WEITZMAN", "WEHMEYER", "WEINMANN", "WISNESKI", "WHELCHEL", "WEISHAAR", "WAGGENER", "WALDROUP", "WESTHOFF", "WIEDEMAN", "WASINGER", "WINBORNE", "") || this.StringAt(0, 9, "WHISENANT", "WEINSTEIN", "WESTERMAN", "WASSERMAN", "WITKOWSKI", "WEINTRAUB", "WINKELMAN", "WINKFIELD", "WANAMAKER", "WIECZOREK", "WIECHMANN", "WOJTOWICZ", "WALKOWIAK", "WEINSTOCK", "WILLEFORD", "WARKENTIN", "WEISINGER", "WINKLEMAN", "WILHEMINA", "") || this.StringAt(0, 10, "WISNIEWSKI", "WUNDERLICH", "WHISENHUNT", "WEINBERGER", "WROBLEWSKI", "WAGUESPACK", "WEISGERBER", "WESTERVELT", "WESTERLUND", "WASILEWSKI", "WILDERMUTH", "WESTENDORF", "WESOLOWSKI", "WEINGARTEN", "WINEBARGER", "WESTERBERG", "WANNAMAKER", "WEISSINGER", "") || this.StringAt(0, 11, "WALDSCHMIDT", "WEINGARTNER", "WINEBRENNER", "") || this.StringAt(0, 12, "WOLFENBARGER", "") || this.StringAt(0, 13, "WOJCIECHOWSKI", "");
    }

    boolean Names_Beginning_With_J_That_Get_Alt_Y() {
        return this.StringAt(0, 3, "JAN", "JON", "JAN", "JIN", "JEN", "") || this.StringAt(0, 4, "JUHL", "JULY", "JOEL", "JOHN", "JOSH", "JUDE", "JUNE", "JONI", "JULI", "JENA", "JUNG", "JINA", "JANA", "JENI", "JOEL", "JANN", "JONA", "JENE", "JULE", "JANI", "JONG", "JOHN", "JEAN", "JUNG", "JONE", "JARA", "JUST", "JOST", "JAHN", "JACO", "JANG", "JUDE", "JONE", "") || this.StringAt(0, 5, "JOANN", "JANEY", "JANAE", "JOANA", "JUTTA", "JULEE", "JANAY", "JANEE", "JETTA", "JOHNA", "JOANE", "JAYNA", "JANES", "JONAS", "JONIE", "JUSTA", "JUNIE", "JUNKO", "JENAE", "JULIO", "JINNY", "JOHNS", "JACOB", "JETER", "JAFFE", "JESKE", "JANKE", "JAGER", "JANIK", "JANDA", "JOSHI", "JULES", "JANTZ", "JEANS", "JUDAH", "JANUS", "JENNY", "JENEE", "JONAH", "JONAS", "JACOB", "JOSUE", "JOSEF", "JULES", "JULIE", "JULIA", "JANIE", "JANIS", "JENNA", "JANNA", "JEANA", "JENNI", "JEANE", "JONNA", "") || this.StringAt(0, 6, "JORDAN", "JORDON", "JOSEPH", "JOSHUA", "JOSIAH", "JOSPEH", "JUDSON", "JULIAN", "JULIUS", "JUNIOR", "JUDITH", "JOESPH", "JOHNIE", "JOANNE", "JEANNE", "JOANNA", "JOSEFA", "JULIET", "JANNIE", "JANELL", "JASMIN", "JANINE", "JOHNNY", "JEANIE", "JEANNA", "JOHNNA", "JOELLE", "JOVITA", "JOSEPH", "JONNIE", "JANEEN", "JANINA", "JOANIE", "JAZMIN", "JOHNIE", "JANENE", "JOHNNY", "JONELL", "JENELL", "JANETT", "JANETH", "JENINE", "JOELLA", "JOEANN", "JULIAN", "JOHANA", "JENICE", "JANNET", "JANISE", "JULENE", "JOSHUA", "JANEAN", "JAIMEE", "JOETTE", "JANYCE", "JENEVA", "JORDAN", "JACOBS", "JENSEN", "JOSEPH", "JANSEN", "JORDON", "JULIAN", "JAEGER", "JACOBY", "JENSON", "JARMAN", "JOSLIN", "JESSEN", "JAHNKE", "JACOBO", "JULIEN", "JOSHUA", "JEPSON", "JULIUS", "JANSON", "JACOBI", "JUDSON", "JARBOE", "JOHSON", "JANZEN", "JETTON", "JUNKER", "JONSON", "JAROSZ", "JENNER", "JAGGER", "JASMIN", "JEPSEN", "JORDEN", "JANNEY", "JUHASZ", "JERGEN", "JAKOB", "") || this.StringAt(0, 7, "JOHNSON", "JOHNNIE", "JASMINE", "JEANNIE", "JOHANNA", "JANELLE", "JANETTE", "JULIANA", "JUSTINA", "JOSETTE", "JOELLEN", "JENELLE", "JULIETA", "JULIANN", "JULISSA", "JENETTE", "JANETTA", "JOSELYN", "JONELLE", "JESENIA", "JANESSA", "JAZMINE", "JEANENE", "JOANNIE", "JADWIGA", "JOLANDA", "JULIANE", "JANUARY", "JEANICE", "JANELLA", "JEANETT", "JENNINE", "JOHANNE", "JOHNSIE", "JANIECE", "JOHNSON", "JENNELL", "JAMISON", "JANSSEN", "JOHNSEN", "JARDINE", "JAGGERS", "JURGENS", "JOURDAN", "JULIANO", "JOSEPHS", "JHONSON", "JOZWIAK", "JANICKI", "JELINEK", "JANSSON", "JOACHIM", "JANELLE", "JACOBUS", "JENNING", "JANTZEN", "JOHNNIE", "") || this.StringAt(0, 8, "JOSEFINA", "JEANNINE", "JULIANNE", "JULIANNA", "JONATHAN", "JONATHON", "JEANETTE", "JANNETTE", "JEANETTA", "JOHNETTA", "JENNEFER", "JULIENNE", "JOSPHINE", "JEANELLE", "JOHNETTE", "JULIEANN", "JOSEFINE", "JULIETTA", "JOHNSTON", "JACOBSON", "JACOBSEN", "JOHANSEN", "JOHANSON", "JAWORSKI", "JENNETTE", "JELLISON", "JOHANNES", "JASINSKI", "JUERGENS", "JARNAGIN", "JEREMIAH", "JEPPESEN", "JARNIGAN", "JANOUSEK", "") || this.StringAt(0, 9, "JOHNATHAN", "JOHNATHON", "JORGENSEN", "JEANMARIE", "JOSEPHINA", "JEANNETTE", "JOSEPHINE", "JEANNETTA", "JORGENSON", "JANKOWSKI", "JOHNSTONE", "JABLONSKI", "JOSEPHSON", "JOHANNSEN", "JURGENSEN", "JIMMERSON", "JOHANSSON", "") || this.StringAt(0, 10, "JAKUBOWSKI", "");
    }
}

