/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.ml.features;

import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ide.actions.searcheverywhere.ml.features.FeaturesProviderCache;
import com.intellij.ide.actions.searcheverywhere.ml.features.SearchEverywhereElementFeaturesProvider;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0004H\u0016J\u001a\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereVcsFileFeaturesProvider;", "Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereElementFeaturesProvider;", "()V", "getElementFeatures", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "element", "", "currentTime", "", "searchQuery", "", "elementPriority", "", "cache", "Lcom/intellij/ide/actions/searcheverywhere/ml/features/FeaturesProviderCache;", "getFeaturesDeclarations", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getFileFeatures", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "Companion", "intellij.searchEverywhereMl"})
public final class SearchEverywhereVcsFileFeaturesProvider
extends SearchEverywhereElementFeaturesProvider {
    @NotNull
    private static final BooleanEventField IS_IGNORED_DATA_KEY;
    @NotNull
    private static final BooleanEventField IS_CHANGED_DATA_KEY;
    @NotNull
    private static final StringEventField FILE_STATUS_DATA_KEY;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public List<EventField<?>> getFeaturesDeclarations() {
        return CollectionsKt.listOf((Object[])new PrimitiveEventField[]{(PrimitiveEventField)IS_IGNORED_DATA_KEY, (PrimitiveEventField)IS_CHANGED_DATA_KEY, (PrimitiveEventField)FILE_STATUS_DATA_KEY});
    }

    @Override
    @NotNull
    public List<EventPair<?>> getElementFeatures(@NotNull Object element, long currentTime, @NotNull String searchQuery, int elementPriority, @Nullable FeaturesProviderCache cache) {
        PsiFileSystemItem psiFileSystemItem;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Object object = element;
        if (object instanceof PSIPresentationBgRendererWrapper.PsiItemWithPresentation) {
            PsiElement psiElement = ((PSIPresentationBgRendererWrapper.PsiItemWithPresentation)element).getItem();
            if (!(psiElement instanceof PsiFileSystemItem)) {
                psiElement = null;
            }
            if ((psiFileSystemItem = (PsiFileSystemItem)psiElement) == null) {
                return CollectionsKt.emptyList();
            }
        } else if (object instanceof PsiFileSystemItem) {
            psiFileSystemItem = (PsiFileSystemItem)element;
        } else {
            return CollectionsKt.emptyList();
        }
        PsiFileSystemItem item = psiFileSystemItem;
        return this.getFileFeatures(item);
    }

    private final List<EventPair<?>> getFileFeatures(PsiFileSystemItem item) {
        if (item.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)item.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(item.project)");
        ChangeListManager changeListManager2 = changeListManager;
        Object[] objectArray = new EventPair[3];
        objectArray[0] = IS_CHANGED_DATA_KEY.with((Object)changeListManager2.isFileAffected(item.getVirtualFile()));
        objectArray[1] = IS_IGNORED_DATA_KEY.with((Object)changeListManager2.isIgnoredFile(item.getVirtualFile()));
        FileStatus fileStatus = changeListManager2.getStatus(item.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"changeListManager.getStatus(item.virtualFile)");
        objectArray[2] = FILE_STATUS_DATA_KEY.with((Object)fileStatus.getId());
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    public SearchEverywhereVcsFileFeaturesProvider() {
        super(FileSearchEverywhereContributor.class);
    }

    static {
        Companion = new Companion(null);
        IS_IGNORED_DATA_KEY = EventFields.Boolean((String)"isIgnored");
        IS_CHANGED_DATA_KEY = EventFields.Boolean((String)"isChanged");
        FILE_STATUS_DATA_KEY = EventFields.String((String)"fileStatus", (List)CollectionsKt.listOf((Object[])new String[]{"NOT_CHANGED", "NOT_CHANGED_IMMEDIATE", "NOT_CHANGED_RECURSIVE", "DELETED", "MODIFIED", "ADDED", "MERGED", "UNKNOWN", "IDEA_FILESTATUS_IGNORED", "HIJACKED", "IDEA_FILESTATUS_MERGED_WITH_CONFLICTS", "IDEA_FILESTATUS_MERGED_WITH_BOTH_CONFLICTS", "IDEA_FILESTATUS_MERGED_WITH_PROPERTY_CONFLICTS", "IDEA_FILESTATUS_DELETED_FROM_FILE_SYSTEM", "SWITCHED", "OBSOLETE", "SUPPRESSED"}));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereVcsFileFeaturesProvider$Companion;", "", "()V", "FILE_STATUS_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getFILE_STATUS_DATA_KEY$intellij_searchEverywhereMl", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "IS_CHANGED_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getIS_CHANGED_DATA_KEY$intellij_searchEverywhereMl", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "IS_IGNORED_DATA_KEY", "getIS_IGNORED_DATA_KEY$intellij_searchEverywhereMl", "intellij.searchEverywhereMl"})
    public static final class Companion {
        @NotNull
        public final BooleanEventField getIS_IGNORED_DATA_KEY$intellij_searchEverywhereMl() {
            return IS_IGNORED_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_CHANGED_DATA_KEY$intellij_searchEverywhereMl() {
            return IS_CHANGED_DATA_KEY;
        }

        @NotNull
        public final StringEventField getFILE_STATUS_DATA_KEY$intellij_searchEverywhereMl() {
            return FILE_STATUS_DATA_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

