/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.ml.features;

import com.intellij.filePrediction.features.history.FileHistoryManagerWrapper;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.actions.searcheverywhere.ml.features.FeaturesProviderCache;
import com.intellij.ide.actions.searcheverywhere.ml.features.SearchEverywhereElementFeaturesProvider;
import com.intellij.ide.actions.searcheverywhere.ml.features.SearchEverywherePsiElementFeaturesProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.DoubleEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0004H\u0016J\"\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereFileFeaturesProvider;", "Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereElementFeaturesProvider;", "()V", "getElementFeatures", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "element", "", "currentTime", "", "searchQuery", "", "elementPriority", "", "cache", "Lcom/intellij/ide/actions/searcheverywhere/ml/features/FeaturesProviderCache;", "getFeaturesDeclarations", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getModificationTimeStats", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "getPredictionScore", "", "getRecentFilesIndex", "isFavorite", "", "isOpened", "isTopLevel", "(Lcom/intellij/psi/PsiFileSystemItem;)Ljava/lang/Boolean;", "matchesFileTypeInQuery", "(Lcom/intellij/psi/PsiFileSystemItem;Ljava/lang/String;)Ljava/lang/Boolean;", "Companion", "intellij.searchEverywhereMl"})
@ApiStatus.Internal
public final class SearchEverywhereFileFeaturesProvider
extends SearchEverywhereElementFeaturesProvider {
    @NotNull
    private static final StringEventField FILETYPE_DATA_KEY;
    @NotNull
    private static final BooleanEventField IS_FAVORITE_DATA_KEY;
    @NotNull
    private static final BooleanEventField IS_OPENED_DATA_KEY;
    @NotNull
    private static final BooleanEventField IS_DIRECTORY_DATA_KEY;
    @NotNull
    private static final IntEventField RECENT_INDEX_DATA_KEY;
    @NotNull
    private static final DoubleEventField PREDICTION_SCORE_DATA_KEY;
    @NotNull
    private static final BooleanEventField IS_EXACT_MATCH_DATA_KEY;
    @NotNull
    private static final BooleanEventField FILETYPE_MATCHES_QUERY_DATA_KEY;
    @NotNull
    private static final BooleanEventField IS_TOP_LEVEL_DATA_KEY;
    @NotNull
    private static final LongEventField TIME_SINCE_LAST_MODIFICATION_DATA_KEY;
    @NotNull
    private static final BooleanEventField WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY;
    @NotNull
    private static final BooleanEventField WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY;
    @NotNull
    private static final BooleanEventField WAS_MODIFIED_IN_LAST_DAY_DATA_KEY;
    @NotNull
    private static final BooleanEventField WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public List<EventField<?>> getFeaturesDeclarations() {
        return CollectionsKt.arrayListOf((Object[])new EventField[]{(EventField)IS_DIRECTORY_DATA_KEY, (EventField)FILETYPE_DATA_KEY, (EventField)IS_FAVORITE_DATA_KEY, (EventField)IS_OPENED_DATA_KEY, (EventField)RECENT_INDEX_DATA_KEY, (EventField)PREDICTION_SCORE_DATA_KEY, (EventField)IS_EXACT_MATCH_DATA_KEY, (EventField)FILETYPE_MATCHES_QUERY_DATA_KEY, (EventField)TIME_SINCE_LAST_MODIFICATION_DATA_KEY, (EventField)WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY, (EventField)WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY, (EventField)WAS_MODIFIED_IN_LAST_DAY_DATA_KEY, (EventField)WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY, (EventField)IS_TOP_LEVEL_DATA_KEY});
    }

    @Override
    @NotNull
    public List<EventPair<?>> getElementFeatures(@NotNull Object element, long currentTime, @NotNull String searchQuery, int elementPriority, @Nullable FeaturesProviderCache cache) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        PsiElement psiElement = SearchEverywherePsiElementFeaturesProvider.Companion.getPsiElement(element);
        if (!(psiElement instanceof PsiFileSystemItem)) {
            psiElement = null;
        }
        PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)psiElement;
        if (psiFileSystemItem == null) {
            return CollectionsKt.emptyList();
        }
        PsiFileSystemItem item = psiFileSystemItem;
        ArrayList data = CollectionsKt.arrayListOf((Object[])new EventPair[]{IS_FAVORITE_DATA_KEY.with((Object)this.isFavorite(item)), IS_DIRECTORY_DATA_KEY.with((Object)item.isDirectory()), IS_EXACT_MATCH_DATA_KEY.with((Object)(elementPriority == 5000 ? 1 : 0))});
        this.putIfValueNotNull(data, (EventField)IS_TOP_LEVEL_DATA_KEY, this.isTopLevel(item));
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        String string = virtualFile.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.virtualFile.nameWithoutExtension");
        String nameOfItem = string;
        String string2 = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)searchQuery));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.getNameWithoutE\u2026getFileName(searchQuery))");
        String fileNameFromQuery = string2;
        data.addAll(this.getNameMatchingFeatures(nameOfItem, fileNameFromQuery));
        if (item.isDirectory()) {
            return data;
        }
        data.add(IS_OPENED_DATA_KEY.with((Object)this.isOpened(item)));
        VirtualFile virtualFile2 = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"item.virtualFile");
        FileType fileType = virtualFile2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"item.virtualFile.fileType");
        data.add(FILETYPE_DATA_KEY.with((Object)fileType.getName()));
        this.putIfValueNotNull(data, (EventField)FILETYPE_MATCHES_QUERY_DATA_KEY, this.matchesFileTypeInQuery(item, searchQuery));
        data.add(RECENT_INDEX_DATA_KEY.with((Object)this.getRecentFilesIndex(item)));
        data.add(PREDICTION_SCORE_DATA_KEY.with((Object)this.getPredictionScore(item)));
        data.addAll((Collection)this.getModificationTimeStats(item, currentTime));
        return data;
    }

    private final boolean isFavorite(PsiFileSystemItem item) {
        FavoritesManager favoritesManager = FavoritesManager.getInstance((Project)item.getProject());
        Object object = ReadAction.compute((ThrowableComputable)new ThrowableComputable(favoritesManager, item){
            final /* synthetic */ FavoritesManager $favoritesManager;
            final /* synthetic */ PsiFileSystemItem $item;

            public final Boolean compute() {
                return this.$favoritesManager.getFavoriteListName(null, this.$item.getVirtualFile()) != null;
            }
            {
                this.$favoritesManager = favoritesManager;
                this.$item = psiFileSystemItem;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.compute<Boole\u2026em.virtualFile) != null }");
        return (Boolean)object;
    }

    private final Boolean isTopLevel(PsiFileSystemItem item) {
        Project project2 = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"item.project");
        Object object = ProjectUtil.guessProjectDir((Project)project2);
        if (object == null || (object = object.getPath()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"item.project.guessProjec\u2026ir()?.path ?: return null");
        Object basePath = object;
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        Object object2 = virtualFile.getParent();
        if (object2 == null || (object2 = object2.getPath()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"item.virtualFile.parent?.path ?: return null");
        Object fileDirectoryPath = object2;
        return Intrinsics.areEqual((Object)fileDirectoryPath, (Object)basePath);
    }

    private final boolean isOpened(PsiFileSystemItem item) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)item.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(item.project)");
        Object[] openedFiles = fileEditorManager.getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)openedFiles, (String)"openedFiles");
        return ArraysKt.contains((Object[])openedFiles, (Object)item.getVirtualFile());
    }

    private final Boolean matchesFileTypeInQuery(PsiFileSystemItem item, String searchQuery) {
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        String fileExtension = virtualFile.getExtension();
        String extensionInQuery = StringsKt.substringAfterLast((String)searchQuery, (char)'.', (String)"");
        CharSequence charSequence = extensionInQuery;
        if (charSequence.length() == 0 || fileExtension == null) {
            return null;
        }
        return Intrinsics.areEqual((Object)extensionInQuery, (Object)fileExtension);
    }

    private final int getRecentFilesIndex(PsiFileSystemItem item) {
        EditorHistoryManager historyManager;
        EditorHistoryManager editorHistoryManager = historyManager = EditorHistoryManager.getInstance((Project)item.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)editorHistoryManager, (String)"historyManager");
        List list = editorHistoryManager.getFileList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"historyManager.fileList");
        List recentFilesList = list;
        int fileIndex = recentFilesList.indexOf(item.getVirtualFile());
        if (fileIndex == -1) {
            return fileIndex;
        }
        return recentFilesList.size() - fileIndex;
    }

    private final List<EventPair<?>> getModificationTimeStats(PsiFileSystemItem item, long currentTime) {
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        long timeSinceLastMod = currentTime - virtualFile.getTimeStamp();
        return CollectionsKt.arrayListOf((Object[])new EventPair[]{TIME_SINCE_LAST_MODIFICATION_DATA_KEY.with((Object)timeSinceLastMod), WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY.with((Object)(timeSinceLastMod <= (long)60000 ? 1 : 0)), WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY.with((Object)(timeSinceLastMod <= (long)3600000 ? 1 : 0)), WAS_MODIFIED_IN_LAST_DAY_DATA_KEY.with((Object)(timeSinceLastMod <= (long)86400000 ? 1 : 0)), WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY.with((Object)(timeSinceLastMod <= 2419200000L ? 1 : 0))});
    }

    private final double getPredictionScore(PsiFileSystemItem item) {
        Project project2 = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"item.project");
        FileHistoryManagerWrapper historyManagerWrapper = FileHistoryManagerWrapper.Companion.getInstance(project2);
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        double probability = historyManagerWrapper.calcNextFileProbability(virtualFile);
        return SearchEverywhereElementFeaturesProvider.Companion.roundDouble$intellij_searchEverywhereMl(probability);
    }

    public SearchEverywhereFileFeaturesProvider() {
        super(FileSearchEverywhereContributor.class, RecentFilesSEContributor.class);
    }

    static {
        Companion = new Companion(null);
        FILETYPE_DATA_KEY = EventFields.StringValidatedByCustomRule((String)"fileType", (String)"file_type");
        IS_FAVORITE_DATA_KEY = EventFields.Boolean((String)"isFavorite");
        IS_OPENED_DATA_KEY = EventFields.Boolean((String)"isOpened");
        IS_DIRECTORY_DATA_KEY = EventFields.Boolean((String)"isDirectory");
        RECENT_INDEX_DATA_KEY = EventFields.Int((String)"recentFilesIndex");
        PREDICTION_SCORE_DATA_KEY = EventFields.Double((String)"predictionScore");
        IS_EXACT_MATCH_DATA_KEY = EventFields.Boolean((String)"isExactMatch");
        FILETYPE_MATCHES_QUERY_DATA_KEY = EventFields.Boolean((String)"fileTypeMatchesQuery");
        IS_TOP_LEVEL_DATA_KEY = EventFields.Boolean((String)"isTopLevel");
        TIME_SINCE_LAST_MODIFICATION_DATA_KEY = EventFields.Long((String)"timeSinceLastModification");
        WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY = EventFields.Boolean((String)"wasModifiedInLastMinute");
        WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY = EventFields.Boolean((String)"wasModifiedInLastHour");
        WAS_MODIFIED_IN_LAST_DAY_DATA_KEY = EventFields.Boolean((String)"wasModifiedInLastDay");
        WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY = EventFields.Boolean((String)"wasModifiedInLastMonth");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\nR\u0014\u0010#\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\nR\u0014\u0010%\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\nR\u0014\u0010'\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\n\u00a8\u0006)"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereFileFeaturesProvider$Companion;", "", "()V", "FILETYPE_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getFILETYPE_DATA_KEY", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "FILETYPE_MATCHES_QUERY_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getFILETYPE_MATCHES_QUERY_DATA_KEY$intellij_searchEverywhereMl", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "IS_DIRECTORY_DATA_KEY", "getIS_DIRECTORY_DATA_KEY$intellij_searchEverywhereMl", "IS_EXACT_MATCH_DATA_KEY", "getIS_EXACT_MATCH_DATA_KEY$intellij_searchEverywhereMl", "IS_FAVORITE_DATA_KEY", "getIS_FAVORITE_DATA_KEY", "IS_OPENED_DATA_KEY", "getIS_OPENED_DATA_KEY", "IS_TOP_LEVEL_DATA_KEY", "getIS_TOP_LEVEL_DATA_KEY$intellij_searchEverywhereMl", "PREDICTION_SCORE_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/DoubleEventField;", "getPREDICTION_SCORE_DATA_KEY$intellij_searchEverywhereMl", "()Lcom/intellij/internal/statistic/eventLog/events/DoubleEventField;", "RECENT_INDEX_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getRECENT_INDEX_DATA_KEY$intellij_searchEverywhereMl", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "TIME_SINCE_LAST_MODIFICATION_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "getTIME_SINCE_LAST_MODIFICATION_DATA_KEY$intellij_searchEverywhereMl", "()Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "WAS_MODIFIED_IN_LAST_DAY_DATA_KEY", "getWAS_MODIFIED_IN_LAST_DAY_DATA_KEY$intellij_searchEverywhereMl", "WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY", "getWAS_MODIFIED_IN_LAST_HOUR_DATA_KEY$intellij_searchEverywhereMl", "WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY", "getWAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY$intellij_searchEverywhereMl", "WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY", "getWAS_MODIFIED_IN_LAST_MONTH_DATA_KEY$intellij_searchEverywhereMl", "intellij.searchEverywhereMl"})
    public static final class Companion {
        @NotNull
        public final StringEventField getFILETYPE_DATA_KEY() {
            return FILETYPE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_FAVORITE_DATA_KEY() {
            return IS_FAVORITE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_OPENED_DATA_KEY() {
            return IS_OPENED_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_DIRECTORY_DATA_KEY$intellij_searchEverywhereMl() {
            return IS_DIRECTORY_DATA_KEY;
        }

        @NotNull
        public final IntEventField getRECENT_INDEX_DATA_KEY$intellij_searchEverywhereMl() {
            return RECENT_INDEX_DATA_KEY;
        }

        @NotNull
        public final DoubleEventField getPREDICTION_SCORE_DATA_KEY$intellij_searchEverywhereMl() {
            return PREDICTION_SCORE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_EXACT_MATCH_DATA_KEY$intellij_searchEverywhereMl() {
            return IS_EXACT_MATCH_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getFILETYPE_MATCHES_QUERY_DATA_KEY$intellij_searchEverywhereMl() {
            return FILETYPE_MATCHES_QUERY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_TOP_LEVEL_DATA_KEY$intellij_searchEverywhereMl() {
            return IS_TOP_LEVEL_DATA_KEY;
        }

        @NotNull
        public final LongEventField getTIME_SINCE_LAST_MODIFICATION_DATA_KEY$intellij_searchEverywhereMl() {
            return TIME_SINCE_LAST_MODIFICATION_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getWAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY$intellij_searchEverywhereMl() {
            return WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getWAS_MODIFIED_IN_LAST_HOUR_DATA_KEY$intellij_searchEverywhereMl() {
            return WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getWAS_MODIFIED_IN_LAST_DAY_DATA_KEY$intellij_searchEverywhereMl() {
            return WAS_MODIFIED_IN_LAST_DAY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getWAS_MODIFIED_IN_LAST_MONTH_DATA_KEY$intellij_searchEverywhereMl() {
            return WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

