/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.ide.BrowserUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyCellUtil;
import com.jetbrains.python.PyCharmCommunityCustomizationBundle;
import com.jetbrains.python.PyCharmProfessionalAdvertiserSettings;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCharmProfessionalAdvertiser
implements Annotator {
    private static final NotificationGroup BALLOON_NOTIFICATIONS = new NotificationGroup("PyCharm Professional Advertiser", NotificationDisplayType.STICKY_BALLOON, false);

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(1);
        }
        Project project = element.getProject();
        if (PyCharmProfessionalAdvertiser.getSettings((Project)project).shown) {
            return;
        }
        if (element instanceof PyFile) {
            PyFile pyFile = (PyFile)element;
            VirtualFile vFile = pyFile.getVirtualFile();
            if (vFile != null && FileIndexFacade.getInstance((Project)project).isInLibraryClasses(vFile)) {
                return;
            }
            if (PyCellUtil.hasCells((PsiFile)pyFile)) {
                PyCharmProfessionalAdvertiser.showInspectionAdvertisement(project, PyCharmCommunityCustomizationBundle.message("pro.advertiser.notification.title.cells.in.editor", new Object[0]), "https://www.jetbrains.com/pycharm/features/scientific_tools.html", "codecells");
            }
            if (PyPsiUtils.containsImport((PyFile)pyFile, (String)"django")) {
                PyCharmProfessionalAdvertiser.showInspectionAdvertisement(project, PyCharmCommunityCustomizationBundle.message("pro.advertiser.notification.title.django.framework", new Object[0]), "https://www.jetbrains.com/pycharm/features/web_development.html#django", "django");
            }
            if (PyPsiUtils.containsImport((PyFile)pyFile, (String)"flask")) {
                PyCharmProfessionalAdvertiser.showInspectionAdvertisement(project, PyCharmCommunityCustomizationBundle.message("pro.advertiser.notification.title.flask.framework", new Object[0]), null, "flask");
            }
            if (PyPsiUtils.containsImport((PyFile)pyFile, (String)"pyramid")) {
                PyCharmProfessionalAdvertiser.showInspectionAdvertisement(project, PyCharmCommunityCustomizationBundle.message("pro.advertiser.notification.title.pyramid.framework", new Object[0]), null, "pyramid");
            }
        }
        if (PyCharmProfessionalAdvertiser.isJupyterFile(element)) {
            PyCharmProfessionalAdvertiser.showInspectionAdvertisement(element.getProject(), PyCharmCommunityCustomizationBundle.message("pro.advertiser.notification.title.jupyter.notebook", new Object[0]), "https://www.jetbrains.com/pycharm/features/scientific_tools.html", "jupyter");
        }
    }

    private static void showInspectionAdvertisement(@NotNull Project project, @NotNull @NlsContexts.NotificationTitle String message, @Nullable String url, @NotNull String source) {
        if (project == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(2);
        }
        if (message == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(3);
        }
        if (source == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(4);
        }
        PyCharmProfessionalAdvertiser.showSingletonNotification(project, message, PyCharmCommunityCustomizationBundle.message("pro.advertiser.notification.pycharm.pro.has.support.for.it", new Object[0]), (notification, event) -> {
            if ("prof".equals(event.getDescription())) {
                BrowserUtil.browse((String)((url != null ? url : "https://www.jetbrains.com/pycharm/features/editions_comparison_matrix.html") + "?utm_source=from_product&utm_medium=advertiser&utm_campaign=" + source));
            }
        });
    }

    private static boolean isJupyterFile(@NotNull PsiElement element) {
        if (element == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(5);
        }
        if (!(element instanceof PsiFile)) {
            return false;
        }
        VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
        return virtualFile != null && Objects.equals(virtualFile.getExtension(), "ipynb");
    }

    private static void showSingletonNotification(@NotNull Project project, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String htmlContent, @NotNull NotificationListener listener) {
        if (project == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(6);
        }
        if (title == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(7);
        }
        if (htmlContent == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(8);
        }
        if (listener == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(9);
        }
        PyCharmProfessionalAdvertiser.getSettings((Project)project).shown = true;
        BALLOON_NOTIFICATIONS.createNotification(title, htmlContent, NotificationType.INFORMATION).setListener((notification, event) -> {
            try {
                listener.hyperlinkUpdate(notification, event);
            }
            finally {
                notification.expire();
            }
        }).notify(project);
    }

    @NotNull
    private static PyCharmProfessionalAdvertiserSettings getSettings(@NotNull Project project) {
        if (project == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(10);
        }
        PyCharmProfessionalAdvertiserSettings pyCharmProfessionalAdvertiserSettings = (PyCharmProfessionalAdvertiserSettings)project.getService(PyCharmProfessionalAdvertiserSettings.class);
        if (pyCharmProfessionalAdvertiserSettings == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(11);
        }
        return pyCharmProfessionalAdvertiserSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PyCharmProfessionalAdvertiser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PyCharmProfessionalAdvertiser";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showInspectionAdvertisement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isJupyterFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showSingletonNotification";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

