/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitLocalBranch;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.reset.GitNewResetDialog;
import git4idea.reset.GitNewResetDialog$createCenterPanel$1$4;
import git4idea.reset.GitResetMode;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lgit4idea/reset/GitNewResetDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "commits", "", "Lgit4idea/repo/GitRepository;", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "defaultMode", "Lgit4idea/reset/GitResetMode;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;Lgit4idea/reset/GitResetMode;)V", "<set-?>", "resetMode", "getResetMode", "()Lgit4idea/reset/GitResetMode;", "createCenterPanel", "Ljavax/swing/JComponent;", "getHelpId", "", "Companion", "intellij.vcs.git"})
public final class GitNewResetDialog
extends DialogWrapper {
    @NotNull
    private GitResetMode resetMode;
    private final Project project;
    private final Map<GitRepository, VcsFullCommitDetails> commits;
    private static final String DIALOG_ID = "git.new.reset.dialog";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final GitResetMode getResetMode() {
        return this.resetMode;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ GitNewResetDialog this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Panel $this$panel) {
                void $this$bind$iv;
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$receiver");
                Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createCenterPanel.1 this$0;

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                        String string = XmlStringUtil.wrapInHtml((CharSequence)git4idea.reset.GitNewResetDialog$Companion.access$prepareDescription(GitNewResetDialog.Companion, GitNewResetDialog.access$getProject$p(this.this$0.this$0), GitNewResetDialog.access$getCommits$p(this.this$0.this$0)));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"XmlStringUtil.wrapInHtml\u2026iption(project, commits))");
                        $this$row.label(string);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)1, null);
                Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)createCenterPanel.2.INSTANCE, (int)1, null);
                ButtonsGroup buttonsGroup = Panel.DefaultImpls.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, (Function1)createCenterPanel.3.INSTANCE, (int)3, null);
                GitNewResetDialog$createCenterPanel$1$4 prop$iv = new GitNewResetDialog$createCenterPanel$1$4(this.this$0);
                boolean $i$f$bind = false;
                $this$bind$iv.bind(MutablePropertyKt.toMutableProperty((KMutableProperty0)prop$iv), GitResetMode.class);
            }
            {
                this.this$0 = gitNewResetDialog;
                super(1);
            }
        }));
    }

    @NotNull
    protected String getHelpId() {
        return DIALOG_ID;
    }

    public GitNewResetDialog(@NotNull Project project, @NotNull Map<GitRepository, ? extends VcsFullCommitDetails> commits2, @NotNull GitResetMode defaultMode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        Intrinsics.checkNotNullParameter((Object)((Object)defaultMode), (String)"defaultMode");
        super(project);
        this.project = project;
        this.commits = commits2;
        this.resetMode = defaultMode;
        this.init();
        this.setTitle(GitBundle.message("git.reset.dialog.title", new Object[0]));
        this.setOKButtonText(GitBundle.message("git.reset.button", new Object[0]));
    }

    public static final /* synthetic */ Project access$getProject$p(GitNewResetDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ Map access$getCommits$p(GitNewResetDialog $this) {
        return $this.commits;
    }

    public static final /* synthetic */ GitResetMode access$getResetMode$p(GitNewResetDialog $this) {
        return $this.resetMode;
    }

    public static final /* synthetic */ void access$setResetMode$p(GitNewResetDialog $this, GitResetMode gitResetMode) {
        $this.resetMode = gitResetMode;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0015\u0010\t\u001a\u00070\u0004\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J)\u0010\r\u001a\u00070\u0004\u00a2\u0006\u0002\b\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/reset/GitNewResetDialog$Companion;", "", "()V", "DIALOG_ID", "", "getSourceText", "Lorg/jetbrains/annotations/NonNls;", "repository", "Lgit4idea/repo/GitRepository;", "getTargetText", "Lorg/jetbrains/annotations/Nls;", "commit", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "prepareDescription", "project", "Lcom/intellij/openapi/project/Project;", "commits", "", "intellij.vcs.git"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final String prepareDescription(Project project, Map<GitRepository, ? extends VcsFullCommitDetails> commits2) {
            boolean isMultiRepo = GitRepositoryManager.getInstance(project).moreThanOneRoot();
            Map.Entry onlyCommit = (Map.Entry)CollectionsKt.singleOrNull((Iterable)commits2.entrySet());
            if (onlyCommit != null && !isMultiRepo) {
                void key;
                Map.Entry entry;
                Map.Entry entry2 = entry = onlyCommit;
                GitRepository gitRepository = (GitRepository)entry2.getKey();
                entry2 = entry;
                VcsFullCommitDetails value = (VcsFullCommitDetails)entry2.getValue();
                return this.getSourceText((GitRepository)key) + " -> " + this.getTargetText(value);
            }
            StringBuilder desc = new StringBuilder();
            Object object = commits2;
            Iterator<Map.Entry<GitRepository, ? extends VcsFullCommitDetails>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                String sourceInRepo;
                void repository;
                Map.Entry<GitRepository, ? extends VcsFullCommitDetails> entry;
                Map.Entry<GitRepository, ? extends VcsFullCommitDetails> entry3 = entry = iterator.next();
                object = entry3.getKey();
                entry3 = entry;
                VcsFullCommitDetails commit = entry3.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)GitBundle.message("git.reset.dialog.description.source.in.repository", this.getSourceText((GitRepository)repository), DvcsUtil.getShortRepositoryName((Repository)((Repository)repository))), (String)"GitBundle.message(\"git.r\u2026positoryName(repository))");
                desc.append(sourceInRepo + " -> " + this.getTargetText(commit) + "<br/>");
            }
            String string = desc.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"desc.toString()");
            return string;
        }

        private final String getTargetText(VcsFullCommitDetails commit) {
            String string = StringUtil.shortenTextWithEllipsis((String)commit.getSubject(), (int)40, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.shortenTextWi\u2026is(commit.subject, 40, 0)");
            String commitMessage = string;
            String string2 = StringUtil.shortenTextWithEllipsis((String)VcsUserUtil.getShortPresentation((VcsUser)commit.getAuthor()), (int)40, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.shortenTextWi\u2026on(commit.author), 40, 0)");
            String author = string2;
            String string3 = GitBundle.message("git.reset.dialog.description.commit.details.by.author", new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)((Hash)commit.getId()).toShortString()).bold()).append(HtmlChunk.text((String)(" \"" + commitMessage + "\""))).toString(), HtmlChunk.tag((String)"code").addText(author));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GitBundle.message(\"git.r\u2026(\"code\").addText(author))");
            return string3;
        }

        private final String getSourceText(GitRepository repository) {
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            String currentRevision = repository.getCurrentRevision();
            Object object = currentBranch != null ? currentBranch.getName() : (currentRevision != null ? "HEAD (" + DvcsUtil.getShortHash((String)currentRevision) + ")" : "HEAD");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when {\n        currentBr\u2026il.HEAD //NON-NLS\n      }");
            String text = object;
            String string = HtmlChunk.text((String)text).bold().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HtmlChunk.text(text).bold().toString()");
            return string;
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$prepareDescription(Companion $this, Project project, Map commits2) {
            return $this.prepareDescription(project, commits2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

