/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GitMerger {
    private final Project myProject;
    private final GitRepositoryManager myRepositoryManager;

    public GitMerger(@NotNull Project project) {
        if (project == null) {
            GitMerger.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
    }

    @NotNull
    public Collection<VirtualFile> getMergingRoots() {
        Collection<VirtualFile> collection = GitUtil.getRootsFromRepositories(ContainerUtil.filter(this.myRepositoryManager.getRepositories(), repository -> repository.getState() == Repository.State.MERGING));
        if (collection == null) {
            GitMerger.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public void mergeCommit(@NotNull Collection<? extends VirtualFile> roots) throws VcsException {
        if (roots == null) {
            GitMerger.$$$reportNull$$$0(2);
        }
        for (VirtualFile virtualFile : roots) {
            this.mergeCommit(virtualFile);
        }
    }

    public void mergeCommit(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            GitMerger.$$$reportNull$$$0(3);
        }
        GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.COMMIT);
        handler.setStdoutSuppressed(false);
        GitRepository repository = GitUtil.getRepositoryForRoot(this.myProject, root);
        File messageFile = repository.getRepositoryFiles().getMergeMessageFile();
        if (!messageFile.exists()) {
            GitLocalBranch branch = repository.getCurrentBranch();
            String branchName = branch != null ? branch.getName() : "";
            handler.addParameters("-m", "Merge branch '" + branchName + "' of " + root.getPresentableUrl() + " with conflicts.");
        } else {
            handler.addParameters("-F");
            handler.addAbsoluteFile(messageFile);
        }
        handler.endOptions();
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/merge/GitMerger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/merge/GitMerger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergingRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mergeCommit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

