/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader.events;

import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import com.intellij.internal.statistic.eventLog.connection.StatisticsResult;
import com.intellij.internal.statistic.uploader.ExternalDataCollectorLogger;
import com.intellij.internal.statistic.uploader.events.ExternalSystemErrorEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEventSerializer;
import com.intellij.internal.statistic.uploader.events.ExternalUploadFinishedEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadSendEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadStartedEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExternalEventsLogger
implements DataCollectorSystemEventLogger {
    private static final int CURRENT_VERSION = 1;
    @NonNls
    private final Logger myLogger = Logger.getLogger("com.intellij.internal.statistic.uploader.events");

    public ExternalEventsLogger() {
        String logDirectory = ExternalDataCollectorLogger.findDirectory(1000000L);
        if (logDirectory != null) {
            this.myLogger.addHandler(ExternalEventsLogger.newAppender(ExternalEventsLogger.getEventLogFile(logDirectory, 1).getAbsolutePath()));
            this.myLogger.setLevel(Level.ALL);
        }
    }

    @NotNull
    public static Handler newAppender(@NotNull String logPath) {
        FileHandler fileHandler;
        if (logPath == null) {
            ExternalEventsLogger.$$$reportNull$$$0(0);
        }
        try {
            @NonNls FileHandler appender = new FileHandler(logPath, false);
            appender.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage() + "\n";
                }
            });
            appender.setLevel(Level.ALL);
            fileHandler = appender;
        }
        catch (IOException e) {
            System.err.println("Error creating log file: " + e.getMessage());
            return new ConsoleHandler();
        }
        if (fileHandler == null) {
            ExternalEventsLogger.$$$reportNull$$$0(1);
        }
        return fileHandler;
    }

    @NotNull
    private static File getEventLogFile(@NotNull String logDirectory, int version) {
        if (logDirectory == null) {
            ExternalEventsLogger.$$$reportNull$$$0(2);
        }
        return new File(logDirectory, "idea_statistics_uploader_events_v" + version + ".log");
    }

    public void logSendingLogsStarted() {
        this.logEvent(new ExternalUploadStartedEvent(System.currentTimeMillis(), null));
    }

    public void logSendingLogsFinished(@NotNull String error) {
        if (error == null) {
            ExternalEventsLogger.$$$reportNull$$$0(3);
        }
        this.logEvent(new ExternalUploadFinishedEvent(System.currentTimeMillis(), error, null));
    }

    public void logSendingLogsFinished(@NotNull String recorderId, @NotNull String error) {
        if (recorderId == null) {
            ExternalEventsLogger.$$$reportNull$$$0(4);
        }
        if (error == null) {
            ExternalEventsLogger.$$$reportNull$$$0(5);
        }
        this.logEvent(new ExternalUploadFinishedEvent(System.currentTimeMillis(), error, recorderId));
    }

    public void logSendingLogsFinished(@NotNull String recorderId, @NotNull StatisticsResult.ResultCode code) {
        if (recorderId == null) {
            ExternalEventsLogger.$$$reportNull$$$0(6);
        }
        if (code == null) {
            ExternalEventsLogger.$$$reportNull$$$0(7);
        }
        String error = code == StatisticsResult.ResultCode.SEND ? null : code.name();
        this.logEvent(new ExternalUploadFinishedEvent(System.currentTimeMillis(), error, recorderId));
    }

    public void logSendingLogsSucceed(@NotNull String recorderId, @NotNull List<String> successfullySentFiles, @NotNull List<Integer> errors, int total) {
        if (recorderId == null) {
            ExternalEventsLogger.$$$reportNull$$$0(8);
        }
        if (successfullySentFiles == null) {
            ExternalEventsLogger.$$$reportNull$$$0(9);
        }
        if (errors == null) {
            ExternalEventsLogger.$$$reportNull$$$0(10);
        }
        int succeed = successfullySentFiles.size();
        int failed = errors.size();
        this.logEvent(new ExternalUploadSendEvent(System.currentTimeMillis(), succeed, failed, total, successfullySentFiles, errors, recorderId));
    }

    @Override
    public void logErrorEvent(@NotNull String recorderId, @NotNull String eventId, @NotNull Throwable exception) {
        if (recorderId == null) {
            ExternalEventsLogger.$$$reportNull$$$0(11);
        }
        if (eventId == null) {
            ExternalEventsLogger.$$$reportNull$$$0(12);
        }
        if (exception == null) {
            ExternalEventsLogger.$$$reportNull$$$0(13);
        }
        this.logEvent(new ExternalSystemErrorEvent(System.currentTimeMillis(), eventId, exception, recorderId));
    }

    private void logEvent(@NotNull ExternalSystemEvent event) {
        if (event == null) {
            ExternalEventsLogger.$$$reportNull$$$0(14);
        }
        this.myLogger.info(ExternalSystemEventSerializer.serialize(event));
    }

    @NotNull
    public static List<ExternalSystemEvent> parseEvents(@NotNull File directory) throws IOException {
        List<String> lines;
        if (directory == null) {
            ExternalEventsLogger.$$$reportNull$$$0(15);
        }
        VersionedFile versionedFile = VersionedFile.find(directory.getAbsolutePath());
        List<String> list = lines = versionedFile.file.exists() ? Files.readAllLines(versionedFile.file.toPath()) : Collections.emptyList();
        if (!lines.isEmpty()) {
            ArrayList<ExternalSystemEvent> events = new ArrayList<ExternalSystemEvent>();
            for (String line : lines) {
                ExternalSystemEvent event = ExternalSystemEventSerializer.deserialize(line, versionedFile.version);
                if (event == null) continue;
                events.add(event);
            }
            ArrayList<ExternalSystemEvent> arrayList = events;
            if (arrayList == null) {
                ExternalEventsLogger.$$$reportNull$$$0(16);
            }
            return arrayList;
        }
        List<ExternalSystemEvent> list2 = Collections.emptyList();
        if (list2 == null) {
            ExternalEventsLogger.$$$reportNull$$$0(17);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logPath";
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/uploader/events/ExternalEventsLogger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logDirectory";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successfullySentFiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/uploader/events/ExternalEventsLogger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newAppender";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newAppender";
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEventLogFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "logSendingLogsFinished";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logSendingLogsSucceed";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logErrorEvent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "logEvent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseEvents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VersionedFile {
        protected final File file;
        protected final int version;

        private VersionedFile(@NotNull File file, int version) {
            if (file == null) {
                VersionedFile.$$$reportNull$$$0(0);
            }
            this.file = file;
            this.version = version;
        }

        @NotNull
        protected static VersionedFile find(@NotNull String logDirectory) {
            if (logDirectory == null) {
                VersionedFile.$$$reportNull$$$0(1);
            }
            int version = 0;
            File file = new File(logDirectory, "idea_statistics_uploader_events.log");
            if (!file.exists()) {
                file = ExternalEventsLogger.getEventLogFile(logDirectory, ++version);
            }
            return new VersionedFile(file, version);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logDirectory";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/uploader/events/ExternalEventsLogger$VersionedFile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "find";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

