/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.util.GithubSettings;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004J$\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "", "()V", "findLocalBranch", "", "repository", "Lgit4idea/repo/GitRepository;", "prRemote", "Lgit4idea/repo/GitRemote;", "isFork", "", "possibleBranchName", "findRemote", "httpUrl", "sshUrl", "getRemoteUrl", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "user", "repo", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "Companion", "intellij.vcs.github"})
public final class GithubGitHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
        return this.getRemoteUrl(server, repoPath.getOwner(), repoPath.getRepository());
    }

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull String user, @NotNull String repo) {
        String string;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        GithubSettings githubSettings = GithubSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)githubSettings, (String)"GithubSettings.getInstance()");
        if (githubSettings.isCloneGitUsingSsh()) {
            String string2;
            String string3;
            String string4;
            String string5 = server.getHost();
            String string6 = server.getSuffix();
            if (string6 != null) {
                string4 = string6;
                int n = 1;
                String string7 = string4.substring(n);
                string3 = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string3 = null;
            }
            if ((string2 = (string4 = string3)) == null) {
                string2 = "";
            }
            string = "git@" + string5 + ":" + string2 + "/" + user + "/" + repo + ".git";
        } else {
            String string8 = server.getHost();
            String string9 = server.getSuffix();
            String string10 = string9;
            if (string10 == null) {
                string10 = "";
            }
            string = "https://" + string8 + string10 + "/" + user + "/" + repo + ".git";
        }
        return string;
    }

    @Nullable
    public final GitRemote findRemote(@NotNull GitRepository repository, @Nullable String httpUrl, @Nullable String sshUrl) {
        Object v2;
        block1: {
            Iterable iterable;
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Collection collection = repository.getRemotes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.remotes");
            Iterable iterable2 = iterable = (Iterable)collection;
            for (Object t : iterable2) {
                GitRemote it = (GitRemote)t;
                boolean bl = false;
                GitRemote gitRemote = it;
                Intrinsics.checkNotNullExpressionValue((Object)gitRemote, (String)"it");
                if (!(gitRemote.getFirstUrl() != null && (Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)httpUrl) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)(httpUrl + ".git")) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)sshUrl) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)(sshUrl + ".git"))))) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String findLocalBranch(@NotNull GitRepository repository, @NotNull GitRemote prRemote, boolean isFork, @Nullable String possibleBranchName) {
        Object object;
        Object v9;
        List localBranchesWithTracking;
        block11: {
            List list2;
            Object destination$iv$iv;
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)prRemote, (String)"prRemote");
            Object object2 = repository.getBranches();
            GitBranchesCollection $this$with = object2;
            boolean bl = false;
            if (isFork) {
                void $this$filterTo$iv$iv2;
                Collection collection = $this$with.getLocalBranches();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"localBranches");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    GitLocalBranch it = (GitLocalBranch)element$iv$iv;
                    boolean bl2 = false;
                    GitRemoteBranch gitRemoteBranch = it.findTrackedBranch(repository);
                    if (!Intrinsics.areEqual((Object)(gitRemoteBranch != null ? gitRemoteBranch.getRemote() : null), (Object)prRemote)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                void $this$filterTo$iv$iv;
                Object v5;
                block10: {
                    Iterable $i$f$filter;
                    Collection collection = $this$with.getRemoteBranches();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"remoteBranches");
                    Iterable $this$filterTo$iv$iv2 = $i$f$filter = (Iterable)collection;
                    for (Object $i$f$filterTo : $this$filterTo$iv$iv2) {
                        GitRemoteBranch it = (GitRemoteBranch)$i$f$filterTo;
                        boolean bl3 = false;
                        GitRemoteBranch gitRemoteBranch = it;
                        Intrinsics.checkNotNullExpressionValue((Object)gitRemoteBranch, (String)"it");
                        if (!Intrinsics.areEqual((Object)gitRemoteBranch.getNameForRemoteOperations(), (Object)possibleBranchName)) continue;
                        v5 = $i$f$filterTo;
                        break block10;
                    }
                    v5 = null;
                }
                GitRemoteBranch gitRemoteBranch = v5;
                if (gitRemoteBranch == null) {
                    return null;
                }
                GitRemoteBranch prRemoteBranch = gitRemoteBranch;
                Collection collection = $this$with.getLocalBranches();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"localBranches");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    GitLocalBranch it = (GitLocalBranch)element$iv$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.findTrackedBranch(repository), (Object)prRemoteBranch)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            }
            localBranchesWithTracking = list2;
            Object object3 = object2 = (Iterable)localBranchesWithTracking;
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                GitLocalBranch it = (GitLocalBranch)t;
                boolean bl5 = false;
                GitLocalBranch gitLocalBranch = it;
                Intrinsics.checkNotNullExpressionValue((Object)gitLocalBranch, (String)"it");
                if (!Intrinsics.areEqual((Object)gitLocalBranch.getName(), (Object)possibleBranchName)) continue;
                v9 = t;
                break block11;
            }
            v9 = null;
        }
        if ((object = (GitLocalBranch)v9) == null || (object = object.getName()) == null) {
            if (!isFork) {
                GitLocalBranch gitLocalBranch = (GitLocalBranch)CollectionsKt.firstOrNull((List)localBranchesWithTracking);
                object = gitLocalBranch != null ? gitLocalBranch.getName() : null;
            } else {
                object = null;
            }
        }
        return object;
    }

    @JvmStatic
    @Nullable
    public static final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        return Companion.findGitRepository(project, file);
    }

    @JvmStatic
    @NotNull
    public static final GithubGitHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper$Companion;", "", "()V", "findGitRepository", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInstance", "Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
            GitRepository repository;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"GitUtil.getRepositoryManager(project)");
            GitRepositoryManager manager = gitRepositoryManager;
            List list2 = manager.getRepositories();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"manager.repositories");
            List repositories = list2;
            if (repositories.size() == 0) {
                return null;
            }
            if (repositories.size() == 1) {
                return (GitRepository)repositories.get(0);
            }
            if (file != null && (repository = (GitRepository)manager.getRepositoryForFileQuick(file)) != null) {
                return repository;
            }
            return (GitRepository)manager.getRepositoryForFileQuick(project.getBaseDir());
        }

        public static /* synthetic */ GitRepository findGitRepository$default(Companion companion, Project project, VirtualFile virtualFile, int n, Object object) {
            if ((n & 2) != 0) {
                virtualFile = null;
            }
            return companion.findGitRepository(project, virtualFile);
        }

        @JvmStatic
        @NotNull
        public final GithubGitHelper getInstance() {
            boolean $i$f$service = false;
            Class<GithubGitHelper> serviceClass$iv = GithubGitHelper.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (GithubGitHelper)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

