/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitRepositoryMappingData;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "Lgit4idea/ui/branch/GitRepositoryMappingData;", "ghRepositoryCoordinates", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "gitRemoteUrlCoordinates", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "(Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;)V", "getGhRepositoryCoordinates", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "gitRemote", "Lgit4idea/repo/GitRemote;", "getGitRemote", "()Lgit4idea/repo/GitRemote;", "getGitRemoteUrlCoordinates", "()Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "gitRepository", "Lgit4idea/repo/GitRepository;", "getGitRepository", "()Lgit4idea/repo/GitRepository;", "repositoryPath", "", "getRepositoryPath", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "intellij.vcs.github"})
public final class GHGitRepositoryMapping
implements GitRepositoryMappingData {
    @NotNull
    private final GHRepositoryCoordinates ghRepositoryCoordinates;
    @NotNull
    private final GitRemoteUrlCoordinates gitRemoteUrlCoordinates;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public GitRemote getGitRemote() {
        return this.gitRemoteUrlCoordinates.getRemote();
    }

    @NotNull
    public GitRepository getGitRepository() {
        return this.gitRemoteUrlCoordinates.getRepository();
    }

    @NotNull
    public String getRepositoryPath() {
        return this.ghRepositoryCoordinates.getRepositoryPath().getRepository();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHGitRepositoryMapping)) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.ghRepositoryCoordinates, (Object)((GHGitRepositoryMapping)other).ghRepositoryCoordinates) ^ true);
    }

    public int hashCode() {
        return this.ghRepositoryCoordinates.hashCode();
    }

    @NotNull
    public String toString() {
        return "(repository=" + this.ghRepositoryCoordinates + ", remote=" + this.gitRemoteUrlCoordinates + ")";
    }

    @NotNull
    public final GHRepositoryCoordinates getGhRepositoryCoordinates() {
        return this.ghRepositoryCoordinates;
    }

    @NotNull
    public final GitRemoteUrlCoordinates getGitRemoteUrlCoordinates() {
        return this.gitRemoteUrlCoordinates;
    }

    public GHGitRepositoryMapping(@NotNull GHRepositoryCoordinates ghRepositoryCoordinates, @NotNull GitRemoteUrlCoordinates gitRemoteUrlCoordinates) {
        Intrinsics.checkNotNullParameter((Object)ghRepositoryCoordinates, (String)"ghRepositoryCoordinates");
        Intrinsics.checkNotNullParameter((Object)gitRemoteUrlCoordinates, (String)"gitRemoteUrlCoordinates");
        this.ghRepositoryCoordinates = ghRepositoryCoordinates;
        this.gitRemoteUrlCoordinates = gitRemoteUrlCoordinates;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping$Companion;", "", "()V", "create", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "remote", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "intellij.vcs.github"})
    public static final class Companion {
        @Nullable
        public final GHGitRepositoryMapping create(@NotNull GithubServerPath server, @NotNull GitRemoteUrlCoordinates remote) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            GHRepositoryPath gHRepositoryPath = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remote.getUrl());
            if (gHRepositoryPath == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)gHRepositoryPath, (String)"GithubUrlUtil.getUserAnd\u2026emote.url) ?: return null");
            GHRepositoryPath repositoryPath = gHRepositoryPath;
            GHRepositoryCoordinates repository = new GHRepositoryCoordinates(server, repositoryPath);
            return new GHGitRepositoryMapping(repository, remote);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

