/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.pullrequest.action.GHPRSelectPullRequestForFileAction;
import org.jetbrains.plugins.github.pullrequest.action.GHPRSwitchRemoteAction;
import org.jetbrains.plugins.github.pullrequest.config.GithubPullRequestsProjectUISettings;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContextRepository;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRToolWindowTabController;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRToolWindowTabControllerImpl;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHProjectRepositoriesManager;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "init", "shouldBeAvailable", "", "Companion", "intellij.vcs.github"})
public final class GHPRToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    public static final String ID = "Pull Requests";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect(toolWindow.getDisposable()).subscribe(GHProjectRepositoriesManager.LIST_CHANGES_TOPIC, (Object)new GHProjectRepositoriesManager.ListChangeListener(toolWindow){
            final /* synthetic */ ToolWindow $toolWindow;

            public void repositoryListChanged(@NotNull Set<GHGitRepositoryMapping> newList, @NotNull Project project) {
                Intrinsics.checkNotNullParameter(newList, (String)"newList");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Collection collection = newList;
                this.$toolWindow.setAvailable(!collection.isEmpty());
            }
            {
                this.$toolWindow = $captured_local_variable$0;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        void it;
        Content $this$apply;
        Content content2;
        ContentManager contentManager;
        ToolWindowEx toolWindowEx;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        ToolWindowEx $this$with = toolWindowEx = (ToolWindowEx)toolWindow;
        boolean bl = false;
        $this$with.setTitleActions(CollectionsKt.listOf((Object[])new AnAction[]{EmptyAction.registerWithShortcutSet((String)"Github.Create.Pull.Request", (ShortcutSet)CommonShortcuts.getNew(), (JComponent)$this$with.getComponent()), (AnAction)new GHPRSelectPullRequestForFileAction()}));
        $this$with.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{(AnAction)new GHPRSwitchRemoteAction()}));
        $this$with.getComponent().putClientProperty("HideIdLabel", "true");
        ContentManager $this$with2 = contentManager = $this$with.getContentManager();
        boolean bl2 = false;
        Content content3 = content2 = $this$with2.getFactory().createContent((JComponent)new JPanel(null), null, false);
        ContentManager contentManager2 = $this$with2;
        boolean bl3 = false;
        $this$apply.setCloseable(false);
        $this$apply.setDisposer(Disposer.newDisposable((String)"GHPR tab disposable"));
        Unit unit = Unit.INSTANCE;
        $this$apply = content2;
        boolean bl4 = false;
        GithubAuthenticationManager authManager = GithubAuthenticationManager.Companion.getInstance();
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GHProjectRepositoriesManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        GHProjectRepositoriesManager repositoryManager = (GHProjectRepositoriesManager)object;
        GHPRDataContextRepository dataContextRepository = GHPRDataContextRepository.Companion.getInstance(project);
        GithubPullRequestsProjectUISettings projectString = GithubPullRequestsProjectUISettings.Companion.getInstance(project);
        Key<GHPRToolWindowTabController> key = GHPRToolWindowTabController.Companion.getKEY();
        void v2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
        it.putUserData(key, (Object)new GHPRToolWindowTabControllerImpl(project, authManager, repositoryManager, dataContextRepository, projectString, (Content)v2));
        unit = Unit.INSTANCE;
        contentManager2.addContent(content2);
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRToolWindowFactory$Companion;", "", "()V", "ID", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

