/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.util.Collections;
import java.util.Iterator;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGBridgeExtension;
import org.apache.batik.bridge.svg12.BindableElementBridge;
import org.apache.batik.bridge.svg12.SVG12TextElementBridge;
import org.apache.batik.bridge.svg12.SVGFlowRootElementBridge;
import org.apache.batik.bridge.svg12.SVGMultiImageElementBridge;
import org.apache.batik.bridge.svg12.SVGSolidColorElementBridge;
import org.apache.batik.bridge.svg12.XBLContentElementBridge;
import org.apache.batik.bridge.svg12.XBLShadowTreeElementBridge;
import org.w3c.dom.Element;

public class SVG12BridgeExtension
extends SVGBridgeExtension {
    public float getPriority() {
        return 0.0f;
    }

    public Iterator getImplementedExtensions() {
        return Collections.EMPTY_LIST.iterator();
    }

    public String getAuthor() {
        return "The Apache Batik Team.";
    }

    public String getContactAddress() {
        return "batik-dev@xmlgraphics.apache.org";
    }

    public String getURL() {
        return "http://xml.apache.org/batik";
    }

    public String getDescription() {
        return "The required SVG 1.2 tags";
    }

    public void registerTags(BridgeContext bridgeContext) {
        super.registerTags(bridgeContext);
        bridgeContext.putBridge(new SVGFlowRootElementBridge());
        bridgeContext.putBridge(new SVGMultiImageElementBridge());
        bridgeContext.putBridge(new SVGSolidColorElementBridge());
        bridgeContext.putBridge(new SVG12TextElementBridge());
        bridgeContext.putBridge(new XBLShadowTreeElementBridge());
        bridgeContext.putBridge(new XBLContentElementBridge());
        bridgeContext.setDefaultBridge(new BindableElementBridge());
        bridgeContext.putReservedNamespaceURI(null);
        bridgeContext.putReservedNamespaceURI("http://www.w3.org/2000/svg");
        bridgeContext.putReservedNamespaceURI("http://www.w3.org/2004/xbl");
    }

    public boolean isDynamicElement(Element element) {
        String string = element.getNamespaceURI();
        if ("http://www.w3.org/2004/xbl".equals(string)) {
            return true;
        }
        if (!"http://www.w3.org/2000/svg".equals(string)) {
            return false;
        }
        String string2 = element.getLocalName();
        return string2.equals("script") || string2.equals("handler") || string2.startsWith("animate") || string2.equals("set");
    }
}

