/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.expression.span.SpanExpression;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import org.opensearch.sql.planner.physical.collector.Collector;

public class AggregationOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final List<NamedAggregator> aggregatorList;
    private final List<NamedExpression> groupByExprList;
    private final NamedExpression span;
    private final Collector collector;
    private Iterator<ExprValue> iterator;

    public AggregationOperator(PhysicalPlan input, List<NamedAggregator> aggregatorList, List<NamedExpression> groupByExprList) {
        this.input = input;
        this.aggregatorList = aggregatorList;
        if (this.hasSpan(groupByExprList)) {
            this.span = groupByExprList.get(0);
            this.groupByExprList = groupByExprList.subList(1, groupByExprList.size());
        } else {
            this.span = null;
            this.groupByExprList = groupByExprList;
        }
        this.collector = Collector.Builder.build(this.span, this.groupByExprList, this.aggregatorList);
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitAggregation(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ExprValue next() {
        return this.iterator.next();
    }

    @Override
    public void open() {
        super.open();
        while (this.input.hasNext()) {
            this.collector.collect(((ExprValue)this.input.next()).bindingTuples());
        }
        this.iterator = this.collector.results().iterator();
    }

    private boolean hasSpan(List<NamedExpression> namedExpressionList) {
        return !namedExpressionList.isEmpty() && namedExpressionList.get(0).getDelegated() instanceof SpanExpression;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregationOperator)) {
            return false;
        }
        AggregationOperator other = (AggregationOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        List<NamedAggregator> this$aggregatorList = this.getAggregatorList();
        List<NamedAggregator> other$aggregatorList = other.getAggregatorList();
        if (this$aggregatorList == null ? other$aggregatorList != null : !((Object)this$aggregatorList).equals(other$aggregatorList)) {
            return false;
        }
        List<NamedExpression> this$groupByExprList = this.getGroupByExprList();
        List<NamedExpression> other$groupByExprList = other.getGroupByExprList();
        if (this$groupByExprList == null ? other$groupByExprList != null : !((Object)this$groupByExprList).equals(other$groupByExprList)) {
            return false;
        }
        NamedExpression this$span = this.getSpan();
        NamedExpression other$span = other.getSpan();
        return !(this$span == null ? other$span != null : !((Object)this$span).equals(other$span));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AggregationOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        List<NamedAggregator> $aggregatorList = this.getAggregatorList();
        result = result * 59 + ($aggregatorList == null ? 43 : ((Object)$aggregatorList).hashCode());
        List<NamedExpression> $groupByExprList = this.getGroupByExprList();
        result = result * 59 + ($groupByExprList == null ? 43 : ((Object)$groupByExprList).hashCode());
        NamedExpression $span = this.getSpan();
        result = result * 59 + ($span == null ? 43 : ((Object)$span).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AggregationOperator(input=" + this.getInput() + ", aggregatorList=" + this.getAggregatorList() + ", groupByExprList=" + this.getGroupByExprList() + ", span=" + this.getSpan() + ", collector=" + this.collector + ", iterator=" + this.iterator + ")";
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public List<NamedAggregator> getAggregatorList() {
        return this.aggregatorList;
    }

    @Generated
    public List<NamedExpression> getGroupByExprList() {
        return this.groupByExprList;
    }

    @Generated
    public NamedExpression getSpan() {
        return this.span;
    }
}

