/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.utils.ParseUtils;

public class ParseExpression
extends FunctionExpression {
    private final Expression expression;
    private final Expression rawPattern;
    private final Expression identifier;
    private final Pattern pattern;

    public ParseExpression(Expression expression, Expression rawPattern, Expression identifier) {
        super(FunctionName.of("parse"), (List<Expression>)ImmutableList.of((Object)expression, (Object)rawPattern, (Object)identifier));
        this.expression = expression;
        this.rawPattern = rawPattern;
        this.identifier = identifier;
        this.pattern = Pattern.compile(rawPattern.valueOf(null).stringValue());
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        ExprValue value = valueEnv.resolve(this.expression);
        try {
            return ParseUtils.parseValue(value, this.pattern, this.identifier.valueOf(null).stringValue());
        }
        catch (ExpressionEvaluationException e) {
            throw new SemanticCheckException(String.format("failed to parse field \"%s\" with type [%s]", this.expression, value.type()));
        }
    }

    @Override
    public ExprType type() {
        return ExprCoreType.STRING;
    }

    @Override
    public <T, C> T accept(ExpressionNodeVisitor<T, C> visitor, C context) {
        return visitor.visitParse(this, context);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParseExpression)) {
            return false;
        }
        ParseExpression other = (ParseExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$expression = this.getExpression();
        Expression other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        Expression this$rawPattern = this.rawPattern;
        Expression other$rawPattern = other.rawPattern;
        if (this$rawPattern == null ? other$rawPattern != null : !this$rawPattern.equals(other$rawPattern)) {
            return false;
        }
        Expression this$identifier = this.getIdentifier();
        Expression other$identifier = other.getIdentifier();
        return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParseExpression;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        Expression $rawPattern = this.rawPattern;
        result = result * 59 + ($rawPattern == null ? 43 : $rawPattern.hashCode());
        Expression $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ParseExpression(expression=" + this.getExpression() + ", rawPattern=" + this.rawPattern + ", identifier=" + this.getIdentifier() + ", pattern=" + this.getPattern() + ")";
    }

    @Generated
    public Expression getExpression() {
        return this.expression;
    }

    @Generated
    public Expression getIdentifier() {
        return this.identifier;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }
}

