/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.dsl;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.And;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Case;
import org.opensearch.sql.ast.expression.Cast;
import org.opensearch.sql.ast.expression.Compare;
import org.opensearch.sql.ast.expression.DataType;
import org.opensearch.sql.ast.expression.EqualTo;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.HighlightFunction;
import org.opensearch.sql.ast.expression.In;
import org.opensearch.sql.ast.expression.Interval;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.Not;
import org.opensearch.sql.ast.expression.Or;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.Span;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.ast.expression.UnresolvedArgument;
import org.opensearch.sql.ast.expression.UnresolvedAttribute;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.When;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.expression.Xor;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.Dedupe;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Head;
import org.opensearch.sql.ast.tree.Limit;
import org.opensearch.sql.ast.tree.Parse;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.RelationSubquery;
import org.opensearch.sql.ast.tree.Rename;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.ast.tree.Values;

public final class AstDSL {
    public static UnresolvedPlan filter(UnresolvedPlan input, UnresolvedExpression expression) {
        return new Filter(expression).attach(input);
    }

    public static UnresolvedPlan relation(String tableName) {
        return new Relation(AstDSL.qualifiedName(tableName));
    }

    public static UnresolvedPlan relation(String tableName, String alias) {
        return new Relation(AstDSL.qualifiedName(tableName), alias);
    }

    public static UnresolvedPlan project(UnresolvedPlan input, UnresolvedExpression ... projectList) {
        return new Project(Arrays.asList(projectList)).attach(input);
    }

    public static Eval eval(UnresolvedPlan input, Let ... projectList) {
        return new Eval(Arrays.asList(projectList)).attach(input);
    }

    public static UnresolvedPlan projectWithArg(UnresolvedPlan input, List<Argument> argList, UnresolvedExpression ... projectList) {
        return new Project(Arrays.asList(projectList), argList).attach(input);
    }

    public static UnresolvedPlan agg(UnresolvedPlan input, List<UnresolvedExpression> aggList, List<UnresolvedExpression> sortList, List<UnresolvedExpression> groupList, List<Argument> argList) {
        return new Aggregation(aggList, sortList, groupList, null, argList).attach(input);
    }

    public static UnresolvedPlan agg(UnresolvedPlan input, List<UnresolvedExpression> aggList, List<UnresolvedExpression> sortList, List<UnresolvedExpression> groupList, UnresolvedExpression span, List<Argument> argList) {
        return new Aggregation(aggList, sortList, groupList, span, argList).attach(input);
    }

    public static UnresolvedPlan rename(UnresolvedPlan input, Map ... maps) {
        return new Rename(Arrays.asList(maps), input);
    }

    @SafeVarargs
    public static UnresolvedPlan values(List<Literal> ... values) {
        return new Values(Arrays.asList(values));
    }

    public static QualifiedName qualifiedName(String ... parts) {
        return new QualifiedName(Arrays.asList(parts));
    }

    public static UnresolvedExpression equalTo(UnresolvedExpression left, UnresolvedExpression right) {
        return new EqualTo(left, right);
    }

    public static UnresolvedExpression unresolvedAttr(String attr) {
        return new UnresolvedAttribute(attr);
    }

    public static UnresolvedPlan relationSubquery(UnresolvedPlan subquery, String subqueryAlias) {
        return new RelationSubquery(subquery, subqueryAlias);
    }

    private static Literal literal(Object value, DataType type) {
        return new Literal(value, type);
    }

    public static Let let(Field var, UnresolvedExpression expression) {
        return new Let(var, expression);
    }

    public static Literal intLiteral(Integer value) {
        return AstDSL.literal(value, DataType.INTEGER);
    }

    public static Literal longLiteral(Long value) {
        return AstDSL.literal(value, DataType.LONG);
    }

    public static Literal shortLiteral(Short value) {
        return AstDSL.literal(value, DataType.SHORT);
    }

    public static Literal floatLiteral(Float value) {
        return AstDSL.literal(value, DataType.FLOAT);
    }

    public static Literal dateLiteral(String value) {
        return AstDSL.literal(value, DataType.DATE);
    }

    public static Literal timeLiteral(String value) {
        return AstDSL.literal(value, DataType.TIME);
    }

    public static Literal timestampLiteral(String value) {
        return AstDSL.literal(value, DataType.TIMESTAMP);
    }

    public static Literal doubleLiteral(Double value) {
        return AstDSL.literal(value, DataType.DOUBLE);
    }

    public static Literal stringLiteral(String value) {
        return AstDSL.literal(value, DataType.STRING);
    }

    public static Literal booleanLiteral(Boolean value) {
        return AstDSL.literal(value, DataType.BOOLEAN);
    }

    public static Interval intervalLiteral(Object value, DataType type, String unit) {
        return new Interval((UnresolvedExpression)AstDSL.literal(value, type), unit);
    }

    public static Literal nullLiteral() {
        return AstDSL.literal(null, DataType.NULL);
    }

    public static Map map(String origin, String target) {
        return new Map(AstDSL.field(origin), AstDSL.field(target));
    }

    public static Map map(UnresolvedExpression origin, UnresolvedExpression target) {
        return new Map(origin, target);
    }

    public static UnresolvedExpression aggregate(String func, UnresolvedExpression field) {
        return new AggregateFunction(func, field);
    }

    public static UnresolvedExpression aggregate(String func, UnresolvedExpression field, UnresolvedExpression ... args) {
        return new AggregateFunction(func, field, Arrays.asList(args));
    }

    public static UnresolvedExpression filteredAggregate(String func, UnresolvedExpression field, UnresolvedExpression condition) {
        return new AggregateFunction(func, field).condition(condition);
    }

    public static UnresolvedExpression distinctAggregate(String func, UnresolvedExpression field) {
        return new AggregateFunction(func, field, true);
    }

    public static UnresolvedExpression filteredDistinctCount(String func, UnresolvedExpression field, UnresolvedExpression condition) {
        return new AggregateFunction(func, field, true).condition(condition);
    }

    public static Function function(String funcName, UnresolvedExpression ... funcArgs) {
        return new Function(funcName, Arrays.asList(funcArgs));
    }

    public static UnresolvedExpression caseWhen(UnresolvedExpression elseClause, When ... whenClauses) {
        return AstDSL.caseWhen(null, elseClause, whenClauses);
    }

    public static UnresolvedExpression caseWhen(UnresolvedExpression caseValueExpr, UnresolvedExpression elseClause, When ... whenClauses) {
        return new Case(caseValueExpr, Arrays.asList(whenClauses), elseClause);
    }

    public static UnresolvedExpression cast(UnresolvedExpression expr, Literal type) {
        return new Cast(expr, type);
    }

    public static When when(UnresolvedExpression condition, UnresolvedExpression result) {
        return new When(condition, result);
    }

    public static UnresolvedExpression highlight(UnresolvedExpression fieldName) {
        return new HighlightFunction(fieldName);
    }

    public static UnresolvedExpression window(UnresolvedExpression function, List<UnresolvedExpression> partitionByList, List<Pair<Sort.SortOption, UnresolvedExpression>> sortList) {
        return new WindowFunction(function, partitionByList, sortList);
    }

    public static UnresolvedExpression not(UnresolvedExpression expression) {
        return new Not(expression);
    }

    public static UnresolvedExpression or(UnresolvedExpression left, UnresolvedExpression right) {
        return new Or(left, right);
    }

    public static UnresolvedExpression and(UnresolvedExpression left, UnresolvedExpression right) {
        return new And(left, right);
    }

    public static UnresolvedExpression xor(UnresolvedExpression left, UnresolvedExpression right) {
        return new Xor(left, right);
    }

    public static UnresolvedExpression in(UnresolvedExpression field, UnresolvedExpression ... valueList) {
        return new In(field, Arrays.asList(valueList));
    }

    public static UnresolvedExpression in(UnresolvedExpression field, List<UnresolvedExpression> valueList) {
        return new In(field, valueList);
    }

    public static UnresolvedExpression compare(String operator, UnresolvedExpression left, UnresolvedExpression right) {
        return new Compare(operator, left, right);
    }

    public static Argument argument(String argName, Literal argValue) {
        return new Argument(argName, argValue);
    }

    public static UnresolvedArgument unresolvedArg(String argName, UnresolvedExpression argValue) {
        return new UnresolvedArgument(argName, argValue);
    }

    public static AllFields allFields() {
        return AllFields.of();
    }

    public static Field field(UnresolvedExpression field) {
        return new Field(field);
    }

    public static Field field(UnresolvedExpression field, Argument ... fieldArgs) {
        return AstDSL.field(field, Arrays.asList(fieldArgs));
    }

    public static Field field(String field) {
        return AstDSL.field(AstDSL.qualifiedName(field));
    }

    public static Field field(String field, Argument ... fieldArgs) {
        return AstDSL.field(field, Arrays.asList(fieldArgs));
    }

    public static Field field(UnresolvedExpression field, List<Argument> fieldArgs) {
        return new Field(field, fieldArgs);
    }

    public static Field field(String field, List<Argument> fieldArgs) {
        return AstDSL.field((UnresolvedExpression)AstDSL.qualifiedName(field), fieldArgs);
    }

    public static Alias alias(String name, UnresolvedExpression expr) {
        return new Alias(name, expr);
    }

    public static Alias alias(String name, UnresolvedExpression expr, String alias) {
        return new Alias(name, expr, alias);
    }

    public static List<UnresolvedExpression> exprList(UnresolvedExpression ... exprList) {
        return Arrays.asList(exprList);
    }

    public static List<Argument> exprList(Argument ... exprList) {
        return Arrays.asList(exprList);
    }

    public static List<UnresolvedArgument> unresolvedArgList(UnresolvedArgument ... exprList) {
        return Arrays.asList(exprList);
    }

    public static List<Argument> defaultFieldsArgs() {
        return AstDSL.exprList(AstDSL.argument("exclude", AstDSL.booleanLiteral(false)));
    }

    public static List<Argument> defaultStatsArgs() {
        return AstDSL.exprList(AstDSL.argument("partitions", AstDSL.intLiteral(1)), AstDSL.argument("allnum", AstDSL.booleanLiteral(false)), AstDSL.argument("delim", AstDSL.stringLiteral(" ")), AstDSL.argument("dedupsplit", AstDSL.booleanLiteral(false)));
    }

    public static List<Argument> defaultDedupArgs() {
        return AstDSL.exprList(AstDSL.argument("number", AstDSL.intLiteral(1)), AstDSL.argument("keepempty", AstDSL.booleanLiteral(false)), AstDSL.argument("consecutive", AstDSL.booleanLiteral(false)));
    }

    public static List<Argument> sortOptions() {
        return AstDSL.exprList(AstDSL.argument("desc", AstDSL.booleanLiteral(false)));
    }

    public static List<Argument> defaultSortFieldArgs() {
        return AstDSL.exprList(AstDSL.argument("asc", AstDSL.booleanLiteral(true)), AstDSL.argument("type", AstDSL.nullLiteral()));
    }

    public static Span span(UnresolvedExpression field, UnresolvedExpression value, SpanUnit unit) {
        return new Span(field, value, unit);
    }

    public static Sort sort(UnresolvedPlan input, Field ... sorts) {
        return new Sort(input, Arrays.asList(sorts));
    }

    public static Dedupe dedupe(UnresolvedPlan input, List<Argument> options, Field ... fields) {
        return new Dedupe(input, options, Arrays.asList(fields));
    }

    public static Head head(UnresolvedPlan input, Integer size, Integer from) {
        return new Head(input, size, from);
    }

    public static List<Argument> defaultTopArgs() {
        return AstDSL.exprList(AstDSL.argument("noOfResults", AstDSL.intLiteral(10)));
    }

    public static RareTopN rareTopN(UnresolvedPlan input, RareTopN.CommandType commandType, List<Argument> noOfResults, List<UnresolvedExpression> groupList, Field ... fields) {
        return new RareTopN(input, commandType, noOfResults, Arrays.asList(fields), groupList).attach(input);
    }

    public static Limit limit(UnresolvedPlan input, Integer limit, Integer offset) {
        return new Limit(limit, offset).attach(input);
    }

    public static Parse parse(UnresolvedPlan input, UnresolvedExpression expression, Literal pattern) {
        return new Parse(expression, pattern, input);
    }

    @Generated
    private AstDSL() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

