/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.github.wnameless.json.flattener.IndexedPeekIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JsonFlattener {
    private final JsonValue source;
    private final Deque<IndexedPeekIterator<?>> elementIters = new ArrayDeque();
    private final Map<String, Object> flattenedJsonMap = new LinkedHashMap<String, Object>();
    private String flattenedJson = null;

    public static String flatten(String json) {
        return new JsonFlattener(json).flatten();
    }

    public static Map<String, Object> flattenAsMap(String json) {
        return new JsonFlattener(json).flattenAsMap();
    }

    public JsonFlattener(String json) {
        this.source = Json.parse((String)json);
        if (!this.source.isObject() && !this.source.isArray()) {
            throw new IllegalArgumentException("Input must be a JSON object or array");
        }
        this.reduce(this.source);
    }

    public Map<String, Object> flattenAsMap() {
        while (!this.elementIters.isEmpty()) {
            IndexedPeekIterator<?> deepestIter = this.elementIters.getLast();
            if (!deepestIter.hasNext()) {
                this.elementIters.removeLast();
                continue;
            }
            if (deepestIter.peek() instanceof JsonObject.Member) {
                JsonObject.Member mem = (JsonObject.Member)deepestIter.next();
                this.reduce(mem.getValue());
                continue;
            }
            if (!(deepestIter.peek() instanceof JsonValue)) continue;
            JsonValue val = (JsonValue)deepestIter.next();
            this.reduce(val);
        }
        return this.flattenedJsonMap;
    }

    public String flatten() {
        if (this.flattenedJson != null) {
            return this.flattenedJson;
        }
        this.flattenAsMap();
        JsonObject jsonObj = Json.object();
        for (Map.Entry<String, Object> mem : this.flattenedJsonMap.entrySet()) {
            String key = mem.getKey();
            Object val = mem.getValue();
            if (val instanceof Boolean) {
                jsonObj.add(key, ((Boolean)val).booleanValue());
                continue;
            }
            if (val instanceof String) {
                jsonObj.add(key, (String)val);
                continue;
            }
            if (val instanceof Number) {
                jsonObj.add(key, val instanceof Long ? (double)((Long)val).longValue() : (Double)val);
                continue;
            }
            jsonObj.add(key, Json.NULL);
        }
        this.flattenedJson = jsonObj.toString();
        return this.flattenedJson;
    }

    private void reduce(JsonValue val) {
        if (val.isObject()) {
            this.elementIters.add(new IndexedPeekIterator(val.asObject().iterator()));
        } else if (val.isArray()) {
            this.elementIters.add(new IndexedPeekIterator(val.asArray().iterator()));
        } else {
            this.flattenedJsonMap.put(this.computeKey(), this.jsonVal2Obj(val));
        }
    }

    private Object jsonVal2Obj(JsonValue jsonValue) {
        if (jsonValue.isBoolean()) {
            return jsonValue.asBoolean();
        }
        if (jsonValue.isString()) {
            return jsonValue.asString();
        }
        if (jsonValue.isNumber()) {
            double v = jsonValue.asDouble();
            if (!Double.isNaN(v) && !Double.isInfinite(v) && v == Math.rint(v)) {
                return jsonValue.asLong();
            }
            return jsonValue.asDouble();
        }
        return null;
    }

    private String computeKey() {
        StringBuilder sb = new StringBuilder();
        for (IndexedPeekIterator<?> iter : this.elementIters) {
            if (iter.getCurrent() instanceof JsonObject.Member) {
                String key = ((JsonObject.Member)iter.getCurrent()).getName();
                if (key.contains(".")) {
                    sb.append('[');
                    sb.append('\"');
                    sb.append(key);
                    sb.append('\"');
                    sb.append(']');
                    continue;
                }
                if (sb.length() != 0) {
                    sb.append('.');
                }
                sb.append(key);
                continue;
            }
            sb.append('[');
            sb.append(iter.getIndex());
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 27;
        result = 31 * result + this.source.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonFlattener)) {
            return false;
        }
        return this.source.equals((Object)((JsonFlattener)o).source);
    }

    public String toString() {
        return "JsonFlattener{source=" + this.source + "}";
    }
}

