/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.stats.collectors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.rca.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.Count;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.IStatistic;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.Max;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.Mean;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.Min;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.NamedCounter;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.Sample;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.Sum;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.vals.AggregateValue;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.vals.Value;
import org.opensearch.performanceanalyzer.rca.stats.format.Formatter;
import org.opensearch.performanceanalyzer.rca.stats.listeners.IListener;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public class SampleAggregator {
    private static final Logger LOG = LogManager.getLogger(SampleAggregator.class);
    private final MeasurementSet[] recognizedSet;
    private ImmutableMap<MeasurementSet, Set<IStatistic>> statMap;
    private AtomicLong startTimeMillis;
    private final IListener listener;
    private final Set<MeasurementSet> listenedMeasurements;

    public SampleAggregator(MeasurementSet[] measurementSet) {
        this(Collections.EMPTY_SET, null, measurementSet);
    }

    public SampleAggregator(Set<MeasurementSet> listenedMeasurements, IListener listener, MeasurementSet[] measurementSet) {
        Objects.requireNonNull(listenedMeasurements);
        this.listenedMeasurements = listenedMeasurements;
        this.listener = listener;
        this.recognizedSet = measurementSet;
        this.init();
    }

    private void init() {
        this.startTimeMillis = new AtomicLong(0L);
        ConcurrentHashMap initializer = new ConcurrentHashMap();
        for (MeasurementSet elem : this.recognizedSet) {
            HashSet<IStatistic<AggregateValue>> impls = new HashSet<IStatistic<AggregateValue>>();
            block10: for (Statistics stats : elem.getStatsList()) {
                switch (stats) {
                    case COUNT: {
                        impls.add(new Count());
                        continue block10;
                    }
                    case MAX: {
                        impls.add(new Max());
                        continue block10;
                    }
                    case MEAN: {
                        impls.add(new Mean());
                        continue block10;
                    }
                    case MIN: {
                        impls.add(new Min());
                        continue block10;
                    }
                    case NAMED_COUNTERS: {
                        impls.add(new NamedCounter());
                        continue block10;
                    }
                    case SAMPLE: {
                        impls.add(new Sample());
                        continue block10;
                    }
                    case SUM: {
                        impls.add(new Sum());
                        continue block10;
                    }
                }
                throw new IllegalArgumentException("Unimplemented stat: " + stats);
            }
            initializer.put(elem, impls);
        }
        this.statMap = ImmutableMap.copyOf(initializer);
    }

    public <V extends Number> void updateStat(MeasurementSet metric, String key, V value) {
        Set statistics = (Set)this.statMap.get((Object)metric);
        if (statistics == null) {
            LOG.error("'{}' asked to be aggregated, when known types are only: {}", (Object)metric, (Object)this.recognizedSet);
            return;
        }
        if (this.startTimeMillis.get() == 0L) {
            this.startTimeMillis.compareAndSet(0L, System.currentTimeMillis());
        }
        for (IStatistic s : statistics) {
            s.calculate(key, value);
        }
        if (this.listenedMeasurements.contains(metric)) {
            this.listener.onOccurrence(metric, value, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillValuesAndReset(Formatter formatter) {
        SampleAggregator sampleAggregator = this;
        synchronized (sampleAggregator) {
            this.fill(formatter);
            this.init();
        }
    }

    public void fill(Formatter formatter) {
        long endTime = System.currentTimeMillis();
        formatter.setStartAndEndTime(this.startTimeMillis.get(), endTime);
        for (Map.Entry entry : this.statMap.entrySet()) {
            MeasurementSet measurement = (MeasurementSet)entry.getKey();
            for (IStatistic statValues : (Set)entry.getValue()) {
                if (statValues.isEmpty()) continue;
                Statistics stat = statValues.type();
                Collection values = statValues.get();
                for (Value value : values) {
                    value.format(formatter, measurement, stat);
                }
            }
        }
    }

    @VisibleForTesting
    public boolean isMeasurementObserved(MeasurementSet toFind) {
        Set statistics = (Set)this.statMap.get((Object)toFind);
        if (statistics == null) {
            return false;
        }
        for (IStatistic statistic : (Set)this.statMap.get((Object)toFind)) {
            if (statistic == null || statistic.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public Collection<IStatistic> getValues(MeasurementSet toFind) {
        Set statistics = (Set)this.statMap.get((Object)toFind);
        if (statistics == null) {
            return Collections.EMPTY_LIST;
        }
        return (Collection)this.statMap.get((Object)toFind);
    }
}

