/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api;

import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.exception.DataAccessException;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.metricsdb.MetricsDB;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.core.LeafNode;
import org.opensearch.performanceanalyzer.rca.framework.core.Queryable;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;

public abstract class Metric
extends LeafNode<MetricFlowUnit> {
    static final String[] metricList;
    private String name;
    private static final Logger LOG;

    public Metric(String name, long evaluationIntervalSeconds) {
        super(0, evaluationIntervalSeconds);
        this.name = name.isEmpty() ? this.getClass().getSimpleName() : name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public MetricFlowUnit gather(Queryable queryable) {
        MetricsDB db;
        LOG.debug("Trying to gather metrics for {}", (Object)this.name);
        try {
            db = queryable.getMetricsDB();
        }
        catch (Exception e) {
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.EXCEPTION_IN_GATHER, this.name(), 1);
            LOG.error("RCA: Caught an exception while getting the DB", (Throwable)e);
            return MetricFlowUnit.generic();
        }
        try {
            Result<Record> result = queryable.queryMetrics(db, this.name);
            return new MetricFlowUnit(queryable.getDBTimestamp(db), result);
        }
        catch (DataAccessException dex) {
            LOG.warn("Looking for metric {}, when it does not exist.", (Object)this.name);
        }
        catch (Exception e) {
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.EXCEPTION_IN_GATHER, this.name(), 1);
            LOG.error("Metric exception:", (Throwable)e);
        }
        return MetricFlowUnit.generic();
    }

    @Override
    public void generateFlowUnitListFromLocal(FlowUnitOperationArgWrapper args) {
        long startTime = System.currentTimeMillis();
        MetricFlowUnit mfu = this.gather(args.getQueryable());
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        PerformanceAnalyzerApp.RCA_GRAPH_METRICS_AGGREGATOR.updateStat(RcaGraphMetrics.METRIC_GATHER_CALL, this.name(), duration);
        this.setFlowUnits(Collections.singletonList(mfu));
    }

    @Override
    public void persistFlowUnit(FlowUnitOperationArgWrapper args) {
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        LOG.error("we are not supposed to read metric flowunit from wire.");
    }

    @Override
    public void handleNodeMuted() {
        this.setLocalFlowUnit(MetricFlowUnit.generic());
    }

    static {
        AllMetrics.OSMetrics[] osMetrics = AllMetrics.OSMetrics.values();
        metricList = new String[osMetrics.length];
        for (int i = 0; i < osMetrics.length; ++i) {
            Metric.metricList[i] = osMetrics[i].name();
        }
        LOG = LogManager.getLogger(Metric.class);
    }
}

