/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.utils;

import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;

public class IndexUtils {
    public static final String NONEXISTENT_INDEX_STATUS = "non-existent";
    public static final String ALIAS_EXISTS_NO_INDICES_STATUS = "alias exists, but does not point to any indices";
    private Client client;
    private ClusterService clusterService;

    @Inject
    public IndexUtils(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    public String getIndexHealthStatus(String indexOrAliasName) throws IllegalArgumentException {
        if (!this.clusterService.state().getRoutingTable().hasIndex(indexOrAliasName)) {
            if (this.clusterService.state().metadata().hasAlias(indexOrAliasName)) {
                List indexMetaDataList = ((IndexAbstraction)this.clusterService.state().metadata().getIndicesLookup().get(indexOrAliasName)).getIndices();
                if (indexMetaDataList.size() == 0) {
                    return ALIAS_EXISTS_NO_INDICES_STATUS;
                }
                if (indexMetaDataList.size() > 1) {
                    throw new IllegalArgumentException("Cannot get health for alias that points to multiple indices");
                }
                indexOrAliasName = ((IndexMetadata)indexMetaDataList.get(0)).getIndex().getName();
            } else {
                return NONEXISTENT_INDEX_STATUS;
            }
        }
        ClusterIndexHealth indexHealth = new ClusterIndexHealth(this.clusterService.state().metadata().index(indexOrAliasName), this.clusterService.state().getRoutingTable().index(indexOrAliasName));
        return indexHealth.getStatus().name().toLowerCase(Locale.ROOT);
    }

    public void getNumberOfDocumentsInIndex(String indexName, ActionListener<Long> listener) {
        if (this.clusterService.state().getRoutingTable().hasIndex(indexName)) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.indices(new String[]{indexName});
            this.client.admin().indices().stats(indicesStatsRequest, ActionListener.wrap(r -> {
                long count = r.getIndex((String)indexName).getPrimaries().docs.getCount();
                listener.onResponse((Object)count);
            }, e -> listener.onFailure(e)));
        } else {
            listener.onResponse((Object)0L);
        }
    }
}

