/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLPredictionAction
extends BaseRestHandler {
    private static final String ML_PREDICTION_ACTION = "ml_prediction_action";

    public String getName() {
        return ML_PREDICTION_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/_predict/{%s}/{%s}", "/_plugins/_ml", "algorithm", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLPredictionTaskRequest mlPredictionTaskRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)mlPredictionTaskRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLPredictionTaskRequest getRequest(RestRequest request) throws IOException {
        String algorithm = RestActionUtils.getAlgorithm(request);
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLInput mlInput = MLInput.parse((XContentParser)parser, (String)algorithm);
        return new MLPredictionTaskRequest(modelId, mlInput);
    }
}

