/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.parameter.clustering;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.annotation.MLAlgoParameter;
import org.opensearch.ml.common.input.parameter.MLAlgoParams;

@MLAlgoParameter(algorithms={FunctionName.RCF_SUMMARIZE})
public class RCFSummarizeParams
implements MLAlgoParams {
    public static final String PARSE_FIELD_NAME = FunctionName.RCF_SUMMARIZE.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> RCFSummarizeParams.parse(it));
    public static final String MAX_K_FIELD = "max_k";
    public static final String INITIAL_K_FIELD = "initial_k";
    public static final String DISTANCE_TYPE_FIELD = "distance_type";
    public static final String PHASE1_REASSIGN_FIELD = "phase1_reassign";
    public static final String PARALLEL__FIELD = "parallel";
    private Integer maxK;
    private Integer initialK;
    private DistanceType distanceType;
    private Boolean phase1Reassign;
    private Boolean parallel;

    public RCFSummarizeParams(Integer maxK, Integer initialK, DistanceType distanceType, Boolean phase1Reassign, Boolean parallel) {
        this.maxK = maxK;
        this.initialK = initialK;
        this.distanceType = distanceType;
        this.phase1Reassign = phase1Reassign;
        this.parallel = parallel;
    }

    public RCFSummarizeParams(StreamInput in) throws IOException {
        this.maxK = in.readOptionalInt();
        this.initialK = in.readOptionalInt();
        this.phase1Reassign = in.readOptionalBoolean();
        this.parallel = in.readOptionalBoolean();
        if (in.readBoolean()) {
            this.distanceType = (DistanceType)in.readEnum(DistanceType.class);
        }
    }

    public static MLAlgoParams parse(XContentParser parser) throws IOException {
        Integer maxK = null;
        Integer initialK = null;
        Boolean phase1Reassign = null;
        Boolean parallel = null;
        DistanceType distanceType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "max_k": {
                    maxK = parser.intValue(false);
                    continue block14;
                }
                case "initial_k": {
                    initialK = parser.intValue(false);
                    continue block14;
                }
                case "phase1_reassign": {
                    phase1Reassign = parser.booleanValue();
                    continue block14;
                }
                case "parallel": {
                    parallel = parser.booleanValue();
                    continue block14;
                }
                case "distance_type": {
                    distanceType = DistanceType.from(parser.text().toUpperCase());
                    continue block14;
                }
            }
            parser.skipChildren();
        }
        return new RCFSummarizeParams(maxK, initialK, distanceType, phase1Reassign, parallel);
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.maxK);
        out.writeOptionalInt(this.initialK);
        out.writeOptionalBoolean(this.phase1Reassign);
        out.writeOptionalBoolean(this.parallel);
        if (this.distanceType != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.distanceType);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.maxK != null) {
            builder.field(MAX_K_FIELD, this.maxK);
        }
        if (this.initialK != null) {
            builder.field(INITIAL_K_FIELD, this.initialK);
        }
        if (this.phase1Reassign != null) {
            builder.field(PHASE1_REASSIGN_FIELD, this.phase1Reassign);
        }
        if (this.parallel != null) {
            builder.field(PARALLEL__FIELD, this.parallel);
        }
        if (this.distanceType != null) {
            builder.field(DISTANCE_TYPE_FIELD, this.distanceType.name());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Generated
    public static RCFSummarizeParamsBuilder builder() {
        return new RCFSummarizeParamsBuilder();
    }

    @Generated
    public RCFSummarizeParamsBuilder toBuilder() {
        return new RCFSummarizeParamsBuilder().maxK(this.maxK).initialK(this.initialK).distanceType(this.distanceType).phase1Reassign(this.phase1Reassign).parallel(this.parallel);
    }

    @Generated
    public Integer getMaxK() {
        return this.maxK;
    }

    @Generated
    public Integer getInitialK() {
        return this.initialK;
    }

    @Generated
    public DistanceType getDistanceType() {
        return this.distanceType;
    }

    @Generated
    public Boolean getPhase1Reassign() {
        return this.phase1Reassign;
    }

    @Generated
    public Boolean getParallel() {
        return this.parallel;
    }

    @Generated
    public void setMaxK(Integer maxK) {
        this.maxK = maxK;
    }

    @Generated
    public void setInitialK(Integer initialK) {
        this.initialK = initialK;
    }

    @Generated
    public void setDistanceType(DistanceType distanceType) {
        this.distanceType = distanceType;
    }

    @Generated
    public void setPhase1Reassign(Boolean phase1Reassign) {
        this.phase1Reassign = phase1Reassign;
    }

    @Generated
    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RCFSummarizeParams)) {
            return false;
        }
        RCFSummarizeParams other = (RCFSummarizeParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxK = this.getMaxK();
        Integer other$maxK = other.getMaxK();
        if (this$maxK == null ? other$maxK != null : !((Object)this$maxK).equals(other$maxK)) {
            return false;
        }
        Integer this$initialK = this.getInitialK();
        Integer other$initialK = other.getInitialK();
        if (this$initialK == null ? other$initialK != null : !((Object)this$initialK).equals(other$initialK)) {
            return false;
        }
        Boolean this$phase1Reassign = this.getPhase1Reassign();
        Boolean other$phase1Reassign = other.getPhase1Reassign();
        if (this$phase1Reassign == null ? other$phase1Reassign != null : !((Object)this$phase1Reassign).equals(other$phase1Reassign)) {
            return false;
        }
        Boolean this$parallel = this.getParallel();
        Boolean other$parallel = other.getParallel();
        if (this$parallel == null ? other$parallel != null : !((Object)this$parallel).equals(other$parallel)) {
            return false;
        }
        DistanceType this$distanceType = this.getDistanceType();
        DistanceType other$distanceType = other.getDistanceType();
        return !(this$distanceType == null ? other$distanceType != null : !((Object)((Object)this$distanceType)).equals((Object)other$distanceType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RCFSummarizeParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxK = this.getMaxK();
        result = result * 59 + ($maxK == null ? 43 : ((Object)$maxK).hashCode());
        Integer $initialK = this.getInitialK();
        result = result * 59 + ($initialK == null ? 43 : ((Object)$initialK).hashCode());
        Boolean $phase1Reassign = this.getPhase1Reassign();
        result = result * 59 + ($phase1Reassign == null ? 43 : ((Object)$phase1Reassign).hashCode());
        Boolean $parallel = this.getParallel();
        result = result * 59 + ($parallel == null ? 43 : ((Object)$parallel).hashCode());
        DistanceType $distanceType = this.getDistanceType();
        result = result * 59 + ($distanceType == null ? 43 : ((Object)((Object)$distanceType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RCFSummarizeParams(maxK=" + this.getMaxK() + ", initialK=" + this.getInitialK() + ", distanceType=" + this.getDistanceType() + ", phase1Reassign=" + this.getPhase1Reassign() + ", parallel=" + this.getParallel() + ")";
    }

    @Generated
    public static class RCFSummarizeParamsBuilder {
        @Generated
        private Integer maxK;
        @Generated
        private Integer initialK;
        @Generated
        private DistanceType distanceType;
        @Generated
        private Boolean phase1Reassign;
        @Generated
        private Boolean parallel;

        @Generated
        RCFSummarizeParamsBuilder() {
        }

        @Generated
        public RCFSummarizeParamsBuilder maxK(Integer maxK) {
            this.maxK = maxK;
            return this;
        }

        @Generated
        public RCFSummarizeParamsBuilder initialK(Integer initialK) {
            this.initialK = initialK;
            return this;
        }

        @Generated
        public RCFSummarizeParamsBuilder distanceType(DistanceType distanceType) {
            this.distanceType = distanceType;
            return this;
        }

        @Generated
        public RCFSummarizeParamsBuilder phase1Reassign(Boolean phase1Reassign) {
            this.phase1Reassign = phase1Reassign;
            return this;
        }

        @Generated
        public RCFSummarizeParamsBuilder parallel(Boolean parallel) {
            this.parallel = parallel;
            return this;
        }

        @Generated
        public RCFSummarizeParams build() {
            return new RCFSummarizeParams(this.maxK, this.initialK, this.distanceType, this.phase1Reassign, this.parallel);
        }

        @Generated
        public String toString() {
            return "RCFSummarizeParams.RCFSummarizeParamsBuilder(maxK=" + this.maxK + ", initialK=" + this.initialK + ", distanceType=" + this.distanceType + ", phase1Reassign=" + this.phase1Reassign + ", parallel=" + this.parallel + ")";
        }
    }

    public static enum DistanceType {
        L1,
        L2,
        LInfinity;


        public static DistanceType from(String value) {
            try {
                return DistanceType.valueOf(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong distance type");
            }
        }
    }
}

