/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.forcemerge;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.action.support.DefaultShardOperationFailedException;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.indexmanagement.indexstatemanagement.action.ForceMergeAction;
import org.opensearch.indexmanagement.indexstatemanagement.step.forcemerge.WaitForForceMergeStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000e\u001a\u00020\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0016J+\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/forcemerge/WaitForForceMergeStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/ForceMergeAction;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/ForceMergeAction;)V", "info", "", "", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getActionStartTime", "Ljava/time/Instant;", "context", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "getMaxNumSegments", "", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;)Ljava/lang/Integer;", "getShardsStillMergingSegments", "indexName", "maxNumSegments", "(Ljava/lang/String;ILorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "isIdempotent", "", "Companion", "opensearch-index-management"})
public final class WaitForForceMergeStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ForceMergeAction action;
    private final Logger logger;
    @NotNull
    private Step.StepStatus stepStatus;
    @Nullable
    private Map<String, ? extends Object> info;
    @NotNull
    public static final String name = "wait_for_force_merge";
    public static final long FORCE_MERGE_TIMEOUT_IN_SECONDS = 43200L;

    public WaitForForceMergeStep(@NotNull ForceMergeAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, false);
        this.action = action;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.stepStatus = Step.StepStatus.STARTING;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super WaitForForceMergeStep> var1_1) {
        if (!(var1_1 instanceof execute.1)) ** GOTO lbl-1000
        var12_2 = var1_1;
        if ((var12_2.label & -2147483648) != 0) {
            var12_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ WaitForForceMergeStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super WaitForForceMergeStep>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getContext();
                if (v0 == null) {
                    return this;
                }
                context = v0;
                indexName = context.getMetadata().getIndex();
                v1 = this.getMaxNumSegments(context);
                if (v1 == null) {
                    return this;
                }
                maxNumSegments = v1;
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = indexName;
                $continuation.label = 1;
                v2 = this.getShardsStillMergingSegments(indexName, maxNumSegments, context, (Continuation<? super Integer>)$continuation);
                if (v2 == var13_4) {
                    return var13_4;
                }
                ** GOTO lbl35
            }
            case 1: {
                indexName = (String)$continuation.L$2;
                context = (StepContext)$continuation.L$1;
                this = (WaitForForceMergeStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl35:
                // 2 sources

                v3 = shardsStillMergingSegments = (Integer)v2;
                if (v3 == null) {
                    return this;
                }
                v3.intValue();
                var6_9 = false;
                if (shardsStillMergingSegments == 0) {
                    message = WaitForForceMergeStep.Companion.getSuccessMessage(indexName);
                    this.logger.info(message);
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
                } else {
                    var7_12 = Duration.between(this.getActionStartTime(context), Instant.now());
                    Intrinsics.checkNotNullExpressionValue((Object)var7_12, (String)"between(getActionStartTi\u2026(context), Instant.now())");
                    timeWaitingForForceMerge = var7_12;
                    v4 = this.action.getConfigTimeout();
                    if (v4 == null) {
                        v5 = 43200L;
                    } else {
                        v6 = v4.getTimeout();
                        v5 = timeoutInSeconds = v6 == null ? 43200L : (var9_14 = v6.getSeconds());
                    }
                    if (timeWaitingForForceMerge.getSeconds() > timeoutInSeconds) {
                        this.logger.error("Force merge on [" + indexName + "] timed out with [" + shardsStillMergingSegments + "] shards containing unmerged segments");
                        this.stepStatus = Step.StepStatus.FAILED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForForceMergeStep.Companion.getFailedTimedOutMessage(indexName)));
                    } else {
                        this.logger.debug("Force merge still running on [" + indexName + "] with [" + shardsStillMergingSegments + "] shards containing unmerged segments");
                        this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForForceMergeStep.Companion.getWaitingMessage(indexName)));
                    }
                }
                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Integer getMaxNumSegments(StepContext context) {
        ActionProperties actionProperties;
        ManagedIndexMetaData managedIndexMetaData = context.getMetadata();
        ActionMetaData actionMetaData = managedIndexMetaData.getActionMetaData();
        ActionProperties actionProperties2 = actionProperties = actionMetaData == null ? null : actionMetaData.getActionProperties();
        if ((actionProperties2 == null ? null : actionProperties2.getMaxNumSegments()) == null) {
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)("Unable to retrieve [" + ActionProperties.Properties.MAX_NUM_SEGMENTS.getKey() + "] from ActionProperties=" + actionProperties)));
            return null;
        }
        return actionProperties.getMaxNumSegments();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object getShardsStillMergingSegments(String var1_1, int var2_2, StepContext var3_3, Continuation<? super Integer> var4_4) {
        if (!(var4_4 instanceof getShardsStillMergingSegments.1)) ** GOTO lbl-1000
        var26_5 = var4_4;
        if ((var26_5.label & -2147483648) != 0) {
            var26_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ WaitForForceMergeStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WaitForForceMergeStep.access$getShardsStillMergingSegments(this.this$0, null, 0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var27_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_8 = new String[]{indexName};
                statsRequest = (IndicesStatsRequest)new IndicesStatsRequest().indices(var6_8);
                $continuation.L$0 = this;
                $continuation.L$1 = indexName;
                $continuation.I$0 = maxNumSegments;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient().admin().indices(), (Function2)new Function2<IndicesAdminClient, ActionListener<IndicesStatsResponse>, Unit>(statsRequest){
                    final /* synthetic */ IndicesStatsRequest $statsRequest;
                    {
                        this.$statsRequest = $statsRequest;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<IndicesStatsResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.stats(this.$statsRequest, it);
                    }
                }, $continuation);
                ** if (v0 != var27_7) goto lbl23
lbl22:
                // 1 sources

                return var27_7;
lbl23:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                maxNumSegments = $continuation.I$0;
                indexName = (String)$continuation.L$1;
                this = (WaitForForceMergeStep)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    if ((statsResponse = (IndicesStatsResponse)v0).getStatus() == RestStatus.OK) {
                        var7_12 = statsResponse.getShards();
                        Intrinsics.checkNotNullExpressionValue((Object)var7_12, (String)"statsResponse.shards");
                        $this$count$iv = var7_12;
                        $i$f$count = false;
                        count$iv = 0;
                        var10_21 = $this$count$iv;
                        var11_24 = 0;
                        var12_26 = var10_21.length;
                        while (var11_24 < var12_26) {
                            element$iv = var10_21[var11_24];
                            ++var11_24;
                            it = (ShardStats)element$iv;
                            $i$a$-count-WaitForForceMergeStep$getShardsStillMergingSegments$2 = false;
                            v1 = it.getStats().segments;
                            v2 = count = v1 == null ? null : Boxing.boxLong((long)v1.getCount());
                            if (count == null) {
                                this.logger.warn(indexName + " wait for force merge had null segments");
                                v3 = false;
                            } else {
                                v3 = count > (long)maxNumSegments;
                            }
                            if (!v3) continue;
                            ++count$iv;
                        }
                        return Boxing.boxInt((int)count$iv);
                    }
                    message = WaitForForceMergeStep.Companion.getFailedSegmentCheckMessage(indexName);
                    this.logger.warn(message + " - " + statsResponse.getStatus());
                    this.stepStatus = Step.StepStatus.FAILED;
                    $i$f$count = new Pair[2];
                    $i$f$count[0] = TuplesKt.to((Object)"message", (Object)message);
                    count$iv /* !! */  = statsResponse.getShardFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)count$iv /* !! */ , (String)"statsResponse.shardFailures");
                    count$iv /* !! */  = count$iv /* !! */ ;
                    var23_36 = "shard_failures";
                    var22_37 = 1;
                    var21_38 = $i$f$count;
                    var20_39 = this;
                    $i$f$map = false;
                    var11_25 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                    $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        var18_41 = (DefaultShardOperationFailedException)item$iv$iv;
                        var24_43 = destination$iv$iv;
                        $i$a$-map-WaitForForceMergeStep$getShardsStillMergingSegments$3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        var24_43.add(OpenSearchExtensionsKt.getUsefulCauseString((DefaultShardOperationFailedException)it));
                    }
                    var24_43 = (List)destination$iv$iv;
                    var21_38[var22_37] = TuplesKt.to((Object)var23_36, (Object)var24_43);
                    var20_39.info = MapsKt.mapOf((Pair[])$i$f$count);
                }
                catch (Exception e) {
                    message = WaitForForceMergeStep.Companion.getFailedSegmentCheckMessage(indexName);
                    this.logger.error(message, (Throwable)e);
                    this.stepStatus = Step.StepStatus.FAILED;
                    $i$f$count = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
                    mutableInfo = MapsKt.mutableMapOf((Pair[])$i$f$count);
                    errorMessage = e.getMessage();
                    if (errorMessage != null) {
                        var9_20 = mutableInfo;
                        var10_23 = "cause";
                        var9_20.put(var10_23, errorMessage);
                    }
                    this.info = MapsKt.toMap((Map)mutableInfo);
                }
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Instant getActionStartTime(StepContext context) {
        ManagedIndexMetaData managedIndexMetaData = context.getMetadata();
        ActionMetaData actionMetaData = managedIndexMetaData.getActionMetaData();
        Long l = actionMetaData == null ? null : actionMetaData.getStartTime();
        if (l == null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            return instant;
        }
        long startTime = l;
        Instant instant = Instant.ofEpochMilli(startTime);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(startTime)");
        return instant;
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        ActionMetaData actionMetaData;
        ActionMetaData currentActionMetaData;
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        ActionMetaData actionMetaData2 = currentActionMetaData = currentMetadata.getActionMetaData();
        if (actionMetaData2 == null) {
            actionMetaData = null;
        } else {
            ActionMetaData it = actionMetaData2;
            boolean bl = false;
            actionMetaData = this.stepStatus != Step.StepStatus.COMPLETED ? it : ActionMetaData.copy$default((ActionMetaData)currentActionMetaData, null, null, (int)0, (boolean)false, (int)0, null, null, (int)63, null);
        }
        ActionMetaData updatedActionMetaData = actionMetaData;
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, (ActionMetaData)updatedActionMetaData, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, (int)119551, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    public static final /* synthetic */ Object access$getShardsStillMergingSegments(WaitForForceMergeStep $this, String indexName, int maxNumSegments, StepContext context, Continuation $completion) {
        return $this.getShardsStillMergingSegments(indexName, maxNumSegments, context, (Continuation<? super Integer>)$completion);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/forcemerge/WaitForForceMergeStep$Companion;", "", "()V", "FORCE_MERGE_TIMEOUT_IN_SECONDS", "", "name", "", "getFailedSegmentCheckMessage", "index", "getFailedTimedOutMessage", "getSuccessMessage", "getWaitingMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedTimedOutMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Force merge timed out [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedSegmentCheckMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to check segments when waiting for force merge to complete [index=" + index2 + "]";
        }

        @NotNull
        public final String getWaitingMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Waiting for force merge to complete [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully confirmed segments force merged [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

