"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pageStyles = exports.observabilityTitle = exports.observabilityPluginOrder = exports.observabilityID = exports.UI_DATE_FORMAT = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SPAN_REGEX = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.PPL_STATS_REGEX = exports.PPL_SPAN_REGEX = exports.PPL_SEARCH = exports.PPL_NEWLINE_REGEX = exports.PPL_INDEX_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_DATE_FORMAT = exports.PPL_BASE = exports.PLOTLY_COLOR = exports.OPENSEARCH_PANELS_API = exports.OBSERVABILITY_BASE = exports.NUMERICAL_FIELDS = exports.LONG_CHART_COLOR = exports.LIVE_OPTIONS = exports.LIVE_END_TIME = exports.EVENT_ANALYTICS = exports.ENABLED_VIS_TYPES = exports.DSL_SEARCH = exports.DSL_MAPPING = exports.DSL_ENDPOINT = exports.DSL_CAT = exports.DSL_BASE = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// Client route
const PPL_BASE = '/api/ppl';
exports.PPL_BASE = PPL_BASE;
const PPL_SEARCH = '/search';
exports.PPL_SEARCH = PPL_SEARCH;
const DSL_BASE = '/api/dsl';
exports.DSL_BASE = DSL_BASE;
const DSL_SEARCH = '/search';
exports.DSL_SEARCH = DSL_SEARCH;
const DSL_CAT = '/cat.indices';
exports.DSL_CAT = DSL_CAT;
const DSL_MAPPING = '/indices.getFieldMapping';
exports.DSL_MAPPING = DSL_MAPPING;
const OBSERVABILITY_BASE = '/api/observability';
exports.OBSERVABILITY_BASE = OBSERVABILITY_BASE;
const EVENT_ANALYTICS = '/event_analytics';
exports.EVENT_ANALYTICS = EVENT_ANALYTICS;
const SAVED_OBJECTS = '/saved_objects';
exports.SAVED_OBJECTS = SAVED_OBJECTS;
const SAVED_QUERY = '/query';
exports.SAVED_QUERY = SAVED_QUERY;
const SAVED_VISUALIZATION = '/vis'; // Server route

exports.SAVED_VISUALIZATION = SAVED_VISUALIZATION;
const PPL_ENDPOINT = '/_plugins/_ppl';
exports.PPL_ENDPOINT = PPL_ENDPOINT;
const SQL_ENDPOINT = '/_plugins/_sql';
exports.SQL_ENDPOINT = SQL_ENDPOINT;
const DSL_ENDPOINT = '/_plugins/_dsl';
exports.DSL_ENDPOINT = DSL_ENDPOINT;
const observabilityID = 'observability-dashboards';
exports.observabilityID = observabilityID;
const observabilityTitle = 'Observability';
exports.observabilityTitle = observabilityTitle;
const observabilityPluginOrder = 6000; // Shared Constants

exports.observabilityPluginOrder = observabilityPluginOrder;
const SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
exports.SQL_DOCUMENTATION_URL = SQL_DOCUMENTATION_URL;
const PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observability-plugin/ppl/commands/';
exports.PPL_DOCUMENTATION_URL = PPL_DOCUMENTATION_URL;
const UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
exports.UI_DATE_FORMAT = UI_DATE_FORMAT;
const PPL_DATE_FORMAT = 'YYYY-MM-DD HH:mm:ss.SSSSSS';
exports.PPL_DATE_FORMAT = PPL_DATE_FORMAT;
const SPAN_REGEX = /span/;
exports.SPAN_REGEX = SPAN_REGEX;
const PPL_SPAN_REGEX = /by\s*span/i;
exports.PPL_SPAN_REGEX = PPL_SPAN_REGEX;
const PPL_STATS_REGEX = /\|\s*stats/i;
exports.PPL_STATS_REGEX = PPL_STATS_REGEX;
const PPL_INDEX_INSERT_POINT_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)(.*)/i;
exports.PPL_INDEX_INSERT_POINT_REGEX = PPL_INDEX_INSERT_POINT_REGEX;
const PPL_INDEX_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)/i;
exports.PPL_INDEX_REGEX = PPL_INDEX_REGEX;
const PPL_NEWLINE_REGEX = /[\n\r]+/g; // Observability plugin URI

exports.PPL_NEWLINE_REGEX = PPL_NEWLINE_REGEX;
const BASE_OBSERVABILITY_URI = '/_plugins/_observability';
const OPENSEARCH_PANELS_API = {
  OBJECT: `${BASE_OBSERVABILITY_URI}/object`
}; // Saved Objects

exports.OPENSEARCH_PANELS_API = OPENSEARCH_PANELS_API;
const SAVED_OBJECT = '/object'; // Color Constants

exports.SAVED_OBJECT = SAVED_OBJECT;
const PLOTLY_COLOR = ['#3CA1C7', '#8C55A3', '#DB748A', '#F2BE4B', '#68CCC2', '#2A7866', '#843769', '#374FB8', '#BD6F26', '#4C636F'];
exports.PLOTLY_COLOR = PLOTLY_COLOR;
const LONG_CHART_COLOR = PLOTLY_COLOR[1];
exports.LONG_CHART_COLOR = LONG_CHART_COLOR;
const pageStyles = {
  float: 'left',
  width: '100%',
  maxWidth: '1130px'
};
exports.pageStyles = pageStyles;
const NUMERICAL_FIELDS = ['short', 'integer', 'long', 'float', 'double'];
exports.NUMERICAL_FIELDS = NUMERICAL_FIELDS;
const ENABLED_VIS_TYPES = ['bar', 'horizontal_bar', 'line', 'pie', 'heatmap', 'text']; //Live tail constants

exports.ENABLED_VIS_TYPES = ENABLED_VIS_TYPES;
const LIVE_OPTIONS = [{
  label: '5s',
  startTime: 'now-5s',
  delayTime: 5000
}, {
  label: '10s',
  startTime: 'now-10s',
  delayTime: 10000
}, {
  label: '30s',
  startTime: 'now-30s',
  delayTime: 30000
}, {
  label: '1m',
  startTime: 'now-1m',
  delayTime: 60000
}, {
  label: '5m',
  startTime: 'now-5m',
  delayTime: 60000 * 5
}, {
  label: '15m',
  startTime: 'now-15m',
  delayTime: 60000 * 15
}, {
  label: '30m',
  startTime: 'now-30m',
  delayTime: 60000 * 30
}, {
  label: '1h',
  startTime: 'now-1h',
  delayTime: 60000 * 60
}, {
  label: '2h',
  startTime: 'now-2h',
  delayTime: 60000 * 120
}];
exports.LIVE_OPTIONS = LIVE_OPTIONS;
const LIVE_END_TIME = 'now';
exports.LIVE_END_TIME = LIVE_END_TIME;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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