/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.alerting.model.AggregationResultBucket;
import org.opensearch.alerting.model.BucketLevelTriggerRunResult;
import org.opensearch.alerting.model.Monitor;
import org.opensearch.alerting.model.MonitorMetadata;
import org.opensearch.alerting.model.action.Action;
import org.opensearch.alerting.model.action.ActionExecutionPolicy;
import org.opensearch.alerting.model.action.ActionExecutionScope;
import org.opensearch.alerting.model.destination.Destination;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.util.DestinationType;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u001a6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\b\u001a)\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\n\u0010\u001f\u001a\u00020\b*\u00020 \u001a\u0014\u0010!\u001a\u00020\"*\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\"\u001a\u0018\u0010$\u001a\u00020\u0004*\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0'\u001a\n\u0010(\u001a\u00020\u0004*\u00020\u001e\u001a\n\u0010)\u001a\u00020\u0004*\u00020\u001e\u001a\n\u0010*\u001a\u00020\u0004*\u00020%\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006+"}, d2={"logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "defaultToPerExecutionAction", "", "maxActionableAlertCount", "", "monitorId", "", "triggerId", "totalActionableAlertCount", "", "monitorOrTriggerError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isValidEmail", "email", "updateMonitorMetadata", "Lorg/opensearch/action/index/IndexResponse;", "client", "Lorg/opensearch/client/Client;", "settings", "Lorg/opensearch/common/settings/Settings;", "monitorMetadata", "Lorg/opensearch/alerting/model/MonitorMetadata;", "(Lorg/opensearch/client/Client;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/alerting/model/MonitorMetadata;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getActionExecutionPolicy", "Lorg/opensearch/alerting/model/action/ActionExecutionPolicy;", "Lorg/opensearch/alerting/model/action/Action;", "monitor", "Lorg/opensearch/alerting/model/Monitor;", "getBucketKeysHash", "Lorg/opensearch/alerting/model/AggregationResultBucket;", "getCombinedTriggerRunResult", "Lorg/opensearch/alerting/model/BucketLevelTriggerRunResult;", "prevTriggerRunResult", "isAllowed", "Lorg/opensearch/alerting/model/destination/Destination;", "allowList", "", "isBucketLevelMonitor", "isDocLevelMonitor", "isTestAction", "opensearch-alerting"})
public final class AlertingUtilsKt {
    private static final Logger logger = LogManager.getLogger((String)"AlertingUtils");

    public static final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Regex validEmailPattern = new Regex("(?:[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", RegexOption.IGNORE_CASE);
        return validEmailPattern.matches((CharSequence)email);
    }

    public static final boolean isAllowed(@NotNull Destination $this$isAllowed, @NotNull List<String> allowList) {
        Intrinsics.checkNotNullParameter((Object)$this$isAllowed, (String)"<this>");
        Intrinsics.checkNotNullParameter(allowList, (String)"allowList");
        return allowList.contains($this$isAllowed.getType().getValue());
    }

    public static final boolean isTestAction(@NotNull Destination $this$isTestAction) {
        Intrinsics.checkNotNullParameter((Object)$this$isTestAction, (String)"<this>");
        return $this$isTestAction.getType() == DestinationType.TEST_ACTION;
    }

    public static final boolean isBucketLevelMonitor(@NotNull Monitor $this$isBucketLevelMonitor) {
        Intrinsics.checkNotNullParameter((Object)$this$isBucketLevelMonitor, (String)"<this>");
        return $this$isBucketLevelMonitor.getMonitorType() == Monitor.MonitorType.BUCKET_LEVEL_MONITOR;
    }

    public static final boolean isDocLevelMonitor(@NotNull Monitor $this$isDocLevelMonitor) {
        Intrinsics.checkNotNullParameter((Object)$this$isDocLevelMonitor, (String)"<this>");
        return $this$isDocLevelMonitor.getMonitorType() == Monitor.MonitorType.DOC_LEVEL_MONITOR;
    }

    @NotNull
    public static final String getBucketKeysHash(@NotNull AggregationResultBucket $this$getBucketKeysHash) {
        Intrinsics.checkNotNullParameter((Object)$this$getBucketKeysHash, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$getBucketKeysHash.getBucketKeys(), (CharSequence)"#", null, null, (int)0, null, null, (int)62, null);
    }

    @Nullable
    public static final ActionExecutionPolicy getActionExecutionPolicy(@NotNull Action $this$getActionExecutionPolicy, @NotNull Monitor monitor) {
        Intrinsics.checkNotNullParameter((Object)$this$getActionExecutionPolicy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        ActionExecutionPolicy actionExecutionPolicy = $this$getActionExecutionPolicy.getActionExecutionPolicy();
        return actionExecutionPolicy == null ? (AlertingUtilsKt.isBucketLevelMonitor(monitor) ? ActionExecutionPolicy.Companion.getDefaultConfigurationForBucketLevelMonitor() : (AlertingUtilsKt.isDocLevelMonitor(monitor) ? ActionExecutionPolicy.Companion.getDefaultConfigurationForDocumentLevelMonitor() : (ActionExecutionPolicy)null)) : actionExecutionPolicy;
    }

    @NotNull
    public static final BucketLevelTriggerRunResult getCombinedTriggerRunResult(@NotNull BucketLevelTriggerRunResult $this$getCombinedTriggerRunResult, @Nullable BucketLevelTriggerRunResult prevTriggerRunResult) {
        Intrinsics.checkNotNullParameter((Object)$this$getCombinedTriggerRunResult, (String)"<this>");
        if (prevTriggerRunResult == null) {
            return $this$getCombinedTriggerRunResult;
        }
        Map mergedAggregationResultBuckets = MapsKt.plus(prevTriggerRunResult.getAggregationResultBuckets(), $this$getCombinedTriggerRunResult.getAggregationResultBuckets());
        Map mergedActionResultsMap = MapsKt.toMutableMap((Map)MapsKt.plus(prevTriggerRunResult.getActionResultsMap(), $this$getCombinedTriggerRunResult.getActionResultsMap()));
        Exception exception = $this$getCombinedTriggerRunResult.getError();
        if (exception == null) {
            exception = prevTriggerRunResult.getError();
        }
        Exception error = exception;
        return BucketLevelTriggerRunResult.copy$default($this$getCombinedTriggerRunResult, null, error, mergedAggregationResultBuckets, mergedActionResultsMap, 1, null);
    }

    public static final boolean defaultToPerExecutionAction(long maxActionableAlertCount, @NotNull String monitorId, @NotNull String triggerId, int totalActionableAlertCount, @Nullable Exception monitorOrTriggerError) {
        Intrinsics.checkNotNullParameter((Object)monitorId, (String)"monitorId");
        Intrinsics.checkNotNullParameter((Object)triggerId, (String)"triggerId");
        if (monitorOrTriggerError != null) {
            logger.debug("Trigger [" + triggerId + "] in monitor [" + monitorId + "] encountered an error. Defaulting to [" + ActionExecutionScope.Type.PER_EXECUTION + "] for action execution to communicate error.");
            return true;
        }
        if (maxActionableAlertCount < 0L) {
            return false;
        }
        if ((long)totalActionableAlertCount > maxActionableAlertCount) {
            logger.debug("The total actionable alerts for trigger [" + triggerId + "] in monitor [" + monitorId + "] is [" + totalActionableAlertCount + "] which exceeds the maximum of [" + maxActionableAlertCount + "]. Defaulting to [" + ActionExecutionScope.Type.PER_EXECUTION + "] for action execution.");
            return true;
        }
        return false;
    }

    @Nullable
    public static final Object updateMonitorMetadata(@NotNull Client client, @NotNull Settings settings, @NotNull MonitorMetadata monitorMetadata, @NotNull Continuation<? super IndexResponse> $completion) {
        IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
        IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(monitorMetadata.toXContent(xContentBuilder, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).id(monitorMetadata.getId()).timeout((TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(settings));
        return OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)client), (Function2)((Function2)new Function2<Client, ActionListener<IndexResponse>, Unit>(client, indexRequest2){
            final /* synthetic */ Client $client;
            final /* synthetic */ IndexRequest $indexRequest;
            {
                this.$client = $client;
                this.$indexRequest = $indexRequest;
                super(2);
            }

            public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<IndexResponse> it) {
                Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$client.index(this.$indexRequest, it);
            }
        }), $completion);
    }
}

