/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportActionKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.commons.authuser.User;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001JD\u0010\b\u001a\u00020\u0003\"\b\b\u0000\u0010\t*\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0012\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u0014\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J*\u0010\u001c\u001a\u00020\u0003\"\b\b\u0000\u0010\t*\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u000eH\u0016R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/alerting/transport/SecureTransportAction;", "", "filterByEnabled", "", "getFilterByEnabled", "()Z", "setFilterByEnabled", "(Z)V", "checkUserPermissionsWithResource", "T", "requesterUser", "Lorg/opensearch/commons/authuser/User;", "resourceUser", "actionListener", "Lorg/opensearch/action/ActionListener;", "resourceType", "", "resourceId", "doFilterForUser", "user", "isAdmin", "listenFilterBySettingChange", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "readUserFromThreadContext", "client", "Lorg/opensearch/client/Client;", "validateUserBackendRoles", "opensearch-alerting"})
public interface SecureTransportAction {
    public boolean getFilterByEnabled();

    public void setFilterByEnabled(boolean var1);

    public void listenFilterBySettingChange(@NotNull ClusterService var1);

    @Nullable
    public User readUserFromThreadContext(@NotNull Client var1);

    public boolean doFilterForUser(@Nullable User var1);

    public <T> boolean validateUserBackendRoles(@Nullable User var1, @NotNull ActionListener<T> var2);

    public <T> boolean checkUserPermissionsWithResource(@Nullable User var1, @Nullable User var2, @NotNull ActionListener<T> var3, @NotNull String var4, @NotNull String var5);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void listenFilterBySettingChange(@NotNull SecureTransportAction this_, @NotNull ClusterService clusterService) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
            clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> DefaultImpls.listenFilterBySettingChange$lambda-0(this_, arg_0));
        }

        @Nullable
        public static User readUserFromThreadContext(@NotNull SecureTransportAction this_, @NotNull Client client) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            String userStr = (String)client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
            SecureTransportActionKt.access$getLog$p().debug("User and roles string from thread context: " + userStr);
            return User.parse((String)userStr);
        }

        public static boolean doFilterForUser(@NotNull SecureTransportAction this_, @Nullable User user) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            SecureTransportActionKt.access$getLog$p().debug("Is filterByEnabled: " + this_.getFilterByEnabled() + " ; Is admin user: " + DefaultImpls.isAdmin(this_, user));
            return DefaultImpls.isAdmin(this_, user) ? false : this_.getFilterByEnabled();
        }

        private static boolean isAdmin(SecureTransportAction this_, User user) {
            boolean bl;
            if (user == null) {
                bl = false;
            } else {
                List list = user.getRoles();
                if (list == null ? false : ((Collection)list).isEmpty()) {
                    bl = false;
                } else {
                    List list2 = user.getRoles();
                    bl = list2 == null ? false : list2.contains("all_access");
                }
            }
            return bl;
        }

        public static <T> boolean validateUserBackendRoles(@NotNull SecureTransportAction this_, @Nullable User user, @NotNull ActionListener<T> actionListener) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            if (this_.getFilterByEnabled()) {
                if (user == null) {
                    actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Filter by user backend roles is enabled with security disabled.", RestStatus.FORBIDDEN, new Object[0])));
                    return false;
                }
                if (DefaultImpls.isAdmin(this_, user)) {
                    return true;
                }
                Collection collection = user.getBackendRoles();
                if (collection == null || collection.isEmpty()) {
                    actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("User doesn't have backend roles configured. Contact administrator", RestStatus.FORBIDDEN, new Object[0])));
                    return false;
                }
            }
            return true;
        }

        public static <T> boolean checkUserPermissionsWithResource(@NotNull SecureTransportAction this_, @Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
            List requesterBackendRoles;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
            if (!this_.doFilterForUser(requesterUser)) {
                return true;
            }
            User user = resourceUser;
            List resourceBackendRoles = user == null ? null : user.getBackendRoles();
            User user2 = requesterUser;
            List list = requesterBackendRoles = user2 == null ? null : user2.getBackendRoles();
            if (resourceBackendRoles == null || requesterBackendRoles == null || CollectionsKt.intersect((Iterable)resourceBackendRoles, (Iterable)requesterBackendRoles).isEmpty()) {
                actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Do not have permissions to resource, " + resourceType + ", with id, " + resourceId, RestStatus.FORBIDDEN, new Object[0])));
                return false;
            }
            return true;
        }

        private static void listenFilterBySettingChange$lambda-0(SecureTransportAction this$0, Boolean it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this$0.setFilterByEnabled(it);
        }
    }
}

