/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.SetOnce;
import org.opensearch.Version;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.TriFunction;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.CompositeIndexEventListener;
import org.opensearch.index.Index;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.IndexingSlowLog;
import org.opensearch.index.SearchSlowLog;
import org.opensearch.index.analysis.AnalysisRegistry;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.cache.query.DisabledQueryCache;
import org.opensearch.index.cache.query.IndexQueryCache;
import org.opensearch.index.cache.query.QueryCache;
import org.opensearch.index.engine.EngineConfigFactory;
import org.opensearch.index.engine.EngineFactory;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.index.shard.SearchOperationListener;
import org.opensearch.index.similarity.SimilarityService;
import org.opensearch.index.store.FsDirectoryFactory;
import org.opensearch.indices.IndicesQueryCache;
import org.opensearch.indices.breaker.CircuitBreakerService;
import org.opensearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.opensearch.indices.mapper.MapperRegistry;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.plugins.IndexStorePlugin;
import org.opensearch.script.ScriptService;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.threadpool.ThreadPool;

public final class IndexModule {
    public static final Setting<Boolean> NODE_STORE_ALLOW_MMAP = Setting.boolSetting("node.store.allow_mmap", true, Setting.Property.NodeScope);
    private static final FsDirectoryFactory DEFAULT_DIRECTORY_FACTORY = new FsDirectoryFactory();
    private static final IndexStorePlugin.RecoveryStateFactory DEFAULT_RECOVERY_STATE_FACTORY = RecoveryState::new;
    public static final Setting<String> INDEX_STORE_TYPE_SETTING = new Setting("index.store.type", "", Function.identity(), Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final Setting<String> INDEX_RECOVERY_TYPE_SETTING = new Setting("index.recovery.type", "", Function.identity(), Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final Setting<List<String>> INDEX_STORE_PRE_LOAD_SETTING = Setting.listSetting("index.store.preload", Collections.emptyList(), Function.identity(), Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final Setting<List<String>> INDEX_STORE_HYBRID_MMAP_EXTENSIONS = Setting.listSetting("index.store.hybrid.mmap.extensions", List.of("nvd", "dvd", "tim", "tip", "dim", "kdd", "kdi", "cfs", "doc"), Function.identity(), Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final String SIMILARITY_SETTINGS_PREFIX = "index.similarity";
    public static final Setting<Boolean> INDEX_QUERY_CACHE_ENABLED_SETTING = Setting.boolSetting("index.queries.cache.enabled", true, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_QUERY_CACHE_EVERYTHING_SETTING = Setting.boolSetting("index.queries.cache.everything", false, Setting.Property.IndexScope);
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(IndexModule.class);
    private final IndexSettings indexSettings;
    private final AnalysisRegistry analysisRegistry;
    private final EngineFactory engineFactory;
    private final EngineConfigFactory engineConfigFactory;
    private SetOnce<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> indexReaderWrapper = new SetOnce();
    private final Set<IndexEventListener> indexEventListeners = new HashSet<IndexEventListener>();
    private final Map<String, TriFunction<Settings, Version, ScriptService, Similarity>> similarities = new HashMap<String, TriFunction<Settings, Version, ScriptService, Similarity>>();
    private final Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories;
    private final SetOnce<BiFunction<IndexSettings, IndicesQueryCache, QueryCache>> forceQueryCacheProvider = new SetOnce();
    private final List<SearchOperationListener> searchOperationListeners = new ArrayList<SearchOperationListener>();
    private final List<IndexingOperationListener> indexOperationListeners = new ArrayList<IndexingOperationListener>();
    private final IndexNameExpressionResolver expressionResolver;
    private final AtomicBoolean frozen = new AtomicBoolean(false);
    private final BooleanSupplier allowExpensiveQueries;
    private final Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories;

    public IndexModule(IndexSettings indexSettings, AnalysisRegistry analysisRegistry, EngineFactory engineFactory, EngineConfigFactory engineConfigFactory, Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories, BooleanSupplier allowExpensiveQueries, IndexNameExpressionResolver expressionResolver, Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories) {
        this.indexSettings = indexSettings;
        this.analysisRegistry = analysisRegistry;
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.engineConfigFactory = Objects.requireNonNull(engineConfigFactory);
        this.searchOperationListeners.add(new SearchSlowLog(indexSettings));
        this.indexOperationListeners.add(new IndexingSlowLog(indexSettings));
        this.directoryFactories = Collections.unmodifiableMap(directoryFactories);
        this.allowExpensiveQueries = allowExpensiveQueries;
        this.expressionResolver = expressionResolver;
        this.recoveryStateFactories = recoveryStateFactories;
    }

    public <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer) {
        this.ensureNotFrozen();
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(setting, consumer);
    }

    public <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer, Consumer<T> validator) {
        this.ensureNotFrozen();
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(setting, consumer, validator);
    }

    public Settings getSettings() {
        return this.indexSettings.getSettings();
    }

    public Index getIndex() {
        return this.indexSettings.getIndex();
    }

    EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    public void addIndexEventListener(IndexEventListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.indexEventListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.indexEventListeners.add(listener);
    }

    public void addSearchOperationListener(SearchOperationListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.searchOperationListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.searchOperationListeners.add(listener);
    }

    public void addIndexOperationListener(IndexingOperationListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.indexOperationListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.indexOperationListeners.add(listener);
    }

    public void addSimilarity(String name, TriFunction<Settings, Version, ScriptService, Similarity> similarity) {
        this.ensureNotFrozen();
        if (this.similarities.containsKey(name) || SimilarityService.BUILT_IN.containsKey(name)) {
            throw new IllegalArgumentException("similarity for name: [" + name + " is already registered");
        }
        this.similarities.put(name, similarity);
    }

    public void setReaderWrapper(Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>> indexReaderWrapperFactory) {
        this.ensureNotFrozen();
        this.indexReaderWrapper.set(indexReaderWrapperFactory);
    }

    IndexEventListener freeze() {
        if (this.frozen.compareAndSet(false, true)) {
            return new CompositeIndexEventListener(this.indexSettings, this.indexEventListeners);
        }
        throw new IllegalStateException("already frozen");
    }

    public static boolean isBuiltinType(String storeType) {
        for (Type type : Type.values()) {
            if (!type.match(storeType)) continue;
            return true;
        }
        return false;
    }

    public static Type defaultStoreType(boolean allowMmap) {
        if (allowMmap && Constants.JRE_IS_64BIT && MMapDirectory.UNMAP_SUPPORTED) {
            return Type.HYBRIDFS;
        }
        return Type.NIOFS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexService newIndexService(IndexService.IndexCreationContext indexCreationContext, NodeEnvironment environment, NamedXContentRegistry xContentRegistry, IndexService.ShardStoreDeleter shardStoreDeleter, CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ThreadPool threadPool, ScriptService scriptService, ClusterService clusterService, Client client, IndicesQueryCache indicesQueryCache, MapperRegistry mapperRegistry, IndicesFieldDataCache indicesFieldDataCache, NamedWriteableRegistry namedWriteableRegistry, BooleanSupplier idFieldDataEnabled, ValuesSourceRegistry valuesSourceRegistry, IndexStorePlugin.RemoteDirectoryFactory remoteDirectoryFactory) throws IOException {
        IndexService indexService;
        block4: {
            IndexEventListener eventListener = this.freeze();
            Function readerWrapperFactory = this.indexReaderWrapper.get() == null ? shard -> null : (Function)this.indexReaderWrapper.get();
            eventListener.beforeIndexCreated(this.indexSettings.getIndex(), this.indexSettings.getSettings());
            IndexStorePlugin.DirectoryFactory directoryFactory = IndexModule.getDirectoryFactory(this.indexSettings, this.directoryFactories);
            IndexStorePlugin.RecoveryStateFactory recoveryStateFactory = IndexModule.getRecoveryStateFactory(this.indexSettings, this.recoveryStateFactories);
            QueryCache queryCache = null;
            IndexAnalyzers indexAnalyzers = null;
            boolean success = false;
            try {
                BiFunction queryCacheProvider;
                queryCache = this.indexSettings.getValue(INDEX_QUERY_CACHE_ENABLED_SETTING).booleanValue() ? ((queryCacheProvider = (BiFunction)this.forceQueryCacheProvider.get()) == null ? new IndexQueryCache(this.indexSettings, indicesQueryCache) : (QueryCache)queryCacheProvider.apply(this.indexSettings, indicesQueryCache)) : new DisabledQueryCache(this.indexSettings);
                if (IndexService.needsMapperService(this.indexSettings, indexCreationContext)) {
                    indexAnalyzers = this.analysisRegistry.build(this.indexSettings);
                }
                IndexService indexService2 = new IndexService(this.indexSettings, indexCreationContext, environment, xContentRegistry, new SimilarityService(this.indexSettings, scriptService, this.similarities), shardStoreDeleter, indexAnalyzers, this.engineFactory, this.engineConfigFactory, circuitBreakerService, bigArrays, threadPool, scriptService, clusterService, client, queryCache, directoryFactory, remoteDirectoryFactory, eventListener, readerWrapperFactory, mapperRegistry, indicesFieldDataCache, this.searchOperationListeners, this.indexOperationListeners, namedWriteableRegistry, idFieldDataEnabled, this.allowExpensiveQueries, this.expressionResolver, valuesSourceRegistry, recoveryStateFactory);
                success = true;
                indexService = indexService2;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{queryCache, indexAnalyzers});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{queryCache, indexAnalyzers});
        }
        return indexService;
    }

    private static IndexStorePlugin.DirectoryFactory getDirectoryFactory(IndexSettings indexSettings, Map<String, IndexStorePlugin.DirectoryFactory> indexStoreFactories) {
        IndexStorePlugin.DirectoryFactory factory;
        String storeType = indexSettings.getValue(INDEX_STORE_TYPE_SETTING);
        Boolean allowMmap = NODE_STORE_ALLOW_MMAP.get(indexSettings.getNodeSettings());
        Type type = storeType.isEmpty() || Type.FS.getSettingsKey().equals(storeType) ? IndexModule.defaultStoreType(allowMmap) : (IndexModule.isBuiltinType(storeType) ? Type.fromSettingsKey(storeType) : null);
        if (!(allowMmap.booleanValue() || type != Type.MMAPFS && type != Type.HYBRIDFS)) {
            throw new IllegalArgumentException("store type [" + storeType + "] is not allowed because mmap is disabled");
        }
        if (storeType.isEmpty() || IndexModule.isBuiltinType(storeType)) {
            factory = DEFAULT_DIRECTORY_FACTORY;
        } else {
            factory = indexStoreFactories.get(storeType);
            if (factory == null) {
                throw new IllegalArgumentException("Unknown store type [" + storeType + "]");
            }
        }
        return factory;
    }

    private static IndexStorePlugin.RecoveryStateFactory getRecoveryStateFactory(IndexSettings indexSettings, Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories) {
        String recoveryType = indexSettings.getValue(INDEX_RECOVERY_TYPE_SETTING);
        if (recoveryType.isEmpty()) {
            return DEFAULT_RECOVERY_STATE_FACTORY;
        }
        IndexStorePlugin.RecoveryStateFactory factory = recoveryStateFactories.get(recoveryType);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown recovery type [" + recoveryType + "]");
        }
        return factory;
    }

    public MapperService newIndexMapperService(NamedXContentRegistry xContentRegistry, MapperRegistry mapperRegistry, ScriptService scriptService) throws IOException {
        return new MapperService(this.indexSettings, this.analysisRegistry.build(this.indexSettings), xContentRegistry, new SimilarityService(this.indexSettings, scriptService, this.similarities), mapperRegistry, () -> {
            throw new UnsupportedOperationException("no index query shard context available");
        }, () -> false, scriptService);
    }

    public void forceQueryCacheProvider(BiFunction<IndexSettings, IndicesQueryCache, QueryCache> queryCacheProvider) {
        this.ensureNotFrozen();
        this.forceQueryCacheProvider.set(queryCacheProvider);
    }

    private void ensureNotFrozen() {
        if (this.frozen.get()) {
            throw new IllegalStateException("Can't modify IndexModule once the index service has been created");
        }
    }

    public static enum Type {
        HYBRIDFS("hybridfs"),
        NIOFS("niofs"),
        MMAPFS("mmapfs"),
        SIMPLEFS("simplefs"),
        FS("fs");

        private final String settingsKey;
        private final boolean deprecated;
        private static final Map<String, Type> TYPES;

        private Type(String settingsKey) {
            this(settingsKey, false);
        }

        private Type(String settingsKey, boolean deprecated) {
            this.settingsKey = settingsKey;
            this.deprecated = deprecated;
        }

        public String getSettingsKey() {
            return this.settingsKey;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public static Type fromSettingsKey(String key) {
            Type type = TYPES.get(key);
            if (type == null) {
                throw new IllegalArgumentException("no matching store type for [" + key + "]");
            }
            if (type.isDeprecated()) {
                DEPRECATION_LOGGER.deprecate(type.getSettingsKey(), " is deprecated and will be removed in 2.0", new Object[0]);
            }
            return type;
        }

        public boolean match(String setting) {
            return this.getSettingsKey().equals(setting);
        }

        static {
            HashMap<String, Type> types = new HashMap<String, Type>(4);
            for (Type type : Type.values()) {
                types.put(type.settingsKey, type);
            }
            TYPES = Collections.unmodifiableMap(types);
        }
    }
}

