/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionType;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.BaseNodeRequest;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.shard.ShardStateMetadata;
import org.opensearch.index.store.Store;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportNodesListGatewayStartedShards
extends TransportNodesAction<Request, NodesGatewayStartedShards, NodeRequest, NodeGatewayStartedShards>
implements AsyncShardFetch.Lister<NodesGatewayStartedShards, NodeGatewayStartedShards> {
    public static final String ACTION_NAME = "internal:gateway/local/started_shards";
    public static final ActionType<NodesGatewayStartedShards> TYPE = new ActionType<NodesGatewayStartedShards>("internal:gateway/local/started_shards", NodesGatewayStartedShards::new);
    private final Settings settings;
    private final NodeEnvironment nodeEnv;
    private final IndicesService indicesService;
    private final NamedXContentRegistry namedXContentRegistry;

    @Inject
    public TransportNodesListGatewayStartedShards(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeEnvironment env, IndicesService indicesService, NamedXContentRegistry namedXContentRegistry) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "fetch_shard_started", NodeGatewayStartedShards.class);
        this.settings = settings;
        this.nodeEnv = env;
        this.indicesService = indicesService;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    @Override
    public void list(ShardId shardId, String customDataPath, DiscoveryNode[] nodes, ActionListener<NodesGatewayStartedShards> listener) {
        this.execute(new Request(shardId, customDataPath, nodes), listener);
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeGatewayStartedShards newNodeResponse(StreamInput in) throws IOException {
        return new NodeGatewayStartedShards(in);
    }

    @Override
    protected NodesGatewayStartedShards newResponse(Request request, List<NodeGatewayStartedShards> responses, List<FailedNodeException> failures) {
        return new NodesGatewayStartedShards(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeGatewayStartedShards nodeOperation(NodeRequest request) {
        try {
            ShardId shardId = request.getShardId();
            this.logger.trace("{} loading local shard state info", (Object)shardId);
            ShardStateMetadata shardStateMetadata = ShardStateMetadata.FORMAT.loadLatestState(this.logger, this.namedXContentRegistry, this.nodeEnv.availableShardPaths(request.shardId));
            if (shardStateMetadata != null) {
                if (this.indicesService.getShardOrNull(shardId) == null) {
                    String customDataPath;
                    if (request.getCustomDataPath() != null) {
                        customDataPath = request.getCustomDataPath();
                    } else {
                        IndexMetadata metadata = this.clusterService.state().metadata().index(shardId.getIndex());
                        if (metadata != null) {
                            customDataPath = new IndexSettings(metadata, this.settings).customDataPath();
                        } else {
                            this.logger.trace("{} node doesn't have meta data for the requests index", (Object)shardId);
                            throw new OpenSearchException("node doesn't have meta data for index " + shardId.getIndex(), new Object[0]);
                        }
                    }
                    ShardPath shardPath = null;
                    try {
                        shardPath = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, customDataPath);
                        if (shardPath == null) {
                            throw new IllegalStateException(shardId + " no shard path found");
                        }
                        Store.tryOpenIndex(shardPath.resolveIndex(), shardId, this.nodeEnv::shardLock, this.logger);
                    }
                    catch (Exception exception) {
                        ShardPath finalShardPath = shardPath;
                        this.logger.trace(() -> new ParameterizedMessage("{} can't open index for shard [{}] in path [{}]", new Object[]{shardId, shardStateMetadata, finalShardPath != null ? finalShardPath.resolveIndex() : ""}), (Throwable)exception);
                        String allocationId = shardStateMetadata.allocationId != null ? shardStateMetadata.allocationId.getId() : null;
                        return new NodeGatewayStartedShards(this.clusterService.localNode(), allocationId, shardStateMetadata.primary, null, exception);
                    }
                }
                this.logger.debug("{} shard state info found: [{}]", (Object)shardId, (Object)shardStateMetadata);
                String allocationId = shardStateMetadata.allocationId != null ? shardStateMetadata.allocationId.getId() : null;
                IndexShard shard = (IndexShard)this.indicesService.getShardOrNull(shardId);
                return new NodeGatewayStartedShards(this.clusterService.localNode(), allocationId, shardStateMetadata.primary, shard != null ? shard.getLatestReplicationCheckpoint() : null);
            }
            this.logger.trace("{} no local shard info found", (Object)shardId);
            return new NodeGatewayStartedShards(this.clusterService.localNode(), null, false, null);
        }
        catch (Exception e) {
            throw new OpenSearchException("failed to load started shards", (Throwable)e, new Object[0]);
        }
    }

    public static class NodeGatewayStartedShards
    extends BaseNodeResponse {
        private final String allocationId;
        private final boolean primary;
        private final Exception storeException;
        private final ReplicationCheckpoint replicationCheckpoint;

        public NodeGatewayStartedShards(StreamInput in) throws IOException {
            super(in);
            this.allocationId = in.readOptionalString();
            this.primary = in.readBoolean();
            this.storeException = in.readBoolean() ? in.readException() : null;
            this.replicationCheckpoint = in.getVersion().onOrAfter(Version.V_2_3_0) && in.readBoolean() ? new ReplicationCheckpoint(in) : null;
        }

        public NodeGatewayStartedShards(DiscoveryNode node, String allocationId, boolean primary, ReplicationCheckpoint replicationCheckpoint) {
            this(node, allocationId, primary, replicationCheckpoint, null);
        }

        public NodeGatewayStartedShards(DiscoveryNode node, String allocationId, boolean primary, ReplicationCheckpoint replicationCheckpoint, Exception storeException) {
            super(node);
            this.allocationId = allocationId;
            this.primary = primary;
            this.replicationCheckpoint = replicationCheckpoint;
            this.storeException = storeException;
        }

        public String allocationId() {
            return this.allocationId;
        }

        public boolean primary() {
            return this.primary;
        }

        public ReplicationCheckpoint replicationCheckpoint() {
            return this.replicationCheckpoint;
        }

        public Exception storeException() {
            return this.storeException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.allocationId);
            out.writeBoolean(this.primary);
            if (this.storeException != null) {
                out.writeBoolean(true);
                out.writeException(this.storeException);
            } else {
                out.writeBoolean(false);
            }
            if (out.getVersion().onOrAfter(Version.V_2_3_0)) {
                if (this.replicationCheckpoint != null) {
                    out.writeBoolean(true);
                    this.replicationCheckpoint.writeTo(out);
                } else {
                    out.writeBoolean(false);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeGatewayStartedShards that = (NodeGatewayStartedShards)o;
            return this.primary == that.primary && Objects.equals(this.allocationId, that.allocationId) && Objects.equals(this.storeException, that.storeException) && Objects.equals(this.replicationCheckpoint, that.replicationCheckpoint);
        }

        public int hashCode() {
            int result = this.allocationId != null ? this.allocationId.hashCode() : 0;
            result = 31 * result + (this.primary ? 1 : 0);
            result = 31 * result + (this.storeException != null ? this.storeException.hashCode() : 0);
            result = 31 * result + (this.replicationCheckpoint != null ? this.replicationCheckpoint.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("NodeGatewayStartedShards[").append("allocationId=").append(this.allocationId).append(",primary=").append(this.primary);
            if (this.storeException != null) {
                buf.append(",storeException=").append(this.storeException);
            }
            if (this.replicationCheckpoint != null) {
                buf.append(",ReplicationCheckpoint=").append(this.replicationCheckpoint.toString());
            }
            buf.append("]");
            return buf.toString();
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.customDataPath = in.getVersion().onOrAfter(LegacyESVersion.V_7_6_0) ? in.readString() : null;
        }

        public NodeRequest(Request request) {
            this.shardId = Objects.requireNonNull(request.shardId());
            this.customDataPath = Objects.requireNonNull(request.getCustomDataPath());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            if (out.getVersion().onOrAfter(LegacyESVersion.V_7_6_0)) {
                assert (this.customDataPath != null);
                out.writeString(this.customDataPath);
            }
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }
    }

    public static class NodesGatewayStartedShards
    extends BaseNodesResponse<NodeGatewayStartedShards> {
        public NodesGatewayStartedShards(StreamInput in) throws IOException {
            super(in);
        }

        public NodesGatewayStartedShards(ClusterName clusterName, List<NodeGatewayStartedShards> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeGatewayStartedShards> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeGatewayStartedShards::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeGatewayStartedShards> nodes) throws IOException {
            out.writeList(nodes);
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.customDataPath = in.getVersion().onOrAfter(LegacyESVersion.V_7_6_0) ? in.readString() : null;
        }

        public Request(ShardId shardId, String customDataPath, DiscoveryNode[] nodes) {
            super(nodes);
            this.shardId = Objects.requireNonNull(shardId);
            this.customDataPath = Objects.requireNonNull(customDataPath);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            if (out.getVersion().onOrAfter(LegacyESVersion.V_7_6_0)) {
                out.writeString(this.customDataPath);
            }
        }
    }
}

