Welcome to Metasploit-land. Are you a Metasploit user who wants to get started or get better at hacking stuff (that you have permission to hack)? The quickest way to get started is to [download the Metasploit nightly installers](https://github.com/rapid7/metasploit-framework/wiki/Nightly-Installers). This will give you access to both the free, open-source Metasploit Framework and a free trial of Metasploit Pro.

If you're using [Kali Linux](https://kali.org/), Metasploit is already pre-installed. See the [Kali documentation](https://kali.org/docs/tools/starting-metasploit-framework-in-kali/) for how to get started using Metasploit in Kali Linux.

Are you anxious to get your [Metasploit Development Environment](https://github.com/rapid7/metasploit-framework/wiki/Setting-Up-a-Metasploit-Development-Environment) set up so you can start [[Landing Pull Requests]] and contributing excellent exploit code? If so, you're in the right place. If you're an exploit developer, you will want to review our [[Guidelines for Accepting Modules and Enhancements]] to find out what we expect when we see pull requests for new Metasploit modules. No idea what you should start working on? Check out the guidelines for [[contributing to Metasploit]], and dive into [[Setting Up a Metasploit Development Environment]].

# Getting Started #

- [[Setting Up a Metasploit Development Environment]]
- [[Using Metasploit]]
- [[Using Git]]
- [[Reporting a Bug]]
- [[Navigating and Understanding Metasploit's Codebase|./Navigating-and-Understanding-Metasploits-Codebase.md]]

# Contributing

- [[Contributing to Metasploit]]
- [[Creating Metasploit Framework LoginScanners]]
- [[Guidelines for Accepting Modules and Enhancements]]
- [[Common Metasploit Module Coding Mistakes]]
- [[Style Tips]]
- [[Committer Rights]]
- [[Landing Pull Requests]]

# Metasploit Development #

- [[Style Tips]]
- [[Get Started Writing an Exploit]]
- [[How to get started with writing an auxiliary module]]
- [[How to get started with writing a post module]]
- [[How to get started with writing a Meterpreter script]]
- [[Running Private Modules]]
- [[Exploit Ranking]]
- [[Module Reference Identifiers]]
- [[How to check Microsoft patch levels for your exploit]]
- [[How to clean up files using FileDropper]]
- [[How to deprecate a Metasploit module]]
- [[How to do reporting or store data in module development]]
- [[How to log in Metasploit]]
- [[How to obfuscate JavaScript in Metasploit]]
- [[How to parse an HTTP response]]
- [[How to Send an HTTP Request Using HTTPClient]]
- [[How to send an HTTP request using Rex Proto Http Client]]
- [[How to use command stagers]]
- [[How to use datastore options]]
- [[How to use Msf Auxiliary AuthBrute to write a bruteforcer]]
- [[How to use PhpEXE to exploit an arbitrary file upload bug]]
- [[How to use Powershell in an exploit]]
- [[How to use Railgun for Windows post exploitation]]
- [[How to Use the FILEFORMAT mixin to create a file format exploit]]
- [[How to use the Msf Exploit Remote Tcp mixin]]
- [[How to use the Seh mixin to exploit an exception handler]]
- [[How to use WbemExec for a write privilege attack on Windows]]
- [[How to write a browser exploit using BrowserExploitServer]]
- [[How to write a browser exploit using HttpServer]]
- [[How to write a check method]]
- [[How to write a HTTP LoginScanner Module]]
- [[How to write a module using HttpServer and HttpClient]]
- [[How to zip files with Msf::Util::EXE.to_zip|./How-to-zip-files-with-Msf-Util-EXE-to_zip.md]]
- [[How to use Metasploit Framework Compiler Windows to compile C code]]
- [[How to use Metasploit Framework Obfuscation CRandomizer]]
- [[How to decrypt RC4 with Metasploit Framework Compiler]]
- [[How to decode Base64 with Metasploit Framework Compiler]]
- [[How to XOR with Metasploit Framework Compiler]]
- [[Using ReflectiveDll Injection]]
- [[Oracle Usage]]
- [[Definition of Module Reliability, Side Effects, and Stability|./Definition-of-Module-Reliability-Side-Effects-and-Stability.md]]

# Metasploit Payloads #

- [[How Payloads Work]]
- [[Merging Metasploit Payload Gem Updates]]
- [[Meterpreter Configuration]]
- [[Meterpreter HTTP Communication]]
- [[Meterpreter Paranoid Mode]]
- [[Meterpreter Reliable Network Communication]]
- [[Meterpreter Sleep Control]]
- [[Meterpreter Stageless Mode]]
- [[Meterpreter Timeout Control]]
- [[Meterpreter Transport Control]]
- [[Meterpreter Unicode Support]]
- [[Payload UUID]]
- [[Python Extension]]
- [[The ins and outs of HTTP and HTTPS communications in Meterpreter and Metasploit Stagers]]


# Other Metasploit Resources #

- [[Metasploit 5.0 Release Notes]]
- [[Downloads by Version]]
- [[Evading Anti Virus]]
- [[How to use a Metasploit module appropriately]]
- [[How to use a reverse shell in Metasploit]]
- [[Information About Unmet Browser Exploit Requirements]]
- [[How to use msfvenom]]
- [[What my Rex Proto SMB Error means]]
- [[Why CVE Is Not Available]]

# GitHub Resources #

- [[Git Cheatsheet]]
- [[Git Reference Sites]]
- [[Remote Branch Pruning]]

