/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx;

import javafx.concurrent.Task;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.messages.FilmListReadStopEvent;
import mediathek.tool.MessageBus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilmListFilterTask
extends Task<Void> {
    private final Daten daten = Daten.getInstance();
    private final boolean submitEvent;
    private static final Logger logger = LogManager.getLogger(FilmListFilterTask.class);

    public FilmListFilterTask(boolean submitEvent) {
        this.submitEvent = submitEvent;
    }

    @Override
    protected Void call() {
        logger.trace("FilmListFilterTask started");
        if (this.submitEvent) {
            MessageBus.getMessageBus().publishAsync(new FilmListReadStopEvent());
        }
        this.updateMessage("Abos eintragen");
        this.updateProgress(-1L, 4L);
        this.daten.getListeAbo().setAboFuerFilm(this.daten.getListeFilme(), false);
        this.updateMessage("Alle Filter anwenden");
        this.updateProgress(-1L, 4L);
        this.daten.getListeBlacklist().filterListe();
        SwingUtilities.invokeLater(() -> this.daten.getFilmeLaden().notifyFertig(new ListenerFilmeLadenEvent("", "", 100, 100, false)));
        logger.trace("FilmListFilterTask finished");
        return null;
    }
}

