/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_downloads;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Taskbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TabPane;
import javafx.stage.Modality;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.Konstanten;
import mediathek.config.MVConfig;
import mediathek.controller.history.MVUsedUrl;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.DownloadInfos;
import mediathek.daten.DownloadStartInfo;
import mediathek.daten.ListeDownloads;
import mediathek.daten.abo.DatenAbo;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.TabPaneIndex;
import mediathek.gui.actions.ShowFilmInformationAction;
import mediathek.gui.dialog.DialogBeendenZeit;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.gui.dialog.DialogEditDownload;
import mediathek.gui.filmInformation.InfoDialog;
import mediathek.gui.messages.AboListChangedEvent;
import mediathek.gui.messages.BlacklistChangedEvent;
import mediathek.gui.messages.DownloadFilterVisibilityChangedEvent;
import mediathek.gui.messages.DownloadInfoUpdateAvailableEvent;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.gui.messages.DownloadProgressChangedEvent;
import mediathek.gui.messages.DownloadQueueRankChangedEvent;
import mediathek.gui.messages.DownloadRateLimitChangedEvent;
import mediathek.gui.messages.GeoStateChangedEvent;
import mediathek.gui.messages.ParallelDownloadNumberChangedEvent;
import mediathek.gui.messages.RestartDownloadEvent;
import mediathek.gui.messages.StartEvent;
import mediathek.gui.messages.UpdateStatusBarLeftDisplayEvent;
import mediathek.gui.tabs.AGuiTabPanel;
import mediathek.gui.toolbar.FXDownloadToolBar;
import mediathek.javafx.descriptionPanel.DescriptionPanelController;
import mediathek.javafx.downloadtab.DownloadTabInformationLabel;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.DirOpenAction;
import mediathek.tool.FileSize;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Listener;
import mediathek.tool.MVFilmSize;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MessageBus;
import mediathek.tool.NoSelectionErrorDialog;
import mediathek.tool.OpenPlayerAction;
import mediathek.tool.cellrenderer.CellRendererDownloads;
import mediathek.tool.datum.Datum;
import mediathek.tool.listener.BeobTableHeader;
import mediathek.tool.models.TModelDownload;
import mediathek.tool.table.MVDownloadsTable;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GuiDownloads
extends AGuiTabPanel {
    public static final String NAME = "Downloads";
    private static final String COMBO_DISPLAY_ALL = "alle";
    private static final String COMBO_DISPLAY_DOWNLOADS_ONLY = "nur Downloads";
    private static final String COMBO_DISPLAY_ABOS_ONLY = "nur Abos";
    private static final String COMBO_VIEW_ALL = "alle";
    private static final String COMBO_VIEW_NOT_STARTED = "nicht gestartet";
    private static final String COMBO_VIEW_STARTED = "gestartet";
    private static final String COMBO_VIEW_WAITING = "nur wartende";
    private static final String COMBO_VIEW_RUN_ONLY = "nur laufende";
    private static final String COMBO_VIEW_FINISHED_ONLY = "nur abgeschlossene";
    private static final String MENU_ITEM_TEXT_CLEANUP_DOWNLOADS = "Liste s\u00e4ubern";
    private static final String ACTION_MAP_KEY_EDIT_DOWNLOAD = "dl_aendern";
    private static final String ACTION_MAP_KEY_DELETE_DOWNLOAD = "dl_delete";
    private static final String ACTION_MAP_KEY_MARK_AS_SEEN = "seen";
    private static final String ACTION_MAP_KEY_MAERK_AS_UNSEEN = "unseen";
    private static final String ACTION_MAP_KEY_START_DOWNLOAD = "dl_start";
    private static final int[] COLUMNS_DISABLED = new int[]{6, 7, 39, 22};
    private static final Logger logger = LogManager.getLogger(GuiDownloads.class);
    private static final String HEAD = "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head><style type=\"text/css\"> .sans { font-family: Verdana, Geneva, sans-serif; }</style></head><body>";
    private static final String END = "</body></html>";
    private final AtomicLong _lastUpdate = new AtomicLong(0L);
    private final AtomicBoolean tabVisible = new AtomicBoolean(false);
    private final JCheckBoxMenuItem cbShowDownloadDescription = new JCheckBoxMenuItem("Filmbeschreibung anzeigen");
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private boolean onlyAbos;
    private boolean onlyDownloads;
    private boolean onlyWaiting;
    private boolean onlyNotStarted;
    private boolean onlyStarted;
    private boolean onlyFinished;
    private boolean onlyRun;
    private boolean loadFilmlist;
    private TModelDownload model;
    private DownloadTabInformationLabel filmInfoLabel;
    private MVDownloadsTable tabelle;
    private final AGuiTabPanel.MarkFilmAsSeenAction markFilmAsSeenAction = new AGuiTabPanel.MarkFilmAsSeenAction();
    private final AGuiTabPanel.MarkFilmAsUnseenAction markFilmAsUnseenAction = new AGuiTabPanel.MarkFilmAsUnseenAction();
    private JSplitPane jSplitPane1;
    private JPanel jPanelFilterExtern;
    private JComboBox<String> cbDisplayCategories;
    private JComboBox<String> cbView;
    private JButton btnClear;
    private JSpinner jSpinnerAnzahlDownloads;
    private JSpinner jSpinner1;
    private JEditorPane txtDownload;
    private JScrollPane downloadListScrollPane;
    private JFXPanel fxDescriptionPanel;
    private JFXPanel toolBarPanel;

    public GuiDownloads(Daten aDaten, MediathekGui mediathekGui) {
        this.daten = aDaten;
        this.mediathekGui = mediathekGui;
        this.initComponents();
        this.setupF4Key(mediathekGui);
        this.setupDownloadListTable();
        this.setupDescriptionPanel();
        this.showDescriptionPanel();
        this.init();
        this.installTabInfoStatusBarControl();
        this.setupFilmSelectionPropertyListener(mediathekGui);
        this.initTable();
        this.addListenerMediathekView();
        this.setupDisplayCategories();
        this.setupCheckboxView();
        this.setupToolBar();
        this.setupDownloadRateLimitSpinner();
        this.setupFilterPanel();
        this.setupComponentListener();
        if (Taskbar.isTaskbarSupported()) {
            this.setupTaskbarMenu();
        }
    }

    @Override
    public void tabelleSpeichern() {
        if (this.tabelle != null) {
            this.tabelle.writeTableConfigurationData();
        }
    }

    private void setupToolBar() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            final FXDownloadToolBar toolBar = new FXDownloadToolBar();
            toolBar.btnFilmInfo.setOnAction(e -> SwingUtilities.invokeLater(() -> MediathekGui.ui().getFilmInfoDialog().showInfo()));
            toolBar.btnUpdateDownloads.setOnAction(e -> SwingUtilities.invokeLater(this::updateDownloads));
            toolBar.btnStartAllDownloads.setOnAction(e -> SwingUtilities.invokeLater(() -> this.starten(true)));
            toolBar.btnPlayFilm.setOnAction(e -> SwingUtilities.invokeLater(this::filmAbspielen));
            toolBar.btnZurueckstellen.setOnAction(e -> SwingUtilities.invokeLater(() -> this.downloadLoeschen(false)));
            toolBar.btnRemoveDownload.setOnAction(e -> SwingUtilities.invokeLater(() -> this.downloadLoeschen(true)));
            toolBar.btnCleanup.setOnAction(e -> SwingUtilities.invokeLater(this::cleanupDownloads));
            toolBar.btnFilter.setOnAction(e -> SwingUtilities.invokeLater(() -> MessageBus.getMessageBus().publishAsync(new DownloadFilterVisibilityChangedEvent())));
            Daten.getInstance().getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

                @Override
                public void start(ListenerFilmeLadenEvent event) {
                    Platform.runLater(() -> toolBar2.btnUpdateDownloads.setDisable(true));
                }

                @Override
                public void fertig(ListenerFilmeLadenEvent event) {
                    Platform.runLater(() -> toolBar2.btnUpdateDownloads.setDisable(false));
                }
            });
            this.toolBarPanel.setScene(new Scene(toolBar));
        });
    }

    private void setupF4Key(final MediathekGui mediathekGui) {
        if (SystemUtils.IS_OS_WINDOWS) {
            InputMap im = this.cbDisplayCategories.getInputMap();
            im.put(KeyStroke.getKeyStroke(115, 0), "einstellungen");
            ActionMap am = this.cbDisplayCategories.getActionMap();
            am.put("einstellungen", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mediathekGui.getSettingsDialog().setVisible(true);
                }
            });
        }
    }

    private void setupFilmSelectionPropertyListener(final MediathekGui mediathekGui) {
        this.tabelle.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int sel = this.tabelle.getSelectedRowCount();
                Platform.runLater(() -> mediathekGui.getSelectedItemsProperty().setValue(sel));
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                int sel = GuiDownloads.this.tabelle.getSelectedRowCount();
                Platform.runLater(() -> mediathekGui.getSelectedItemsProperty().setValue(sel));
                GuiDownloads.this.onComponentShown();
            }
        });
    }

    @Override
    protected void installTabInfoStatusBarControl() {
        final ObservableList<Node> leftItems = this.mediathekGui.getStatusBarController().getStatusBar().getLeftItems();
        Platform.runLater(() -> {
            this.filmInfoLabel = new DownloadTabInformationLabel(this.daten);
            if (this.isVisible()) {
                leftItems.add(this.filmInfoLabel);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Platform.runLater(() -> {
                    GuiDownloads.this.filmInfoLabel.setVisible(true);
                    leftItems.add(GuiDownloads.this.filmInfoLabel);
                });
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Platform.runLater(() -> {
                    GuiDownloads.this.filmInfoLabel.setVisible(false);
                    leftItems.remove(GuiDownloads.this.filmInfoLabel);
                });
            }
        });
    }

    private void setupDownloadListTable() {
        this.tabelle = new MVDownloadsTable();
        this.downloadListScrollPane.setViewportView(this.tabelle);
    }

    private void setupDisplayCategories() {
        EventList<String> displaySelectionList = GlazedLists.eventListOf("alle", COMBO_DISPLAY_DOWNLOADS_ONLY, COMBO_DISPLAY_ABOS_ONLY);
        this.cbDisplayCategories.setModel(GlazedListsSwing.eventComboBoxModelWithThreadProxyList(displaySelectionList));
        this.cbDisplayCategories.getModel().setSelectedItem("alle");
        this.cbDisplayCategories.addActionListener(new DisplayCategoryListener());
    }

    private void setupCheckboxView() {
        EventList<String> viewSelectionList = GlazedLists.eventListOf("alle", COMBO_VIEW_NOT_STARTED, COMBO_VIEW_STARTED, COMBO_VIEW_WAITING, COMBO_VIEW_RUN_ONLY, COMBO_VIEW_FINISHED_ONLY);
        this.cbView.setModel(GlazedListsSwing.eventComboBoxModelWithThreadProxyList(viewSelectionList));
        this.cbView.getModel().setSelectedItem("alle");
        this.cbView.addActionListener(new ViewCategoryListener());
    }

    private void initTable() {
        this.tabelle.readColumnConfigurationData();
        this.tabelle.setSpalten();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    private void setupComponentListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                GuiDownloads.this.tabVisible.set(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                GuiDownloads.this.tabVisible.set(false);
            }
        });
    }

    private void setupFilterPanel() {
        boolean visible = MVConfig.getBool(MVConfig.Configs.SYSTEM_TAB_DOWNLOAD_FILTER_VIS);
        this.updateFilterVisibility(visible);
        Configuration config = ApplicationConfiguration.getConfiguration();
        int location = config.getInt("application.ui.download.tab.divider.location", 200);
        this.jSplitPane1.setDividerLocation(location);
        this.jSplitPane1.addPropertyChangeListener("dividerLocation", pce -> {
            if (this.jPanelFilterExtern.isVisible()) {
                config.setProperty("application.ui.download.tab.divider.location", this.jSplitPane1.getDividerLocation());
            }
        });
    }

    @Handler
    private void handleParallelDownloadNumberChange(ParallelDownloadNumberChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            int maxNumDownloads = ApplicationConfiguration.getConfiguration().getInt("download.max_simultaneous.number", 1);
            this.jSpinnerAnzahlDownloads.setValue(maxNumDownloads);
        });
    }

    @Handler
    private void handleDownloadFilterVisibilityChanged(DownloadFilterVisibilityChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            boolean visibility = !this.jPanelFilterExtern.isVisible();
            this.updateFilterVisibility(visibility);
            MVConfig.add(MVConfig.Configs.SYSTEM_TAB_DOWNLOAD_FILTER_VIS, Boolean.toString(visibility));
        });
    }

    private void updateFilterVisibility(boolean visible) {
        this.jPanelFilterExtern.setVisible(visible);
        if (visible) {
            int location = this.config.getInt("application.ui.download.tab.divider.location", 200);
            this.jSplitPane1.setDividerLocation(location);
        }
    }

    private void setupTaskbarMenu() {
        Taskbar taskbar = Taskbar.getTaskbar();
        if (taskbar.isSupported(Taskbar.Feature.MENU)) {
            PopupMenu popupMenu = taskbar.getMenu();
            if (popupMenu == null) {
                popupMenu = new PopupMenu();
            }
            MenuItem miStartAllDownloads = new MenuItem("Alle Downloads starten");
            miStartAllDownloads.addActionListener(e -> this.starten(true));
            MenuItem miStopAllDownloads = new MenuItem("Alle Downloads stoppen");
            miStopAllDownloads.addActionListener(e -> this.stoppen(true));
            popupMenu.add(miStartAllDownloads);
            popupMenu.add(miStopAllDownloads);
            taskbar.setMenu(popupMenu);
        }
    }

    @Handler
    private void handleDownloadInfoUpdate(DownloadInfoUpdateAvailableEvent e) {
        if (this.tabVisible.get()) {
            SwingUtilities.invokeLater(() -> {
                if (this.txtDownload.isShowing()) {
                    this.setInfoText();
                }
            });
        }
    }

    private void setupDownloadRateLimitSpinner() {
        int oldDownloadLimit = ApplicationConfiguration.getConfiguration().getInt("download.rate.limit", 0);
        this.jSpinner1.setValue(oldDownloadLimit);
        this.jSpinner1.addChangeListener(e -> {
            int downloadLimit = (Integer)this.jSpinner1.getValue();
            logger.info("Saving download rate limit {} to config", (Object)downloadLimit);
            ApplicationConfiguration.getConfiguration().setProperty("download.rate.limit", downloadLimit);
            DownloadRateLimitChangedEvent evt = new DownloadRateLimitChangedEvent();
            evt.newLimit = downloadLimit;
            MessageBus.getMessageBus().publishAsync(evt);
        });
    }

    @Override
    public void installMenuEntries(JMenu menu) {
        JMenuItem miDownloadsStartAll = new JMenuItem("Alle Downloads starten");
        miDownloadsStartAll.setIcon(IconFontSwing.buildIcon(FontAwesome.ANGLE_DOUBLE_DOWN, 16.0f));
        miDownloadsStartAll.addActionListener(e -> this.starten(true));
        JMenuItem miDownloadStartTimed = new JMenuItem("Alle Downloads zeitverz\u00f6gert starten...");
        miDownloadStartTimed.addActionListener(e -> this.startAllDownloadsAtSpecificTime());
        JMenuItem miStopAllDownloads = new JMenuItem("Alle Downloads stoppen");
        miStopAllDownloads.addActionListener(e -> this.stoppen(true));
        JMenuItem miStopWaitingDownloads = new JMenuItem("Wartende Downloads stoppen");
        miStopWaitingDownloads.addActionListener(e -> this.stopAllWaitingDownloads());
        final JMenuItem miUpdateDownloads = new JMenuItem("Liste der Downloads aktualisieren");
        miUpdateDownloads.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        miUpdateDownloads.setIcon(IconFontSwing.buildIcon(FontAwesome.REFRESH, 16.0f));
        miUpdateDownloads.addActionListener(e -> this.updateDownloads());
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                miUpdateDownloads.setEnabled(false);
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                miUpdateDownloads.setEnabled(true);
            }
        });
        JMenuItem miCleanupDownloads = new JMenuItem(MENU_ITEM_TEXT_CLEANUP_DOWNLOADS);
        miCleanupDownloads.setIcon(IconFontSwing.buildIcon(FontAwesome.ERASER, 16.0f));
        miCleanupDownloads.addActionListener(e -> this.cleanupDownloads());
        JMenuItem miStartDownloads = new JMenuItem("Ausgew\u00e4hlte Downloads starten");
        miStartDownloads.setIcon(IconFontSwing.buildIcon(FontAwesome.CARET_DOWN, 16.0f));
        miStartDownloads.addActionListener(e -> this.starten(false));
        JMenuItem miStopDownloads = new JMenuItem("Ausgew\u00e4hlte Downloads stoppen");
        miStopDownloads.addActionListener(e -> this.stoppen(false));
        JMenuItem miDownloadsVorziehen = new JMenuItem("Downloads vorziehen");
        miDownloadsVorziehen.setIcon(Icons.ICON_MENUE_VORZIEHEN);
        miDownloadsVorziehen.addActionListener(e -> this.downloadsVorziehen());
        JMenuItem miDownloadsZurueckstellen = new JMenuItem("Downloads zur\u00fcckstellen");
        miDownloadsZurueckstellen.setIcon(IconFontSwing.buildIcon(FontAwesome.CLOCK_O, 16.0f));
        miDownloadsZurueckstellen.addActionListener(e -> this.downloadLoeschen(false));
        JMenuItem miDownloadsLoeschen = new JMenuItem("Downloads aus Liste entfernen");
        miDownloadsLoeschen.setIcon(IconFontSwing.buildIcon(FontAwesome.TRASH_O, 16.0f));
        miDownloadsLoeschen.addActionListener(e -> this.downloadLoeschen(true));
        JMenuItem miEditDownload = new JMenuItem("Download \u00e4ndern");
        miEditDownload.setIcon(IconFontSwing.buildIcon(FontAwesome.PENCIL_SQUARE_O, 16.0f));
        miEditDownload.addActionListener(e -> this.editDownload());
        JMenuItem miMarkFilmAsSeen = new JMenuItem("Filme als gesehen markieren");
        miMarkFilmAsSeen.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        miMarkFilmAsSeen.addActionListener(this.markFilmAsSeenAction);
        JMenuItem miMarkFilmAsUnseen = new JMenuItem("Filme als ungesehen markieren");
        miMarkFilmAsUnseen.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        miMarkFilmAsUnseen.addActionListener(this.markFilmAsUnseenAction);
        JMenuItem miPlayDownload = new JMenuItem("Gespeicherten Film abspielen");
        miPlayDownload.setIcon(IconFontSwing.buildIcon(FontAwesome.PLAY, 16.0f));
        miPlayDownload.addActionListener(e -> this.filmAbspielen());
        JMenuItem miInvertSelection = new JMenuItem("Auswahl umkehren");
        miInvertSelection.addActionListener(e -> this.tabelle.invertSelection());
        JMenuItem miShutdownAfterDownload = new JMenuItem("Aktion nach abgeschlossenen Downloads...");
        miShutdownAfterDownload.setIcon(IconFontSwing.buildIcon(FontAwesome.POWER_OFF, 16.0f));
        miShutdownAfterDownload.addActionListener(e -> {
            if (this.daten.getListeDownloads().unfinishedDownloads() > 0L) {
                this.mediathekGui.beenden(true, false);
            } else {
                JOptionPane.showMessageDialog(this, "Die Downloads m\u00fcssen zuerst gestartet werden.", "Keine laufenden Downloads", 0);
            }
        });
        menu.add(miDownloadsStartAll);
        menu.add(miDownloadStartTimed);
        menu.add(miStopAllDownloads);
        menu.add(miStopWaitingDownloads);
        menu.add(miUpdateDownloads);
        menu.add(miCleanupDownloads);
        menu.addSeparator();
        menu.add(miStartDownloads);
        menu.add(miStopDownloads);
        menu.add(miDownloadsVorziehen);
        menu.add(miDownloadsZurueckstellen);
        menu.add(miDownloadsLoeschen);
        menu.add(miEditDownload);
        menu.addSeparator();
        menu.add(this.cbShowDownloadDescription);
        menu.addSeparator();
        menu.add(miMarkFilmAsSeen);
        menu.add(miMarkFilmAsUnseen);
        menu.add(miPlayDownload);
        menu.addSeparator();
        menu.add(miInvertSelection);
        menu.addSeparator();
        menu.add(miShutdownAfterDownload);
    }

    private void setupDescriptionPanel() {
        Platform.runLater(() -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                loader.setLocation(Konstanten.FXML_FILM_DESCRIPTION_PANEL_URL);
                TabPane descriptionPane = (TabPane)loader.load();
                DescriptionPanelController descriptionPanelController = (DescriptionPanelController)loader.getController();
                descriptionPanelController.setOnCloseRequest(e -> {
                    SwingUtilities.invokeLater(() -> this.fxDescriptionPanel.setVisible(false));
                    e.consume();
                });
                this.fxDescriptionPanel.setScene(new Scene(descriptionPane));
                SwingUtilities.invokeLater(() -> this.tabelle.getSelectionModel().addListSelectionListener(e -> {
                    Optional<DatenFilm> optFilm = this.getCurrentlySelectedFilm();
                    Platform.runLater(() -> descriptionPanelController.showFilmDescription(optFilm));
                }));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    public void onComponentShown() {
        this.mediathekGui.tabPaneIndexProperty().setValue(TabPaneIndex.DOWNLOAD);
        this.updateFilmData();
    }

    public void starten(boolean alle) {
        this.filmStartenWiederholenStoppen(alle, true, true, false);
    }

    public void stoppen(boolean alle) {
        this.filmStartenWiederholenStoppen(alle, false, true, false);
    }

    private void setupKeyMappings() {
        InputMap im = this.tabelle.getInputMap();
        im.put(KeyStroke.getKeyStroke(10, 0), ACTION_MAP_KEY_EDIT_DOWNLOAD);
        im.put(KeyStroke.getKeyStroke(127, 0), ACTION_MAP_KEY_DELETE_DOWNLOAD);
        im.put(KeyStroke.getKeyStroke(71, 0), ACTION_MAP_KEY_MARK_AS_SEEN);
        im.put(KeyStroke.getKeyStroke(85, 0), ACTION_MAP_KEY_MAERK_AS_UNSEEN);
        im.put(KeyStroke.getKeyStroke(68, 0), ACTION_MAP_KEY_START_DOWNLOAD);
        ActionMap am = this.tabelle.getActionMap();
        am.put(ACTION_MAP_KEY_EDIT_DOWNLOAD, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiDownloads.this.editDownload();
            }
        });
        am.put(ACTION_MAP_KEY_DELETE_DOWNLOAD, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiDownloads.this.downloadLoeschen(true);
            }
        });
        am.put(ACTION_MAP_KEY_MARK_AS_SEEN, this.markFilmAsSeenAction);
        am.put(ACTION_MAP_KEY_MAERK_AS_UNSEEN, this.markFilmAsUnseenAction);
        am.put(ACTION_MAP_KEY_START_DOWNLOAD, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiDownloads.this.filmStartenWiederholenStoppen(false, true, true, false);
            }
        });
    }

    private void init() {
        this.setupKeyMappings();
        CellRendererDownloads cellRenderer = new CellRendererDownloads();
        this.tabelle.setDefaultRenderer(Object.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Datum.class, cellRenderer);
        this.tabelle.setDefaultRenderer(MVFilmSize.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Integer.class, cellRenderer);
        this.model = new TModelDownload();
        this.tabelle.setModel(this.model);
        this.tabelle.addMouseListener(new BeobMausTabelle());
        this.tabelle.getSelectionModel().addListSelectionListener(event -> {
            if (!event.getValueIsAdjusting()) {
                this.updateFilmData();
            }
        });
        this.tabelle.setLineBreak(MVConfig.getBool(MVConfig.Configs.SYSTEM_TAB_DOWNLOAD_LINEBREAK));
        this.tabelle.getTableHeader().addMouseListener(new BeobTableHeader(this.tabelle, DatenDownload.spaltenAnzeigen, COLUMNS_DISABLED, new int[]{6, 7}, true, MVConfig.Configs.SYSTEM_TAB_DOWNLOAD_LINEBREAK));
        this.btnClear.setIcon(Icons.ICON_BUTTON_CLEAR);
        this.btnClear.addActionListener(l -> {
            this.cbDisplayCategories.setSelectedIndex(0);
            this.cbView.setSelectedIndex(0);
        });
        this.jSpinnerAnzahlDownloads.setModel(new SpinnerNumberModel(1, 1, 9, 1));
        this.jSpinnerAnzahlDownloads.setValue(this.config.getInt("download.max_simultaneous.number", 1));
        this.jSpinnerAnzahlDownloads.addChangeListener(l -> {
            int maxNumDownloads = ((Number)this.jSpinnerAnzahlDownloads.getModel().getValue()).intValue();
            this.config.setProperty("download.max_simultaneous.number", maxNumDownloads);
            MessageBus.getMessageBus().publishAsync(new ParallelDownloadNumberChangedEvent());
        });
        int location = this.config.getInt("application.ui.download.tab.divider.location", 200);
        this.jSplitPane1.setDividerLocation(location);
        this.setupInfoPanel();
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                GuiDownloads.this.loadFilmlist = true;
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                GuiDownloads.this.loadFilmlist = false;
                GuiDownloads.this.daten.getListeDownloads().filmEintragen();
                if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ABOS_SOFORT_SUCHEN))) {
                    GuiDownloads.this.updateDownloads();
                } else {
                    GuiDownloads.this.reloadTable();
                }
            }
        });
    }

    private void setupInfoPanel() {
        this.txtDownload.setText("");
        this.txtDownload.setEditable(false);
        this.txtDownload.setFocusable(false);
        this.txtDownload.setContentType("text/html");
    }

    private void setInfoText() {
        if (this.daten.getListeDownloads().getStarts().total_starts == 0) {
            this.txtDownload.setText("");
            return;
        }
        Object info = HEAD;
        info = (String)info + this.getInfoText();
        DownloadInfos downloadInfos = this.daten.getDownloadInfos();
        long byteAlleDownloads = downloadInfos.getByteAlleDownloads();
        long byteAktDownloads = downloadInfos.getByteAktDownloads();
        if (byteAlleDownloads > 0L || byteAktDownloads > 0L) {
            info = (String)info + "<br />";
            info = (String)info + "<span class=\"sans\"><b>Gr\u00f6\u00dfe:</b><br />";
            info = byteAktDownloads > 0L ? (String)info + FileSize.convertSize(byteAktDownloads) + " von " + FileSize.convertSize(byteAlleDownloads) + " MByte</span>" : (String)info + FileSize.convertSize(byteAlleDownloads) + " MByte</span>";
        }
        long timeRestAktDownloads = downloadInfos.getTimeRestAktDownloads();
        long timeRestAllDownloads = downloadInfos.getTimeRestAllDownloads();
        if (timeRestAktDownloads > 0L && timeRestAllDownloads > 0L) {
            info = (String)info + "<br />";
            info = (String)info + "<span class=\"sans\"><b>Restzeit:</b><br />laufende: " + downloadInfos.getRestzeit() + ",<br />alle: " + downloadInfos.getGesamtRestzeit() + "</span>";
        } else if (timeRestAktDownloads > 0L) {
            info = (String)info + "<br />";
            info = (String)info + "<span class=\"sans\"><b>Restzeit:</b><br />laufende: " + downloadInfos.getRestzeit() + "</span>";
        } else if (timeRestAllDownloads > 0L) {
            info = (String)info + "<br />";
            info = (String)info + "<span class=\"sans\"><b>Restzeit:</b><br />alle: " + downloadInfos.getGesamtRestzeit() + "</span>";
        }
        info = (String)info + END;
        this.txtDownload.setText((String)info);
    }

    private String getInfoText() {
        DownloadStartInfo info = this.daten.getListeDownloads().getStarts();
        String textLinks = "<span class=\"sans\"><b>Downloads:  </b>" + info.total_starts + "<br />";
        if (info.hasValues()) {
            textLinks = textLinks + "( ";
            textLinks = textLinks + (String)(info.running == 1 ? "1 l\u00e4uft" : info.running + " laufen");
            textLinks = textLinks + (String)(info.initialized == 1 ? ", 1 wartet" : ", " + info.initialized + " warten");
            if (info.finished > 0) {
                textLinks = textLinks + (String)(info.finished == 1 ? ", 1 fertig" : ", " + info.finished + " fertig");
            }
            if (info.error > 0) {
                textLinks = textLinks + (String)(info.error == 1 ? ", 1 fehlerhaft" : ", " + info.error + " fehlerhaft");
            }
            textLinks = textLinks + " )";
        }
        textLinks = textLinks + "<br /></span>";
        return textLinks;
    }

    @Handler
    private void handleRestartDownloadEvent(RestartDownloadEvent e) {
        this.reloadAndSave();
    }

    @Handler
    private void handleDownloadQueueRankChanged(DownloadQueueRankChangedEvent e) {
        this.reloadAndSave();
    }

    private void reloadAndSave() {
        SwingUtilities.invokeLater(() -> {
            this.reloadTable();
            this.daten.allesSpeichern();
        });
    }

    @Handler
    private void handleAboListChanged(AboListChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ABOS_SOFORT_SUCHEN))) {
                this.updateDownloads();
            }
        });
    }

    @Handler
    private void handleDownloadListChange(DownloadListChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.reloadTable();
            this.daten.allesSpeichern();
        });
    }

    @Handler
    private void handleBlacklistChangedEvent(BlacklistChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ABOS_SOFORT_SUCHEN)) && Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_AUCH_ABO))) {
                this.updateDownloads();
            }
        });
    }

    private void addListenerMediathekView() {
        MessageBus.getMessageBus().subscribe(this);
        Listener.addListener(new Listener(27, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ABOS_SOFORT_SUCHEN))) {
                    GuiDownloads.this.updateDownloads();
                }
            }
        });
        this.setupShowFilmDescriptionMenuItem();
    }

    @Handler
    private void handleDownloadProgressChanged(DownloadProgressChangedEvent e) {
        long now = System.currentTimeMillis();
        if (now - this._lastUpdate.get() >= 500L) {
            this._lastUpdate.set(now);
            SwingUtilities.invokeLater(() -> this.daten.getListeDownloads().setModelProgress(this.model));
        }
    }

    @Handler
    private void handleGeoStateChangedEvent(GeoStateChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.tabelle.fireTableDataChanged(true);
            this.setInfo();
        });
    }

    private void setupShowFilmDescriptionMenuItem() {
        this.cbShowDownloadDescription.setSelected(ApplicationConfiguration.getConfiguration().getBoolean("download.show_description", true));
        this.cbShowDownloadDescription.addActionListener(l -> this.fxDescriptionPanel.setVisible(this.cbShowDownloadDescription.isSelected()));
        this.cbShowDownloadDescription.addItemListener(e -> ApplicationConfiguration.getConfiguration().setProperty("download.show_description", this.cbShowDownloadDescription.isSelected()));
        this.fxDescriptionPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                GuiDownloads.this.cbShowDownloadDescription.setSelected(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                GuiDownloads.this.cbShowDownloadDescription.setSelected(false);
            }
        });
    }

    private void showDescriptionPanel() {
        this.fxDescriptionPanel.setVisible(ApplicationConfiguration.getConfiguration().getBoolean("download.show_description", true));
    }

    private synchronized void reloadTable() {
        this.tabelle.getSpalten();
        this.daten.getListeDownloads().getModel(this.model, this.onlyAbos, this.onlyDownloads, this.onlyNotStarted, this.onlyStarted, this.onlyWaiting, this.onlyRun, this.onlyFinished);
        this.tabelle.setSpalten();
        this.updateFilmData();
        this.setInfo();
    }

    @Handler
    private void handleStartEvent(StartEvent msg) {
        SwingUtilities.invokeLater(this::reloadTable);
    }

    public synchronized void updateDownloads() {
        if (this.loadFilmlist) {
            return;
        }
        ListeDownloads listeDownloads = this.daten.getListeDownloads();
        listeDownloads.abosAuffrischen();
        listeDownloads.abosSuchen(this.mediathekGui);
        this.reloadTable();
        if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DOWNLOAD_SOFORT_STARTEN))) {
            this.filmStartenWiederholenStoppen(true, true, false, true);
        }
    }

    public synchronized void cleanupDownloads() {
        this.daten.getListeDownloads().listePutzen();
    }

    private synchronized void downloadsAufraeumen(DatenDownload datenDownload) {
        this.daten.getListeDownloads().listePutzen(datenDownload);
    }

    private ArrayList<DatenDownload> getSelDownloads() {
        ArrayList<DatenDownload> arrayDownloads = new ArrayList<DatenDownload>();
        int[] rows = this.tabelle.getSelectedRows();
        TableModel model = this.tabelle.getModel();
        if (rows.length > 0) {
            for (int row : rows) {
                DatenDownload datenDownload = (DatenDownload)model.getValueAt(this.tabelle.convertRowIndexToModel(row), 39);
                arrayDownloads.add(datenDownload);
            }
        } else {
            NoSelectionErrorDialog.show();
        }
        return arrayDownloads;
    }

    @Override
    protected Optional<DatenFilm> getCurrentlySelectedFilm() {
        int selectedTableRow = this.tabelle.getSelectedRow();
        if (selectedTableRow != -1) {
            int modelIndex = this.tabelle.convertRowIndexToModel(selectedTableRow);
            DatenDownload download = (DatenDownload)this.tabelle.getModel().getValueAt(modelIndex, 39);
            Optional<DatenFilm> optRet = download.film == null ? Optional.empty() : Optional.of(download.film);
            return optRet;
        }
        return Optional.empty();
    }

    private DatenDownload getSelDownload() {
        DatenDownload datenDownload = null;
        int row = this.tabelle.getSelectedRow();
        if (row != -1) {
            datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(row), 39);
        } else {
            NoSelectionErrorDialog.show();
        }
        return datenDownload;
    }

    public synchronized void editDownload() {
        DatenDownload datenDownload = this.getSelDownload();
        if (datenDownload == null) {
            return;
        }
        boolean gestartet = false;
        if (datenDownload.start != null && datenDownload.start.status >= 2) {
            gestartet = true;
        }
        DatenDownload datenDownloadKopy = datenDownload.getCopy();
        DialogEditDownload dialog = new DialogEditDownload(this.mediathekGui, true, datenDownloadKopy, gestartet, this.tabelle.getColumnModel());
        dialog.setVisible(true);
        if (dialog.ok) {
            datenDownload.aufMichKopieren(datenDownloadKopy);
            this.reloadTable();
        }
    }

    private void downloadsVorziehen() {
        ArrayList<DatenDownload> arrayDownloads = this.getSelDownloads();
        if (arrayDownloads.isEmpty()) {
            return;
        }
        this.daten.getListeDownloads().downloadsVorziehen(arrayDownloads);
    }

    private void zielordnerOeffnen() {
        DatenDownload datenDownload = this.getSelDownload();
        if (datenDownload == null) {
            return;
        }
        String s2 = datenDownload.arr[30];
        DirOpenAction.zielordnerOeffnen(this.mediathekGui, s2);
    }

    public void filmAbspielen() {
        DatenDownload datenDownload = this.getSelDownload();
        if (datenDownload == null) {
            return;
        }
        String s2 = datenDownload.arr[31];
        OpenPlayerAction.filmAbspielen(this.mediathekGui, s2);
    }

    private void filmLoeschen_() {
        DatenDownload datenDownload = this.getSelDownload();
        if (datenDownload == null) {
            return;
        }
        if (datenDownload.start != null && datenDownload.start.status < 3) {
            MVMessageDialog.showMessageDialog(this.mediathekGui, "Download erst stoppen!", "Film l\u00f6schen", 0);
            return;
        }
        try {
            File file = new File(datenDownload.arr[31]);
            if (!file.exists()) {
                MVMessageDialog.showMessageDialog(this.mediathekGui, "Die Datei existiert nicht!", "Film l\u00f6schen", 0);
                return;
            }
            int ret = JOptionPane.showConfirmDialog(this.mediathekGui, datenDownload.arr[31], "Film L\u00f6schen?", 0);
            if (ret == 0) {
                logger.info(new String[]{"Datei l\u00f6schen: ", file.getAbsolutePath()});
                if (!file.delete()) {
                    throw new Exception();
                }
            }
        }
        catch (Exception ex) {
            MVMessageDialog.showMessageDialog(this.mediathekGui, "Konnte die Datei nicht l\u00f6schen!", "Film l\u00f6schen", 0);
            logger.error("Fehler beim l\u00f6schen: " + datenDownload.arr[31]);
        }
    }

    public void downloadLoeschen(boolean permanentDeletion) {
        try {
            ArrayList<DatenDownload> arrayDownloads = this.getSelDownloads();
            if (arrayDownloads.isEmpty()) {
                return;
            }
            String zeit = DateTimeFormatter.ofPattern("dd.MM.yyyy").format(LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()));
            ArrayList<DatenDownload> arrayDownloadsLoeschen = new ArrayList<DatenDownload>();
            ArrayList<MVUsedUrl> urlAboList = new ArrayList<MVUsedUrl>();
            for (DatenDownload datenDownload : arrayDownloads) {
                if (permanentDeletion) {
                    arrayDownloadsLoeschen.add(datenDownload);
                    if (!datenDownload.isFromAbo()) continue;
                    urlAboList.add(new MVUsedUrl(zeit, datenDownload.arr[4], datenDownload.arr[5], datenDownload.arr[20]));
                    continue;
                }
                datenDownload.zurueckstellen();
            }
            if (!urlAboList.isEmpty()) {
                this.daten.getAboHistoryController().add(urlAboList);
            }
            this.daten.getListeDownloads().downloadLoeschen(arrayDownloadsLoeschen);
            this.reloadTable();
        }
        catch (Exception ex) {
            logger.error("downloadLoeschen()", (Throwable)ex);
        }
    }

    @NotNull
    private List<DatenDownload> addAllDownloadsToList() {
        int rowCount = this.tabelle.getRowCount();
        TableModel tableModel = this.tabelle.getModel();
        ArrayList<DatenDownload> destList = new ArrayList<DatenDownload>();
        for (int i = 0; i < rowCount; ++i) {
            DatenDownload datenDownload = (DatenDownload)tableModel.getValueAt(this.tabelle.convertRowIndexToModel(i), 39);
            destList.add(datenDownload);
        }
        return destList;
    }

    public void startAllDownloadsAtSpecificTime() {
        if (this.tabelle.getRowCount() == 0) {
            Platform.runLater(() -> {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle("MediathekView");
                alert.setHeaderText("Keine Downloads vorhanden");
                alert.setContentText("Es sind keine Downloads in der Liste zum Starten vorhanden.");
                alert.initModality(Modality.APPLICATION_MODAL);
                alert.showAndWait();
            });
            return;
        }
        this.tabelle.sortDownloadListByTableRows();
        List<DatenDownload> allDownloadsList = this.addAllDownloadsToList();
        ArrayList<DatenDownload> listeUrlsDownloadsAbbrechen = new ArrayList<DatenDownload>();
        ArrayList<DatenDownload> listeDownloadsStarten = new ArrayList<DatenDownload>();
        for (DatenDownload download : allDownloadsList) {
            if (download.start != null) {
                if (download.start.status == 2) continue;
                if (download.start.status > 2) {
                    int a = JOptionPane.showConfirmDialog(this.mediathekGui, "Film nochmal starten?  ==> " + download.arr[5], "Fertiger Download", 0);
                    if (a != 0) continue;
                    listeUrlsDownloadsAbbrechen.add(download);
                    if (download.isFromAbo()) {
                        this.daten.getAboHistoryController().removeUrl(download.arr[20]);
                    }
                }
            }
            listeDownloadsStarten.add(download);
        }
        this.daten.getListeDownloads().downloadAbbrechen(listeUrlsDownloadsAbbrechen);
        DialogBeendenZeit dialogBeenden = new DialogBeendenZeit(this.mediathekGui, listeDownloadsStarten);
        dialogBeenden.setVisible(true);
        if (dialogBeenden.applicationCanTerminate()) {
            this.mediathekGui.beenden(false, dialogBeenden.isShutdownRequested());
        }
        this.reloadTable();
    }

    private void filmStartenWiederholenStoppen(boolean processAllDownloads, boolean starten, boolean restartFinishedDownloads, boolean skipManualDownloads) {
        List<DatenDownload> selectedDownloadsList;
        ArrayList<DatenDownload> listeDownloadsLoeschen = new ArrayList<DatenDownload>();
        ArrayList<DatenDownload> listeDownloadsStarten = new ArrayList<DatenDownload>();
        if (this.tabelle.getRowCount() == 0) {
            return;
        }
        if (starten && processAllDownloads) {
            this.tabelle.sortDownloadListByTableRows();
        }
        List<DatenDownload> list = selectedDownloadsList = processAllDownloads ? this.addAllDownloadsToList() : this.getSelDownloads();
        if (!starten) {
            this.daten.getStarterClass().delayNewStarts();
        }
        int antwort = -1;
        for (DatenDownload download : selectedDownloadsList) {
            if (starten) {
                if (download.start != null) {
                    if (download.start.status == 2 || !restartFinishedDownloads && download.start.status > 2) continue;
                    if (download.start.status > 2) {
                        if (antwort == -1) {
                            Object text = selectedDownloadsList.size() > 1 ? "Es sind bereits fertige Filme dabei,\ndiese nochmal starten?" : "Film nochmal starten?  ==> " + download.arr[5];
                            antwort = JOptionPane.showConfirmDialog(this.mediathekGui, text, "Fertiger Download", 1);
                        }
                        if (antwort == 2) {
                            return;
                        }
                        if (antwort == 1) continue;
                        listeDownloadsLoeschen.add(download);
                        if (download.isFromAbo()) {
                            this.daten.getAboHistoryController().removeUrl(download.arr[20]);
                        }
                    }
                }
                listeDownloadsStarten.add(download);
                continue;
            }
            if (download.start == null || download.start.status > 2) continue;
            listeDownloadsLoeschen.add(download);
        }
        this.daten.getListeDownloads().downloadAbbrechen(listeDownloadsLoeschen);
        if (skipManualDownloads) {
            listeDownloadsStarten.removeIf(item -> !item.isFromAbo());
        }
        if (starten) {
            DatenDownload.startenDownloads(listeDownloadsStarten);
        }
        this.reloadTable();
    }

    public void stopAllWaitingDownloads() {
        ArrayList<DatenDownload> listeStopDownload = new ArrayList<DatenDownload>();
        for (int i = 0; i < this.tabelle.getRowCount(); ++i) {
            DatenDownload datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(i), 39);
            if (datenDownload.start == null || datenDownload.start.status >= 2) continue;
            listeStopDownload.add(datenDownload);
        }
        this.daten.getListeDownloads().downloadAbbrechen(listeStopDownload);
    }

    private void setInfo() {
        MessageBus.getMessageBus().publishAsync(new UpdateStatusBarLeftDisplayEvent());
    }

    private void updateFilmData() {
        if (this.isShowing()) {
            InfoDialog infoDialog;
            DatenDownload datenDownload;
            DatenFilm aktFilm = null;
            int selectedTableRow = this.tabelle.getSelectedRow();
            if (selectedTableRow >= 0 && (datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(selectedTableRow), 39)) != null) {
                aktFilm = datenDownload.film;
            }
            if ((infoDialog = this.mediathekGui.getFilmInfoDialog()) != null) {
                infoDialog.updateCurrentFilm(aktFilm);
            }
        }
    }

    @Override
    protected List<DatenFilm> getSelFilme() {
        ArrayList<DatenFilm> arrayFilme = new ArrayList<DatenFilm>();
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                DatenDownload datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(row), 39);
                if (datenDownload.film == null) continue;
                arrayFilme.add(datenDownload.film);
            }
        } else {
            NoSelectionErrorDialog.show();
        }
        return arrayFilme;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanelFilterExtern = new JPanel();
        JPanel panel3 = new JPanel();
        JLabel label1 = new JLabel();
        this.cbDisplayCategories = new JComboBox();
        JLabel label2 = new JLabel();
        this.cbView = new JComboBox();
        this.btnClear = new JButton();
        JPanel panel2 = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.jSpinnerAnzahlDownloads = new JSpinner();
        JLabel lblBandwidth = new JLabel();
        JLabel jLabel1 = new JLabel();
        this.jSpinner1 = new JSpinner();
        JScrollPane spDownload = new JScrollPane();
        this.txtDownload = new JEditorPane();
        JPanel downloadListArea = new JPanel();
        this.downloadListScrollPane = new JScrollPane();
        this.fxDescriptionPanel = new JFXPanel();
        this.toolBarPanel = new JFXPanel();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(330);
        this.jPanelFilterExtern.setPreferredSize(new Dimension(200, 644));
        this.jPanelFilterExtern.setLayout(new MigLayout(new LC().insets("0").hideMode(3).gridGap("0", "0"), new AC().grow().fill(), new AC().gap().fill().gap().grow().fill()));
        panel3.setBorder(new TitledBorder("Anzeige"));
        panel3.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill(), new AC().fill().gap().fill().gap().fill()));
        label1.setText("Typ:");
        panel3.add((Component)label1, new CC().cell(0, 0));
        panel3.add(this.cbDisplayCategories, new CC().cell(1, 0));
        label2.setText("Status:");
        panel3.add((Component)label2, new CC().cell(0, 1));
        panel3.add(this.cbView, new CC().cell(1, 1));
        this.btnClear.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-clear.png")));
        this.btnClear.setToolTipText("Filter zur\u00fccksetzen");
        panel3.add((Component)this.btnClear, new CC().cell(0, 2, 2, 1).alignX("right").growX(0.0f).width("32:32:32").height("32:32:32"));
        this.jPanelFilterExtern.add((Component)panel3, new CC().cell(0, 0));
        panel2.setBorder(new TitledBorder(NAME));
        panel2.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().fill().gap().fill(), new AC().gap().fill()));
        jLabel3.setText("gleichzeitig:");
        panel2.add((Component)jLabel3, new CC().cell(0, 0));
        panel2.add((Component)this.jSpinnerAnzahlDownloads, new CC().cell(1, 0));
        lblBandwidth.setText("max. Bandbreite:");
        panel2.add((Component)lblBandwidth, new CC().cell(0, 1));
        jLabel1.setText("KiB/s");
        panel2.add((Component)jLabel1, new CC().cell(2, 1));
        this.jSpinner1.setModel(new SpinnerNumberModel(0, 0, 0x100000, 1));
        this.jSpinner1.setToolTipText("<html>\nBandbreitenbegrenzung eines Downloads in XX Kilobytes pro Sekunde.\n<b><br><u>WICHTIG:</u><br>ENTWEDER<br>den Wert \u00fcber die Pfeiltasten \u00e4ndern<br>ODER<br>Zahlen eingeben UND ENTER-Taste dr\u00fccken!</b>\n</html>");
        panel2.add((Component)this.jSpinner1, new CC().cell(1, 1));
        this.jPanelFilterExtern.add((Component)panel2, new CC().cell(0, 1));
        spDownload.setPreferredSize(new Dimension(14, 150));
        this.txtDownload.setEditable(false);
        this.txtDownload.setOpaque(false);
        this.txtDownload.setPreferredSize(new Dimension(10, 500));
        spDownload.setViewportView(this.txtDownload);
        this.jPanelFilterExtern.add((Component)spDownload, new CC().cell(0, 2));
        this.jSplitPane1.setLeftComponent(this.jPanelFilterExtern);
        downloadListArea.setLayout(new BorderLayout());
        downloadListArea.add((Component)this.downloadListScrollPane, "Center");
        downloadListArea.add((Component)this.fxDescriptionPanel, "South");
        this.jSplitPane1.setRightComponent(downloadListArea);
        this.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.toolBarPanel, "North");
    }

    private final class DisplayCategoryListener
    implements ActionListener {
        private DisplayCategoryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox source2 = (JComboBox)e.getSource();
            switch ((String)source2.getModel().getSelectedItem()) {
                case "alle": {
                    GuiDownloads.this.onlyAbos = false;
                    GuiDownloads.this.onlyDownloads = false;
                    break;
                }
                case "nur Downloads": {
                    GuiDownloads.this.onlyAbos = false;
                    GuiDownloads.this.onlyDownloads = true;
                    break;
                }
                case "nur Abos": {
                    GuiDownloads.this.onlyAbos = true;
                    GuiDownloads.this.onlyDownloads = false;
                }
            }
            GuiDownloads.this.reloadTable();
        }
    }

    private final class ViewCategoryListener
    implements ActionListener {
        private ViewCategoryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox source2 = (JComboBox)e.getSource();
            switch ((String)source2.getModel().getSelectedItem()) {
                case "alle": {
                    GuiDownloads.this.onlyNotStarted = false;
                    GuiDownloads.this.onlyStarted = false;
                    GuiDownloads.this.onlyWaiting = false;
                    GuiDownloads.this.onlyFinished = false;
                    GuiDownloads.this.onlyRun = false;
                    break;
                }
                case "nicht gestartet": {
                    GuiDownloads.this.onlyNotStarted = true;
                    GuiDownloads.this.onlyStarted = false;
                    GuiDownloads.this.onlyWaiting = false;
                    GuiDownloads.this.onlyFinished = false;
                    GuiDownloads.this.onlyRun = false;
                    break;
                }
                case "gestartet": {
                    GuiDownloads.this.onlyNotStarted = false;
                    GuiDownloads.this.onlyStarted = true;
                    GuiDownloads.this.onlyWaiting = false;
                    GuiDownloads.this.onlyFinished = false;
                    GuiDownloads.this.onlyRun = false;
                    break;
                }
                case "nur wartende": {
                    GuiDownloads.this.onlyNotStarted = false;
                    GuiDownloads.this.onlyStarted = false;
                    GuiDownloads.this.onlyWaiting = true;
                    GuiDownloads.this.onlyFinished = false;
                    GuiDownloads.this.onlyRun = false;
                    break;
                }
                case "nur abgeschlossene": {
                    GuiDownloads.this.onlyNotStarted = false;
                    GuiDownloads.this.onlyStarted = false;
                    GuiDownloads.this.onlyWaiting = false;
                    GuiDownloads.this.onlyFinished = true;
                    GuiDownloads.this.onlyRun = false;
                    break;
                }
                case "nur laufende": {
                    GuiDownloads.this.onlyNotStarted = false;
                    GuiDownloads.this.onlyStarted = false;
                    GuiDownloads.this.onlyWaiting = false;
                    GuiDownloads.this.onlyFinished = false;
                    GuiDownloads.this.onlyRun = true;
                }
            }
            GuiDownloads.this.reloadTable();
        }
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        private final ShowFilmInformationAction showFilmInformationAction = new ShowFilmInformationAction(false);
        DatenDownload datenDownload;
        private Point p;

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                if (arg0.getClickCount() == 1) {
                    this.p = arg0.getPoint();
                    int row = GuiDownloads.this.tabelle.rowAtPoint(this.p);
                    int column = GuiDownloads.this.tabelle.columnAtPoint(this.p);
                    if (row >= 0) {
                        this.buttonTable(row, column);
                    }
                } else if (arg0.getClickCount() > 1) {
                    GuiDownloads.this.editDownload();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            this.p = arg0.getPoint();
            int row = GuiDownloads.this.tabelle.rowAtPoint(this.p);
            if (row >= 0) {
                this.datenDownload = (DatenDownload)GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(row), 39);
            }
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            this.p = arg0.getPoint();
            int row = GuiDownloads.this.tabelle.rowAtPoint(this.p);
            if (row >= 0) {
                this.datenDownload = (DatenDownload)GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(row), 39);
            }
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void buttonTable(int row, int column) {
            if (row != -1) {
                this.datenDownload = (DatenDownload)GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(row), 39);
                if (GuiDownloads.this.tabelle.convertColumnIndexToModel(column) == 6) {
                    if (this.datenDownload.start != null && !this.datenDownload.isDownloadManager()) {
                        if (this.datenDownload.start.status == 3) {
                            GuiDownloads.this.filmAbspielen();
                        } else {
                            GuiDownloads.this.filmStartenWiederholenStoppen(false, this.datenDownload.start.status == 4, true, false);
                        }
                    } else {
                        GuiDownloads.this.filmStartenWiederholenStoppen(false, true, true, false);
                    }
                } else if (GuiDownloads.this.tabelle.convertColumnIndexToModel(column) == 7) {
                    if (this.datenDownload.start != null) {
                        if (this.datenDownload.start.status >= 3) {
                            GuiDownloads.this.downloadsAufraeumen(this.datenDownload);
                        } else {
                            GuiDownloads.this.downloadLoeschen(true);
                        }
                    } else {
                        GuiDownloads.this.downloadLoeschen(true);
                    }
                }
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = GuiDownloads.this.tabelle.rowAtPoint(this.p);
            if (nr != -1) {
                GuiDownloads.this.tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            boolean wartenOderLaufen = false;
            int row = GuiDownloads.this.tabelle.getSelectedRow();
            if (row != -1) {
                DatenDownload download = (DatenDownload)GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(row), 39);
                if (download.start != null && download.start.status <= 2) {
                    wartenOderLaufen = true;
                }
            }
            JMenuItem itemStarten = new JMenuItem("Download starten");
            itemStarten.setIcon(IconFontSwing.buildIcon(FontAwesome.CARET_DOWN, 16.0f));
            itemStarten.setEnabled(!wartenOderLaufen);
            jPopupMenu.add(itemStarten);
            itemStarten.addActionListener(arg0 -> GuiDownloads.this.filmStartenWiederholenStoppen(false, true, true, false));
            JMenuItem itemStoppen = new JMenuItem("Download stoppen");
            itemStoppen.setEnabled(wartenOderLaufen);
            jPopupMenu.add(itemStoppen);
            itemStoppen.addActionListener(arg0 -> GuiDownloads.this.filmStartenWiederholenStoppen(false, false, true, false));
            jPopupMenu.addSeparator();
            JMenuItem itemVorziehen = new JMenuItem("Download vorziehen");
            itemVorziehen.setIcon(Icons.ICON_MENUE_VORZIEHEN);
            jPopupMenu.add(itemVorziehen);
            itemVorziehen.addActionListener(arg0 -> GuiDownloads.this.downloadsVorziehen());
            JMenuItem itemLoeschen = new JMenuItem("Download zur\u00fcckstellen");
            itemLoeschen.setIcon(IconFontSwing.buildIcon(FontAwesome.CLOCK_O, 16.0f));
            jPopupMenu.add(itemLoeschen);
            itemLoeschen.addActionListener(arg0 -> GuiDownloads.this.downloadLoeschen(false));
            JMenuItem itemDauerhaftLoeschen = new JMenuItem("Download aus Liste entfernen");
            itemDauerhaftLoeschen.setIcon(IconFontSwing.buildIcon(FontAwesome.TRASH_O, 16.0f));
            jPopupMenu.add(itemDauerhaftLoeschen);
            itemDauerhaftLoeschen.addActionListener(arg0 -> GuiDownloads.this.downloadLoeschen(true));
            JMenuItem itemAendern = new JMenuItem("Download \u00e4ndern");
            itemAendern.setIcon(IconFontSwing.buildIcon(FontAwesome.PENCIL_SQUARE_O, 16.0f));
            jPopupMenu.add(itemAendern);
            itemAendern.addActionListener(arg0 -> GuiDownloads.this.editDownload());
            jPopupMenu.addSeparator();
            JMenuItem itemAlleStarten = new JMenuItem("Alle Downloads starten");
            itemAlleStarten.setIcon(IconFontSwing.buildIcon(FontAwesome.ANGLE_DOUBLE_DOWN, 16.0f));
            itemAlleStarten.addActionListener(arg0 -> GuiDownloads.this.starten(true));
            jPopupMenu.add(itemAlleStarten);
            JMenuItem itemAlleStoppen = new JMenuItem("Alle Downloads stoppen");
            itemAlleStoppen.addActionListener(arg0 -> GuiDownloads.this.stoppen(true));
            jPopupMenu.add(itemAlleStoppen);
            JMenuItem itemWartendeStoppen = new JMenuItem("wartende Downloads stoppen");
            jPopupMenu.add(itemWartendeStoppen);
            itemWartendeStoppen.addActionListener(arg0 -> GuiDownloads.this.stopAllWaitingDownloads());
            JMenuItem itemAktualisieren = new JMenuItem("Liste der Downloads aktualisieren");
            itemAktualisieren.setIcon(IconFontSwing.buildIcon(FontAwesome.REFRESH, 16.0f));
            jPopupMenu.add(itemAktualisieren);
            itemAktualisieren.addActionListener(arg0 -> GuiDownloads.this.updateDownloads());
            JMenuItem itemAufraeumen = new JMenuItem(GuiDownloads.MENU_ITEM_TEXT_CLEANUP_DOWNLOADS);
            itemAufraeumen.setIcon(IconFontSwing.buildIcon(FontAwesome.ERASER, 16.0f));
            jPopupMenu.add(itemAufraeumen);
            itemAufraeumen.addActionListener(arg0 -> GuiDownloads.this.cleanupDownloads());
            jPopupMenu.addSeparator();
            JMenuItem itemPlayerDownload = new JMenuItem("gespeicherten Film (Datei) abspielen");
            itemPlayerDownload.setIcon(IconFontSwing.buildIcon(FontAwesome.PLAY, 16.0f));
            itemPlayerDownload.addActionListener(e -> GuiDownloads.this.filmAbspielen());
            jPopupMenu.add(itemPlayerDownload);
            JMenuItem itemDeleteDownload = new JMenuItem("gespeicherten Film (Datei) l\u00f6schen");
            itemDeleteDownload.setIcon(IconFontSwing.buildIcon(FontAwesome.TIMES, 16.0f));
            itemDeleteDownload.addActionListener(e -> GuiDownloads.this.filmLoeschen_());
            jPopupMenu.add(itemDeleteDownload);
            JMenuItem itemOeffnen = new JMenuItem("Zielordner \u00f6ffnen");
            itemOeffnen.setIcon(IconFontSwing.buildIcon(FontAwesome.FOLDER_OPEN_O, 16.0f));
            jPopupMenu.add(itemOeffnen);
            itemOeffnen.addActionListener(e -> GuiDownloads.this.zielordnerOeffnen());
            jPopupMenu.addSeparator();
            JMenu submenueAbo = new JMenu("Abo");
            JMenuItem itemChangeAbo = new JMenuItem("Abo \u00e4ndern");
            JMenuItem itemDelAbo = new JMenuItem("Abo l\u00f6schen");
            if (this.datenDownload == null) {
                submenueAbo.setEnabled(false);
                itemChangeAbo.setEnabled(false);
                itemDelAbo.setEnabled(false);
            } else if (this.datenDownload.film == null) {
                submenueAbo.setEnabled(false);
                itemChangeAbo.setEnabled(false);
                itemDelAbo.setEnabled(false);
            } else {
                DatenAbo datenAbo = GuiDownloads.this.daten.getListeAbo().getAboFuerFilm_schnell(this.datenDownload.film, false);
                if (datenAbo == null) {
                    submenueAbo.setEnabled(false);
                    itemChangeAbo.setEnabled(false);
                    itemDelAbo.setEnabled(false);
                } else {
                    itemDelAbo.addActionListener(e -> GuiDownloads.this.daten.getListeAbo().aboLoeschen(datenAbo));
                    itemChangeAbo.addActionListener(e -> {
                        DialogEditAbo dialog = new DialogEditAbo(GuiDownloads.this.mediathekGui, datenAbo, false);
                        dialog.setVisible(true);
                        if (dialog.successful()) {
                            GuiDownloads.this.daten.getListeAbo().aenderungMelden();
                        }
                    });
                }
            }
            submenueAbo.add(itemDelAbo);
            submenueAbo.add(itemChangeAbo);
            jPopupMenu.add(submenueAbo);
            jPopupMenu.addSeparator();
            JMenuItem itemPlayer = new JMenuItem("Film (URL) abspielen");
            itemPlayer.addActionListener(e -> {
                int nr1 = GuiDownloads.this.tabelle.rowAtPoint(this.p);
                if (nr1 != -1) {
                    Optional<DatenPset> optPSetPlay = Optional.ofNullable(Daten.listePset.getPsetAbspielen());
                    optPSetPlay.ifPresentOrElse(gruppe -> {
                        Optional<DatenDownload> optDL = Optional.ofNullable((DatenDownload)GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(nr1), 39));
                        optDL.ifPresent(dl -> {
                            if (dl.film != null) {
                                DatenFilm filmClone = new DatenFilm(dl.film);
                                filmClone.setUrlNormalQuality(dl.arr[21]);
                                filmClone.setUrlLowQuality("");
                                GuiDownloads.this.daten.getStarterClass().urlMitProgrammStarten((DatenPset)gruppe, filmClone, "");
                            }
                        });
                    }, () -> {
                        String menuPath = SystemUtils.IS_OS_MAC_OSX ? "MediathekView->Einstellungen\u2026->Aufzeichnen und Abspielen->Set bearbeiten" : "Datei->Einstellungen->Set bearbeiten";
                        MVMessageDialog.showMessageDialog(GuiDownloads.this.mediathekGui, "Bitte legen Sie im Men\u00fc \"" + menuPath + "\" ein Programm zum Abspielen fest.", "Kein Videoplayer!", 1);
                    });
                }
            });
            jPopupMenu.add(itemPlayer);
            JMenuItem itemUrl = new JMenuItem("URL kopieren");
            itemUrl.addActionListener(e -> {
                int nr1 = GuiDownloads.this.tabelle.rowAtPoint(this.p);
                if (nr1 != -1) {
                    GuiFunktionen.copyToClipboard(GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(nr1), 21).toString());
                }
            });
            jPopupMenu.add(itemUrl);
            jPopupMenu.add(this.showFilmInformationAction);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}

