/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import java.util.Set;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;

public class PrettyListView<T>
extends ListView<T> {
    private static String userAgentStyleSheet;
    private ScrollBar vBar = new ScrollBar();
    private ScrollBar hBar = new ScrollBar();
    private ParallelTransition parallelFadeIn;
    private ParallelTransition parallelFadeOut;

    public PrettyListView() {
        this.skinProperty().addListener(skin -> {
            this.bindScrollBars();
            this.getChildren().addAll((Node[])new Node[]{this.vBar, this.hBar});
        });
        this.getStyleClass().add("pretty-list-view");
        this.vBar.setManaged(false);
        this.vBar.setOpacity(0.0);
        this.vBar.setOrientation(Orientation.VERTICAL);
        this.vBar.getStyleClass().add("pretty-scroll-bar");
        this.vBar.visibleProperty().bind(this.vBar.visibleAmountProperty().isNotEqualTo(0));
        this.hBar.setManaged(false);
        this.hBar.setOpacity(0.0);
        this.hBar.setOrientation(Orientation.HORIZONTAL);
        this.hBar.getStyleClass().add("pretty-scroll-bar");
        this.hBar.visibleProperty().bind(this.hBar.visibleAmountProperty().isNotEqualTo(0));
        FadeTransition fadeInVBar = new FadeTransition(Duration.millis(500.0), this.vBar);
        fadeInVBar.setFromValue(0.0);
        fadeInVBar.setToValue(1.0);
        FadeTransition fadeInHBar = new FadeTransition(Duration.millis(500.0), this.hBar);
        fadeInHBar.setFromValue(0.0);
        fadeInHBar.setToValue(1.0);
        this.parallelFadeIn = new ParallelTransition(fadeInVBar, fadeInHBar);
        FadeTransition fadeOutVBar = new FadeTransition(Duration.millis(500.0), this.vBar);
        fadeOutVBar.setFromValue(1.0);
        fadeOutVBar.setToValue(0.0);
        FadeTransition fadeOutHBar = new FadeTransition(Duration.millis(500.0), this.hBar);
        fadeOutHBar.setFromValue(1.0);
        fadeOutHBar.setToValue(0.0);
        this.parallelFadeOut = new ParallelTransition(fadeOutVBar, fadeOutHBar);
        this.setFocusTraversable(false);
        this.registerListeners();
    }

    private void bindScrollBars() {
        Set<Node> nodes = this.lookupAll("VirtualScrollBar");
        nodes.stream().filter(ScrollBar.class::isInstance).forEach(node -> {
            ScrollBar bar = (ScrollBar)node;
            switch (bar.getOrientation()) {
                case VERTICAL: {
                    this.bindScrollBars(this.vBar, bar);
                    break;
                }
                case HORIZONTAL: {
                    this.bindScrollBars(this.hBar, bar);
                }
            }
        });
    }

    private void bindScrollBars(ScrollBar scrollBarA, ScrollBar scrollBarB) {
        scrollBarA.valueProperty().bindBidirectional(scrollBarB.valueProperty());
        scrollBarA.minProperty().bindBidirectional(scrollBarB.minProperty());
        scrollBarA.maxProperty().bindBidirectional(scrollBarB.maxProperty());
        scrollBarA.visibleAmountProperty().bindBidirectional(scrollBarB.visibleAmountProperty());
        scrollBarA.unitIncrementProperty().bindBidirectional(scrollBarB.unitIncrementProperty());
        scrollBarA.blockIncrementProperty().bindBidirectional(scrollBarB.blockIncrementProperty());
    }

    private void registerListeners() {
        EventHandler<MouseEvent> mouseHandler = e -> {
            EventType<? extends MouseEvent> type = e.getEventType();
            if (MouseEvent.MOUSE_ENTERED.equals(type)) {
                this.parallelFadeIn.play();
            } else if (MouseEvent.MOUSE_EXITED.equals(type)) {
                this.parallelFadeOut.play();
            }
        };
        this.addEventFilter(MouseEvent.MOUSE_ENTERED, mouseHandler);
        this.addEventFilter(MouseEvent.MOUSE_EXITED, mouseHandler);
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        Insets insets = this.getInsets();
        double width = this.getWidth();
        double height = this.getHeight();
        double prefWidth = this.vBar.prefWidth(-1.0);
        this.vBar.resizeRelocate(width - prefWidth - insets.getRight(), insets.getTop(), prefWidth, height - insets.getTop() - insets.getBottom());
        double prefHeight = this.hBar.prefHeight(-1.0);
        this.hBar.resizeRelocate(insets.getLeft(), height - prefHeight - insets.getBottom(), width - insets.getLeft() - insets.getRight(), prefHeight);
    }

    @Override
    public String getUserAgentStylesheet() {
        if (null == userAgentStyleSheet) {
            userAgentStyleSheet = this.getClass().getResource("pretty-list-view.css").toExternalForm();
        }
        return userAgentStyleSheet;
    }
}

