/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolboxfx.evt.type.LocationChangeEvt;
import eu.hansolo.toolboxfx.geom.Location;
import java.net.URL;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class MapTileSkin
extends TileSkin {
    private static final DateTimeFormatter DF = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final DateTimeFormatter TF = DateTimeFormatter.ISO_LOCAL_TIME;
    private Text titleText;
    private Text text;
    private WebView webView;
    private WebEngine webEngine;
    private boolean readyToGo;
    private EventHandler<MouseEvent> mouseHandler;
    private EvtObserver<LocationChangeEvt> locationObserver;
    private ListChangeListener<Location> poiListener;

    public MapTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.mouseHandler = event -> {
            if (event.getClickCount() == 2) {
                this.centerLocation();
            }
        };
        this.locationObserver = e -> this.redraw();
        this.poiListener = c -> {
            while (c.next()) {
                int i;
                if (c.wasPermutated()) {
                    for (i = c.getFrom(); i < c.getTo(); ++i) {
                        this.updatePoi((Location)this.tile.getPoiList().get(i));
                    }
                    continue;
                }
                if (c.wasUpdated()) {
                    for (i = c.getFrom(); i < c.getTo(); ++i) {
                        this.updatePoi((Location)this.tile.getPoiList().get(i));
                    }
                    continue;
                }
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(poi -> this.addPoi((Location)poi));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(poi -> this.removePoi((Location)poi));
            }
        };
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill(this.tile.getTextColor());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        this.webView = new WebView();
        this.webView.setMinSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.webView.setMaxSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.webView.setPrefSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.webEngine = this.webView.getEngine();
        this.webEngine.getLoadWorker().stateProperty().addListener((ov, o, n) -> {
            if (Worker.State.SUCCEEDED == n) {
                this.readyToGo = true;
                if (Tile.MapProvider.BW != this.tile.getMapProvider()) {
                    this.changeMapProvider(this.tile.getMapProvider());
                }
                this.updateLocation();
                this.updateLocationColor();
                this.tile.getPoiList().forEach(poi -> this.addPoi((Location)poi));
                this.addTrack(this.tile.getTrack());
                this.updateTrackColor();
            }
        });
        URL maps = Tile.class.getResource("osm.html");
        this.webEngine.load(maps.toExternalForm());
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.webView, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.pane.addEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseHandler);
        this.tile.getPoiList().addListener(this.poiListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
            this.webView.setMaxSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.68 : this.size * 0.795);
            this.webView.setPrefSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.68 : this.size * 0.795);
        } else if ("LOCATION".equals(EVENT_TYPE)) {
            this.tile.getCurrentLocation().addLocationObserver(LocationChangeEvt.ANY, this.locationObserver);
            this.updateLocation();
        } else if ("TRACK".equals(EVENT_TYPE)) {
            this.addTrack(this.tile.getTrack());
        } else if ("MAP_PROVIDER".equals(EVENT_TYPE)) {
            this.changeMapProvider(this.tile.getMapProvider());
        }
    }

    @Override
    public void dispose() {
        this.pane.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseHandler);
        this.tile.getCurrentLocation().removeLocationObserver(LocationChangeEvt.ANY, this.locationObserver);
        this.tile.getPoiList().removeListener(this.poiListener);
        super.dispose();
    }

    private void updateLocation() {
        if (this.readyToGo) {
            Platform.runLater(() -> {
                Location location = this.tile.getCurrentLocation();
                double lat = location.getLatitude();
                double lon = location.getLongitude();
                String name = location.getName();
                String info = location.getInfo();
                int zoomLevel = location.getZoomLevel();
                StringBuilder scriptCommand = new StringBuilder();
                scriptCommand.append("window.lat = ").append(lat).append(";").append("window.lon = ").append(lon).append(";").append("window.locationName = \"").append(name).append("\";").append("window.locationInfo = \"").append(info.toString()).append("\";").append("window.zoomLevel = ").append(zoomLevel).append(";").append("document.moveMarker(window.locationName, window.locationInfo, window.lat, window.lon, window.zoomLevel);");
                this.webEngine.executeScript(scriptCommand.toString());
            });
        }
    }

    private void updatePoi(Location POI) {
        this.removePoi(POI);
        this.addPoi(POI);
    }

    private void addPoi(Location POI) {
        if (this.readyToGo) {
            Platform.runLater(() -> {
                double lat = POI.getLatitude();
                double lon = POI.getLongitude();
                String name = POI.getName();
                String info = POI.getInfo();
                String color = POI.getFill().toString().replace("0x", "#");
                StringBuilder scriptCommand = new StringBuilder();
                scriptCommand.append("window.lat = ").append(lat).append(";").append("window.lon = ").append(lon).append(";").append("window.locationName = \"").append(name).append("\";").append("window.locationInfo = \"").append(info.toString()).append("\";").append("window.poiColor = \"").append(color).append("\";").append("document.addPoi(window.locationName, window.locationInfo, window.lat, window.lon, window.poiColor);");
                this.webEngine.executeScript(scriptCommand.toString());
            });
        }
    }

    private void removePoi(Location POI) {
        if (this.readyToGo) {
            Platform.runLater(() -> {
                String name = POI.getName();
                StringBuilder scriptCommand = new StringBuilder();
                scriptCommand.append("window.locationName = \"").append(name).append("\";").append("document.removePoi(window.locationName);");
                this.webEngine.executeScript(scriptCommand.toString());
            });
        }
    }

    private void updateLocationColor() {
        if (this.readyToGo) {
            Platform.runLater(() -> {
                String locationColor = this.tile.getCurrentLocation().getFill().toString().replace("0x", "#");
                StringBuilder scriptCommand = new StringBuilder();
                scriptCommand.append("window.locationColor = '").append(locationColor).append("';").append("document.setLocationColor(window.locationColor);");
                this.webEngine.executeScript(scriptCommand.toString());
            });
        }
    }

    private void updateTrackColor() {
        if (this.readyToGo) {
            Platform.runLater(() -> {
                String trackColor = this.tile.getTrackColor().styleName;
                StringBuilder scriptCommand = new StringBuilder();
                scriptCommand.append("window.trackColor = '").append(trackColor).append("';").append("document.setTrackColor(window.trackColor);");
                this.webEngine.executeScript(scriptCommand.toString());
            });
        }
    }

    private void centerLocation() {
        if (this.readyToGo) {
            Platform.runLater(() -> {
                StringBuilder scriptCommand = new StringBuilder();
                scriptCommand.append("window.zoomLevel = ").append(this.tile.getCurrentLocation().getZoomLevel()).append(";");
                scriptCommand.append("document.zoomToLocation(window.zoomLevel);");
                this.webEngine.executeScript(scriptCommand.toString());
            });
        }
    }

    private void addTrack(List<Location> LOCATIONS) {
        if (LOCATIONS.isEmpty() && this.readyToGo) {
            Platform.runLater(() -> {
                StringBuilder scriptCommand = new StringBuilder();
                scriptCommand.append("document.clearTrack();");
                this.webEngine.executeScript(scriptCommand.toString());
            });
            return;
        }
        int length = LOCATIONS.size();
        if (length <= 4) {
            return;
        }
        if (this.readyToGo) {
            Platform.runLater(() -> {
                String time;
                String date;
                String name;
                double lon1;
                double lat1;
                StringBuilder scriptCommand = new StringBuilder();
                String trackColor = this.tile.getTrackColor().styleName;
                for (int i = 0; i < length - 1; ++i) {
                    scriptCommand.setLength(0);
                    lat1 = ((Location)LOCATIONS.get(i)).getLatitude();
                    lon1 = ((Location)LOCATIONS.get(i)).getLongitude();
                    double lat2 = ((Location)LOCATIONS.get(i + 1)).getLatitude();
                    double lon2 = ((Location)LOCATIONS.get(i + 1)).getLongitude();
                    name = ((Location)LOCATIONS.get(i)).getName();
                    date = DF.format(((Location)LOCATIONS.get(i)).getLocalDateTime(ZoneId.systemDefault()));
                    time = TF.format(((Location)LOCATIONS.get(i)).getLocalDateTime(ZoneId.systemDefault()));
                    scriptCommand.append("window.lat1 = ").append(lat1).append(";").append("window.lon1 = ").append(lon1).append(";").append("window.lat2 = ").append(lat2).append(";").append("window.lon2 = ").append(lon2).append(";").append("window.locationName = \"").append(name).append("\";").append("window.locationDate = \"").append(date).append("\";").append("window.locationTime = \"").append(time).append("\";").append("window.trackColor = \"").append(trackColor).append("\";").append("document.addToTrack(window.lat1, window.lon1, window.lat2, window.lon2,window.locationName, window.locationDate, window.locationTime, window.trackColor);");
                    this.webEngine.executeScript(scriptCommand.toString());
                }
                scriptCommand.setLength(0);
                lat1 = ((Location)LOCATIONS.get(0)).getLatitude();
                lon1 = ((Location)LOCATIONS.get(0)).getLongitude();
                name = ((Location)LOCATIONS.get(0)).getName();
                date = DF.format(((Location)LOCATIONS.get(0)).getLocalDateTime(ZoneId.systemDefault()));
                time = TF.format(((Location)LOCATIONS.get(0)).getLocalDateTime(ZoneId.systemDefault()));
                scriptCommand.append("window.lat1 = ").append(lat1).append(";").append("window.lon1 = ").append(lon1).append(";").append("window.locationName = \"").append(name).append("\";").append("window.locationDate = \"").append(date).append("\";").append("window.locationTime = \"").append(time).append("\";").append("document.addStartPoiMarker(window.lat1, window.lon1, window.locationName, window.locationDate, window.locationTime);");
                this.webEngine.executeScript(scriptCommand.toString());
                scriptCommand.setLength(0);
                lat1 = ((Location)LOCATIONS.get(length - 1)).getLatitude();
                lon1 = ((Location)LOCATIONS.get(length - 1)).getLongitude();
                name = ((Location)LOCATIONS.get(length - 1)).getName();
                date = DF.format(((Location)LOCATIONS.get(length - 1)).getLocalDateTime(ZoneId.systemDefault()));
                time = TF.format(((Location)LOCATIONS.get(length - 1)).getLocalDateTime(ZoneId.systemDefault()));
                scriptCommand.append("window.lat1 = ").append(lat1).append(";").append("window.lon1 = ").append(lon1).append(";").append("window.locationName = \"").append(name).append("\";").append("window.locationDate = \"").append(date).append("\";").append("window.locationTime = \"").append(time).append("\";").append("document.addStopPoiMarker(window.lat1, window.lon1, window.locationName, window.locationDate, window.locationTime);");
                this.webEngine.executeScript(scriptCommand.toString());
            });
        }
    }

    private void changeMapProvider(Tile.MapProvider PROVIDER) {
        if (this.readyToGo) {
            Platform.runLater(() -> {
                StringBuilder scriptCommand = new StringBuilder();
                scriptCommand.append("window.provider = '").append(PROVIDER.name).append("';").append("document.changeMapProvider(window.provider);");
                this.webEngine.executeScript(scriptCommand.toString());
            });
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double containerWidth = this.contentBounds.getWidth();
        double containerHeight = this.contentBounds.getHeight();
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            if (containerWidth > 0.0 && containerHeight > 0.0) {
                this.webView.setMinSize(containerWidth, containerHeight);
                this.webView.setMaxSize(containerWidth, containerHeight);
                this.webView.setPrefSize(containerWidth, containerHeight);
                this.webView.relocate(this.contentBounds.getX(), this.contentBounds.getY());
            }
            this.resizeStaticText();
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
        this.updateLocationColor();
        this.updateTrackColor();
    }
}

