/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.chart;

import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.toolboxfx.GradientLookup;
import eu.hansolo.toolboxfx.geom.Location;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class ChartDataBuilder<B extends ChartDataBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected ChartDataBuilder() {
    }

    public static final ChartDataBuilder create() {
        return new ChartDataBuilder();
    }

    public final B name(String NAME) {
        this.properties.put("name", new SimpleStringProperty(NAME));
        return (B)this;
    }

    public final B value(double VALUE) {
        this.properties.put("value", new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B timestamp(Instant TIMESTAMP) {
        this.properties.put("timestamp", new SimpleObjectProperty<Instant>(TIMESTAMP));
        return (B)this;
    }

    public final B timestamp(ZonedDateTime TIMESTAMP) {
        this.properties.put("timestamp", new SimpleObjectProperty<Instant>(TIMESTAMP.toInstant()));
        return (B)this;
    }

    public final B duration(Duration DURATION) {
        this.properties.put("duration", new SimpleObjectProperty<Duration>(DURATION));
        return (B)this;
    }

    public final B location(Location LOCATION) {
        this.properties.put("location", new SimpleObjectProperty<Location>(LOCATION));
        return (B)this;
    }

    public final B fillColor(Color COLOR) {
        this.properties.put("fillColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B strokeColor(Color COLOR) {
        this.properties.put("strokeColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B animated(boolean ANIMATED) {
        this.properties.put("animated", new SimpleBooleanProperty(ANIMATED));
        return (B)this;
    }

    public final B formatString(String FORMAT_STRING) {
        this.properties.put("formatString", new SimpleStringProperty(FORMAT_STRING));
        return (B)this;
    }

    public final B minValue(double MIN_VALUE) {
        this.properties.put("minValue", new SimpleDoubleProperty(MIN_VALUE));
        return (B)this;
    }

    public final B maxValue(double MAX_VALUE) {
        this.properties.put("maxValue", new SimpleDoubleProperty(MAX_VALUE));
        return (B)this;
    }

    public final B gradientLookup(GradientLookup GRADIENT_LOOKUP) {
        this.properties.put("gradientLookup", new SimpleObjectProperty<GradientLookup>(GRADIENT_LOOKUP));
        return (B)this;
    }

    public final B useChartDataColor(boolean USE) {
        this.properties.put("useChartDataColor", new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B onChartDataEvent(ChartDataEventListener HANDLER) {
        this.properties.put("onChartDataEvent", new SimpleObjectProperty<ChartDataEventListener>(HANDLER));
        return (B)this;
    }

    public final B image(Image IMAGE) {
        this.properties.put("image", new SimpleObjectProperty<Image>(IMAGE));
        return (B)this;
    }

    public final ChartData build() {
        ChartData DATA = new ChartData();
        for (String key : this.properties.keySet()) {
            if ("name".equals(key)) {
                DATA.setName((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("value".equals(key)) {
                DATA.setValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("timestamp".equals(key)) {
                DATA.setTimestamp((Instant)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("duration".equals(key)) {
                DATA.setDuration((Duration)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("location".equals(key)) {
                DATA.setLocation((Location)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("fillColor".equals(key)) {
                DATA.setFillColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("strokeColor".equals(key)) {
                DATA.setStrokeColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textColor".equals(key)) {
                DATA.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("animated".equals(key)) {
                DATA.setAnimated(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("formatString".equals(key)) {
                DATA.setFormatString((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minValue".equals(key)) {
                DATA.setMinValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxValue".equals(key)) {
                DATA.setMaxValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("gradientLookup".equals(key)) {
                DATA.setGradientLookup((GradientLookup)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("useChartDataColor".equals(key)) {
                DATA.setUseChartDataColors(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onChartDataEvent".equals(key)) {
                DATA.setOnChartDataEvent((ChartDataEventListener)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"image".equals(key)) continue;
            DATA.setImage((Image)((ObjectProperty)this.properties.get(key)).get());
        }
        return DATA;
    }
}

