/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.addons;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.addons.Spinner;
import eu.hansolo.tilesfx.addons.SpinnerType;
import eu.hansolo.tilesfx.events.SpinnerEvent;
import eu.hansolo.tilesfx.events.SpinnerEventType;
import eu.hansolo.tilesfx.events.SpinnerObserver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.DefaultProperty;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

@DefaultProperty(value="children")
public class CanvasSpinner
extends Region
implements Spinner {
    protected static final double PREFERRED_WIDTH = 100.0;
    protected static final double PREFERRED_HEIGHT = 144.0;
    protected static final double MINIMUM_WIDTH = 10.0;
    protected static final double MINIMUM_HEIGHT = 10.0;
    protected static final double MAXIMUM_WIDTH = 1024.0;
    protected static final double MAXIMUM_HEIGHT = 1024.0;
    private final SpinnerEvent VALUE_CHANGED_EVENT = new SpinnerEvent(this, SpinnerEventType.VALUE_CHANGED);
    private final SpinnerEvent ZERO_PASSED_EVENT = new SpinnerEvent(this, SpinnerEventType.ZERO_PASSED);
    private static double aspectRatio;
    private boolean keepAspect;
    private double width;
    private double height;
    private double extendedHeight;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Rectangle overlay;
    private Canvas imageCanvas;
    private GraphicsContext imageCtx;
    private WritableImage image;
    private Pane pane;
    private SnapshotParameters snapshotParameters;
    private double digitWidth;
    private double digitHeight;
    private double columnHeight;
    private double verticalSpace;
    private double zeroOffset;
    private Color _backgroundColor;
    private ObjectProperty<Color> backgroundColor;
    private Color _foregroundColor;
    private ObjectProperty<Color> foregroundColor;
    private Font font;
    private double oldValue;
    private double _value;
    private DoubleProperty value;
    private boolean _backgroundVisible;
    private BooleanProperty backgroundVisible;
    private boolean _overlayVisible;
    private BooleanProperty overlayVisible;
    private boolean initialized;
    private SpinnerType spinnerType;
    private Timeline timeline;
    private Map<SpinnerObserver, SpinnerEventType> observers;
    private BooleanBinding showing;

    public CanvasSpinner() {
        this(SpinnerType.NUMERIC_0_9);
    }

    public CanvasSpinner(SpinnerType SpinnerTYPE) {
        this.getStylesheets().add(CanvasSpinner.class.getResource("spinner.css").toExternalForm());
        aspectRatio = 1.44;
        this.width = 100.0;
        this.height = 144.0;
        this.keepAspect = true;
        this._backgroundColor = Tile.BACKGROUND;
        this._foregroundColor = Tile.FOREGROUND;
        this.oldValue = 0.0;
        this._value = 0.0;
        this._backgroundVisible = true;
        this._overlayVisible = true;
        this.initialized = false;
        this.spinnerType = SpinnerTYPE;
        this.timeline = new Timeline();
        this.observers = new ConcurrentHashMap<SpinnerObserver, SpinnerEventType>();
        this.snapshotParameters = new SnapshotParameters();
        this.snapshotParameters.setFill(Tile.BACKGROUND);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(this.width, this.height);
            }
        }
        this.getStyleClass().add("spinner");
        this.canvas = new Canvas(this.width, this.height);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.imageCanvas = new Canvas(this.width, this.height);
        this.imageCtx = this.imageCanvas.getGraphicsContext2D();
        this.imageCtx.setLineWidth(1.0);
        this.imageCtx.setTextAlign(TextAlignment.CENTER);
        this.imageCtx.setTextBaseline(VPos.CENTER);
        LinearGradient overlayGradient = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, Color.rgb(0, 0, 0, 1.0)), new Stop(0.1, Color.rgb(0, 0, 0, 0.4)), new Stop(0.33, Color.rgb(255, 255, 255, 0.45)), new Stop(0.46, Color.rgb(255, 255, 255, 0.0)), new Stop(0.9, Color.rgb(0, 0, 0, 0.4)), new Stop(1.0, Color.rgb(0, 0, 0, 1.0)));
        this.overlay = new Rectangle();
        this.overlay.setFill(overlayGradient);
        this.pane = new Pane(this.canvas, this.overlay);
        this.getChildren().setAll((Node[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        if (null != this.getScene()) {
            this.setupBinding();
        } else {
            this.sceneProperty().addListener((o1, ov1, nv1) -> {
                if (null == nv1) {
                    return;
                }
                if (null != this.getScene().getWindow()) {
                    this.setupBinding();
                } else {
                    ((Scene)this.sceneProperty().get()).windowProperty().addListener((o2, ov2, nv2) -> {
                        if (null == nv2) {
                            return;
                        }
                        this.setupBinding();
                    });
                }
            });
        }
    }

    private void setupBinding() {
        this.showing = Bindings.createBooleanBinding(() -> {
            if (this.getScene() != null && this.getScene().getWindow() != null) {
                return this.getScene().getWindow().isShowing();
            }
            return false;
        }, this.sceneProperty(), this.getScene().windowProperty(), this.getScene().getWindow().showingProperty());
        this.showing.addListener(o -> {
            if (this.showing.get()) {
                this.redraw();
            }
        });
    }

    private void init() {
        if (!this.isShowing()) {
            return;
        }
        this.setBackground(new Background(new BackgroundFill(this.getBackgroundColor(), CornerRadii.EMPTY, Insets.EMPTY)));
        this.imageCtx.clearRect(0.0, 0.0, this.digitWidth, this.extendedHeight);
        if (this.isBackgroundVisible()) {
            this.imageCtx.setFill(this.getBackgroundColor());
            this.imageCtx.fillRect(0.0, 0.0, this.digitWidth, this.extendedHeight);
            this.imageCtx.setStroke(Color.web("#f0f0f0"));
            this.imageCtx.strokeLine(0.0, 0.0, 0.0, this.extendedHeight);
            this.imageCtx.setStroke(Color.web("#202020"));
            this.imageCtx.strokeLine(this.digitWidth, 0.0, this.digitWidth, this.extendedHeight);
        }
        this.imageCtx.setFont(this.font);
        this.imageCtx.setFill(this.getForegroundColor());
        switch (this.spinnerType) {
            case ALPHABETIC: {
                for (int i = 0; i < 28; ++i) {
                    this.imageCtx.fillText(this.spinnerType.getCharacters()[i % 27], this.digitWidth * 0.5, this.verticalSpace * (double)(i + 0) + this.verticalSpace / 2.0);
                }
                break;
            }
            case NUMERIC_0_9: {
                for (int i = 9; i < 21; ++i) {
                    this.imageCtx.fillText(this.spinnerType.getCharacters()[i % 10], this.digitWidth * 0.5, this.verticalSpace * (double)(i - 9) + this.verticalSpace / 2.0);
                }
                break;
            }
            case NUMERIC_0_5: {
                for (int i = 5; i < 13; ++i) {
                    this.imageCtx.fillText(this.spinnerType.getCharacters()[i % 6], this.digitWidth * 0.5, this.verticalSpace * (double)(i - 5) + this.verticalSpace / 2.0);
                }
                break;
            }
            case NUMERIC_0_3: {
                for (int i = 3; i < 9; ++i) {
                    this.imageCtx.fillText(this.spinnerType.getCharacters()[i % 4], this.digitWidth * 0.5, this.verticalSpace * (double)(i - 3) + this.verticalSpace / 2.0);
                }
                break;
            }
            case NUMERIC_0_2: {
                for (int i = 2; i < 7; ++i) {
                    this.imageCtx.fillText(this.spinnerType.getCharacters()[i % 3], this.digitWidth * 0.5, this.verticalSpace * (double)(i - 2) + this.verticalSpace / 2.0);
                }
                break;
            }
            case NUMERIC_0_1: {
                for (int i = 1; i < 5; ++i) {
                    this.imageCtx.fillText(this.spinnerType.getCharacters()[i % 2], this.digitWidth * 0.5, this.verticalSpace * (double)(i - 1) + this.verticalSpace / 2.0);
                }
                break;
            }
            case SIGNS: {
                for (int i = 0; i < 2; ++i) {
                    this.imageCtx.fillText(this.spinnerType.getCharacters()[i % 2], this.digitWidth * 0.5, this.verticalSpace * (double)(i + 1) + this.verticalSpace / 2.0);
                }
                break;
            }
        }
        this.image = this.imageCanvas.snapshot(this.snapshotParameters, null);
        this.initialized = true;
    }

    private void initOverlay() {
        if (this.isOverlayVisible()) {
            LinearGradient overlayGradient = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, Color.rgb(0, 0, 0, 1.0)), new Stop(0.1, Color.rgb(0, 0, 0, 0.4)), new Stop(0.33, Color.rgb(255, 255, 255, 0.45)), new Stop(0.46, Color.rgb(255, 255, 255, 0.0)), new Stop(0.9, Color.rgb(0, 0, 0, 0.4)), new Stop(1.0, Color.rgb(0, 0, 0, 1.0)));
            this.overlay.setFill(overlayGradient);
        } else {
            LinearGradient overlayGradient = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, this.getBackgroundColor()), new Stop(0.1, this.getBackgroundColor()), new Stop(0.101, Color.TRANSPARENT), new Stop(1.0, Color.TRANSPARENT));
            this.overlay.setFill(overlayGradient);
        }
    }

    @Override
    public void layoutChildren() {
        super.layoutChildren();
    }

    @Override
    protected double computeMinWidth(double height) {
        return 10.0;
    }

    @Override
    protected double computeMinHeight(double width) {
        return 10.0;
    }

    @Override
    protected double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    @Override
    protected double computePrefHeight(double width) {
        return super.computePrefHeight(width);
    }

    @Override
    protected double computeMaxWidth(double height) {
        return 1024.0;
    }

    @Override
    protected double computeMaxHeight(double width) {
        return 1024.0;
    }

    @Override
    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    @Override
    public double getOldValue() {
        return this.oldValue;
    }

    @Override
    public double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    @Override
    public void setValue(double value) {
        if (null == this.value) {
            this.oldValue = this._value;
            if (value < 0.0 || value > (double)this.spinnerType.getUpperLimit()) {
                this._value = 0.0;
                this.fireSpinnerEvent(this.ZERO_PASSED_EVENT);
            } else {
                this._value = value;
                if ((int)this._value != (int)this.oldValue) {
                    this.fireSpinnerEvent(this.VALUE_CHANGED_EVENT);
                    if ((int)this._value == 0) {
                        this.fireSpinnerEvent(this.ZERO_PASSED_EVENT);
                    }
                }
            }
            this.redraw();
        } else {
            this.value.set(value);
        }
    }

    public void setValue(Character character) {
        if (SpinnerType.NUMERIC_0_9 == this.spinnerType || SpinnerType.NUMERIC_0_5 == this.spinnerType) {
            throw new IllegalArgumentException("Type must be of type ALPHABETIC or SIGN");
        }
        this.setValue(character.charValue() - 65);
    }

    @Override
    public DoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new DoublePropertyBase(this._value){

                @Override
                protected void invalidated() {
                    if (this.get() < 0.0 || this.get() > (double)CanvasSpinner.this.spinnerType.getUpperLimit()) {
                        this.set(0.0);
                    }
                    CanvasSpinner.this.redraw();
                }

                @Override
                public Object getBean() {
                    return CanvasSpinner.this;
                }

                @Override
                public String getName() {
                    return "value";
                }
            };
            this.value.addListener((o, ov, nv) -> {
                this.oldValue = ov.doubleValue();
                if (nv.intValue() != ov.intValue()) {
                    this.fireSpinnerEvent(this.VALUE_CHANGED_EVENT);
                    if (nv.intValue() == 0) {
                        this.fireSpinnerEvent(this.ZERO_PASSED_EVENT);
                    }
                }
            });
        }
        return this.value;
    }

    @Override
    public boolean isBackgroundVisible() {
        return null == this.backgroundVisible ? this._backgroundVisible : this.backgroundVisible.get();
    }

    @Override
    public void setBackgroundVisible(boolean visible) {
        if (null == this.overlayVisible) {
            this._backgroundVisible = visible;
            this.initialized = false;
            this.redraw();
        } else {
            this.backgroundVisible.set(visible);
        }
    }

    @Override
    public BooleanProperty backgroundVisibleProperty() {
        if (null == this.backgroundVisible) {
            this.backgroundVisible = new BooleanPropertyBase(this._backgroundVisible){

                @Override
                protected void invalidated() {
                    CanvasSpinner.this.initialized = false;
                    CanvasSpinner.this.redraw();
                }

                @Override
                public Object getBean() {
                    return CanvasSpinner.this;
                }

                @Override
                public String getName() {
                    return "overlayVisible";
                }
            };
        }
        return this.backgroundVisible;
    }

    @Override
    public boolean isOverlayVisible() {
        return null == this.overlayVisible ? this._overlayVisible : this.overlayVisible.get();
    }

    @Override
    public void setOverlayVisible(boolean visible) {
        if (null == this.overlayVisible) {
            this._overlayVisible = visible;
            this.initOverlay();
        } else {
            this.overlayVisible.set(visible);
        }
    }

    @Override
    public BooleanProperty overlayVisibleProperty() {
        if (null == this.overlayVisible) {
            this.overlayVisible = new BooleanPropertyBase(this._overlayVisible){

                @Override
                protected void invalidated() {
                    CanvasSpinner.this.initOverlay();
                }

                @Override
                public Object getBean() {
                    return CanvasSpinner.this;
                }

                @Override
                public String getName() {
                    return "overlayVisible";
                }
            };
        }
        return this.overlayVisible;
    }

    @Override
    public void spinUp() {
        double targetValue;
        if (null == this.value) {
            this.value = this.valueProperty();
        }
        if (Double.compare(this.getValue(), this.spinnerType.upperLimit) == 0) {
            this.setValue(0.0);
            targetValue = 1.0;
        } else {
            targetValue = this.getValue() + 1.0;
        }
        KeyValue kv0 = new KeyValue(this.value, this.getValue(), Interpolator.LINEAR);
        KeyValue kv1 = new KeyValue(this.value, targetValue, Interpolator.LINEAR);
        KeyFrame kf0 = new KeyFrame(Duration.ZERO, kv0);
        KeyFrame kf1 = new KeyFrame(Duration.millis(500.0), kv1);
        this.timeline.stop();
        this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{kf0, kf1});
        this.timeline.play();
    }

    @Override
    public void spinDown() {
        if (null == this.value) {
            this.value = this.valueProperty();
        }
        KeyValue kv0 = new KeyValue(this.value, this.getValue(), Interpolator.LINEAR);
        KeyValue kv1 = new KeyValue(this.value, this.getValue() - 1.0, Interpolator.LINEAR);
        KeyFrame kf0 = new KeyFrame(Duration.ZERO, kv0);
        KeyFrame kf1 = new KeyFrame(Duration.millis(500.0), kv1);
        this.timeline.stop();
        this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{kf0, kf1});
        this.timeline.play();
    }

    @Override
    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (null == this.backgroundColor) {
            this._backgroundColor = color;
            this.initialized = false;
            this.redraw();
        } else {
            this.backgroundColor.set(color);
        }
    }

    @Override
    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                @Override
                protected void invalidated() {
                    CanvasSpinner.this.initialized = false;
                    CanvasSpinner.this.redraw();
                }

                @Override
                public Object getBean() {
                    return CanvasSpinner.this;
                }

                @Override
                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    @Override
    public Color getForegroundColor() {
        return null == this.foregroundColor ? this._foregroundColor : (Color)this.foregroundColor.get();
    }

    @Override
    public void setForegroundColor(Color color) {
        if (null == this.foregroundColor) {
            this._foregroundColor = color;
            this.initialized = false;
            this.redraw();
        } else {
            this.foregroundColor.set(color);
        }
    }

    @Override
    public ObjectProperty<Color> foregroundColorProperty() {
        if (null == this.foregroundColor) {
            this.foregroundColor = new ObjectPropertyBase<Color>(this._foregroundColor){

                @Override
                protected void invalidated() {
                    CanvasSpinner.this.initialized = false;
                    CanvasSpinner.this.redraw();
                }

                @Override
                public Object getBean() {
                    return CanvasSpinner.this;
                }

                @Override
                public String getName() {
                    return "foregroundColor";
                }
            };
            this._foregroundColor = null;
        }
        return this.foregroundColor;
    }

    @Override
    public SpinnerType getSpinnerType() {
        return this.spinnerType;
    }

    @Override
    public void setSpinnerType(SpinnerType spinnerType) {
        this.spinnerType = spinnerType;
        this.initialized = false;
        this.redraw();
    }

    @Override
    public boolean isShowing() {
        return null != this.showing && this.showing.get();
    }

    @Override
    public void setSnapshotBackground(Color color) {
        this.snapshotParameters.setFill(color);
        this.initialized = false;
        this.redraw();
    }

    @Override
    public void reInit() {
        this.initialized = false;
        this.redraw();
    }

    @Override
    public double getSpinnerWidth() {
        return this.width;
    }

    @Override
    public double getSpinnerHeight() {
        return this.height;
    }

    @Override
    public double getDigitHeight() {
        return this.digitHeight;
    }

    @Override
    public double getExtendedHeight() {
        return this.extendedHeight;
    }

    private void drawCharacters() {
        double value = this.getValue();
        int numb = (int)Math.floor(value);
        double fraction = value - (double)numb;
        String numbString = Integer.toString(numb);
        int idx = numbString.length() - 1;
        int num = idx < 0 ? 0 : numb;
        this.ctx.drawImage(this.image, this.width - this.digitWidth, -(this.verticalSpace * ((double)num + fraction) + this.zeroOffset));
    }

    @Override
    public void setOnValueChanged(SpinnerObserver observer) {
        if (!this.observers.containsKey(observer)) {
            this.observers.put(observer, SpinnerEventType.VALUE_CHANGED);
        }
    }

    @Override
    public void setOnZeroPassed(SpinnerObserver observer) {
        if (!this.observers.containsKey(observer)) {
            this.observers.put(observer, SpinnerEventType.ZERO_PASSED);
        }
    }

    @Override
    public void setOnSpinnerEvent(SpinnerObserver observer) {
        if (!this.observers.containsKey(observer)) {
            this.observers.put(observer, SpinnerEventType.ANY);
        }
    }

    @Override
    public void removeSpinnerObserver(SpinnerObserver observer) {
        if (this.observers.containsKey(observer)) {
            this.observers.remove(observer);
        }
    }

    @Override
    public void removeAllObservers() {
        this.observers.clear();
    }

    @Override
    public void fireSpinnerEvent(SpinnerEvent evt) {
        SpinnerEventType spinnerEventType = evt.getType();
        Stream stream = this.observers.entrySet().stream();
        switch (spinnerEventType) {
            case VALUE_CHANGED: {
                stream.filter(entry -> entry.getValue() == SpinnerEventType.VALUE_CHANGED).forEach(entry -> ((SpinnerObserver)entry.getKey()).onSpinnerEvent(evt));
                break;
            }
            case ZERO_PASSED: {
                stream.filter(entry -> entry.getValue() == SpinnerEventType.ZERO_PASSED).forEach(entry -> ((SpinnerObserver)entry.getKey()).onSpinnerEvent(evt));
                break;
            }
            default: {
                stream.filter(entry -> entry.getValue() == SpinnerEventType.ANY).forEach(entry -> ((SpinnerObserver)entry.getKey()).onSpinnerEvent(evt));
            }
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (this.keepAspect) {
            if (aspectRatio * this.width > this.height) {
                this.width = 1.0 / (aspectRatio / this.height);
            } else if (1.0 / (aspectRatio / this.height) > this.width) {
                this.height = aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.digitHeight = Math.floor(this.height * 0.85);
            this.width = this.digitWidth = this.isBackgroundVisible() ? Math.floor(this.height * 0.68) : this.width;
            this.font = Font.font(this.digitHeight);
            switch (this.spinnerType) {
                case ALPHABETIC: {
                    this.columnHeight = this.digitHeight * 28.0;
                    this.verticalSpace = this.columnHeight / 29.0;
                    break;
                }
                case SIGNS: {
                    this.columnHeight = this.digitHeight * 1.0;
                    this.verticalSpace = this.columnHeight / 2.0;
                    break;
                }
                case NUMERIC_0_9: 
                case NUMERIC_0_5: 
                case NUMERIC_0_3: 
                case NUMERIC_0_2: 
                case NUMERIC_0_1: {
                    this.columnHeight = this.digitHeight * 11.0;
                    this.verticalSpace = this.columnHeight / 12.0;
                }
            }
            this.extendedHeight = this.columnHeight * 1.1;
            this.zeroOffset = this.verticalSpace * 0.81;
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.imageCanvas.setWidth(this.digitWidth);
            this.imageCanvas.setHeight(this.extendedHeight);
            this.overlay.setWidth(this.digitWidth);
            this.overlay.setHeight(this.height);
            this.initialized = false;
            this.redraw();
        }
    }

    private void redraw() {
        if (!this.initialized) {
            this.init();
        }
        this.drawCharacters();
    }
}

