/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries.tools;

import eu.hansolo.fx.countries.Country;
import eu.hansolo.fx.countries.tools.CountryPath;
import eu.hansolo.fx.countries.tools.OperatingSystem;
import eu.hansolo.fx.countries.tools.Records;
import eu.hansolo.fx.countries.tools.Resolution;
import eu.hansolo.fx.countries.tools.Size;
import eu.hansolo.toolboxfx.geom.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.Interpolator;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;

public class Helper {
    private static final List<Records.City> cities = new ArrayList<Records.City>();
    private static final List<Records.City> capitals = new ArrayList<Records.City>();
    private static final Map<String, Records.Airport> airports = new HashMap<String, Records.Airport>();
    private static final Map<Country, Long> populations = new HashMap<Country, Long>();
    private static final NavigableMap<Long, String> SUFFIXES = new TreeMap<Long, String>(Map.of(1000L, "k", 1000000L, "M", 1000000000L, "G", 1000000000000L, "T", 1000000000000000L, "P", 1000000000000000000L, "E"));

    public static final int clamp(int min2, int max, int value) {
        if (value < min2) {
            return min2;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final long clamp(long min2, long max, long value) {
        if (value < min2) {
            return min2;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final float clamp(float min2, float max, float value) {
        if (value < min2) {
            return min2;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final double clamp(double min2, double max, double value) {
        if (value < min2) {
            return min2;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final OperatingSystem getOperatingSystem() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            return OperatingSystem.WINDOWS;
        }
        if (os.indexOf("mac") >= 0) {
            return OperatingSystem.MACOS;
        }
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            return OperatingSystem.LINUX;
        }
        if (os.indexOf("sunos") >= 0) {
            return OperatingSystem.SOLARIS;
        }
        return OperatingSystem.NONE;
    }

    public static final List<Records.City> getCities() {
        if (cities.isEmpty()) {
            try (InputStream in = Helper.class.getResourceAsStream("cities.txt");
                 BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                Stream<String> lines = reader.lines();
                lines.forEach(line -> {
                    long population;
                    String[] cityParts = line.split(",");
                    String name = cityParts[0];
                    double lat = Double.parseDouble(cityParts[2]);
                    double lon = Double.parseDouble(cityParts[3]);
                    Optional<Country> countryOpt = Country.fromIso2(cityParts[5]);
                    Country country = countryOpt.isPresent() ? countryOpt.get() : null;
                    boolean capital = cityParts[8].equals("primary");
                    long l = population = cityParts.length == 10 ? Long.parseLong(cityParts[9]) : -1L;
                    if (null != country) {
                        cities.add(new Records.City(name, lat, lon, country, capital, population));
                    }
                });
                lines.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return cities;
    }

    public static final List<Records.City> getCapitals() {
        if (capitals.isEmpty()) {
            capitals.addAll(Helper.getCities().stream().filter(city -> city.isCapital()).collect(Collectors.toList()));
        }
        return capitals;
    }

    public static final Map<String, Records.Airport> getAirports() {
        if (airports.isEmpty()) {
            try (InputStream in = Helper.class.getResourceAsStream("airports.txt");
                 BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                Stream<String> lines = reader.lines();
                lines.forEach(line -> {
                    String[] airportParts = line.split(",");
                    Size size = Size.fromText(airportParts[0]);
                    String name = airportParts[1];
                    Optional<Country> countryOpt = Country.fromIso2(airportParts[2]);
                    String iata = airportParts[3];
                    double lat = Double.parseDouble(airportParts[4]);
                    double lon = Double.parseDouble(airportParts[5]);
                    if (countryOpt.isPresent()) {
                        airports.put(iata, new Records.Airport(name, lat, lon, countryOpt.get(), size, iata));
                    }
                });
                lines.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return airports;
    }

    public static final Map<Country, Long> getPopulations() {
        if (populations.isEmpty()) {
            try (InputStream in = Helper.class.getResourceAsStream("population_2020.txt");
                 BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                Stream<String> lines = reader.lines();
                lines.forEach(line -> {
                    String[] populationParts = line.split(",");
                    String countryIso2 = populationParts[0];
                    Optional<Country> countryOpt = Country.fromIso2(countryIso2);
                    Long population = Long.valueOf(populationParts[1]);
                    if (countryOpt.isPresent()) {
                        populations.put(countryOpt.get(), population);
                    }
                });
                lines.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return populations;
    }

    public static final Map<String, List<CountryPath>> createCountryPaths(Resolution resolution) {
        Properties properties = Helper.readProperties(Resolution.HI_RES == resolution ? "eu/hansolo/fx/countries/hires.properties" : "eu/hansolo/fx/countries/lores.properties");
        HashMap<String, List<CountryPath>> countryPaths = new HashMap<String, List<CountryPath>>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String name = key.toString();
            ArrayList<CountryPath> pathList = new ArrayList<CountryPath>();
            for (String path : value.toString().split(";")) {
                pathList.add(new CountryPath(name, path));
            }
            countryPaths.put(name, pathList);
        }));
        return countryPaths;
    }

    public static final Map<Country, List<CountryPath>> createCountryPaths2(Resolution resolution) {
        Properties resolutionProperties = Helper.readProperties(Resolution.HI_RES == resolution ? "eu/hansolo/fx/countries/hires.properties" : "eu/hansolo/fx/countries/lores.properties");
        HashMap<Country, List<CountryPath>> countryPaths = new HashMap<Country, List<CountryPath>>();
        resolutionProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String iso2 = key.toString();
            Optional<Country> country = Country.fromIso2(key.toString());
            if (country.isEmpty()) {
                return;
            }
            ArrayList<CountryPath> pathList = new ArrayList<CountryPath>();
            for (String path : value.toString().split(";")) {
                pathList.add(new CountryPath(iso2, path));
            }
            countryPaths.put(country.get(), pathList);
        }));
        return countryPaths;
    }

    public static final String colorToWeb(Color color) {
        return color.toString().replace("0x", "#").substring(0, 7);
    }

    public static final Color getColorAt(LinearGradient gradient, double fraction) {
        List<Stop> stops = gradient.getStops();
        double frctn = fraction < 0.0 ? 0.0 : (fraction > 1.0 ? 1.0 : fraction);
        Stop lowerStop = new Stop(0.0, stops.get(0).getColor());
        Stop upperStop = new Stop(1.0, stops.get(stops.size() - 1).getColor());
        for (Stop stop : stops) {
            double currentFraction = stop.getOffset();
            if (Double.compare(currentFraction, frctn) == 0) {
                return stop.getColor();
            }
            if (Double.compare(currentFraction, frctn) < 0) {
                lowerStop = new Stop(currentFraction, stop.getColor());
                continue;
            }
            upperStop = new Stop(currentFraction, stop.getColor());
            break;
        }
        double interpolationFraction = (frctn - lowerStop.getOffset()) / (upperStop.getOffset() - lowerStop.getOffset());
        return (Color)Interpolator.LINEAR.interpolate(lowerStop.getColor(), upperStop.getColor(), interpolationFraction);
    }

    public static final double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static final double bearing(Point p1, Point p2) {
        return Helper.bearing(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static final double bearing(double x1, double y1, double x2, double y2) {
        double bearing = Math.toDegrees(Math.atan2(y2 - y1, x2 - x1)) + 90.0;
        if (bearing < 0.0) {
            bearing += 360.0;
        }
        return bearing;
    }

    public static final int getMinutes(double decimalDegree) {
        return (int)((decimalDegree - (double)((int)decimalDegree)) * 60.0);
    }

    public static final double getSeconds(double decimalDegree) {
        return ((decimalDegree - (double)((int)decimalDegree)) * 60.0 - (double)Helper.getMinutes(decimalDegree)) * 60.0;
    }

    public static final double getDecimalDeg(int degrees2, int minutes, double seconds) {
        return (seconds / 60.0 + (double)minutes) / 60.0 + (double)degrees2;
    }

    public static final Point latLonToXY(double lat, double lon) {
        double[] xy = Helper.latLonToXY(lat, lon, -28.7565, 129.675, 1009.0, 665.0);
        return new Point(xy[0], xy[1]);
    }

    public static final Point latLonToXY(Point latlon) {
        return Helper.latLonToXY(latlon, -28.7565, 129.675, 1009.0, 665.0);
    }

    public static final Point latLonToXY(Point latlon, double mapOffsetX, double mapOffsetY, double mapWidth, double mapHeight) {
        double[] xy = Helper.latLonToXY(latlon.getY(), latlon.getX(), mapOffsetX, mapOffsetY, mapWidth, mapHeight);
        return new Point(xy[0], xy[1]);
    }

    public static final double[] latLonToXY(double latitude, double longitude, double mapOffsetX, double mapOffsetY, double mapWidth, double mapHeight) {
        double x = (longitude + 180.0) * (mapWidth / 360.0) + mapOffsetX;
        double y = mapHeight / 2.0 - mapWidth * Math.log(Math.tan(0.7853981633974483 + Math.toRadians(latitude) / 2.0)) / (Math.PI * 2) + mapOffsetY;
        return new double[]{x, y};
    }

    public static final Point xyToLatLon(double x, double y) {
        double[] latlon = Helper.xyToLatLon(x, y, -28.7565, 129.675, 1009.0, 665.0);
        return new Point(latlon[0], latlon[1]);
    }

    public static final Point xyToLatLon(Point xy) {
        return Helper.xyToLatLon(xy, -28.7565, 129.675, 1009.0, 665.0);
    }

    public static final Point xyToLatLon(Point xy, double mapOffsetX, double mapOffsetY, double mapWidth, double mapHeight) {
        double[] ll = Helper.xyToLatLon(xy.getY(), xy.getX(), mapOffsetX, mapOffsetY, mapWidth, mapHeight);
        return new Point(ll[0], ll[1]);
    }

    public static final double[] xyToLatLon(double x, double y, double mapOffsetX, double mapOffsetY, double mapWidth, double mapHeight) {
        double longitude = (x - mapOffsetX) * 360.0 / mapWidth - 180.0;
        double latitude = Math.toDegrees(-(Math.atan(Math.exp(((y - mapOffsetY) * 2.0 - mapHeight) * Math.PI / mapWidth)) * 4.0 - Math.PI) / 2.0);
        return new double[]{latitude, longitude};
    }

    public static final Properties readProperties(String filename) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Properties properties = new Properties();
        try (InputStream resourceStream = loader.getResourceAsStream(filename);){
            properties.load(resourceStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public static final String shortenNumber(long value) {
        return Helper.shortenNumber(value, Locale.US);
    }

    public static final String shortenNumber(long value, Locale locale) {
        if (value == Long.MIN_VALUE) {
            return Helper.shortenNumber(-9223372036854775807L, locale);
        }
        if (value < 0L) {
            return "-" + Helper.shortenNumber(-value, locale);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> entry = SUFFIXES.floorEntry(value);
        Long divideBy = entry.getKey();
        String suffix = entry.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        NumberFormat formatter = NumberFormat.getNumberInstance(locale);
        formatter.setMinimumFractionDigits(1);
        formatter.setMaximumFractionDigits(1);
        return hasDecimal ? formatter.format((double)truncated / 10.0) + suffix : truncated / 10L + suffix;
    }

    public static final <T extends Point> Point getMidPoint(T p1, T p2) {
        return new Point((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
    }

    public static final double[] getMidPoint(double x1, double y1, double x2, double y2) {
        return new double[]{(x1 + x2) / 2.0, (y1 + y2) / 2.0};
    }

    public static final Point rotatePointAroundRotationCenter(Point p, Point rc, double angle) {
        double[] rp = Helper.rotatePointAroundRotationCenter(p.getX(), p.getY(), rc.getX(), rc.getY(), angle);
        return new Point(rp[0], rp[1]);
    }

    public static final double[] rotatePointAroundRotationCenter(double x, double y, double rx, double ry, double angle) {
        double rad = Math.toRadians(angle);
        double sin = Math.sin(rad);
        double cos = Math.cos(rad);
        double nX = rx + (x - rx) * cos - (y - ry) * sin;
        double nY = ry + (x - rx) * sin + (y - ry) * cos;
        return new double[]{nX, nY};
    }

    public static final Point getCubicBezierXYatT(Point startPoint, Point controlPoint1, Point controlPoint2, Point endPoint, double distance) {
        double x = Helper.cubicN(distance, startPoint.getX(), controlPoint1.getX(), controlPoint2.getX(), endPoint.getX());
        double y = Helper.cubicN(distance, startPoint.getY(), controlPoint1.getY(), controlPoint2.getY(), endPoint.getY());
        return new Point(x, y);
    }

    public static final double[] getCubicBezierXYatT(double startPointX, double startPointY, double controlPoint1X, double controlPoint1Y, double controlPoint2X, double controlPoint2Y, double endPointX, double endPointY, double distance) {
        double x = Helper.cubicN(distance, startPointX, controlPoint1X, controlPoint2X, endPointX);
        double y = Helper.cubicN(distance, startPointY, controlPoint1Y, controlPoint2Y, endPointY);
        return new double[]{x, y};
    }

    private static double cubicN(double distance, double a, double b, double c, double d) {
        double t2 = distance * distance;
        double t3 = t2 * distance;
        return a + (-a * 3.0 + distance * (3.0 * a - a * distance)) * distance + (3.0 * b + distance * (-6.0 * b + b * 3.0 * distance)) * distance + (c * 3.0 - c * 3.0 * distance) * t2 + d * t3;
    }

    public static final double getControlPointAngle(Point p1, Point p2) {
        double distance = Helper.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        double cpAngle = distance > 600.0 ? 80.0 : (distance > 500.0 ? 70.0 : (distance > 400.0 ? 60.0 : (distance > 300.0 ? 50.0 : (distance > 200.0 ? 40.0 : (distance > 100.0 ? 30.0 : (distance > 50.0 ? 20.0 : 10.0))))));
        return cpAngle;
    }
}

