/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries.tools;

import eu.hansolo.fx.countries.evt.CountryEvt;
import eu.hansolo.fx.countries.tools.CLocation;
import eu.hansolo.fx.countries.tools.ConnectionPartType;
import eu.hansolo.fx.countries.tools.Helper;
import eu.hansolo.toolbox.evt.EvtObserver;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class Connection {
    private final CountryEvt<Connection> SELECTED_EVENT = new CountryEvt<Connection>((Object)this, CountryEvt.SELECTED, this);
    private final CountryEvt<Connection> UPDATED_EVENT = new CountryEvt<Connection>((Object)this, CountryEvt.UPDATE, this);
    private List<EvtObserver<CountryEvt<Connection>>> observers;
    private CLocation _sourceLocation;
    private ObjectProperty<CLocation> sourceLocation;
    private CLocation _targetLocation;
    private ObjectProperty<CLocation> targetLocation;
    private String _name;
    private StringProperty name;
    private double _value;
    private DoubleProperty value;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Color _sourceColor;
    private ObjectProperty<Color> sourceColor;
    private Color _targetColor;
    private ObjectProperty<Color> targetColor;
    private boolean _gradientFill;
    private BooleanProperty gradientFill;
    private Color _selectedStroke;
    private ObjectProperty<Color> selectedStroke;
    private double _lineWidth;
    private DoubleProperty lineWidth;
    private boolean _arrowsVisible;
    private BooleanProperty arrowsVisible;
    private String _tooltipText;
    private StringProperty tooltipText;
    private boolean _selected;
    private BooleanProperty selected;

    public Connection(CLocation sourceLocation, CLocation targetLocation) {
        this(sourceLocation, targetLocation, "", 0.0, Color.BLACK, Color.BLUE, Color.RED, false, 1.0, "");
    }

    public Connection(CLocation sourceLocation, CLocation targetLocation, Color stroke) {
        this(sourceLocation, targetLocation, "", 0.0, stroke, Color.BLUE, Color.RED, false, 1.0, "");
    }

    public Connection(CLocation sourceLocation, CLocation targetLocation, String name) {
        this(sourceLocation, targetLocation, name, 0.0, Color.BLACK, Color.BLUE, Color.RED, false, 1.0, "");
    }

    public Connection(CLocation sourceLocation, CLocation targetLocation, String name, Color stroke) {
        this(sourceLocation, targetLocation, name, 0.0, stroke, Color.BLUE, Color.RED, false, 1.0, "");
    }

    public Connection(CLocation sourceLocation, CLocation targetLocation, String name, double value) {
        this(sourceLocation, targetLocation, name, value, Color.BLACK, Color.BLUE, Color.RED, false, 1.0, "");
    }

    public Connection(CLocation sourceLocation, CLocation targetLocation, String name, double value, Color stroke) {
        this(sourceLocation, targetLocation, name, value, stroke, Color.BLUE, Color.RED, false, 1.0, "");
    }

    public Connection(CLocation sourceLocation, CLocation targetLocation, String name, double value, Color sourceColor, Color targetColor, boolean gradientFill) {
        this(sourceLocation, targetLocation, name, value, Color.BLACK, sourceColor, targetColor, gradientFill, 1.0, "");
    }

    public Connection(CLocation sourceLocation, CLocation targetLocation, String name, double value, Color sourceColor, Color targetColor, boolean gradientFill, String tooltipText) {
        this(sourceLocation, targetLocation, name, value, Color.BLACK, sourceColor, targetColor, gradientFill, 1.0, tooltipText);
    }

    public Connection(CLocation sourceLocation, CLocation targetLocation, String name, double value, Color stroke, String tooltipText) {
        this(sourceLocation, targetLocation, name, value, stroke, Color.BLUE, Color.RED, false, 1.0, tooltipText);
    }

    public Connection(CLocation sourceLocation, CLocation targetLocation, String name, double value, Color stroke, Color sourceColor, Color targetColor, boolean gradientFill, double lineWidth, String tooltipText) {
        if (ConnectionPartType.SOURCE != sourceLocation.getConnectionPartType()) {
            throw new IllegalArgumentException("targetLocation needs to be of type SOURCE");
        }
        if (ConnectionPartType.TARGET != targetLocation.getConnectionPartType()) {
            throw new IllegalArgumentException("sourceLocation needs to be of type TARGET");
        }
        this.observers = new CopyOnWriteArrayList<EvtObserver<CountryEvt<Connection>>>();
        this._sourceLocation = sourceLocation;
        this._targetLocation = targetLocation;
        this._name = name;
        this._value = value;
        this._stroke = stroke;
        this._tooltipText = tooltipText;
        this._sourceColor = sourceColor;
        this._targetColor = targetColor;
        this._gradientFill = gradientFill;
        this._selectedStroke = Color.RED;
        this._lineWidth = Helper.clamp(0.5, 10.0, lineWidth);
        this._arrowsVisible = false;
        this._selected = false;
    }

    public CLocation getTargetLocation() {
        return null == this.targetLocation ? this._targetLocation : (CLocation)this.targetLocation.get();
    }

    public void setTargetLocation(CLocation targetLocation) {
        if (null == this.targetLocation) {
            this._targetLocation = targetLocation;
            this.fireEvt(this.UPDATED_EVENT);
        } else {
            this.targetLocation.set(targetLocation);
        }
    }

    public ObjectProperty<CLocation> targetLocationProperty() {
        if (null == this.targetLocation) {
            this.targetLocation = new ObjectPropertyBase<CLocation>(this._targetLocation){

                @Override
                protected void invalidated() {
                    Connection.this.fireEvt(Connection.this.UPDATED_EVENT);
                }

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "targetLocation";
                }
            };
            this._targetLocation = null;
        }
        return this.targetLocation;
    }

    public CLocation getSourceLocation() {
        return null == this.sourceLocation ? this._sourceLocation : (CLocation)this.sourceLocation.get();
    }

    public void setSourceLocation(CLocation sourceLocation) {
        if (null == this.sourceLocation) {
            this._sourceLocation = sourceLocation;
            this.fireEvt(this.UPDATED_EVENT);
        } else {
            this.sourceLocation.set(sourceLocation);
        }
    }

    public ObjectProperty<CLocation> sourceLocationProperty() {
        if (null == this.sourceLocation) {
            this.sourceLocation = new ObjectPropertyBase<CLocation>(this._sourceLocation){

                @Override
                protected void invalidated() {
                    Connection.this.fireEvt(Connection.this.UPDATED_EVENT);
                }

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "sourceLocation";
                }
            };
            this._sourceLocation = null;
        }
        return this.sourceLocation;
    }

    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String name) {
        if (null == this.name) {
            this._name = name;
            this.fireEvt(this.UPDATED_EVENT);
        } else {
            this.name.set(name);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                @Override
                protected void invalidated() {
                    Connection.this.fireEvt(Connection.this.UPDATED_EVENT);
                }

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    public double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    public void setValue(double value) {
        if (null == this.value) {
            this._value = value;
            this.fireEvt(this.UPDATED_EVENT);
        } else {
            this.value.set(value);
        }
    }

    public DoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new DoublePropertyBase(this._value){

                @Override
                protected void invalidated() {
                    Connection.this.fireEvt(Connection.this.UPDATED_EVENT);
                }

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public Color getStroke() {
        return null == this.stroke ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color stroke) {
        if (null == this.stroke) {
            this._stroke = stroke;
            this.fireEvt(this.UPDATED_EVENT);
        } else {
            this.stroke.set(stroke);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (null == this.stroke) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                @Override
                protected void invalidated() {
                    Connection.this.fireEvt(Connection.this.UPDATED_EVENT);
                }

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    public Color getSourceColor() {
        return null == this.sourceColor ? this._sourceColor : (Color)this.sourceColor.get();
    }

    public void setSourceColor(Color sourceColor) {
        if (null == this.sourceColor) {
            this._sourceColor = sourceColor;
            this.fireEvt(this.UPDATED_EVENT);
        } else {
            this.sourceColor.set(sourceColor);
        }
    }

    public ObjectProperty<Color> sourceColorProperty() {
        if (null == this.sourceColor) {
            this.sourceColor = new ObjectPropertyBase<Color>(this._sourceColor){

                @Override
                protected void invalidated() {
                    Connection.this.fireEvt(Connection.this.UPDATED_EVENT);
                }

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "sourceColor";
                }
            };
            this._sourceColor = null;
        }
        return this.sourceColor;
    }

    public Color getTargetColor() {
        return null == this.targetColor ? this._targetColor : (Color)this.targetColor.get();
    }

    public void setTargetColor(Color targetColor) {
        if (null == this.targetColor) {
            this._targetColor = targetColor;
            this.fireEvt(this.UPDATED_EVENT);
        } else {
            this.targetColor.set(targetColor);
        }
    }

    public ObjectProperty<Color> targetColorProperty() {
        if (null == this.targetColor) {
            this.targetColor = new ObjectPropertyBase<Color>(this._targetColor){

                @Override
                protected void invalidated() {
                    Connection.this.fireEvt(Connection.this.UPDATED_EVENT);
                }

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "targetColor";
                }
            };
            this._targetColor = null;
        }
        return this.targetColor;
    }

    public boolean getGradientFill() {
        return null == this.gradientFill ? this._gradientFill : this.gradientFill.get();
    }

    public void setGradientFill(boolean gradientFill) {
        if (null == this.gradientFill) {
            this._gradientFill = gradientFill;
            this.fireEvt(this.UPDATED_EVENT);
        } else {
            this.gradientFill.set(gradientFill);
        }
    }

    public BooleanProperty gradientFillProperty() {
        if (null == this.gradientFill) {
            this.gradientFill = new BooleanPropertyBase(this._gradientFill){

                @Override
                protected void invalidated() {
                    Connection.this.fireEvt(Connection.this.UPDATED_EVENT);
                }

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "gradientFill";
                }
            };
        }
        return this.gradientFill;
    }

    public Color getSelectedStroke() {
        return null == this.selectedStroke ? this._selectedStroke : (Color)this.selectedStroke.get();
    }

    public void setSelectedStroke(Color selectedStroke) {
        if (null == this.selectedStroke) {
            this._selectedStroke = selectedStroke;
            this.fireEvt(this.UPDATED_EVENT);
        } else {
            this.selectedStroke.set(selectedStroke);
        }
    }

    public ObjectProperty<Color> selectedStrokeProperty() {
        if (null == this.selectedStroke) {
            this.selectedStroke = new ObjectPropertyBase<Color>(this._selectedStroke){

                @Override
                protected void invalidated() {
                    Connection.this.fireEvt(Connection.this.UPDATED_EVENT);
                }

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "selectedStroke";
                }
            };
            this._selectedStroke = null;
        }
        return this.selectedStroke;
    }

    public double getLineWidth() {
        return null == this.lineWidth ? this._lineWidth : this.lineWidth.get();
    }

    public void setLineWidth(double lineWidth) {
        if (null == this.lineWidth) {
            this._lineWidth = Helper.clamp(0.5, 10.0, lineWidth);
            this.fireEvt(this.UPDATED_EVENT);
        } else {
            this.lineWidth.set(lineWidth);
        }
    }

    public DoubleProperty lineWidthProperty() {
        if (null == this.lineWidth) {
            this.lineWidth = new DoublePropertyBase(this._lineWidth){

                @Override
                protected void invalidated() {
                    this.set(Helper.clamp(0.5, 10.0, this.get()));
                    Connection.this.fireEvt(Connection.this.UPDATED_EVENT);
                }

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "lineWidth";
                }
            };
        }
        return this.lineWidth;
    }

    public boolean getArrowsVisible() {
        return null == this.arrowsVisible ? this._arrowsVisible : this.arrowsVisible.get();
    }

    public void setArrowsVisible(boolean arrowsVisible) {
        if (null == this.arrowsVisible) {
            this._arrowsVisible = arrowsVisible;
            this.fireEvt(this.UPDATED_EVENT);
        } else {
            this.arrowsVisible.set(arrowsVisible);
        }
    }

    public BooleanProperty arrowsVisibleProperty() {
        if (null == this.arrowsVisible) {
            this.arrowsVisible = new BooleanPropertyBase(this._arrowsVisible){

                @Override
                protected void invalidated() {
                    Connection.this.fireEvt(Connection.this.UPDATED_EVENT);
                }

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "arrowsVisible";
                }
            };
        }
        return this.arrowsVisible;
    }

    public String getTooltipText() {
        return null == this.tooltipText ? this._tooltipText : (String)this.tooltipText.get();
    }

    public void setTooltipText(String tooltipText) {
        if (null == this.tooltipText) {
            this._tooltipText = tooltipText;
        } else {
            this.tooltipText.set(tooltipText);
        }
    }

    public StringProperty tooltipTextProperty() {
        if (null == this.tooltipText) {
            this.tooltipText = new StringPropertyBase(this._tooltipText){

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "tooltipText";
                }
            };
        }
        return this.tooltipText;
    }

    public boolean isSelected() {
        return null == this.selected ? this._selected : this.selected.get();
    }

    public void setSelected(boolean selected) {
        if (null == this.selected) {
            this._selected = selected;
            this.fireEvt(this.SELECTED_EVENT);
        } else {
            this.selected.set(selected);
        }
    }

    public BooleanProperty selectedProperty() {
        if (null == this.selected) {
            this.selected = new BooleanPropertyBase(this._selected){

                @Override
                protected void invalidated() {
                    Connection.this.fireEvt(Connection.this.SELECTED_EVENT);
                }

                @Override
                public Object getBean() {
                    return Connection.this;
                }

                @Override
                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    public void setOnEvt(EvtObserver<CountryEvt<Connection>> observer) {
        this.addEvtObserver(observer);
    }

    public void addEvtObserver(EvtObserver<CountryEvt<Connection>> observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    public void removeEvtObserver(EvtObserver<CountryEvt<Connection>> observer) {
        if (this.observers.contains(observer)) {
            this.observers.remove(observer);
        }
    }

    public void fireEvt(CountryEvt evt) {
        for (EvtObserver<CountryEvt<Connection>> observer : this.observers) {
            observer.handle(evt);
        }
    }
}

