/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries.tools;

import eu.hansolo.fx.countries.Country;
import eu.hansolo.fx.countries.tools.CRegion;
import eu.hansolo.fx.countries.tools.CountryPath;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.paint.Color;

public enum BusinessRegion implements CRegion
{
    AFRICA(Country.DZ, Country.EG, Country.EH, Country.LY, Country.MA, Country.SD, Country.SS, Country.TN, Country.BF, Country.BJ, Country.CI, Country.CV, Country.GH, Country.GM, Country.GN, Country.GW, Country.LR, Country.ML, Country.MR, Country.NE, Country.NG, Country.SH, Country.SL, Country.SN, Country.TG, Country.AO, Country.CD, Country.CF, Country.CG, Country.CM, Country.GA, Country.GQ, Country.ST, Country.TD, Country.BI, Country.DJ, Country.ER, Country.ET, Country.KE, Country.KM, Country.MG, Country.MU, Country.MW, Country.MZ, Country.RE, Country.RW, Country.SC, Country.SO, Country.TZ, Country.UG, Country.YT, Country.ZM, Country.ZW, Country.BW, Country.LS, Country.NA, Country.SZ, Country.ZA),
    NORTHERN_AFRICA(Country.DZ, Country.EG, Country.EH, Country.LY, Country.MA, Country.SD, Country.SS, Country.TN),
    WESTERN_AFRICA(Country.BF, Country.BJ, Country.CI, Country.CV, Country.GH, Country.GM, Country.GN, Country.GW, Country.LR, Country.ML, Country.MR, Country.NE, Country.NG, Country.SH, Country.SL, Country.SN, Country.TG),
    MIDDLE_AFRICA(Country.AO, Country.CD, Country.CF, Country.CG, Country.CM, Country.GA, Country.GQ, Country.ST, Country.TD),
    EASTERN_AFRICA(Country.BI, Country.DJ, Country.ER, Country.ET, Country.KE, Country.KM, Country.MG, Country.MU, Country.MW, Country.MZ, Country.RE, Country.RW, Country.SC, Country.SO, Country.TZ, Country.UG, Country.YT, Country.ZM, Country.ZW),
    SOUTHERN_AFRICA(Country.BW, Country.LS, Country.NA, Country.SZ, Country.ZA),
    AMERICAS(Country.BM, Country.CA, Country.PM, Country.US, Country.AG, Country.AI, Country.AW, Country.BB, Country.BL, Country.BS, Country.CU, Country.DM, Country.DO, Country.GD, Country.GP, Country.HT, Country.JM, Country.KN, Country.KY, Country.LC, Country.MF, Country.MQ, Country.MS, Country.PR, Country.TC, Country.TT, Country.VC, Country.VG, Country.VI, Country.BZ, Country.CR, Country.GT, Country.HN, Country.MX, Country.NI, Country.PA, Country.SV, Country.AR, Country.BO, Country.BR, Country.CL, Country.CO, Country.EC, Country.FK, Country.GF, Country.GY, Country.PE, Country.PY, Country.SR, Country.UY, Country.VE),
    AMERICAS_INCLUDING_GREENLAND(Country.BM, Country.CA, Country.GL, Country.PM, Country.US, Country.AG, Country.AI, Country.AW, Country.BB, Country.BL, Country.BS, Country.CU, Country.DM, Country.DO, Country.GD, Country.GP, Country.HT, Country.JM, Country.KN, Country.KY, Country.LC, Country.MF, Country.MQ, Country.MS, Country.PR, Country.TC, Country.TT, Country.VC, Country.VG, Country.VI, Country.BZ, Country.CR, Country.GT, Country.HN, Country.MX, Country.NI, Country.PA, Country.SV, Country.AR, Country.BO, Country.BR, Country.CL, Country.CO, Country.EC, Country.FK, Country.GF, Country.GY, Country.PE, Country.PY, Country.SR, Country.UY, Country.VE),
    NORTHERN_AMERICA(Country.BM, Country.CA, Country.GL, Country.PM, Country.US),
    CARIBBEAN(Country.AG, Country.AI, Country.AW, Country.BB, Country.BL, Country.BS, Country.CU, Country.DM, Country.DO, Country.GD, Country.GP, Country.HT, Country.JM, Country.KN, Country.KY, Country.LC, Country.MF, Country.MQ, Country.MS, Country.PR, Country.TC, Country.TT, Country.VC, Country.VG, Country.VI),
    CENTRAL_AMERICA(Country.BZ, Country.CR, Country.GT, Country.HN, Country.MX, Country.NI, Country.PA, Country.SV),
    SOUTH_AMERICA(Country.AR, Country.BO, Country.BR, Country.CL, Country.CO, Country.EC, Country.FK, Country.GF, Country.GY, Country.PE, Country.PY, Country.SR, Country.UY, Country.VE),
    APAC(Country.AS, Country.AU, Country.BD, Country.BN, Country.BT, Country.CC, Country.CK, Country.CN, Country.CX, Country.FJ, Country.FM, Country.GU, Country.HK, Country.ID, Country.IN, Country.IO, Country.JP, Country.KH, Country.KI, Country.KP, Country.KR, Country.LA, Country.LK, Country.MH, Country.MM, Country.MN, Country.MO, Country.MP, Country.MV, Country.MY, Country.NC, Country.NF, Country.NP, Country.NR, Country.NU, Country.NZ, Country.PF, Country.PG, Country.PH, Country.PK, Country.PN, Country.PW, Country.SB, Country.SG, Country.TH, Country.TK, Country.TL, Country.TO, Country.TV, Country.TW, Country.VN, Country.VU, Country.WF, Country.WS),
    ASIA(Country.TM, Country.TJ, Country.KG, Country.KZ, Country.UZ, Country.CN, Country.HK, Country.JP, Country.KP, Country.KR, Country.MN, Country.MO, Country.TW, Country.AF, Country.BD, Country.BT, Country.IN, Country.IR, Country.LK, Country.MV, Country.NP, Country.PK, Country.BN, Country.ID, Country.KH, Country.LA, Country.MM, Country.MY, Country.PH, Country.SG, Country.TH, Country.TL, Country.VN, Country.AE, Country.AM, Country.AZ, Country.BH, Country.CY, Country.GE, Country.IL, Country.IQ, Country.JO, Country.KW, Country.LB, Country.OM, Country.PS, Country.QA, Country.SA, Country.SY, Country.TR, Country.YE),
    CENTRAL_ASIA(Country.TM, Country.TJ, Country.KG, Country.KZ, Country.UZ),
    EASTERN_ASIA(Country.CN, Country.HK, Country.JP, Country.KP, Country.KR, Country.MN, Country.MO, Country.TW),
    SOUTHERN_ASIA(Country.AF, Country.BD, Country.BT, Country.IN, Country.IR, Country.LK, Country.MV, Country.NP, Country.PK),
    SOUTH_EASTERN_ASIA(Country.BN, Country.ID, Country.KH, Country.LA, Country.MM, Country.MY, Country.PH, Country.SG, Country.TH, Country.TL, Country.VN),
    WESTERN_ASIA(Country.AE, Country.AM, Country.AZ, Country.BH, Country.CY, Country.GE, Country.IL, Country.IQ, Country.JO, Country.KW, Country.LB, Country.OM, Country.PS, Country.QA, Country.SA, Country.SY, Country.TR, Country.YE),
    APJC(Country.AS, Country.AU, Country.BD, Country.BN, Country.BT, Country.CC, Country.CK, Country.CN, Country.CX, Country.FJ, Country.FM, Country.GU, Country.HK, Country.HM, Country.ID, Country.IN, Country.IO, Country.JP, Country.KH, Country.KI, Country.KP, Country.KR, Country.LA, Country.LK, Country.MH, Country.MM, Country.MN, Country.MO, Country.MP, Country.MV, Country.MY, Country.NC, Country.NF, Country.NP, Country.NR, Country.NU, Country.NZ, Country.PF, Country.PG, Country.PH, Country.PN, Country.PW, Country.SB, Country.SG, Country.TH, Country.TK, Country.TL, Country.TO, Country.TV, Country.TW, Country.VN, Country.VU, Country.WS),
    ANZ(Country.AU, Country.NZ),
    BENELUX(Country.BE, Country.NL, Country.LU),
    BRICS(Country.RU, Country.BR, Country.CN, Country.IN, Country.ZA),
    DACH(Country.DE, Country.AT, Country.CH),
    EMEA(Country.AF, Country.AX, Country.AL, Country.DZ, Country.AD, Country.AO, Country.AM, Country.AT, Country.AZ, Country.BH, Country.BY, Country.BE, Country.BJ, Country.BA, Country.BW, Country.BV, Country.BG, Country.BF, Country.BI, Country.CM, Country.CV, Country.CF, Country.TD, Country.KM, Country.CD, Country.CG, Country.HR, Country.CY, Country.CZ, Country.DK, Country.DJ, Country.EG, Country.GQ, Country.ER, Country.EE, Country.ET, Country.FK, Country.FO, Country.FI, Country.FR, Country.GA, Country.GM, Country.GE, Country.DE, Country.GH, Country.GI, Country.GR, Country.GL, Country.GG, Country.GW, Country.HU, Country.IS, Country.IR, Country.IQ, Country.IE, Country.IM, Country.IL, Country.IT, Country.CI, Country.JE, Country.JO, Country.KZ, Country.KE, Country.XK, Country.KW, Country.KG, Country.LV, Country.LB, Country.LS, Country.LR, Country.LY, Country.LI, Country.LT, Country.LU, Country.MK, Country.MG, Country.MW, Country.ML, Country.MT, Country.MR, Country.MU, Country.YT, Country.MD, Country.MC, Country.ME, Country.MA, Country.MZ, Country.NA, Country.NL, Country.NE, Country.NG, Country.NO, Country.OM, Country.PK, Country.PS, Country.PL, Country.PT, Country.QA, Country.RE, Country.RO, Country.RU, Country.RW, Country.SH, Country.SM, Country.ST, Country.SA, Country.SN, Country.RS, Country.SC, Country.SL, Country.SK, Country.SI, Country.SO, Country.ZA, Country.GS, Country.ES, Country.SD, Country.SJ, Country.SZ, Country.SE, Country.CH, Country.SY, Country.TJ, Country.TZ, Country.TG, Country.TN, Country.TR, Country.TM, Country.UG, Country.UA, Country.AE, Country.GB, Country.UZ, Country.VA, Country.EH, Country.YE, Country.ZM, Country.ZW),
    EUROPEAN_UNION(Country.AT, Country.BE, Country.BG, Country.HR, Country.CY, Country.CZ, Country.DK, Country.EE, Country.FI, Country.FR, Country.DE, Country.GR, Country.HU, Country.IE, Country.IT, Country.LV, Country.LT, Country.LU, Country.MT, Country.NL, Country.PL, Country.PT, Country.RO, Country.SK, Country.SI, Country.ES, Country.SE),
    EUROPE(Country.GG, Country.JE, Country.AX, Country.DK, Country.EE, Country.FI, Country.FO, Country.GB, Country.IE, Country.IM, Country.IS, Country.LT, Country.LV, Country.NO, Country.SE, Country.SJ, Country.AT, Country.BE, Country.CH, Country.DE, Country.FR, Country.LI, Country.LU, Country.MC, Country.NL, Country.BG, Country.BY, Country.CZ, Country.HU, Country.MD, Country.PL, Country.RO, Country.RU, Country.SK, Country.UA, Country.AD, Country.AL, Country.BA, Country.ES, Country.GI, Country.GR, Country.HR, Country.IT, Country.ME, Country.MK, Country.MT, Country.RS, Country.PT, Country.SI, Country.SM, Country.VA),
    NORTHERN_EUROPE(Country.GG, Country.JE, Country.AX, Country.DK, Country.EE, Country.FI, Country.FO, Country.GB, Country.IE, Country.IM, Country.IS, Country.LT, Country.LV, Country.NO, Country.SE, Country.SJ),
    WESTERN_EUROPE(Country.AT, Country.BE, Country.CH, Country.DE, Country.FR, Country.LI, Country.LU, Country.MC, Country.NL),
    EASTERN_EUROPE(Country.BG, Country.BY, Country.CZ, Country.HU, Country.MD, Country.PL, Country.RO, Country.RU, Country.SK, Country.UA),
    SOUTHERN_EUROPE(Country.AD, Country.AL, Country.BA, Country.ES, Country.GI, Country.GR, Country.HR, Country.IT, Country.ME, Country.MK, Country.MT, Country.RS, Country.PT, Country.SI, Country.SM, Country.VA),
    OCEANIA(Country.AU, Country.NF, Country.NZ, Country.FJ, Country.NC, Country.PG, Country.SB, Country.VU, Country.FM, Country.GU, Country.KI, Country.MH, Country.MP, Country.NR, Country.PW, Country.AS, Country.CK, Country.NU, Country.PF, Country.PN, Country.TK, Country.TO, Country.TV, Country.WF, Country.WS),
    AUSTRLIA_AND_NEW_ZEALAND(Country.AU, Country.NF, Country.NZ),
    MELANESIA(Country.FJ, Country.NC, Country.PG, Country.SB, Country.VU),
    MICRONESIA(Country.FM, Country.GU, Country.KI, Country.MH, Country.MP, Country.NR, Country.PW),
    POLYNESIA(Country.AS, Country.CK, Country.NU, Country.PF, Country.PN, Country.TK, Country.TO, Country.TV, Country.WF, Country.WS),
    NORAM(Country.US, Country.CA, Country.MX, Country.GT, Country.BZ, Country.CU, Country.DO, Country.HT, Country.HN, Country.SV, Country.NI, Country.CR, Country.PA);

    private List<Country> countries;
    private Map<Country, List<CountryPath>> countryPaths;

    private BusinessRegion(Country ... countries) {
        this.countries = new ArrayList<Country>(Set.of(countries));
    }

    @Override
    public List<Country> getCountries() {
        return this.countries;
    }

    @Override
    public void setFill(Color fill) {
        this.countries.forEach(country -> country.setFill(fill));
    }

    @Override
    public void setStroke(Color stroke) {
        this.countries.forEach(country -> country.setFill(stroke));
    }

    @Override
    public final List<Point> getRegionBounds() {
        double ulx = 360.0;
        double uly = 180.0;
        double lrx = 0.0;
        double lry = 0.0;
        for (Country country : this.getCountries()) {
            List<Point> coords = Country.getCountryBounds().get((Object)country);
            if (null == coords) continue;
            Point ul = coords.get(0);
            Point lr = coords.get(1);
            double lastULx = ulx;
            double lastULy = uly;
            ulx = ul.getX() + 180.0;
            uly = (ul.getY() - 90.0) * -1.0;
            ulx = Math.min(ulx, lastULx);
            uly = Math.min(uly, lastULy);
            double lastLRx = lrx;
            double lastLRy = lry;
            lrx = lr.getX() + 180.0;
            lry = (lr.getY() - 90.0) * -1.0;
            lrx = Math.max(lrx, lastLRx);
            lry = Math.max(lry, lastLRy);
        }
        uly = uly * -1.0 + 90.0;
        lry = lry * -1.0 + 90.0;
        Point upperLeft = new Point(ulx -= 180.0, uly);
        Point lowerRight = new Point(lrx -= 180.0, lry);
        return List.of(upperLeft, lowerRight);
    }

    @Override
    public final Map<Country, List<CountryPath>> getCountryPaths() {
        if (null == this.countryPaths) {
            this.countryPaths = new HashMap<Country, List<CountryPath>>();
            this.getCountries().forEach(country -> {
                ArrayList paths = new ArrayList();
                country.getCopyOfPaths().forEach(countryPath -> paths.add(countryPath));
                this.countryPaths.put((Country)((Object)country), paths);
            });
        }
        return this.countryPaths;
    }

    public final List<CountryPath> getPaths() {
        ArrayList<CountryPath> paths = new ArrayList<CountryPath>();
        this.getCountryPaths().values().forEach(cps -> cps.forEach(countryPath -> paths.add((CountryPath)countryPath)));
        return paths;
    }
}

