# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.sql_database import SQLDatabase


class PostgreSQLDatabase(SQLDatabase):
    r"""
    PostgreSQLDatabase - maintain a connection to a postgre_sql database
    
    Superclass: SQLDatabase
    
    postgre_sql (http://www.postgres.org) is a BSD-licensed SQL database.
    It's large, fast, and can not be easily embedded inside other
    applications.  Its databases are stored in files that belong to
    another process.
    
    This class provides a VTK interface to postgre_sql.  You do need to
    download external libraries: we need a copy of postgre_sql 8
    (currently 8.2 or 8.3) so that we can link against the libpq C
    interface.
    
    @par Thanks: Thanks to David Thompson and Andy Wilson from Sandia
    National Laboratories for implementing this class.
    
    @sa
    PostgreSQLQuery
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPostgreSQLDatabase, obj, update, **traits)
    
    connect_options = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Additional options for the database.
        """
    )

    def _connect_options_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConnectOptions,
                        self.connect_options)

    database_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        The name of the database to connect to.
        """
    )

    def _database_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDatabaseName,
                        self.database_name)

    host_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        The database server host name.
        """
    )

    def _host_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHostName,
                        self.host_name)

    server_port = traits.Trait(-1, traits.Range(-1, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        The port used for connecting to the database.
        """
    )

    def _server_port_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetServerPort,
                        self.server_port)

    user = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        The user name for connecting to the database server.
        """
    )

    def _user_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUser,
                        self.user)

    def _get_databases(self):
        return wrap_vtk(self._vtk_obj.GetDatabases())
    databases = traits.Property(_get_databases, desc=\
        r"""
        Return a list of databases on the server.
        """
    )

    def create_database(self, *args):
        """
        create_database(self, dbName:str, dropExisting:bool=False) -> bool
        C++: bool create_database(const char *dbName,
            bool dropExisting=false)
        Create a new database, optionally dropping any existing database
        of the same name. Returns true when the database is properly
        created and false on failure.
        """
        ret = self._wrap_call(self._vtk_obj.CreateDatabase, *args)
        return ret

    def drop_database(self, *args):
        """
        drop_database(self, dbName:str) -> bool
        C++: bool drop_database(const char *dbName)
        Drop a database if it exists. Returns true on success and false
        on failure.
        """
        ret = self._wrap_call(self._vtk_obj.DropDatabase, *args)
        return ret

    def parse_url(self, *args):
        """
        parse_url(self, url:str) -> bool
        
        Overridden to determine connection parameters given the URL. This
        is called by create_from_url() to initialize the instance. Look at
        create_from_url() for details about the URL format.
        """
        ret = self._wrap_call(self._vtk_obj.ParseURL, *args)
        return ret

    def set_password(self, *args):
        """
        set_password(self, __a:str) -> None
        C++: virtual void set_password(const char *)
        The user's password for connecting to the database server.
        """
        ret = self._wrap_call(self._vtk_obj.SetPassword, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('connect_options', 'GetConnectOptions'),
    ('database_name', 'GetDatabaseName'), ('host_name', 'GetHostName'),
    ('server_port', 'GetServerPort'), ('user', 'GetUser'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'connect_options',
    'database_name', 'host_name', 'server_port', 'user'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PostgreSQLDatabase, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PostgreSQLDatabase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['connect_options', 'database_name', 'host_name',
            'server_port', 'user']),
            title='Edit PostgreSQLDatabase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PostgreSQLDatabase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

