# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.distributed_data_filter import DistributedDataFilter


class PDistributedDataFilter(DistributedDataFilter):
    r"""
    PDistributedDataFilter - Distribute data among processors
    
    Superclass: DistributedDataFilter
    
    This filter redistributes data among processors in a parallel
    application into spatially contiguous UnstructuredGrids. The
    execution model anticipated is that all processes read in part of a
    large DataSet. Each process sets the input of filter to be that
    data_set. When executed, this filter builds in parallel a k-d tree,
    decomposing the space occupied by the distributed data_set into
    spatial regions.  It assigns each spatial region to a processor.  The
    data is then redistributed and the output is a single
    UnstructuredGrid containing the cells in the process' assigned
    regions.
    
    This filter is sometimes called "D3" for "distributed data
    decomposition".
    
    Enhancement: You can set the k-d tree decomposition, rather than have
    D3 compute it.  This allows you to divide a dataset using the
    decomposition computed for another dataset.  Obtain a description of
    the k-d tree cuts this way:
    
    {cpp}
       BSPCuts *cuts = d3_object1->get_cuts()
    
    And set it this way:
    
    {cpp}
        d3_object2->set_cuts(cuts)
    
    It is desirable to have a field array of global node IDs for two
    reasons:
    
    1. When merging together sub grids that were distributed across
       processors, global node IDs can be used to remove duplicate points
    and significantly reduce the size of the resulting output grid.  If
       no such array is available, D3 will use a tolerance to merge
       points, which is much slower.
    
    2. If ghost cells have been requested, D3 requires a global node ID
       array in order to request and transfer ghost cells in parallel
       among the processors.  If there is no global node ID array, D3
       will in parallel create a global node ID array, and the time to do
    this can be significant.
    
    D3 uses `vtkpoint_data::get_global_ids` to access global node ids from
    the input. If none is found, and ghost cells have been requested, D3
    will create a temporary global node ID array before acquiring ghost
    cells.
    
    It is also desirable to have global element IDs
    (vtkcell_data::get_global_ids). However, if they don't exist D3 can
    create them relatively quickly.
    
    @warning
    The Execute() method must be called by all processes in the parallel
    application, or it will hang.  If you are not certain that your
    pipeline will execute identically on all processors, you may want to
    use this filter in an explicit execution mode.
    
    @sa
    KdTree PKdTree BSPCuts
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPDistributedDataFilter, obj, update, **traits)
    
    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('clip_cells', 'GetClipCells'), ('include_all_intersecting_cells',
    'GetIncludeAllIntersectingCells'), ('retain_kdtree',
    'GetRetainKdtree'), ('timing', 'GetTiming'), ('use_minimal_memory',
    'GetUseMinimalMemory'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('boundary_mode', 'GetBoundaryMode'), ('minimum_ghost_level',
    'GetMinimumGhostLevel'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'clip_cells', 'debug', 'global_warning_display',
    'include_all_intersecting_cells', 'release_data_flag',
    'retain_kdtree', 'timing', 'use_minimal_memory', 'boundary_mode',
    'minimum_ghost_level', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PDistributedDataFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PDistributedDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['clip_cells', 'include_all_intersecting_cells',
            'retain_kdtree', 'timing', 'use_minimal_memory'], ['boundary_mode'],
            ['minimum_ghost_level']),
            title='Edit PDistributedDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PDistributedDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

